/*
 * Q : _RȐ\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclFreeformCurveWithControlPoints2D.java,v 1.18 2000/08/11 06:18:49 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * Q : _RȐ\ۃNXB
 * <p>
 * ̃NX̃CX^X́A
 * _ (JgclPoint2D) ̔z controlPoints
 * 
 * d (double) ̔z weights
 * B
 * </p>
 * <p>
 * weights  null ̏ꍇɂ͔LȐ (Ȑ) \B
 * </p>
 * <p>
 * weights ɔz񂪐ݒ肳Ăꍇɂ͗LȐ\B
 * weights[i]  controlPoints[i] ɑΉB
 * ȂA܂̂Ƃ weights[i] ̒l͐łȂ΂ȂȂB
 * </p>
 *
 * @version $Revision: 1.18 $, $Date: 2000/08/11 06:18:49 $
 * @author Information-technology Promotion Agency, Japan
 */

public abstract class JgclFreeformCurveWithControlPoints2D extends JgclBoundedCurve2D {
    /**
     * _̔zB
     * @serial
     */
    protected JgclPoint2D[] controlPoints;

    /**
     * d݂̔zB
     * <p>
     * Ȑł null ƂB
     * </p>
     * @serial
     */
    protected double[] weights;

    /**
     * _Əd݂\񎟌zB
     * <p>
     * KvɉăLbVB
     * </p>
     * <p>
     * controlPointsArray[i] ̒ 2 ̏ꍇA
     * controlPointsArray[i][0]  i Ԗڂ̐_ X A
     * controlPointsArray[i][1]  i Ԗڂ̐_ Y 
     * \B
     * </p>
     * <p>
     * controlPointsArray[i] ̒ 3 ̏ꍇA
     * controlPointsArray[i][0]  (i Ԗڂ̐_ X  * i Ԗڂ̏d)A
     * controlPointsArray[i][1]  (i Ԗڂ̐_ Y  * i Ԗڂ̏d)A
     * controlPointsArray[i][2]  i Ԗڂ̏d
     * \B
     * </p>
     * @serial
     */
    private double[][] controlPointsArray = null;

    /**
     * ^ɃIuWFNg\zB
     * <p>
     * etB[hɂ͒lݒ肵ȂB
     * </p>
     */
    protected JgclFreeformCurveWithControlPoints2D() {
	super();
    }

    /**
     * _^đȐƂăIuWFNg\zB
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	controlPoints  null ł
     * <li>	controlPoints ̒ 2 菬
     * <li>	controlPoints ̂vf̒l null ł
     * </ul>
     * </p>
     *
     * @param controlPoints	_̔z
     * @see	JgclInvalidArgumentValue
     */
    protected JgclFreeformCurveWithControlPoints2D(JgclPoint2D[] controlPoints) {
	super();
	int npnts = setControlPoints(controlPoints);
	weights = null;
    }

    /**
     * _Ədݗ^ėLȐƂăIuWFNg\zB
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	controlPoints  null ł
     * <li>	controlPoints ̒ 2 菬
     * <li>	controlPoints ̂vf̒l null ł
     * <li>	weights  null ł
     * <li>	weights ̒ npnts ƈvĂȂ
     * <li>	weights ̂vf̒lłȂ
     * <li>	weights ̂vf̒l w ɂāA
     *		(w / (weights ̍ől))  JgclMachineEpsilon.DOUBLE 菬ȂB
     * </ul>
     * </p>
     *
     * @param controlPoints	_̔z
     * @param weights		d݂̔z
     * @see	JgclInvalidArgumentValue
     */
    protected JgclFreeformCurveWithControlPoints2D(JgclPoint2D[] controlPoints,
						   double[] weights) {
	super();
	int npnts = setControlPoints(controlPoints);
	setWeights(npnts, weights);
    }

    /**
     * _ (Əd) 񎟌zŗ^
     * Ȑ (邢͗LȐ) ƂăIuWFNg\zB
     * <p>
     * cpArray ̒𐧌_̐ƂB
     * ܂AcpArray[0] ̒ 2 łΑȐA3 łΗLȐƂB
     * </p>
     * <p>
     * cpArray[i] ̒ 2 ̏ꍇA
     * cpArray[i][0]  i Ԗڂ̐_ X A
     * cpArray[i][1]  i Ԗڂ̐_ Y 
     * ̂ƂB
     * </p>
     * <p>
     * cpArray[i] ̒ 3 ̏ꍇA
     * cpArray[i][0]  (i Ԗڂ̐_ X  * i Ԗڂ̏d)A
     * cpArray[i][1]  (i Ԗڂ̐_ Y  * i Ԗڂ̏d)A
     * cpArray[i][2]  i Ԗڂ̏d
     * ̂ƂB
     * </p>
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	_̐ 2 菬
     * <li>	d݂̒lłȂ
     * <li>	d݂̒l w ɂāA
     *		(w / (dݗ̍ől))  JgclMachineEpsilon.DOUBLE 菬ȂB
     * </ul>
     * </p>
     *
     * @param cpArray	_ (яd) ̔z
     * @see	JgclInvalidArgumentValue
     */
    protected JgclFreeformCurveWithControlPoints2D(double[][] cpArray) {
	super();

	int npnts = cpArray.length;
	JgclPoint2D[] cp = new JgclPoint2D[npnts];
	boolean isPoly = (cpArray[0].length == 2);

	if (!isPoly) {	// L
	    double[] tmp = new double[3];
	    double[] wt = new double[npnts];
	    for (int i = 0; i < npnts; i++) {
		for (int j = 0; j < 3; j++)
		    tmp[j] = cpArray[i][j];
		convRational0Deriv(tmp);
		cp[i] = new JgclCartesianPoint2D(tmp[0], tmp[1]);
		wt[i] = tmp[2];
	    }
	    setWeights(npnts, wt);
	} else {
	    for (int i = 0; i < npnts; i++) {
		cp[i] = new JgclCartesianPoint2D(cpArray[i][0], cpArray[i][1]);
	    }
	    weights = null;
	}
	npnts = setControlPoints(cp);
    }

    /**
     * _Ədݗ^
     * Ȑ邢͗LȐƂăIuWFNg\zB
     * <p>
     * doCheck  false ̏ꍇA
     * ^ꂽ controlPoints  weights ̒l
     * ΉtB[hɂ̂܂ܐݒ肷B
     *  weights  null ł΁AȐ͔L () `ɂȂB
     * ȂAcontrolPoints  null ^ƁA\łȂʂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇA
     * weights lĂ
     * {@link #JgclFreeformCurveWithControlPoints2D(JgclPoint2D[], double[])
     * JgclFreeformCurveWithControlPoints2D(JgclPoint2D[], double[])}A
     * weights  null ł
     * {@link #JgclFreeformCurveWithControlPoints2D(JgclPoint2D[])
     * JgclFreeformCurveWithControlPoints2D(JgclPoint2D[])}
     * Ɠl̏sȂB
     * </p>
     *
     * @param controlPoitns	_̔z
     * @param weights	d݂̔z
     * @param doCheck	̃`FbNsȂǂ
     */
    protected JgclFreeformCurveWithControlPoints2D(JgclPoint2D[] controlPoints,
						   double[] weights,
						   boolean doCheck) {
	super();
	if (doCheck) {
	    int npnts = setControlPoints(controlPoints);
	    if (weights == null)
		weights = null;
	    else
		setWeights(npnts, weights);
	} else {
	    this.controlPoints = controlPoints;
	    this.weights = weights;
	}
    }

    /**
     * ̋Ȑ̐_ԂB
     * 
     * @return		_̔z
     */
    public JgclPoint2D[] controlPoints() {
	JgclPoint2D[] copied = new JgclPoint2D[controlPoints.length];

	for (int i = 0; i < controlPoints.length; i++)
	    copied[i] = controlPoints[i];
	return copied;
    }

    /**
     * ̋Ȑ i Ԗڂ̐_ԂB
     * 
     * @param i	CfbNX
     * @return	_
     */
    public JgclPoint2D controlPointAt(int i) {
	return controlPoints[i];
    }

    /**
     * ̋Ȑ̏dݗԂB
     * <p>
     * ȐȐ̏ꍇ null ԂB
     * </p>
     * 
     * @return	d݂̔z
     */
    public double[] weights() {
	if (weights == null)
	    return null;
	return (double[])weights.clone();
    }

    /**
     * ̋Ȑ i Ԗڂ̐_̏d݂ԂB
     * <p>
     * ȐȐ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𓊂B
     * </p>
     * 
     * @param i	CfbNX
     * @return	d
     * @see	JgclInvalidArgumentValue
     */
    public double weightAt(int i) {
	if (weights == null)
	    throw new JgclInvalidArgumentValue();
	return weights[i];
    }

    /**
     * ̋Ȑ̐_̐ԂB
     * 
     * @return	_̐
     */
    public int nControlPoints() {
	return controlPoints.length;
    }

    /**
     * ̋ȐL`ۂԂB
     *
     * @return	L`Ȃ trueAłȂ false
     */
    public boolean isRational() {
	return weights != null;
    }

    /**
     * ̋Ȑ`ۂԂB
     *
     * @return	`Ȃ trueAłȂ false
     */
    public boolean isPolynomial() {
	return weights == null;
    }

    /**
     * ̋Ȑ̎ԏł̂悻̒ԂB
     * <p>
     * _񂾃|S (䑽p`) ̒ԂB
     * </p>
     *
     * @return	Ȑ̂悻̒
     */
    double approximateLength() {
	int i, j;
	double aprx_leng;

	aprx_leng = 0.0;
	for (i = 0, j = 1; j < nControlPoints(); i++, j++)
	    aprx_leng += controlPointAt(i).distance(controlPointAt(j));

	return aprx_leng;
    }

    /**
     * ̋Ȑ̎ԏł̂悻̑ݔ͈͂`ԂB
     * <p>
     * _܂ދ`ԂB
     * </p>
     *
     * @return	Ȑ̂悻̑ݔ͈͂`
     */
    JgclEnclosingBox2D approximateEnclosingBox() {
	double min_crd_x;
	double min_crd_y;
	double max_crd_x;
	double max_crd_y;
	int n = nControlPoints();
	JgclPoint2D point;
	double x, y;

	point = controlPointAt(0);
	max_crd_x = min_crd_x = point.x();
	max_crd_y = min_crd_y = point.y();

	for (int i = 1; i < n; i++) {
	    point = controlPointAt(i);
	    x = point.x();
	    y = point.y();
	    /**/ if (x < min_crd_x) min_crd_x = x;
	    else if (x > max_crd_x) max_crd_x = x;
	    /**/ if (y < min_crd_y) min_crd_y = y;
	    else if (y > max_crd_y) max_crd_y = y;
	}
	return new JgclEnclosingBox2D(min_crd_x, min_crd_y, max_crd_x, max_crd_y);
    }

    /**
     * ̃CX^X̃tB[hɐ_ݒ肷B
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	controlPoints  null ł
     * <li>	controlPoints ̒ 2 菬
     * <li>	controlPoints ̂vf̒l null ł
     * </ul>
     * </p>
     *
     * @param controlPoints	ݒ肷鐧_
     * @return	_̐
     * @see	JgclInvalidArgumentValue
     */
    private int setControlPoints(JgclPoint2D[] controlPoints) {
	int npnts;

	if (controlPoints == null) {
	    throw new JgclInvalidArgumentValue();
	}
	if ((npnts = controlPoints.length) < 2) {
	    throw new JgclInvalidArgumentValue();
	}
	this.controlPoints = new JgclPoint2D[npnts];
	for (int i = 0; i < npnts; i++) {
	    if (controlPoints[i] == null) {
		throw new JgclInvalidArgumentValue();
	    }
	    this.controlPoints[i] = controlPoints[i];
	}
	return npnts;
    }

    /**
     * ̃CX^X̃tB[hɏdݗݒ肷B
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	weights  null ł
     * <li>	weights ̒ npnts ƈvĂȂ
     * <li>	weights ̂vf̒lłȂ
     * <li>	weights ̂vf̒l w ɂāA
     *		(w / (weights ̍ől))  JgclMachineEpsilon.DOUBLE 菬ȂB
     * </ul>
     * </p>
     *
     * @param npnts	_̐
     * @param weights	ݒ肷dݗ
     * @see	JgclUtil#isDividable(double, double)
     * @see	JgclMachineEpsilon#DOUBLE
     * @see	JgclInvalidArgumentValue
     */
    private void setWeights(int npnts, double[] weights) {
	if (weights == null) {
	    throw new JgclInvalidArgumentValue();
	}
	if (weights.length != npnts) {
	    throw new JgclInvalidArgumentValue();
	}

	double max_weight = 0.0;
	for (int i = 0; i < npnts; i++)
	    if (weights[i] > max_weight)
		max_weight = weights[i];
	if (max_weight <= 0.0)
	    throw new JgclInvalidArgumentValue();

	this.weights = new double[npnts];
	for (int i = 0; i < npnts; i++) {
	    if (weights[i] <= 0.0 || !JgclUtil.isDividable(max_weight, weights[i])) {
		throw new JgclInvalidArgumentValue();
	    }
	    this.weights[i] = weights[i];
	}
    }

    /**
     * ^ꂽ̐_̐i[u̓񎟌zv̗̈lB
     *
     * @param isPoly	`ۂ
     * @param size	z̑ꎟ̗vf (_̐)
     * @return		_̐i[z
     */
    static protected double[][] allocateDoubleArray(boolean isPoly,
						    int size) {
	return new double[size][(isPoly) ? 2 : 3];
    }

    /**
     * ̋Ȑ̐_ (яd) ̐A^ꂽ񎟌z̗vfɑB
     * <p>
     * isPoly  true ̏ꍇA
     * doubleArray[i][0]  i Ԗڂ̐_ X A
     * doubleArray[i][1]  i Ԗڂ̐_ Y 
     * \B
     * </p>
     * <p>
     * isPoly  false ̏ꍇA
     * doubleArray[i][0]  (i Ԗڂ̐_ X  * i Ԗڂ̏d)A
     * doubleArray[i][1]  (i Ԗڂ̐_ Y  * i Ԗڂ̏d)A
     * doubleArray[i][2]  i Ԗڂ̏d
     * \B
     * </p>
     *
     * @param isPoly	`ۂ
     * @param uicp	z̑ꎟ̗vf (zɒl鐧_̐)
     * @param doubleArray	_̐i[񎟌z
     */
    protected void setCoordinatesToDoubleArray(boolean isPoly,
					       int uicp,
					       double[][] doubleArray) {
	if (isPoly) {
	    for (int i = 0; i < uicp; i++) {
		doubleArray[i][0] = controlPoints[i].x();
		doubleArray[i][1] = controlPoints[i].y();
	    }
	} else {
	    for (int i = 0; i < uicp; i++) {
		doubleArray[i][0] = controlPoints[i].x() * weights[i];
		doubleArray[i][1] = controlPoints[i].y() * weights[i];
		doubleArray[i][2] = weights[i];
	    }
	}
    }

    /**
     * ̋Ȑ̐_ (яd) ̐܂ށu̓񎟌zvԂB
     * <p>
     * isPoly  true ̏ꍇA
     * ̃\bhԂ񎟌z C ̗vf
     * C[i][0]  i Ԗڂ̐_ X A
     * C[i][1]  i Ԗڂ̐_ Y 
     * \B
     * </p>
     * <p>
     * isPoly  false ̏ꍇA
     * ̃\bhԂ񎟌z C ̗vf
     * C[i][0]  (i Ԗڂ̐_ X  * i Ԗڂ̏d)A
     * C[i][1]  (i Ԗڂ̐_ Y  * i Ԗڂ̏d)A
     * C[i][2]  i Ԗڂ̏d
     * \B
     * </p>
     *
     * @param isPoly	`ۂ
     * @return	_ (яd) ̐܂ޔz
     */
    protected double[][] toDoubleArray(boolean isPoly) {
	if (controlPointsArray != null)
	    return controlPointsArray;

	int uicp = nControlPoints();

	controlPointsArray =
	    JgclFreeformCurveWithControlPoints2D.allocateDoubleArray(isPoly, uicp);

	setCoordinatesToDoubleArray(isPoly, uicp, controlPointsArray);

	return controlPointsArray;
    }

    /**
     * Wŗ^ꂽ (Ȑ) _ X/Y/W ɕϊB
     * <p>
     * (wx, wy, w) ŗ^ꂽ (Ȑ) _ (x, y, w) ɕϊB
     * </p>
     *
     * @param d0D	Ȑ̓_
     */
    protected void convRational0Deriv(double[] d0D) {
	for (int i = 0; i < 2; i++) {
	    d0D[i] /= d0D[2];
	}
    }

    /**
     * Wŗ^ꂽȐ̓_ƈꎟ֐ X/Y/W ɕϊB
     * <p>
     * (wx, wy, w) ŗ^ꂽȐ̓_ƈꎟ֐ (x, y, w) ɕϊB
     * </p>
     *
     * @param d0D	Ȑ̓_
     * @param d1D	ꎟ֐
     */
    protected void convRational1Deriv(double[] d0D, double[] d1D) {
	convRational0Deriv(d0D);
	for (int i = 0; i < 2; i++) {
	    d1D[i] = (d1D[i] - (d1D[2] * d0D[i])) / d0D[2];
	}
    }

    /**
     * Wŗ^ꂽȐ̓_/ꎟ֐/񎟓֐ X/Y/W ɕϊB
     * <p>
     * (wx, wy, w) ŗ^ꂽȐ̓_/ꎟ֐/񎟓֐ (x, y, w) ɕϊB
     * </p>
     *
     * @param d0D	Ȑ̓_
     * @param d1D	ꎟ֐
     * @param d2D	񎟓֐
     */
    protected void convRational2Deriv(double[] d0D, double[] d1D, double[] d2D) {
	convRational1Deriv(d0D, d1D);
	for (int i = 0; i < 2; i++) {
	    d2D[i] = (d2D[i] - ((2.0 * d1D[2] * d1D[i]) + (d2D[2] * d0D[i]))) / d0D[2];
	}
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	 true
     */
    public boolean isFreeform() {
	return true;
    }

    /**
     * ̋Ȑ̐_̐ɓψȏdݗԂB
     * <p>
     * ʂƂēz̊evf̒l 1 łB
     * </p>
     *
     * @return	d݂̔z
     */
    public double[] makeUniformWeights() {
	double[] uniformWeights = new double[this.nControlPoints()];
	for (int i = 0; i < uniformWeights.length; i++)
	    uniformWeights[i] = 1.0;
	return uniformWeights;
    }
}
