/*
 * Q : tBbgȐ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclFilletObject2D.java,v 1.11 2000/04/26 09:38:55 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.*;

/**
 * Q : tBbgȐ\NXB
 * <p>
 * ̃NX́AȐɐڂ~ (tBbgƂ) \B
 * </p>
 * <p>
 * ̃NX̃CX^X
 * <ul>
 * <li> tBbg̔a radius
 * <li> tBbg̒S center
 * <li> tBbg̋Ȑ (Ȑ 1) Ɛڂ_ pointOnCurve1
 * <li> tBbg̋Ȑ (Ȑ 2) Ɛڂ_ pointOnCurve2
 * </ul>
 * ێB
 * </p>
 *
 * @version $Revision: 1.11 $, $Date: 2000/04/26 09:38:55 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclFilletObject2D extends JgclNonParametricCurve2D {
    /**
     * tBbg̔aB
     * @serial
     */
    private double radius;

    /**
     * tBbg̒SB
     * @serial
     */
    private JgclPoint2D center;

    /**
     * Ȑ 1 ̓_B
     * @serial
     */
    private JgclPointOnCurve2D pointOnCurve1;

    /**
     * Ȑ 2 ̓_B
     * @serial
     */
    private JgclPointOnCurve2D pointOnCurve2;

    /**
     * etB[hɐݒ肷l^ăIuWFNg\zB
     * <p>
     * ܂̂ƂApubic ȃRXgN^ł͂Ȃ߁Ã`FbNsĂȂB
     * publicɂKvoꍇ́AdoCheck ̂KvB
     * </p>
     * 
     * @param radius	tBbg̔a
     * @param center	tBbg̒S
     * @param pointOnCurve1	Ȑ 1 ̓_
     * @param pointOnCurve2	Ȑ 2 ̓_
     */
    JgclFilletObject2D(double radius, JgclPoint2D center,
		       JgclPointOnCurve2D pointOnCurve1, JgclPointOnCurve2D pointOnCurve2) {
	super();
	this.radius = radius;
	this.center = center;
	this.pointOnCurve1 = pointOnCurve1;
	this.pointOnCurve2 = pointOnCurve2;
    }

    /**
     * ̃tBbg̔aԂB
     * 
     * @return	tBbg̔a
     */
    public double radius() {
	return this.radius;
    }

    /**
     * ̃tBbg̒SԂB
     * 
     * @return	tBbg̒S
     */
    public JgclPoint2D center() {
	return this.center;
    }

    /**
     * ̃tBbg̋Ȑ 1 ̓_ԂB
     * 
     * @return	Ȑ 1 ̓_
     */
    public JgclPointOnCurve2D pointOnCurve1() {
	return this.pointOnCurve1;
    }

    /**
     * ̃tBbg̋Ȑ 2 ̓_ԂB
     * 
     * @return	Ȑ 2 ̓_
     */
    public JgclPointOnCurve2D pointOnCurve2() {
	return this.pointOnCurve2;
    }

    /**
     * ̃tBbgȐ (~) ɕϊB
     * <p>
     * smallFan  true ̏ꍇ́ASp΂菬Ȃ̉~ʂԂB
     * smallFan  false ̏ꍇ́ASp΂傫Ȃ̉~ʂԂB
     * ȂA~ʂ̐is͕K pointOnCurve1  pointOnCurve2 ֌B
     * </p>
     *
     * @param smallFan	~ʂ̒Sp΂菬Ȃ悤ɂ邩ǂ
     * @return	tBbg\~
     */
    public JgclTrimmedCurve2D toCurve(boolean smallFan) {
	JgclVector2D vecS = pointOnCurve1().subtract(center()).unitized();
	JgclVector2D vecE = pointOnCurve2().subtract(center()).unitized();
	if (vecS.parallelDirection(vecE))
	    throw new JgclInvalidArgumentValue();

	double angle = vecS.angleWith(vecE);

	if ((angle < Math.PI && !smallFan) ||
	    (angle > Math.PI && smallFan))
	    angle -= JgclMath.PI2;
	    
	JgclAxis2Placement2D a2p = new JgclAxis2Placement2D(center(), vecS);
	JgclCircle2D cir = new JgclCircle2D(a2p, radius);
	JgclParameterSection section = new JgclParameterSection(0.0, angle);
	return new JgclTrimmedCurve2D(cir, section);
    }

    /**
     * ̃tBbg pointOnCurve1  pointOnCurve2 ̂ԂB
     *
     * @return	pointOnCurve1  pointOnCurve2 tBbg
     */
    JgclFilletObject2D exchange() {
	return new JgclFilletObject2D(radius(), center(), pointOnCurve2(), pointOnCurve1());
    }

    /**
     * ̃tBbgƁA^ꂽtBbg̃tBbg\ۂ𒲂ׂB
     *
     * @return	̃tBbg\Ȃ trueAłȂ false
     */
    boolean parametricallyIdentical(JgclFilletObject2D mate) {
	if (!center.identical(mate.center()))
	    return false;

	if (!pointOnCurve1.parametricallyIdentical(mate.pointOnCurve1()))
	    return false;

	if (!pointOnCurve2.parametricallyIdentical(mate.pointOnCurve2()))
	    return false;

	return true;
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tradius " + radius);
        writer.println(indent_tab + "\tcenter");
        center().output(writer, indent + 2);
        writer.println(indent_tab + "\tpointOnCurve1");
        pointOnCurve1().output(writer, indent + 2);
        writer.println(indent_tab + "\tpointOnCurve2");
        pointOnCurve2().output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}

