/*
 * R : ȉ~\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclEllipse3D.java,v 1.53 2000/08/11 06:18:48 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : ȉ~\NXB
 * <p>
 * ȉ~́A̒S̈ʒuƋǏ X/Y ̕ǏWn
 * (zuA{@link JgclAxis2Placement3D JgclAxis2Placement3D}) position 
 * Ǐ X ̔a semiAxis1A
 * Ǐ Y ̔a semiAxis2
 * Œ`B
 * </p>
 * <p>
 * t p[^Ƃȉ~ P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(t) = position.location()
 *	     + semiAxis1 * cos(t) * position.x()
 *	     + semiAxis2 * sin(t) * position.y()
 * </pre>
 * </p>
 *
 * @version $Revision: 1.53 $, $Date: 2000/08/11 06:18:48 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclEllipse3D extends JgclConic3D {
    /**
     * a1 (ǏWX̔a) B
     * @serial
     */
    private double semiAxis1;

    /**
     * a2 (ǏWY̔a) B
     * @serial
     */
    private double semiAxis2;

    /**
     * ̔a̒lAێtB[hɐݒ肷B
     * <p>
     * semiAxis1, semiAxis2 ̒l͐łȂ΂ȂȂB
     * </p>
     * <p>
     * semiAxis1, semiAxis2 ̂ꂩ̒l
     * ݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     *
     * @param semiAxis1	a1
     * @param semiAxis2	a2
     * @see	JgclInvalidArgumentValue
     */
    private void setSemiAxis(double semiAxis1, double semiAxis2)
    {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = condition.getToleranceForDistance();

	if (semiAxis1 < dTol) {
	    throw new JgclInvalidArgumentValue();
	}
	this.semiAxis1 = semiAxis1;

	if (semiAxis2 < dTol) {
	    throw new JgclInvalidArgumentValue();
	}
	this.semiAxis2 = semiAxis2;
    }

    /**
     * ǏWnƊeɑ΂锼a^ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * semiAxis1, semiAxis2 ̂ꂩ̒l
     * ݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param position	SƋǏ X/Y/Z ̕ǏWn
     * @param semiAxis1	a1 (Ǐ X ɑ΂锼a)
     * @param semiAxis2	a2 (Ǐ Y ɑ΂锼a)
     * @see	JgclInvalidArgumentValue
     */
    public JgclEllipse3D(JgclAxis2Placement3D position,
			 double semiAxis1, double semiAxis2)
    {
	super(position);
	setSemiAxis(semiAxis1, semiAxis2);
    }

    /**
     * ̑ȉ~̊e̔apāA^ꂽʒuƌXłQ̑ȉ~쐬B
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param position	Q̑ȉ~̈ʒuƌXǏWn
     * @return	Q̑ȉ~
     * @see	JgclInvalidArgumentValue
     */
    JgclConic2D toLocal2D(JgclAxis2Placement2D position) {
	return new JgclEllipse2D(position, semiAxis1(), semiAxis2());
    }

    /**
     * ̑ȉ~̔a1 (ǏWn X ̔a) ԂB
     * 
     * @return	a1
     */
    public double semiAxis1() {
	return this.semiAxis1;
    }

    /**
     * {@link #semiAxis1() semiAxis1()} ̕ʖ\bhB
     * 
     * @return	a1
     */
    public double xRadius() {
	return this.semiAxis1;
    }

    /**
     * ̑ȉ~̔a2 (ǏWn Y ̔a) ԂB
     * 
     * @return	a2
     */
    public double semiAxis2() {
	return this.semiAxis2;
    }

    /**
     * {@link #semiAxis2() semiAxis2()} ̕ʖ\bhB
     * 
     * @return	a2
     */
    public double yRadius() {
	return this.semiAxis2;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param param	p[^l
     * @return		Wl
     */
    public JgclPoint3D coordinates(double param) {
	param = parameterDomain().wrap(param);
	JgclAxis2Placement3D ax = position();
	JgclVector3D ex = ax.x().multiply(Math.cos(param) * semiAxis1);
	JgclVector3D ey = ax.y().multiply(Math.sin(param) * semiAxis2);

	return ax.location().add(ex.add(ey));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * 
     * @param param	p[^l
     * @return		ڃxNg
     */
    public JgclVector3D tangentVector(double param) {
	param = parameterDomain().wrap(param);
	JgclAxis2Placement3D ax = position();
	JgclVector3D ex1 = ax.x().multiply(-Math.sin(param) * semiAxis1);
	JgclVector3D ey1 = ax.y().multiply(Math.cos(param) * semiAxis2);

	return ex1.add(ey1);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * 
     * @param param	p[^l
     * @return		ȗ
     */
    public JgclCurveCurvature3D curvature(double param) {
	param = parameterDomain().wrap(param);
	JgclAxis2Placement3D ax = position();
	double xlen = Math.cos(param) * semiAxis1;
	double ylen = Math.sin(param) * semiAxis2;
	double x1len = -Math.sin(param) * semiAxis1;
	double y1len = Math.cos(param) * semiAxis2;
	double plen = Math.sqrt(x1len * x1len + y1len * y1len);
	double crv = Math.abs(x1len * ylen - y1len * xlen)
	    / (plen * plen * plen);
	JgclVector3D ex1 = ax.x().multiply(x1len);
	JgclVector3D ey1 = ax.y().multiply(y1len);

	JgclVector3D tangent = ex1.add(ey1);
	// rotate tangent PI/2 around Z axis
	JgclVector3D nrmDir = ax.z().crossProduct(tangent);
	return new JgclCurveCurvature3D(crv, nrmDir.unitized());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * 
     * @param param	p[^l
     * @return		֐
     */
    public JgclCurveDerivative3D evaluation(double param) {
	param = parameterDomain().wrap(param);
	JgclAxis2Placement3D ax = position();
	JgclVector3D ex = ax.x().multiply(Math.cos(param) * semiAxis1);
	JgclVector3D ey = ax.y().multiply(Math.sin(param) * semiAxis2);
	JgclVector3D ex1 = ax.x().multiply(-Math.sin(param) * semiAxis1);
	JgclVector3D ey1 = ax.y().multiply(Math.cos(param) * semiAxis2);

	JgclPoint3D d0 = ax.location().add(ex.add(ey));
	JgclVector3D d1 = ex1.add(ey1);
	JgclVector3D d2 = ex.add(ey).multiply(-1.0);
	JgclVector3D d3 = ex1.add(ey1).multiply(-1.0);

	return new JgclCurveDerivative3D(d0, d1, d2, d3);
    }

    /**
     * ^ꂽp[^ԂɂāA
     * Ԃ̗[Ԍłꂽ_̃p[^l߂B
     * <p>
     * ̃\bh
     * {@link JgclConic3D#toPolyline(JgclParameterSection, JgclToleranceForDistance) 
     * JgclConic3D.toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ŌĂяoB
     * </p>
     * 
     * @param left	[ (ԉ) ̃p[^l
     * @param right	E[ (ԏ) ̃p[^l
     * @return		łꂽ_̃p[^l
     */
    double getPeak(double left, double right) {
	double peak;

	peak = Math.atan2(Math.cos(left) - Math.cos(right),
			  Math.sin(right) - Math.sin(left));

	while (peak < left)
	    peak += Math.PI;
	while (peak > right)
	    peak -= Math.PI;

	return peak;
    }

    /**
     * ̋Ȑ̎w̋ԂČLxWGȐ̗ԂB
     * <p>
     * pint ̑l̐Βl (2 * ) ȏ̏ꍇɂ́A
     *  (2 * ) ƌȂďB
     * </p>
     *
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLxWGȐ̔z
     */
    public JgclPureBezierCurve3D[] toPolyBezierCurves(JgclParameterSection pint) {
	JgclEllipse2D this2D =
	    (JgclEllipse2D)this.toLocal2D(JgclAxis2Placement2D.origin);
	JgclPureBezierCurve2D[] bzcs2D = this2D.toPolyBezierCurves(pint);
	return this.transformPolyBezierCurvesInLocal2DToGrobal3D(bzcs2D);
    }

    /**
     * ̋Ȑ̎w̋ԂČLaXvCȐԂB
     * <p>
     * pint ̑l̐Βl (2 * ) ȏ̏ꍇɂ́A
     *  (2 * ) ƌȂďA
     * `̋ȐԂB
     * </p>
     * 
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLaXvCȐ
     */
    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
	JgclPureBezierCurve3D[] bzcs = this.toPolyBezierCurves(pint);
	boolean closed =
	    (Math.abs(pint.increase()) >= JgclMath.PI2) ? true : false;

	return JgclConic3D.convertPolyBezierCurvesToOneBsplineCurve(bzcs, closed);
    }

    /**
     * ̋ȐƑ̋ȐƂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȉ~̂ƂɁA
     * ݐݒ肳Ă鉉Z̉ŁA
     * ȉ~ꕽʏɏĂA
     * ȉ~̒SԂ̋̋e덷菬A
     * ȉ~̋Ǐ X ̂Ȃpxpx̋e덷菬A
     * ȉ~̋Ǐ X/Y ꂼɂĂ̔a̍̋e덷ȓłꍇɂ́A
     * ȉ~̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     *
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution mate ȉ~ŁAȉ~̓I[o[bvĂAsł
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̑ȉ~ (\ꂽ) RȐ̌_\㐔𐶐B
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̑ȉ~ poly ̌_\㐔̍
     */
    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
	JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
	JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
	double dAlrd2 = xRadius() * xRadius();
	double dAsrd2 = yRadius() * yRadius();
	boolean isPoly = poly.length < 4;
	int degree = xPoly.degree();
	double[] coef = new double[degree + 1];

	if (isPoly) {
	    for (int j = 0; j <= degree; j++)
		coef[j] = (xPoly.coefficientAt(j) / dAlrd2) +
		    (yPoly.coefficientAt(j) / dAsrd2);
	    coef[0] -= 1.0;
	}
	else {
	    JgclRealPolynomial wPoly = poly[3].multiply(poly[3]);
	    for (int j = 0; j <= degree; j++)
		coef[j] = (dAsrd2 * xPoly.coefficientAt(j)) + (dAlrd2 * yPoly.coefficientAt(j))
		    - (dAlrd2 * dAsrd2 * wPoly.coefficientAt(j));
	}
	return new JgclRealPolynomial(coef);
    }

    /**
     * ^ꂽ_̋Ȑɂ邩ۂ`FbNB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȑɂ trueAłȂ false
     */
    boolean checkSolution(JgclPoint3D point) {
	double param = getParameter(point);
	double px = xRadius() * Math.cos(param);
	double py = yRadius() * Math.sin(param);

	return point.identical(new JgclCartesianPoint3D(px, py, 0.0));
	//return Math.abs(point.z()) < getToleranceForDistance();
    }

    /**
     * ^ꂽ_̋Ȑɂ̂ƂāA
     * ̓_̋Ȑł̃p[^l߂B
     * 
     * @param point	ΏۂƂȂ_
     * @return		p[^l
     */
    double getParameter(JgclPoint3D point) {
	double cos = point.x() / xRadius();
	if (cos > 1.0) cos = 1.0;
	if (cos < -1.0) cos = -1.0;
	double acos = Math.acos(cos);
	if (point.y() < 0.0) acos = 2 * Math.PI - acos;

	return acos;
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclConic3D#intersectCnc(JgclConic3D, boolean)
     * JgclConic3D.intersectCnc(JgclConic3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
	try {
	    return intersectCnc(mate, doExchange);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();	// Never be occured
	}
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ݐݒ肳Ă鉉Z̉ŁA
     * ȉ~ꕽʏɏĂA
     * ȉ~̒SԂ̋̋e덷菬A
     * ȉ~̋Ǐ X ̂Ȃpxpx̋e덷菬A
     * ȉ~̋Ǐ X/Y ꂼɂĂ̔a̍̋e덷ȓłꍇɂ́A
     * ȉ~̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclConic3D#intersectCnc(JgclConic3D, boolean)
     * JgclConic3D.intersectCnc(JgclConic3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	ȉ~̓I[o[bvĂAsł
     */
    JgclIntersectionPoint3D[] intersect(JgclEllipse3D  mate, boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	return intersectCnc(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclConic3D#intersectCnc(JgclConic3D, boolean)
     * JgclConic3D.intersectCnc(JgclConic3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
	try {
	    return intersectCnc(mate, doExchange);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();	// Never be occured
	}
     }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclConic3D#intersectCnc(JgclConic3D, boolean)
     * JgclConic3D.intersectCnc(JgclConic3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
	try {
	    return intersectCnc(mate, doExchange);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();	// Never be occured
	}
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. ȉ~v̌_Z\bh
     * {@link JgclPolyline3D#intersect(JgclEllipse3D, boolean)
     * JgclPolyline3D.intersect(JgclEllipse3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. ȉ~v̌_Z\bh
     * {@link JgclTrimmedCurve3D#intersect(JgclEllipse3D, boolean)
     * JgclTrimmedCurve3D.intersect(JgclEllipse3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. ȉ~v̌_Z\bh
     * {@link JgclCompositeCurveSegment3D#intersect(JgclEllipse3D, boolean)
     * JgclCompositeCurveSegment3D.intersect(JgclEllipse3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐNX́uȐ vs. ȉ~v̌_Z\bh
     * {@link JgclCompositeCurve3D#intersect(JgclEllipse3D, boolean)
     * JgclCompositeCurve3D.intersect(JgclEllipse3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐA^ꂽxNgɏ]ĕsړȐԂB
     *
     * @param moveVec	sړ̕Ɨʂ\xNg
     * @return		sړ̋Ȑ
     */
    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
	return new JgclEllipse3D(position().parallelTranslate(moveVec), semiAxis1, semiAxis2);
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * LŎIȃp[^`ԂB
     * ȂAvC}ȗLԂ [0, (2 * )] łB
     * </p>
     * 
     * @return	LŎIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	try {
	    return new JgclParameterDomain(true, 0, 2*Math.PI);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂB
     * <p>
     * ȉ~Ȃ̂ŁA true ԂB
     * </p>
     *
     * @return	ȉ~Ȃ̂ŁA <code>false</code>
     */
    boolean getClosedFlag() {
	return true;
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve3D#ELLIPSE_3D JgclParametricCurve3D.ELLIPSE_3D}
     */
    int type() {
	return ELLIPSE_3D;
    }

    /**
     * ̋ȐA^ꂽǏWn Z ̎ɁA
     * ^ꂽpx]ȐԂB
     *
     * @param trns	ǏWn瓾ꂽWϊZq
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̋Ȑ
     */
    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns,
				  double rCos, double rSin) {
	JgclAxis2Placement3D rpos = position().rotateZ(trns, rCos, rSin);
	return new JgclEllipse3D(rpos, semiAxis1(), semiAxis2());
    }

    /**
     * ̋Ȑ̓_ŁA^ꂽɂȂ_ԂB
     *
     * @param line	
     * @return		^ꂽɂȂ_
     */
    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol2 = condition.getToleranceForDistance2();

	double start = 0.0, increase = Math.PI / 2.0;
	int itry = 0, limit = 3;
	JgclPoint3D point;
	JgclVector3D vector;

	/*
	 * Get a point which is not on the line and verify that
	 * the distance between a point and the line is greater
	 * than the tolerance.
	 */
	do {
	    if (itry > limit) {
		throw new JgclFatal();	// should never be occurred
	    }
	    point = this.coordinates(start + (increase * itry));
	    vector = point.subtract(line.project1From(point));
	    itry++;
	} while (point.isOn(line) || vector.norm() < dTol2);

	return point;
    }

    /**
     * ̋ȐƁAꂽxWGȖʂƂ̊𒲂ׂB
     * <p>
     * ̃\bh {@link JgclIntsCncBzs3D JgclIntsCncBzs3D} ̓ŎgB
     * </p>
     *
     * @param bi	ꂽxWGȖʂ̏
     * @return	Ă trueAłȂ false
     */
    boolean checkInterfere(JgclIntsCncBzs3D.BezierSurfaceInfo bi) {
	double dTol = getToleranceForDistance();
	if (!((bi.box.min().z() < -dTol) && (bi.box.max().z() > dTol))) 
	    return false;

	double ratio = this.yRadius() / this.xRadius();
	boolean all_in = true;
	boolean all_out = true;

	JgclPoint2D[] point = new JgclPoint2D[4];
	point[0] = new JgclCartesianPoint2D(bi.box.min().x(), bi.box.min().y() / ratio);
	point[1] = new JgclCartesianPoint2D(bi.box.max().x(), bi.box.min().y() / ratio);
	point[2] = new JgclCartesianPoint2D(bi.box.max().x(), bi.box.max().y() / ratio);
	point[3] = new JgclCartesianPoint2D(bi.box.min().x(), bi.box.max().y() / ratio);

	for (int i = 0; i < 4; i++) {
	    double dist = point[i].toVector2D().length();
	    if (dist < this.xRadius() - dTol)
		all_out = false;
	    else if (dist > this.xRadius() + dTol)
		all_in = false;
	    else {
		all_out = false;
		all_in = false;
	    }
	}

	if (all_in == true)
	    return false; /* no interfere */

	else if (all_out == true) {
	    if ((bi.box.min().x() > (this.xRadius() + dTol))
		|| (bi.box.min().y() > (this.yRadius() + dTol))
		|| (bi.box.max().x() < (-(this.xRadius() + dTol)))
		|| (bi.box.max().y() < (-(this.yRadius() + dTol))))
		return false;  /* no interfere */
	    if (((point[0].x() > 0.0) && (point[0].y() > 0.0))
		|| ((point[1].x() < 0.0) && (point[1].y() > 0.0))
		|| ((point[2].x() < 0.0) && (point[2].y() < 0.0))
		|| ((point[3].x() > 0.0) && (point[3].y() < 0.0)))
		return false;  /* no interfere */
	    
	    return true; /* interfere */
	}
	else
	    return true; /* interfere */
    }

    /**
     * ̉~ȐƗ^ꂽʂ̌_߂B
     * <p>
     * ̃\bh {@link JgclIntsCncBzs3D JgclIntsCncBzs3D} ̓ŎgB
     * </p>
     *
     * @param plane  
     * @return       _̔z
     */
    JgclIntersectionPoint3D[] intersectConicPlane(JgclPlane3D plane) {
	JgclAxis2Placement3D position =
	    new JgclAxis2Placement3D(JgclPoint3D.origin, null, null);
	JgclEllipse3D ellipse = new JgclEllipse3D(position,
						 this.xRadius(),
						 this.yRadius());
	try {
	    return ellipse.intersect(plane);
	}
	catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł (̉~Ȑ̋ǏWnł) Wl
     * ԂB
     * 
     * @param parameter	p[^l
     * @return	̉~Ȑ̋ǏWnł̍Wl
     */
    JgclPoint3D nlFunc(double parameter) {
	double x = this.xRadius() * Math.cos(parameter);
	double y = this.yRadius() * Math.sin(parameter);
	double z = 0.0;

	return new JgclCartesianPoint3D(x, y, z);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł (̉~Ȑ̋ǏWnł) ڃxNg
     * ԂB
     * 
     * @param parameter	p[^l
     * @return	̉~Ȑ̋ǏWnł̐ڃxNg
     */
    JgclVector3D dnlFunc(double parameter) {
	double x = - this.xRadius() * Math.sin(parameter);
	double y = this.yRadius() * Math.cos(parameter);
	double z = 0.0;

	return new JgclLiteralVector3D(x, y, z);
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclAxis2Placement3D tPosition =
	    this.position().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	double tSemiAxis1;
	double tSemiAxis2;
	if (reverseTransform != true) {
	    tSemiAxis1 = transformationOperator.transform(this.semiAxis1());
	    tSemiAxis2 = transformationOperator.transform(this.semiAxis2());
	} else {
	    tSemiAxis1 = transformationOperator.reverseTransform(this.semiAxis1());
	    tSemiAxis2 = transformationOperator.reverseTransform(this.semiAxis2());
	}
	return new JgclEllipse3D(tPosition, tSemiAxis1, tSemiAxis2);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tposition");
        position().output(writer, indent + 2);
        writer.println(indent_tab + "\tsemiAxis1 " + semiAxis1);
        writer.println(indent_tab + "\tsemiAxis2 " + semiAxis2);
        writer.println(indent_tab + "End");
    }
}
