/*
 * R : Ȗʂ̃NXKw̃[gƂȂ钊ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclElementarySurface3D.java,v 1.33 2000/08/11 06:18:48 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

/**
 * R : Ȗʂ̃NXKw̃[gƂȂ钊ۃNX
 * <p>
 * ȖʂƂ́Aʁ^ʁ^~ʁ^~ʂȂǂ̂ƂB
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * Ȗʂ̈ʒuƌX肷ǏWn
 * (zuA{@link JgclAxis2Placement3D JgclAxis2Placement3D})
 * position ێB
 * </p>
 * <p>
 * position  null łĂ͂ȂȂB
 * </p>
 *
 * @version $Revision: 1.33 $, $Date: 2000/08/11 06:18:48 $
 * @author Information-technology Promotion Agency, Japan
 */

public abstract class JgclElementarySurface3D extends JgclParametricSurface3D {
    /**
     * Ȗʂ́uSvƋǏ̕肷ǏWnB
     * @serial
     */
    private final JgclAxis2Placement3D position;

    /**
     * ǏWnw肵ȂIuWFNg͍ȂB
     */
    private JgclElementarySurface3D() {
	super();
	this.position = null;
    }

    /**
     * ǏWnw肵ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param position	SƎ
     * @see	JgclInvalidArgumentValue
     */
    protected JgclElementarySurface3D(JgclAxis2Placement3D position) {
	super();
	if (position == null)
	    throw new JgclInvalidArgumentValue("position is null.");
	this.position = position;
    }

    /**
     * ̏Ȗʂ́uSvƋǏ̕肵ĂǏWnԂB
     * 
     * @return	SƋǏ̕ǏWn
     */
    public JgclAxis2Placement3D position() {
	return position;
    }

    /**
     * ̏Ȗʏ̋Ȑ^āÃp[^Ԃł̂Q\𓾂B
     * <p>
     * ۂ̉Z
     * {@link JgclToParameterSpaceOfSurface3D#convertCurve(JgclParametricCurve3D, JgclElementarySurface3D)
     * JgclToParameterSpaceOfSurface3D.convertCurve}(curve, this)
     * ōsȂĂB
     * </p>
     *
     * @param curve	Ȗʏ̋Ȑ (R\)
     * @return		p[^Ԃł̋Ȑ (Q\)
     * @see	#curveToIntersectionCurve(JgclParametricCurve3D, JgclElementarySurface3D, boolean)
     * @see	JgclToParameterSpaceOfSurface3D#convertCurve(JgclParametricCurve3D, JgclElementarySurface3D)
     */
    JgclParametricCurve2D curveToParameterCurve(JgclParametricCurve3D curve) {
	return JgclToParameterSpaceOfSurface3D.convertCurve(curve, this);
    }

    /**
     * ̏ȖʂƑ̏Ȗʂ̌\RȐ^āA
     * IuWFNgɕϊB
     * <p>
     * ̃\bh̓ł́A
     * ̂RȐeȖʂ̃p[^Ԃł̂Q\𓾂邽߂
     * {@link #curveToParameterCurve(JgclParametricCurve3D) curveToParameterCurve(JgclParametricCurve3D)}
     * 𗘗pĂB
     * </p>
     * <p>
     * IuWFNg masterRepresentation ̒l
     * JgclPreferredSurfaceCurveRepresentation.CURVE_3D ƂĂB
     * </p>
     *
     * @param curve	\RȐ
     * @param surface	̋Ȗ
     * @param doExchange	 this  mate ̊i[邩ǂ
     * @return		IuWFNg
     * @see	#curveToParameterCurve(JgclParametricCurve3D)
     */
    JgclIntersectionCurve3D curveToIntersectionCurve(JgclParametricCurve3D curve,
						     JgclElementarySurface3D mate,
						     boolean doExchange) {
	JgclParametricCurve2D pcrv1 = this.curveToParameterCurve(curve);
	JgclParametricCurve2D pcrv2 = mate.curveToParameterCurve(curve);
	if (!doExchange)
	    return new JgclIntersectionCurve3D(curve, this, pcrv1, mate, pcrv2,
					       JgclPreferredSurfaceCurveRepresentation.CURVE_3D);
	else
	    return new JgclIntersectionCurve3D(curve, mate, pcrv2, this, pcrv1,
					       JgclPreferredSurfaceCurveRepresentation.CURVE_3D);
    }

    /**
     * XP[Ol 1 ƂāA
     * ̏Ȗʂ̋ǏWnIȍWnւ̕ϊsȂZqԂB
     * 
     * @return	ǏWnIȍWnւ̕ϊsȂZq
     */
    protected JgclCartesianTransformationOperator3D toGlobal() {
	try {
	    return new JgclCartesianTransformationOperator3D(position(), 1.0);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̏Ȗʂ (\ꂽ) RȐ̌_\㐔𐶐钊ۃ\bhB
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̏Ȗʂ poly ̌_\㐔̍
     * @see	#intersect(JgclPureBezierCurve3D, boolean)
     * @see	#intersect(JgclBsplineCurve3D, boolean)
     */
    abstract JgclRealPolynomial makePoly(JgclRealPolynomial[] poly);

    /**
     * ^ꂽ_̋Ȗʏɂ邩ۂ`FbN钊ۃ\bhB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȗʏɂ trueAłȂ false
     * @see	#intersect(JgclPureBezierCurve3D, boolean)
     * @see	#intersect(JgclBsplineCurve3D, boolean)
     */
    abstract boolean checkSolution(JgclPoint3D point);

    /**
     * ̋ȖʂƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (~Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * {@link JgclPlane3D } ̃NXł́Ã\bhI[o[ChĂB
     * </p>
     * 
     * @param mate	̋Ȑ (~Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclConic3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	return mate.intersectQrd(this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate,
                                        boolean doExchange) {
        /*
         * Translate Bezier's control points into
         * JgclElementarySurface3D's local coordinates system
         */
	JgclCartesianTransformationOperator3D transform = this.toGlobal();
	int uicp = mate.nControlPoints();
	JgclPoint3D[] newCp = new JgclPoint3D[uicp];

        // translate control points
	for (int i = 0; i < uicp; i++) {
	    newCp[i] = transform.toLocal(mate.controlPointAt(i));
        }

        // translate weights
	double[] weights = mate.weights();
	if (mate.isRational()) {
	    double max_weight = 0.0;
	    for (int i = 0; i < uicp; i++) {
		if (Math.abs(weights[i]) > max_weight) {
		    max_weight = weights[i];
                }
	    }
	    if (max_weight > 0.0) {
		for (int i = 0; i < uicp; i++) {
		    weights[i] /= max_weight;
		}
            }
	}

	// make Bezier Curve from new control points
	JgclPureBezierCurve3D bzc = new JgclPureBezierCurve3D(newCp, weights, doCheckDebug);
	
        /*
         * make polynomial
         */
	JgclRealPolynomial[] poly = bzc.polynomial(mate.isPolynomial());
	JgclRealPolynomial realPoly = makePoly(poly);
	JgclComplexPolynomial compPoly = realPoly.toComplexPolynomial();
			
        /*
         * get roots
         */
	JgclComplex[] roots;
	try {
	    roots = compPoly.getRootsByDKA();
	}
	catch (JgclComplexPolynomial.DKANotConverge e) {
	    roots = e.getValues();
	}
	catch (JgclComplexPolynomial.ImpossibleEquation e) {
	    throw new JgclFatal();
	}
	catch (JgclComplexPolynomial.IndefiniteEquation e) {
	    throw new JgclFatal();
	}

	int nRoots = roots.length;
	    
	// ̃`FbN
	Vector bzcParams  = new Vector();
	Vector bzcPoints = new Vector();

	for (int j = 0; j < nRoots; j++) {
	    double realRoot = roots[j].real();
	    if (bzc.parameterValidity(realRoot) == JgclParameterValidity.OUTSIDE)
		continue;
	    
	    JgclPoint3D workPoint = bzc.coordinates(realRoot);

	    int paramNum = bzcParams.size();
	    if (checkSolution(workPoint)) {
		int k;
		for (k = 0; k < paramNum; k++) {
		    double paramA =
			((Double)bzcParams.elementAt(k)).doubleValue();
                    JgclPoint3D kthPoint = (JgclPoint3D)bzcPoints.elementAt(k);
		    if ((workPoint.identical(kthPoint)) &&
                        (bzc.identicalParameter(realRoot, paramA)))
			break;
		}
		if (k >= paramNum) {
		    bzcParams.addElement(new Double(realRoot));
		    bzcPoints.addElement(workPoint);
		}
	    }
	}

        /*
         * solution
         */
	int num = bzcParams.size();
        JgclIntersectionPoint3D[] intersectPoints = new
            JgclIntersectionPoint3D[num];
	for (int i = 0; i < num; i++) {
	    double bzcParam = ((Double)bzcParams.elementAt(i)).doubleValue();
	    JgclPoint3D coordinates = mate.coordinates(bzcParam);
            double[] myParams = pointToParameter(coordinates);

	    if (doExchange) {
		intersectPoints[i] = new
		    JgclIntersectionPoint3D(mate, bzcParam,
					    this, myParams[0], myParams[1],
					    doCheckDebug);
            } else {
		intersectPoints[i] = new
		    JgclIntersectionPoint3D(this, myParams[0], myParams[1],
					    mate, bzcParam,
					    doCheckDebug);
            }
	}

	return intersectPoints;
    }

    /**
     * ̋ȖʂƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate,
                                        boolean doExchange) {
	JgclCartesianTransformationOperator3D transform = this.toGlobal();
	JgclBsplineKnot.ValidSegmentInfo vsegInfo = mate.validSegments();
	int uicp = mate.nControlPoints();
	JgclPoint3D[] newCp = new JgclPoint3D[uicp];

	// Transform Bspline's control points into conic's local coordinates
	for (int i = 0; i < uicp; i++)
	    newCp[i] = transform.toLocal(mate.controlPointAt(i));

	// make Bspline curve from new control points
	JgclBsplineCurve3D bsc = new
	    JgclBsplineCurve3D(mate.knotData(), newCp, mate.weights());

	// For each segment
	Vector pointVec = new Vector();
	Vector paramVec = new Vector();
	int nSeg = vsegInfo.nSegments();

	for (int i = 0; i < nSeg; i++) {
	    // make polynomial
	    JgclRealPolynomial[] poly =
		bsc.polynomial(vsegInfo.segmentNumber(i), bsc.isPolynomial());
	    JgclRealPolynomial realPoly = makePoly(poly);
	    JgclComplexPolynomial compPoly = realPoly.toComplexPolynomial();

	    // solve polynomial
	    JgclComplex[] roots;
	    try {
		roots = compPoly.getRootsByDKA();
	    }
	    catch (JgclComplexPolynomial.DKANotConverge e) {
		roots = e.getValues();
	    }
	    catch (JgclComplexPolynomial.ImpossibleEquation e) {
		throw new JgclFatal();
	    }
	    catch (JgclComplexPolynomial.IndefiniteEquation e) {
		throw new JgclFatal();
	    }

            int k = 0;
	    int nRoots = roots.length;
	    for (int j = 0; j < nRoots; j++) {
		double realRoot = roots[j].real();
		if (bsc.parameterValidity(realRoot) == JgclParameterValidity.OUTSIDE)
		    continue;

		double[] knotParams = vsegInfo.knotPoint(i);
		if (realRoot < knotParams[0]) realRoot = knotParams[0];
		if (realRoot > knotParams[1]) realRoot = knotParams[1];

		JgclPoint3D workPoint = bsc.coordinates(realRoot);
		// check solution
		if (!checkSolution(workPoint))
		    continue;

                // check duplicate solution
		int jj;
  		for (jj = 0; jj < k; jj++) {
  		    double dTol = bsc.getToleranceForDistance();
  		    JgclPoint3D pnt = (JgclPoint3D)pointVec.elementAt(jj);
  		    double param = ((Double)paramVec.elementAt(jj)).doubleValue();
  		    if (pnt.identical(workPoint)
			&& bsc.identicalParameter(param, realRoot))
  			break;
  		}
		if (jj >= k) {
		    pointVec.addElement(workPoint);
		    paramVec.addElement(new Double(realRoot));
		    k++;
		}
	    }
	}

	// make intersection point
	int num = paramVec.size();
	JgclIntersectionPoint3D[] intersectPoints = new
            JgclIntersectionPoint3D[num];
	for (int i = 0; i < num; i++) {
	    // get intersection point parameter on Bsc
	    double bscParam = ((Double)paramVec.elementAt(i)).doubleValue();

	    // get Parameter from solution point
	    JgclPoint3D coordinates = mate.coordinates(bscParam);
	    double myParams[] = pointToParameter(coordinates);


	    // make an intersection point
	    if (doExchange) {
		intersectPoints[i] = new
                    JgclIntersectionPoint3D(mate, bscParam,
                                            this, myParams[0], myParams[1],
                                            doCheckDebug);
            } else {
		intersectPoints[i] = new
                    JgclIntersectionPoint3D(this, myParams[0], myParams[1],
                                            mate, bscParam,
                                            doCheckDebug);
            }
	}

	return intersectPoints;
    }
}
