/*
 * R : ~ʂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCylindricalSurface3D.java,v 1.62 2000/08/11 06:18:48 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : ~ʂ\NXB
 * <p>
 * ~ʂ́A̒S̈ʒuƋǏ X/Y/Z ̕ǏWn
 * (zuA{@link JgclAxis2Placement3D JgclAxis2Placement3D}) position 
 * a radius Œ`B
 * </p>
 * <p>
 * ~ʂ
 * U ̃p[^`͗LŎIłA
 * ̃vC}ȗLԂ [0, (2 * )] łB
 * V ̃p[^`͖ŔIłB
 * </p>
 * <p>
 * (u, v) p[^Ƃ~ P(u, v) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(u, v) = c + radius * (cos(u) * x + sin(u) * y) + v * z
 * </pre>
 * ŁAc, x, y, z ͂ꂼ
 * <pre>
 *	c : position.location()
 *	x : position.x()
 *	y : position.y()
 *	z : position.z()
 * </pre>
 * \B
 * </p>
 *
 * @version $Revision: 1.62 $, $Date: 2000/08/11 06:18:48 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclCylindricalSurface3D extends JgclElementarySurface3D {
    /**
     * aB
     * @serial
     */
    private double radius;

    /**
     * aݒ肷B
     * <p>
     * radius ̒lA
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     *
     * @param radius	a
     * @see	JgclInvalidArgumentValue
     */
    private void setRadius(double radius)
    {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = condition.getToleranceForDistance();

	if (radius < dTol) {
	    throw new JgclInvalidArgumentValue();
	}
	this.radius = radius;
    }

    /**
     * ǏWnƔa^ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * radius ̒lA
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param position	Ǐ_ƋǏ X/Y/Z ̕ǏWn
     * @param radius	a
     * @see	JgclInvalidArgumentValue
     */
    public JgclCylindricalSurface3D(JgclAxis2Placement3D position,
				    double radius)
    {
	super(position);
	setRadius(radius);
    }

    /**
     * SƔa^ăIuWFNg\zB
     * <p>
     * cntr  axis  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * radius ̒lA
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param cntr	Ǐ_
     * @param axis	Ǐ Z 
     * @param radius	a
     * @see	JgclInvalidArgumentValue
     */
    public JgclCylindricalSurface3D(JgclPoint3D cntr, JgclVector3D axis,
				    double radius)
    {
	super(new JgclAxis2Placement3D(cntr, axis,
				      axis.verticalVector().unitized()));
	setRadius(radius);
    }

    /**
     * ̉~ʂ̔aԂB
     * 
     * @return	a
     */
    public double radius() {
	return this.radius;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̍WlԂB
     * 
     * @param uParam	U p[^l
     * @param vParam	V p[^l
     * @return		Wl
     */
    public JgclPoint3D coordinates(double uParam, double vParam) {
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	double x = radius * Math.cos(uParam);
	double y = radius * Math.sin(uParam);
	JgclPoint3D pnt = new JgclCartesianPoint3D(x, y, vParam);

	return gtrans.transform(pnt);
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ł̐ڃxNgƂ́Ap[^ U/V ̊eXɂĂ̈ꎟΓ֐łB
     * </p>
     * <p>
     * ʂƂĕԂz̗vf 2 łB
     * z̍ŏ̗vfɂ U p[^ɂĂ̐ڃxNgA
     * Ԗڂ̗vfɂ V p[^ɂĂ̐ڃxNg܂ށB
     * </p>
     *
     * @param uParam	U p[^l
     * @param vParam	V p[^l
     * @return		ڃxNg̔z
     */
    public JgclVector3D[] tangentVector(double uParam, double vParam) {
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	double dux = -radius * Math.sin(uParam);
	double duy =  radius * Math.cos(uParam);
	JgclVector3D dup = new JgclLiteralVector3D(dux, duy, 0.0);
	JgclVector3D dvp = JgclVector3D.zUnitVector;

	JgclVector3D[] tang = {gtrans.transform(dup), gtrans.transform(dvp)};
	return tang;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̖@xNgԂB
     * <p>
     * ̃\bhԂ@xNǵAKꂽPʃxNgłB 
     * </p>
     *
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Kꂽ@xNg
     */
    public JgclVector3D normalVector(double uParam, double vParam)
    {
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	double x = radius * Math.cos(uParam);
	double y = radius * Math.sin(uParam);
	JgclVector3D nrm = new JgclLiteralVector3D(x, y, 0.0);

	return gtrans.transform(nrm).unitized();
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̎ȗԂB
     * <p>
     * ȗ1 (principalCurvature1) ɂ (- 1 / radius)A
     * ȗ2 (principalCurvature2) ɂ 0A
     * xNg1 (principalDirection1) ɂ U p[^ɂĂ̐ڃxNg̒PʃxNgA
     * xNg2 (principalDirection2) ɂ V p[^ɂĂ̐ڃxNg̒PʃxNg
     * ԂB
     * </p>
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		ȗ
     */
    public JgclSurfaceCurvature3D curvature(double uParam, double vParam) {
	JgclVector3D[] tangent = tangentVector(uParam, vParam);

	return new JgclSurfaceCurvature3D(-1.0/radius, tangent[0].unitized(),
					  0,           tangent[1].unitized());
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̕Γ֐ԂB
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Γ֐
     */
    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	double x = radius * Math.cos(uParam);
	double y = radius * Math.sin(uParam);
	// p    = (x, y, vParam)
	// dup  = (-y, x, 0)
	// dvp  = (0, 0, 1)
	// duup = (-x, -y, 0);
	// duvp = (0, 0, 0)
	// dvvp = (0, 0, 0)

	JgclPoint3D pnt = new JgclCartesianPoint3D(x, y, vParam);
	JgclVector3D dup = new JgclLiteralVector3D(-y, x, 0.0);
	JgclVector3D dvp = JgclVector3D.zUnitVector;
	JgclVector3D duup = new JgclLiteralVector3D(-x, -y, 0.0);
	JgclVector3D zerov = JgclVector3D.zeroVector;

	return new JgclSurfaceDerivative3D(gtrans.transform(pnt),
					   gtrans.transform(dup),
					   gtrans.transform(dvp),
					   gtrans.transform(duup),
					   gtrans.transform(zerov),
					   gtrans.transform(zerov));
    }

    /**
     * ^ꂽ_炱̋Ȗʂւ̓e_߂B
     * <p>
     * ^ꂽ_̉~ʂ̒SɂȂA
     * ɓ̓e_ԂB
     * </p>
     * <p>
     * ^ꂽ_Ƃ̉~ʂ̒SƂ̋A
     * ݐݒ肳Ă鉉Z̋̋e덷
     * ꍇɂ́A
     * JgclIndefiniteSolution ̗O𓊂B
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @exception	JgclIndefiniteSolution	s (e̓_~ʂ̒Sɂ)
     */
    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point)
	throws JgclIndefiniteSolution
    {
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	JgclPoint3D lpoint = gtrans.reverseTransform(point);
	double z = lpoint.z();
	JgclPoint3D apoint = new JgclCartesianPoint3D(0.0, 0.0, z);
	JgclVector3D eduvec = lpoint.subtract(apoint);

	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = Math.abs(condition.getToleranceForDistance());

	if (eduvec.length() < dTol) {
	    JgclPointOnSurface3D p;

	    try {
		p = new JgclPointOnSurface3D(this, 0.0, z, doCheckDebug);
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

 	    throw new JgclIndefiniteSolution(p);
	}
	eduvec = eduvec.unitized();

	// get vector angle
	double u = Math.atan2(eduvec.y(), eduvec.x());

	if (u < 0)
	    u += 2*Math.PI;
	JgclPointOnSurface3D foot1 = new JgclPointOnSurface3D(this, u, z, doCheckDebug);
	u += Math.PI;
	if (u >= 2*Math.PI)
	    u -= 2*Math.PI;
	JgclPointOnSurface3D foot2 = new JgclPointOnSurface3D(this, u, z, doCheckDebug);

 	JgclPointOnSurface3D[] proj = { foot1, foot2 };

	return proj;
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎiq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return	̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     */
    public JgclMesh3D
    toMesh(JgclParameterSection uPint,
	   JgclParameterSection vPint,
	   JgclToleranceForDistance tol) {
	return this.makeMesh(1, uPint, vPint, tol);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎiq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param meshType	toMesh Ȃ 1 AtoNonStructuredPoints Ȃ 2
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return	̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     * @see	#toMesh(JgclParameterSection, JgclParameterSection, JgclToleranceForDistance)
     * @see	#toNonStructuredPoints(JgclParameterSection, JgclParameterSection, double, double[])
     */
    private JgclMesh3D
	   makeMesh(int meshType,
		    JgclParameterSection uPint,
		    JgclParameterSection vPint,
		    JgclToleranceForDistance tol) {
	JgclPointOnSurface3D[][] mesh;
	double uParam;
	double vStart = vPint.start();
	double vEnd = vPint.end();
	double vMiddle = (vStart + vEnd) / 2.0;
	JgclPolyline3D pol;
	int u_npnts;
	JgclPointOnCurve3D poc;
	JgclPoint3D pnt;
	JgclPoint3D pnt2;
	JgclVector3D vec;
	JgclVector3D vec2;
	int i;

	/*
	 * V̊Jnʒuł̒fʂƂȂ~߁A
	 * ɉ~|CߎB
	 * ̐ߓ_VJnʒuł̊iq_ƂȂB
	 */
	try {
	    JgclCartesianTransformationOperator3D gtrans = toGlobal();
	    JgclPoint3D cntr;
	    JgclAxis2Placement3D pos;
	    JgclCircle3D cir;

	    pnt = new JgclCartesianPoint3D(0.0, 0.0, vStart);	// S߂B
	    cntr = gtrans.transform(pnt);

	    pos = new JgclAxis2Placement3D(cntr, position().z(), position().x());
	    cir = new JgclCircle3D(pos, radius());		// ~߂B

	    pol = cir.toPolyline(uPint, tol);
	} catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

	/*
	 * V̊Jn_̊iq_V̏I_փRs[A
	 * iq_\B
	 */
	u_npnts = pol.nPoints();
	vec = position().z().multiply(vPint.increase());

	if (meshType == 1) {
	    vec2 = null;
	    mesh = new JgclPointOnSurface3D[u_npnts][2];
	} else {
	    vec2 = position().z().multiply(vPint.increase() / 2.0);
	    mesh = new JgclPointOnSurface3D[u_npnts][3];
	}

	for (i = 0; i < u_npnts; i++) {
	    try {
		poc = (JgclPointOnCurve3D)pol.pointAt(i);
		pnt = new JgclCartesianPoint3D(poc.x(), poc.y(), poc.z());
		uParam = poc.parameter();
		mesh[i][0] = new JgclPointOnSurface3D(pnt, this, uParam, vStart, doCheckDebug);
		if (meshType == 1) {
		    pnt = pnt.add(vec);
		    mesh[i][1] = new JgclPointOnSurface3D(pnt, this, uParam, vEnd, doCheckDebug);
		} else {
		    pnt2 = pnt.add(vec2);
		    mesh[i][1] = new JgclPointOnSurface3D(pnt, this, uParam, vMiddle, doCheckDebug);
		    pnt = pnt.add(vec);
		    mesh[i][2] = new JgclPointOnSurface3D(pnt, this, uParam, vEnd, doCheckDebug);
		}
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	return new JgclMesh3D(mesh, false);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂɍČL Bspline ȖʂԂB
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @return		̋Ȗʂ̎w̋ԂČL Bspline Ȗ
     */
    public JgclBsplineSurface3D
	toBsplineSurface(JgclParameterSection uPint,
			 JgclParameterSection vPint)
    {
	JgclCircle2D circle2D =
	    new JgclCircle2D(JgclAxis2Placement2D.origin, this.radius());

	JgclBsplineCurve2D uBsplineCurve2D = circle2D.toBsplineCurve(uPint);

	int uNPoints = uBsplineCurve2D.nControlPoints();
	int vNPoints = 2;

	JgclPoint3D[][] controlPoints = new JgclPoint3D[uNPoints][vNPoints];
	double[][] weights = new double[uNPoints][vNPoints];

	JgclCartesianTransformationOperator3D localTransformationOperator =
	    this.position().toCartesianTransformationOperator(1.0);

	double vLowerCoord = vPint.start();
	double vUpperCoord = vPint.end();

	for (int ui = 0; ui < uNPoints; ui++) {
	    JgclPoint2D uPoint = uBsplineCurve2D.controlPointAt(ui);
	    controlPoints[ui][0] =
		localTransformationOperator.toEnclosed(uPoint.to3D(vLowerCoord));
	    controlPoints[ui][1] =
		localTransformationOperator.toEnclosed(uPoint.to3D(vUpperCoord));
	    weights[ui][0] = weights[ui][1] = uBsplineCurve2D.weightAt(ui);
	}

	return new JgclBsplineSurface3D(uBsplineCurve2D.knotData(),
					JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment,
					controlPoints, weights);
    }

    /**
     * ^ꂽ_̋Ȗʏɂ邩ۂ`FbNB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȗʏɂ trueAłȂ false
     */
    boolean checkSolution(JgclPoint3D point) {
 	double dTol = getToleranceForDistance();
	double dist = Math.sqrt(point.x() * point.x() + point.y() * point.y());
 	return Math.abs(dist - radius()) < dTol;
    }

    /**
     * ̏Ȗʂ (\ꂽ) RȐ̌_\㐔𐶐B
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̏Ȗʂ poly ̌_\㐔̍
     */
    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
  	JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
  	JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
  	double radius2 = this.radius() * this.radius();
  	boolean isPoly = poly.length < 4;
  	int degree = xPoly.degree();
  	double[] coef = new double[degree + 1];
  	if (isPoly) {
  	    for (int j = 0; j <= degree; j++) {
  		coef[j] = xPoly.coefficientAt(j) +
	                  yPoly.coefficientAt(j);
  	    }
  	    coef[0] -= radius2;
  	} else {
  	    JgclRealPolynomial wPoly = poly[3].multiply(poly[3]);
  	    for (int j = 0; j <= degree; j++) {
  		coef[j] = xPoly.coefficientAt(j) +
  			  yPoly.coefficientAt(j) -
  			  (radius2 * wPoly.coefficientAt(j));
  	    }
  	}
  	return new JgclRealPolynomial(coef);
    }

    /**
     * ̋ȖʂƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
	throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȖʂƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	// tolerance
	double aTol = getToleranceForAngle();
	double dTol = getToleranceForDistance();
	
	JgclVector3D unit_dir = mate.dir().unitized(); // line's unit dir
	JgclVector3D cyl_axis = position().z();        // cylinder's axis
	JgclPoint3D cyl_org = position().location();   // cylinder's origin
	
	if(Math.abs(unit_dir.dotProduct(cyl_axis)) > Math.cos(aTol)){
	    // Line & Cylinder are parallel
	    JgclVector3D pnt_to_org = cyl_org.subtract(mate.pnt());
	    double innerProduct = pnt_to_org.dotProduct(unit_dir);
	    double[] pnt = new double[3];
	    pnt[0] = mate.pnt().x() + innerProduct * unit_dir.x();
	    pnt[1] = mate.pnt().y() + innerProduct * unit_dir.y();
	    pnt[2] = mate.pnt().z() + innerProduct * unit_dir.z();
	    JgclCartesianPoint3D projected_org = new JgclCartesianPoint3D(pnt[0],pnt[1],pnt[2]);
	    JgclVector3D org_to_line = projected_org.subtract(cyl_org);
	    if(Math.abs( org_to_line.length() - radius()) < dTol){
		// overlap
		throw new JgclIndefiniteSolution(mate.pnt());
	    }
	    return new JgclIntersectionPoint3D[0];
	}
	
	// transform line to cylinder's local coordinates
	JgclCartesianTransformationOperator3D trans = new
	    JgclCartesianTransformationOperator3D(position(),1.0);
	
	JgclPoint3D ppnt = trans.reverseTransform(mate.pnt());
	JgclVector3D pvector = trans.reverseTransform(mate.dir());
	JgclLine3D translated_line = new JgclLine3D(ppnt,pvector);

	// resolve in 2D
	JgclCartesianPoint2D cir_org = new JgclCartesianPoint2D(0.0,0.0);
	JgclCircle2D circle = new JgclCircle2D(cir_org,radius());
	JgclLine2D line2 = mate.toLocal2D(trans);

	JgclIntersectionPoint2D[] int_pnt2d = new JgclIntersectionPoint2D[0];

	try{
	   int_pnt2d = circle.intersect(line2);
	}catch (JgclIndefiniteSolution e){
	    // IndefiniteSolution doesnt happen !
	}

	if(int_pnt2d.length == 0)
	return new JgclIntersectionPoint3D[0];
	
	JgclIntersectionPoint3D[] int_pnt = new JgclIntersectionPoint3D[int_pnt2d.length];
	double cyl_param;
	double line_param;

	for(int i=0;i<int_pnt2d.length;i++){
	    line_param = int_pnt2d[i].pointOnCurve2().parameter();
	    cyl_param = int_pnt2d[i].pointOnCurve1().parameter();
	    JgclPoint3D pnt = mate.coordinates(line_param);

	    double height_param = 
		translated_line.pnt().z() + line_param * translated_line.dir().z();

	    // point on line
            JgclPointOnCurve3D PonC = new JgclPointOnCurve3D(pnt,mate,line_param,doCheckDebug);

            // point on surface
            JgclPointOnSurface3D PonS =
                new JgclPointOnSurface3D(pnt,this,cyl_param,height_param,doCheckDebug);

            // intersection point
	    if(doExchange)
		int_pnt[i] = new JgclIntersectionPoint3D(pnt,PonC,PonS,doCheckDebug);
	    else
		int_pnt[i] = new JgclIntersectionPoint3D(pnt,PonS,PonC,doCheckDebug);
	}
	return int_pnt;
    }

    /**
     * ̋ȖʂƑ̋Ȗʂ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		 (܂͌_) ̔z
     * @exception	JgclIndefiniteSolution	mate ~ʂŁA҂I[o[bvĂAsł
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     */
    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate)
	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ʂ̃NX́u vs. ~ʁv̌\bh
     * {@link JgclPlane3D#intersect(JgclCylindricalSurface3D, boolean)
     * JgclPlane3D.intersect(JgclCylindricalSurface3D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSphCyl3D#intersection(JgclSphericalSurface3D, JgclCylindricalSurface3D, boolean)
     * JgclIntsSphCyl3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate,
						 boolean doExchange) {
	return JgclIntsSphCyl3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsCylCyl3D#intersection(JgclCylindricalSurface3D, JgclCylindricalSurface3D, boolean)
     * JgclIntsCylCyl3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @exception	JgclIndefiniteSolution	҂I[o[bvĂAsł
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate,
						 boolean doExchange)
        throws JgclIndefiniteSolution
    {
	return JgclIntsCylCyl3D.intersection(this, mate, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsCylCon3D#intersection(JgclCylindricalSurface3D, JgclConicalSurface3D, boolean)
     * JgclIntsCylCon3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate,
						 boolean doExchange) {
	return JgclIntsCylCon3D.intersection(this, mate, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (xWGȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsQrdBzs3D#intersection(JgclElementarySurface3D, JgclPureBezierSurface3D, boolean)
     * JgclIntsQrdBzs3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate,
						 boolean doExchange) {
	return JgclIntsQrdBzs3D.intersection(this, mate, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (aXvCȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSrfBss3D#intersection(JgclElementarySurface3D, JgclBsplineSurface3D, boolean)
     * JgclIntsSrfBss3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate,
						 boolean doExchange) {
	return JgclIntsSrfBss3D.intersection(this, mate, doExchange);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂItZbgȖʂ
     * ^ꂽ덷ŋߎ Bspline Ȗʂ߂B
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.FRONT/BACK)
     * @param tol     	̋e덷
     * @return		̋Ȗʂ̎w̋`Ԃ̃ItZbgȖʂߎ Bspline Ȗ
     * @see	JgclWhichSide
     */
    public JgclBsplineSurface3D
	offsetByBsplineSurface(JgclParameterSection uPint,
			       JgclParameterSection vPint,
			       double magni,
			       int side,
			       JgclToleranceForDistance tol)
    {
	JgclOfst3D doObj = new JgclOfst3D(this,uPint,vPint,magni,side,tol);
	return doObj.offset();
    }
    
    /**
     * ̋Ȗʂ U p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param uParam	U ̃p[^l
     * @return	w U p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
	JgclPoint3D pnt = coordinates(uParam, 0.0);
	JgclVector3D dir = position().z();
	return new JgclLine3D(pnt, dir);
    }

    /**
     * ̋Ȗʂ V p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param vParam	V ̃p[^l
     * @return	w V p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D vIsoParametricCurve(double vParam) {
	JgclPoint3D pnt = position().location().add(position().z().multiply(vParam));
	JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(pnt, position().z(), position().x());
	return new JgclCircle3D(a2p, radius());
    }

    /**
     * ̋Ȗʂ U ̃p[^`ԂB
     * <p>
     * LŎIȒ`ԂB
     * </p>
     *
     * @return	̋Ȗʂ U ̃p[^`
     */
    JgclParameterDomain getUParameterDomain() {
	try {
	    return new JgclParameterDomain(true, 0, 2*Math.PI);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȗʂ V ̃p[^`ԂB
     * <p>
     * ŔIȒ`ԂB
     * </p>
     *
     * @return	̋Ȗʂ V ̃p[^`
     */
    JgclParameterDomain getVParameterDomain() {
	return new JgclParameterDomain();
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricSurface3D#CYLINDRICAL_SURFACE_3D JgclParametricSurface3D.CYLINDRICAL_SURFACE_3D}
     */
    int type() {
	return CYLINDRICAL_SURFACE_3D;
    }

    /**
     * ̉~ (̒S) ƁA^ꂽ~ (̒S) sǂ𔻒肷B
     * <p>
     * ̉~ʂ̋Ǐ Z ̂Ȃpx 邢 ( - ) 
     * ݐݒ肳Ă鉉Z̊px̋e덷
     * sł̂ƂB
     * </p>
     *
     * @param   mate  Ώۂ̉~
     * @return	      sł trueAłȂ false
     */
    boolean isParallel(JgclCylindricalSurface3D mate) {
	JgclVector3D thisAxis = this.position().z();
	JgclVector3D mateAxis = mate.position().z();
	double dot = thisAxis.dotProduct(mateAxis);

	return Math.abs(dot) > Math.cos(getToleranceForAngle());
    }

    /**
     * ̉~ʂƁA^ꂽ~ʂ̉~ʂƂ݂Ȃ邩ǂ𔻒肷B
     *
     * @param   mate  Ώۂ̉~
     * @return	      ̉~ʂƂ݂Ȃ trueAłȂ false
     */
    boolean equals(JgclCylindricalSurface3D mate) {
	if (isParallel(mate)) {
	    JgclPoint3D source = mate.position().location();
	    JgclPointOnCurve3D[] foot = getAxis().projectFrom(source);

	    if (foot.length != 1) throw new JgclFatal();

	    double dist = source.distance(foot[0]);
	    double dTol = getToleranceForDistance();

	    if (dist < dTol)
		if (Math.abs(radius() - mate.radius()) < dTol)
		    return true;
	}
	return false;
    }

    /**
     * ̉~ʂ̒SƂȂ钼ԂB
     *
     * @return	S
     */
    JgclLine3D getAxis() {
	return new JgclLine3D(position().location(), position().z());
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎ_QԂB
     * <p>
     * ʂƂē_Q͈ʂɁAʑIɂ􉽓IɂAiqł͂ȂB
     * </p>
     * <p>
     * scalingFactor ́A͗pł͂ȂAo͗p̈łB
     * scalingFactor ɂ́Avf 2 ̔z^B
     * scalingFactor[0] ɂ U ̏kڔ{A
     * scalingFactor[1] ɂ V ̏kڔ{ԂB
     * ̒l͉炩̐Βlł͂ȂA
     * p[^̐iޑx T ɑ΂āA
     * U/V ɂĎԏŋȖʏ̓_iޑx Pu/Pv \ΒlłB
     * ܂Ap[^ T iނƁA
     * ԏł̋Ȗʏ̓_ U ł Pu (scalingFactor[0])A
     * V ł Pv (scalingFactor[1]) iނƂ\ĂB
     * T ̑傫͖Ȃ̂ŁA̒lQƂۂɂ́A
     * scalingFactor[0]  scalingFactor[1] ̔䂾pׂłB
     * ȂA̒l͂܂łڈłAȑx̂ł͂ȂB
     * </p>
     * <p>
     * ʂƂĕԂ Vector Ɋ܂܂evf
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D
     * ł邱Ƃ҂łB
     * </p>
     *
     * @param uParameterSection	U ̃p[^
     * @param vParameterSection	V ̃p[^
     * @param tolerance	̋e덷
     * @param scalingFactor	_QOp`ۂɗLpƎv U/V ̏kڔ{
     * @return	_Q܂ Vector
     * @see	JgclPointOnSurface3D
     */
    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection,
					JgclParameterSection vParameterSection,
					double tolerance,
					double[] scalingFactor) {
	Vector result = new Vector();

	JgclMesh3D mesh = this.makeMesh(2, uParameterSection, vParameterSection,
					new JgclToleranceForDistance(tolerance));

	for (int u = 0; u < mesh.uNPoints(); u++)
	    for (int v = 0; v < mesh.vNPoints(); v++)
		result.addElement(mesh.pointAt(u, v));

	scalingFactor[0] = this.radius();
	scalingFactor[1] = 1.0;

	return result;
    }

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricSurface3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclAxis2Placement3D tPosition =
	    this.position().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	double tRadius;
	if (reverseTransform != true)
	    tRadius = transformationOperator.transform(this.radius());
	else
	    tRadius = transformationOperator.reverseTransform(this.radius());
	return new JgclCylindricalSurface3D(tPosition, tRadius);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tposition");
        position().output(writer, indent + 2);
        writer.println(indent_tab + "\tradius\t" + radius);
        writer.println(indent_tab + "End");
    }
}
