/*
 * ȐƋȖʂ̊̃XgNX
 * ł̓I[o[bv̓T|[gĂȂ
 * ܂2̗vf̓T|[gĂȂ
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCurveSurfaceInterferenceList.java,v 1.7 2000/04/26 09:38:52 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * ȐƋȖʂ̊̃XgNX
 * ł̓I[o[bv̓T|[gĂȂ
 * ܂2̗vf̓T|[gĂȂ
 *
 * @version $Revision: 1.7 $, $Date: 2000/04/26 09:38:52 $
 * @author Information-technology Promotion Agency, Japan
 */
class JgclCurveSurfaceInterferenceList
{
    /**
     * Ȑ A
     */
    JgclParametricCurve curveA;

    /**
     * Ȑ A ̒`
     */
    JgclParameterDomain parameterDomainA;

    /**
     * Ȗ B
     */
    JgclParametricSurface surfaceB;

    /**
     * Ȗ B ̒`
     */
    JgclParameterDomain uParameterDomainB;
    JgclParameterDomain vParameterDomainB;

    /**
     * ̋e덷 (IuWFNg\zꂽ_ł)
     */
    JgclToleranceForDistance dTol;

    /**
     * _̃Xg
     */
    Vector listOfIntersections;

    /*
     * IuWFNg\z
     *
     * @param	curveA	 Ȑ A
     * @param	surfaceB Ȗ B
     */
    JgclCurveSurfaceInterferenceList(JgclParametricCurve curveA,
				     JgclParametricSurface surfaceB)
    {
	if ((curveA == null) || (surfaceB == null))
	    throw new JgclNullArgument();

	if (curveA.dimension() != surfaceB.dimension())
	    throw new JgclDimensionsMismatch();

	this.curveA = curveA;
	this.parameterDomainA = curveA.parameterDomain();

	this.surfaceB = surfaceB;
	// gimmick!!
	if (((JgclParametricSurface3D)surfaceB).type() != JgclParametricSurface3D.CURVE_BOUNDED_SURFACE_3D) {
	    this.uParameterDomainB = surfaceB.uParameterDomain();
	    this.vParameterDomainB = surfaceB.vParameterDomain();
	} else {
	    JgclParametricSurface3D basisSurface = ((JgclCurveBoundedSurface3D)surfaceB).basisSurface();
	    this.uParameterDomainB = basisSurface.uParameterDomain();
	    this.vParameterDomainB = basisSurface.vParameterDomain();
	}

	JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
	this.dTol = cond.getToleranceForDistanceAsObject();

	this.listOfIntersections = new Vector();
    }

    /**
     * Ȑ̂p[^lt߂ł̃p[^̋e덷߂B
     *
     * ToleranceForDistance Zo
     *
     * @param	curve	Ȑ
     * @param	param	p[^l
     */
    private double getToleranceForParameter(JgclParametricCurve curve, double param)
    {
	return dTol.toToleranceForParameter((JgclParametricCurve3D)curve, param).value();
    }

    /**
     * Ȗʂ̂p[^lt߂łŨp[^̋e덷߂B
     *
     * ToleranceForDistance Zo
     *
     * @param	surface	Ȗ
     * @param	uParam	Up[^l
     * @param	vParam	Vp[^l
     */
    private double getToleranceForParameterU(JgclParametricSurface surface,
					     double uParam, double vParam)
    {
	return dTol.toToleranceForParameterU((JgclParametricSurface3D)surface,
					     uParam, vParam).value();
    }

    /**
     * Ȗʂ̂p[^lt߂łṼp[^̋e덷߂B
     *
     * ToleranceForDistance Zo
     *
     * @param	surface	Ȗ
     * @param	uParam	Up[^l
     * @param	vParam	Vp[^l
     */
    private double getToleranceForParameterV(JgclParametricSurface surface,
					     double uParam, double vParam)
    {
	return dTol.toToleranceForParameterV((JgclParametricSurface3D)surface,
					     uParam, vParam).value();
    }

    /*
     * _̃p[^lƂ݂Ȃ邩ۂAɊւ萔
     */
    private static final int PARAMETERS_NOT_IDENTICAL   = 0x0;
    private static final int PARAMETERS_IDENTICAL       = 0x1;
    private static final int PARAMETERS_CROSSBOUNDARY_A = 0x2;
    private static final int PARAMETERS_CROSSBOUNDARY_U_B = 0x4;
    private static final int PARAMETERS_CROSSBOUNDARY_V_B = 0x8;

    /**
     * _̃p[^lƂ݂Ȃ邩ۂA\
     */
    class ParametricalIdentityOfTwoIntersections {
	/**
	 * _̃p[^lƂ݂Ȃ邩ۂA\
	 */
	private int value;

	/**
	 * IuWFNg\z
	 */
	ParametricalIdentityOfTwoIntersections() {
	    setNonIdentical();
	}

	/**
	 * _̃p[^lƂ݂ȂȂ̂Ƃ
	 */
	private void setNonIdentical() {
	    value = PARAMETERS_NOT_IDENTICAL;
	}

	/**
	 * _̃p[^lƂ݂Ȃ̂Ƃ
	 */
	private void setIdentical() {
	    value |= PARAMETERS_IDENTICAL;
	}

	/**
	 * _̃p[^lȐ A ̋ÊׂƂ
	 */
	private void setCrossBoundaryOfA()
	{
	    value |= PARAMETERS_CROSSBOUNDARY_A;
	}

	/**
	 * _̃p[^lȖ B UÊׂƂ
	 */
	private void setCrossBoundaryOfBu()
	{
	    value |= PARAMETERS_CROSSBOUNDARY_U_B;
	}

	/**
	 * _̃p[^lȖ B VÊׂƂ
	 */
	private void setCrossBoundaryOfBv()
	{
	    value |= PARAMETERS_CROSSBOUNDARY_V_B;
	}

	/**
	 * _̃p[^lƂ݂Ȃ邩ۂ
	 */
	private boolean isIdentical()
	{
	    return ((value & PARAMETERS_IDENTICAL) != 0);
	}

	/**
	 * _̃p[^lȐ A ̋Eׂۂ
	 */
	private boolean isCrossBoundaryOfA()
	{
	    return ((value & PARAMETERS_CROSSBOUNDARY_A) != 0);
	}

	/**
	 * _̃p[^lȖ B ŰEׂۂ
	 */
	private boolean isCrossBoundaryOfBu()
	{
	    return ((value & PARAMETERS_CROSSBOUNDARY_U_B) != 0);
	}

	/**
	 * _̃p[^lȖ B V̋Eׂۂ
	 */
	private boolean isCrossBoundaryOfBv()
	{
	    return ((value & PARAMETERS_CROSSBOUNDARY_V_B) != 0);
	}
    }

    /**
     * _̏
     */
    class IntersectionInfo
    {
	/**
	 * _̍Wl (null Ȃ)
	 */
	JgclPoint coord;

	/**
	 * _̋Ȑ A ł̃p[^l
	 */
	double paramA;

	/**
	 * _̋Ȗ B łUp[^l
	 */
	double uParamB;

	/**
	 * _̋Ȗ B łVp[^l
	 */
	double vParamB;

	/**
	 * Ȑ A  paramA t߂ł̃p[^̋e덷
	 */
	double pTolA;

	/**
	 * Ȗ B  [uv]ParamB t߂ł̃p[^Űe덷
	 */
	double pTolBu;

	/**
	 * Ȗ B  [uv]ParamB t߂ł̃p[^V̋e덷
	 */
	double pTolBv;

	/**
	 * IuWFNg\z
	 *
	 * @param	coord	_̍Wl (null Ȃ)
	 * @param	paramA	_̋Ȑ A ł̃p[^l
	 * @param	uParamB	_̋Ȗ B łUp[^l
	 * @param	vParamB	_̋Ȗ B łVp[^l
	 */
	IntersectionInfo(JgclPoint coord,
			 double paramA,
			 double uParamB,
			 double vParamB)
	{
	    this.coord = coord;	// null Ȃ

	    this.paramA = paramA;
	    this.uParamB = uParamB;
	    this.vParamB = vParamB;

	    this.pTolA = getToleranceForParameter(curveA, paramA);
	    this.pTolBu = getToleranceForParameterU(surfaceB, uParamB, vParamB);
	    this.pTolBv = getToleranceForParameterV(surfaceB, uParamB, vParamB);
	}

	/**
	 * IuWFNg\z
	 *
	 * @param	coord	_̍Wl (null Ȃ)
	 * @param	paramA	_̋Ȑ A ł̃p[^l
	 * @param	uParamB	_̋Ȗ B łUp[^l
	 * @param	vParamB	_̋Ȗ B łVp[^l
	 * @param	pTolA	Ȑ A  paramA t߂ł̃p[^̋e덷
	 * @param	pTolBu	Ȗ B  [uv]ParamB t߂łUp[^̋e덷
	 * @param	pTolBv	Ȗ B  [uv]ParamB t߂łVp[^̋e덷
	 */
	IntersectionInfo(JgclPoint coord,
			 double paramA,
			 double uParamB,
			 double vParamB,
			 double pTolA,
			 double pTolBu,
			 double pTolBv)
	{
	    this.coord = coord;	// null Ȃ

	    this.paramA = paramA;
	    this.uParamB = uParamB;
	    this.vParamB = vParamB;

	    this.pTolA = pTolA;
	    this.pTolBu = pTolBu;
	    this.pTolBv = pTolBv;
	}

	/**
	 * _̃p[^lƂ݂Ȃ邩ۂAɂĂ̏𓾂
	 *
	 * @param	mate	_̏
	 */
	private ParametricalIdentityOfTwoIntersections getParametricalIdentityWith(IntersectionInfo mate)
	{
	    ParametricalIdentityOfTwoIntersections result =
		new ParametricalIdentityOfTwoIntersections();

	    if (this == mate) {
		result.setIdentical();
		return result;
	    }

	    double diffA = Math.abs(this.paramA - mate.paramA);
	    double diffBu = Math.abs(this.uParamB - mate.uParamB);
	    double diffBv = Math.abs(this.vParamB - mate.vParamB);

	    double pTolA = Math.max(this.pTolA, mate.pTolA);
	    double pTolBu = Math.max(this.pTolBu, mate.pTolBu);
	    double pTolBv = Math.max(this.pTolBv, mate.pTolBv);

	    if ((parameterDomainA.isPeriodic() == true) &&
		(Math.abs(diffA - parameterDomainA.section().absIncrease()) < pTolA))
		result.setCrossBoundaryOfA();

	    if ((uParameterDomainB.isPeriodic() == true) &&
		(Math.abs(diffBu - uParameterDomainB.section().absIncrease()) < pTolBu))
		result.setCrossBoundaryOfBu();

	    if ((vParameterDomainB.isPeriodic() == true) &&
		(Math.abs(diffBv - vParameterDomainB.section().absIncrease()) < pTolBv))
		result.setCrossBoundaryOfBv();

	    if (((result.isCrossBoundaryOfA() == true) || (diffA < pTolA)) &&
		((result.isCrossBoundaryOfBu() == true) || (diffBu < pTolBu)) &&
		((result.isCrossBoundaryOfBv() == true) || (diffBv < pTolBv)))
		result.setIdentical();

	    return result;
	}

	/**
	 * _Ƃ݂Ȃ邩ۂ
	 *
	 * @param	mate	_̏
	 */
	private boolean isIdenticalWith(IntersectionInfo mate)
	{
	    if ((this.coord != null) && (mate.coord != null)) {
		if (((JgclPoint3D)this.coord).identical((JgclPoint3D)mate.coord) != true)
		    return false;
	    }

	    return this.getParametricalIdentityWith(mate).isIdentical();
	}
    }

    /**
     * _ǉ
     *
     * ɗ^ꂽ_ƓƂ݂Ȃ_ɑ݂Ƃɂ́A
     * ɗ^ꂽ_͒ǉȂ
     *
     * @param	theIntersection	_
     */
    void addIntersection(IntersectionInfo theIntersection)
    {
	for (Enumeration e = listOfIntersections.elements(); e.hasMoreElements();)
	    if (theIntersection.isIdenticalWith((IntersectionInfo)e.nextElement()) == true)
		return;

	listOfIntersections.addElement(theIntersection);
    }

    /**
     * _ǉ
     *
     * ɗ^ꂽ_ƓƂ݂Ȃ_ɑ݂Ƃɂ́A
     * ɗ^ꂽ_͒ǉȂ
     *
     * @param	coord	_̍Wl (null Ȃ)
     * @param	paramA	_̋Ȑ A ł̃p[^l
     * @param	uParamB	_̋Ȗ B łŨp[^l
     * @param	vParamB	_̋Ȗ B łṼp[^l
     */
    void addAsIntersection(JgclPoint coord,
			   double paramA,
			   double uParamB,
			   double vParamB)
    {
	/*** Debug
	coord.output(System.out);

	if (dimension == 2)
	{
	    ((JgclParametricCurve2D)curveA).coordinates(paramA).output(System.out);
	    //((JgclParametricSurface2D)surfaceB).coordinates(uParamB, vParamB).output(System.out);
	}
	else
	{
	    ((JgclParametricCurve3D)curveA).coordinates(paramA).output(System.out);
	    ((JgclParametricSurface3D)surfaceB).coordinates(uParamB, vParamB).output(System.out);
	}
	***/

	addIntersection(new IntersectionInfo(coord, paramA, uParamB, vParamB));
    }

    /**
     * _ǉ
     *
     * ɗ^ꂽ_ƓƂ݂Ȃ_ɑ݂Ƃɂ́A
     * ɗ^ꂽ_͒ǉȂ
     *
     * @param	coord	_̍Wl (null Ȃ)
     * @param	paramA	_̋Ȑ A ł̃p[^l
     * @param	uParamB	_̋Ȗ B łŨp[^l
     * @param	vParamB	_̋Ȗ B łṼp[^l
     * @param	pTolA	Ȑ A  paramA t߂ł̃p[^̋e덷
     * @param	pTolBu	Ȗ B  [uv]ParamB t߂łŨp[^̋e덷
     * @param	pTolBv	Ȗ B  [uv]ParamB t߂łṼp[^̋e덷
     */
    void addAsIntersection(JgclPoint coord,
			   double paramA,
			   double uParamB,
			   double vParamB,
			   double pTolA,
			   double pTolBu,
			   double pTolBv)

    {
	addIntersection(new IntersectionInfo(coord, paramA, uParamB, vParamB,
					     pTolA, pTolBu, pTolBv));
    }

    /**
     * _Əd̃XgׂČ_Ƃ JgclIntersectionPoint3D ̔zƂĕԂ
     */
    JgclIntersectionPoint3D[] toJgclIntersectionPoint3DArray(boolean doExchange)
    {
	int totalSize = listOfIntersections.size();
	int i;

	JgclIntersectionPoint3D[] result = new JgclIntersectionPoint3D[totalSize];
	i = 0;

	for (Enumeration e = listOfIntersections.elements(); e.hasMoreElements();)
	{
	    IntersectionInfo ints = (IntersectionInfo)e.nextElement();
	    if (!doExchange)
		result[i++] = (ints.coord == null)
		    ? new JgclIntersectionPoint3D((JgclParametricCurve3D)curveA, ints.paramA,
						  (JgclParametricSurface3D)surfaceB,
						  ints.uParamB, ints.vParamB,
						  JgclGeometry.doCheckDebug)
		    : new JgclIntersectionPoint3D((JgclPoint3D)ints.coord,
						  (JgclParametricCurve3D)curveA, ints.paramA,
						  (JgclParametricSurface3D)surfaceB,
						  ints.uParamB, ints.vParamB,
						  JgclGeometry.doCheckDebug);
	    else
		result[i++] = (ints.coord == null)
		    ? new JgclIntersectionPoint3D((JgclParametricSurface3D)surfaceB,
						  ints.uParamB, ints.vParamB,
						  (JgclParametricCurve3D)curveA, ints.paramA,
						  JgclGeometry.doCheckDebug)
		    : new JgclIntersectionPoint3D((JgclPoint3D)ints.coord,
						  (JgclParametricSurface3D)surfaceB,
						  ints.uParamB, ints.vParamB,
						  (JgclParametricCurve3D)curveA, ints.paramA,
						  JgclGeometry.doCheckDebug);
	}

	return result;
    }
}

// end of file
