/*
 * Ȑm̊̃XgNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCurveCurveInterferenceList.java,v 1.10 2000/04/26 09:38:52 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * Ȑm̊̃XgNX
 *
 * @version $Revision: 1.10 $, $Date: 2000/04/26 09:38:52 $
 * @author Information-technology Promotion Agency, Japan
 */
class JgclCurveCurveInterferenceList
{
    /**
     * Ȑ݂̑Ԃ̎
     */
    int dimension;

    /**
     * Ȑ A
     */
    JgclParametricCurve curveA;

    /**
     * Ȑ A ̒`
     */
    JgclParameterDomain parameterDomainA;

    /**
     * Ȑ B
     */
    JgclParametricCurve curveB;

    /**
     * Ȑ B ̒`
     */
    JgclParameterDomain parameterDomainB;

    /**
     * ̋e덷 (IuWFNg\zꂽ_ł)
     */
    JgclToleranceForDistance dTol;

    /**
     * _̃Xg
     */
    Vector listOfIntersections;

    /**
     * d̃Xg
     */
    Vector listOfOverlaps;

    /*
     * IuWFNg\z
     *
     * @param	curveA	Ȑ A
     * @param	curveB	Ȑ B
     */
    JgclCurveCurveInterferenceList(JgclParametricCurve curveA,
				   JgclParametricCurve curveB)
    {
	if ((curveA == null) || (curveB == null))
	    throw new JgclNullArgument();

	if ((this.dimension = curveA.dimension()) != curveB.dimension())
	    throw new JgclDimensionsMismatch();

	this.curveA = curveA;
	this.parameterDomainA = curveA.parameterDomain();

	this.curveB = curveB;
	this.parameterDomainB = curveB.parameterDomain();

	JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
	this.dTol = cond.getToleranceForDistanceAsObject();

	this.listOfIntersections = new Vector();
	this.listOfOverlaps      = new Vector();
    }

    /**
     * Ȑ̂p[^lt߂ł̃p[^̋e덷߂B
     *
     * ToleranceForDistance Zo
     *
     * @param	curve	Ȑ
     * @param	param	p[^l
     */
    private double getToleranceForParameter(JgclParametricCurve curve, double param)
    {
	if (dimension == 2) {
	    return dTol.toToleranceForParameter((JgclParametricCurve2D)curve, param).value();
	} else {
	    return dTol.toToleranceForParameter((JgclParametricCurve3D)curve, param).value();
	}
    }

    /*
     * _̃p[^lƂ݂Ȃ邩ۂAɊւ萔
     */
    private static final int PARAMETERS_NOT_IDENTICAL   = 0x0;
    private static final int PARAMETERS_IDENTICAL       = 0x1;
    private static final int PARAMETERS_CROSSBOUNDARY_A = 0x2;
    private static final int PARAMETERS_CROSSBOUNDARY_B = 0x4;

    /**
     * _̃p[^lƂ݂Ȃ邩ۂA\
     */
    class ParametricalIdentityOfTwoIntersections {
	/**
	 * _̃p[^lƂ݂Ȃ邩ۂA\
	 */
	private int value;

	/**
	 * IuWFNg\z
	 */
	ParametricalIdentityOfTwoIntersections() {
	    setNonIdentical();
	}

	/**
	 * _̃p[^lƂ݂ȂȂ̂Ƃ
	 */
	private void setNonIdentical() {
	    value = PARAMETERS_NOT_IDENTICAL;
	}

	/**
	 * _̃p[^lƂ݂Ȃ̂Ƃ
	 */
	private void setIdentical() {
	    value |= PARAMETERS_IDENTICAL;
	}

	/**
	 * _̃p[^lȐ A ̋ÊׂƂ
	 */
	private void setCrossBoundaryOfA()
	{
	    value |= PARAMETERS_CROSSBOUNDARY_A;
	}

	/**
	 * _̃p[^lȐ B ̋ÊׂƂ
	 */
	private void setCrossBoundaryOfB()
	{
	    value |= PARAMETERS_CROSSBOUNDARY_B;
	}

	/**
	 * _̃p[^lƂ݂Ȃ邩ۂ
	 */
	private boolean isIdentical()
	{
	    return ((value & PARAMETERS_IDENTICAL) != 0);
	}

	/**
	 * _̃p[^lȐ A ̋Eׂۂ
	 */
	private boolean isCrossBoundaryOfA()
	{
	    return ((value & PARAMETERS_CROSSBOUNDARY_A) != 0);
	}

	/**
	 * _̃p[^lȐ B ̋Eׂۂ
	 */
	private boolean isCrossBoundaryOfB()
	{
	    return ((value & PARAMETERS_CROSSBOUNDARY_B) != 0);
	}
    }

    /**
     * _̏
     */
    class IntersectionInfo
    {
	/**
	 * _̍Wl (null Ȃ)
	 */
	JgclPoint coord;

	/**
	 * _̋Ȑ A ł̃p[^l
	 */
	double paramA;

	/**
	 * _̋Ȑ B ł̃p[^l
	 */
	double paramB;

	/**
	 * Ȑ A  paramA t߂ł̃p[^̋e덷
	 */
	double pTolA;

	/**
	 * Ȑ B  paramB t߂ł̃p[^̋e덷
	 */
	double pTolB;

	/**
	 * IuWFNg\z
	 *
	 * @param	coord	_̍Wl (null Ȃ)
	 * @param	paramA	_̋Ȑ A ł̃p[^l
	 * @param	paramB	_̋Ȑ B ł̃p[^l
	 */
	IntersectionInfo(JgclPoint coord,
			 double paramA,
			 double paramB)
	{
	    this.coord = coord;	// null Ȃ

	    this.paramA = paramA;
	    this.paramB = paramB;

	    this.pTolA = getToleranceForParameter(curveA, paramA);
	    this.pTolB = getToleranceForParameter(curveB, paramB);
	}

	/**
	 * IuWFNg\z
	 *
	 * @param	coord	_̍Wl (null Ȃ)
	 * @param	paramA	_̋Ȑ A ł̃p[^l
	 * @param	paramB	_̋Ȑ B ł̃p[^l
	 * @param	pTolA	Ȑ A  paramA t߂ł̃p[^̋e덷
	 * @param	pTolB	Ȑ B  paramB t߂ł̃p[^̋e덷
	 */
	IntersectionInfo(JgclPoint coord,
			 double paramA,
			 double paramB,
			 double pTolA,
			 double pTolB)
	{
	    this.coord = coord;	// null Ȃ

	    this.paramA = paramA;
	    this.paramB = paramB;

	    this.pTolA = pTolA;
	    this.pTolB = pTolB;
	}

	/**
	 * _̃p[^lƂ݂Ȃ邩ۂAɂĂ̏𓾂
	 *
	 * @param	mate	_̏
	 */
	private ParametricalIdentityOfTwoIntersections getParametricalIdentityWith(IntersectionInfo mate)
	{
	    ParametricalIdentityOfTwoIntersections result =
		new ParametricalIdentityOfTwoIntersections();

	    if (this == mate) {
		result.setIdentical();
		return result;
	    }

	    double diffA = Math.abs(this.paramA - mate.paramA);
	    double diffB = Math.abs(this.paramB - mate.paramB);

	    double pTolA = Math.max(this.pTolA, mate.pTolA);
	    double pTolB = Math.max(this.pTolB, mate.pTolB);

	    if ((parameterDomainA.isPeriodic() == true) &&
		(Math.abs(diffA - parameterDomainA.section().absIncrease()) < pTolA))
		result.setCrossBoundaryOfA();


	    if ((parameterDomainB.isPeriodic() == true) &&
		(Math.abs(diffB - parameterDomainB.section().absIncrease()) < pTolB))
		result.setCrossBoundaryOfB();

	    if (((result.isCrossBoundaryOfA() == true) || (diffA < pTolA)) &&
		((result.isCrossBoundaryOfB() == true) || (diffB < pTolB)))
		result.setIdentical();

	    return result;
	}

	/**
	 * _Ƃ݂Ȃ邩ۂ
	 *
	 * @param	mate	_̏
	 */
	private boolean isIdenticalWith(IntersectionInfo mate)
	{
	    if ((this.coord != null) && (mate.coord != null)) {
		if (dimension == 2) {
		    if (((JgclPoint2D)this.coord).identical((JgclPoint2D)mate.coord) != true)
			return false;
		}
		else
		{
		    if (((JgclPoint3D)this.coord).identical((JgclPoint3D)mate.coord) != true)
			return false;
		}
	    }

	    return this.getParametricalIdentityWith(mate).isIdentical();
	}

	/**
	 * dɊ܂܂Ă邩ۂ
	 *
	 * @param	mate	d
	 * @return	dɊ܂܂ trueAłȂ false
	 */
	boolean isContainedIn(OverlapInfo ovlp)
	{
	    if (this.isIdenticalWith(ovlp.headPoint) == true)
		return true;

	    if (this.isIdenticalWith(ovlp.tailPoint) == true)
		return true;

	    double thisParam;

	    boolean ovlpCrossBoundary;
	    double ovlpHead;
	    double ovlpTail;

	    double ovlpHeadPTol;
	    double ovlpTailPTol;

	    double ovlpLower;
	    double ovlpUpper;

	    for (int i = 0; i < 2; i++)
	    {
		if (i == 0)
		{   // for curve A
		    thisParam = this.paramA;

		    ovlpCrossBoundary = ovlp.crossBoundaryA;
		    ovlpHead = ovlp.headPoint.paramA;
		    ovlpTail = ovlp.tailPoint.paramA;

		    ovlpHeadPTol = ovlp.headPoint.pTolA;
		    ovlpTailPTol = ovlp.tailPoint.pTolA;
		}
		else
		{   // for curve B
		    thisParam = this.paramB;

		    ovlpCrossBoundary = ovlp.crossBoundaryB;
		    ovlpHead = ovlp.headPoint.paramB;
		    ovlpTail = ovlp.tailPoint.paramB;

		    ovlpHeadPTol = ovlp.headPoint.pTolB;
		    ovlpTailPTol = ovlp.tailPoint.pTolB;
		}

		if (ovlpHead < ovlpTail)
		{
		    ovlpLower = ovlpHead - ovlpHeadPTol;
		    ovlpUpper = ovlpTail + ovlpTailPTol;
		}
		else
		{
		    ovlpLower = ovlpTail - ovlpTailPTol;
		    ovlpUpper = ovlpHead + ovlpHeadPTol;
		}

		if (ovlpCrossBoundary == true)
		{
		    double swap = ovlpLower; ovlpLower = ovlpUpper; ovlpUpper = swap;
		}

		if ((thisParam < ovlpLower) && (ovlpUpper < thisParam))
		    return false;
	    }

	    return true;
	}
    }

    /**
     * _ǉ
     *
     * ɗ^ꂽ_ƓƂ݂Ȃ_ɑ݂Ƃɂ́A
     * ɗ^ꂽ_͒ǉȂ
     *
     * @param	theIntersection	_
     */
    void addIntersection(IntersectionInfo theIntersection)
    {
	for (Enumeration e = listOfIntersections.elements(); e.hasMoreElements();)
	    if (theIntersection.isIdenticalWith((IntersectionInfo)e.nextElement()) == true)
		return;

	listOfIntersections.addElement(theIntersection);
    }

    /**
     * _ǉ
     *
     * ɗ^ꂽ_ƓƂ݂Ȃ_ɑ݂Ƃɂ́A
     * ɗ^ꂽ_͒ǉȂ
     *
     * @param	coord	_̍Wl (null Ȃ)
     * @param	paramA	_̋Ȑ A ł̃p[^l
     * @param	paramB	_̋Ȑ B ł̃p[^l
     */
    void addAsIntersection(JgclPoint coord,
			   double paramA,
			   double paramB)
    {
	/*** Debug
	coord.output(System.out);

	if (dimension == 2)
	{
	    ((JgclParametricCurve2D)curveA).coordinates(paramA).output(System.out);
	    ((JgclParametricCurve2D)curveB).coordinates(paramB).output(System.out);
	}
	else
	{
	    ((JgclParametricCurve3D)curveA).coordinates(paramA).output(System.out);
	    ((JgclParametricCurve3D)curveB).coordinates(paramB).output(System.out);
	}
	***/

	addIntersection(new IntersectionInfo(coord, paramA, paramB));
    }

    /**
     * _ǉ
     *
     * ɗ^ꂽ_ƓƂ݂Ȃ_ɑ݂Ƃɂ́A
     * ɗ^ꂽ_͒ǉȂ
     *
     * @param	coord	_̍Wl (null Ȃ)
     * @param	paramA	_̋Ȑ A ł̃p[^l
     * @param	paramB	_̋Ȑ B ł̃p[^l
     * @param	pTolA	Ȑ A  paramA t߂ł̃p[^̋e덷
     * @param	pTolB	Ȑ B  paramB t߂ł̃p[^̋e덷
     */
    void addAsIntersection(JgclPoint coord,
			   double paramA,
			   double paramB,
			   double pTolA,
			   double pTolB)

    {
	addIntersection(new IntersectionInfo(coord, paramA, paramB, pTolA, pTolB));
    }

    /**
     * dɊ܂܂Ă_폜
     */
    void removeIntersectionsContainedInOverlap()
    {
	Vector clonedList = (Vector)(listOfIntersections.clone());
	listOfIntersections.removeAllElements();

	for (Enumeration e1 = clonedList.elements(); e1.hasMoreElements();)
	{
	    IntersectionInfo intersection = (IntersectionInfo)e1.nextElement();
	    boolean contained = false;

	    for (Enumeration e2 = listOfOverlaps.elements(); e2.hasMoreElements();)
	    {
		if (intersection.isContainedIn((OverlapInfo)e2.nextElement()) == true)
		{
		    contained = true;
		    break;
		}
	    }

	    if (contained != true)
		listOfIntersections.addElement(intersection);
	}
    }

    /**
     * d̏
     */
    class OverlapInfo
    {
	/**
	 * d̊Jn_
	 */
	IntersectionInfo headPoint;

	/**
	 * d̏I_
	 */
	IntersectionInfo tailPoint;

	/**
	 * dȐ A ̎̋Eׂł邩ۂBׂłΐ^
	 */
	private boolean crossBoundaryA;

	/**
	 * dȐ B ̎̋Eׂł邩ۂBׂłΐ^
	 */
	private boolean crossBoundaryB;

	/**
	 * IuWFNg\z
	 *
	 * @param	headParamA	d̊Jn_̋Ȑ A ł̃p[^l
	 * @param	headParamB	d̊Jn_̋Ȑ B ł̃p[^l
	 * @param	increaseParamA	d̋Ȑ A ł̃p[^l
	 * @param	increaseParamB	d̋Ȑ B ł̃p[^l
	 */
	OverlapInfo(double headParamA,
		    double headParamB,
		    double increaseParamA,
		    double increaseParamB)
	{
	    headParamA = parameterDomainA.wrap(headParamA);
	    headParamB = parameterDomainB.wrap(headParamB);
	    double tailParamA = parameterDomainA.wrap(headParamA + increaseParamA);
	    double tailParamB = parameterDomainB.wrap(headParamB + increaseParamB);

	    this.headPoint = new IntersectionInfo(null, headParamA, headParamB);
	    this.tailPoint = new IntersectionInfo(null, tailParamA, tailParamB);

	    if (((headParamA > tailParamA) && (increaseParamA > 0)) ||
		((headParamA < tailParamA) && (increaseParamA < 0)))
		this.crossBoundaryA = true;
	    else
		this.crossBoundaryA = false;

	    if (((headParamB > tailParamB) && (increaseParamB > 0)) ||
		((headParamB < tailParamB) && (increaseParamB < 0)))
		this.crossBoundaryB = true;
	    else
		this.crossBoundaryB = false;
	}

	/**
	 * IuWFNg\z
	 *
	 * @param	headParamA	d̊Jn_̋Ȑ A ł̃p[^l
	 * @param	headParamB	d̊Jn_̋Ȑ B ł̃p[^l
	 * @param	increaseParamA	d̋Ȑ A ł̃p[^l
	 * @param	increaseParamB	d̋Ȑ B ł̃p[^l
	 * @param	headPTolA	Ȑ A ̊Jn_t߂ł̃p[^̋e덷
	 * @param	headPTolB	Ȑ B ̊Jn_t߂ł̃p[^̋e덷
	 * @param	tailPTolA	Ȑ A ̏I_t߂ł̃p[^̋e덷
	 * @param	tailPTolB	Ȑ B ̏I_t߂ł̃p[^̋e덷
	 */
	OverlapInfo(double headParamA,
		    double headParamB,
		    double increaseParamA,
		    double increaseParamB,
		    double headPTolA,
		    double headPTolB,
		    double tailPTolA,
		    double tailPTolB)
	{
	    headParamA = parameterDomainA.wrap(headParamA);
	    headParamB = parameterDomainB.wrap(headParamB);
	    double tailParamA = parameterDomainA.wrap(headParamA + increaseParamA);
	    double tailParamB = parameterDomainB.wrap(headParamB + increaseParamB);

	    this.headPoint = new IntersectionInfo(null, headParamA, headParamB, headPTolA, headPTolB);
	    this.tailPoint = new IntersectionInfo(null, tailParamA, tailParamB, tailPTolA, tailPTolB);

	    if (((headParamA > tailParamA) && (increaseParamA > 0)) ||
		((headParamA < tailParamA) && (increaseParamA < 0)))
		this.crossBoundaryA = true;
	    else
		this.crossBoundaryA = false;

	    if (((headParamB > tailParamB) && (increaseParamB > 0)) ||
		((headParamB < tailParamB) && (increaseParamB < 0)))
		this.crossBoundaryB = true;
	    else
		this.crossBoundaryB = false;
	}

	/**
	 * crossBoundary[AB] ̒lXV
	 *
	 * @param	mate	d
	 * @param	identity	p[^̓ꐫ
	 */
	private void setCrossBoundaryFlags(OverlapInfo mate,
					   ParametricalIdentityOfTwoIntersections identity)
	{
	    if ((mate.crossBoundaryA == true) || (identity.isCrossBoundaryOfA() == true))
		this.crossBoundaryA = true;

	    if ((mate.crossBoundaryB == true) || (identity.isCrossBoundaryOfB() == true))
		this.crossBoundaryB = true;
	}

	/**
	 * Ȑ A ł̃p[^̑lvZĕԂ
	 *
	 * @return	Ȑ A ł̃p[^̑l
	 */
	private double computeIncreaseA()
	{
	    double increase = this.tailPoint.paramA - this.headPoint.paramA;

	    if ((parameterDomainA.isPeriodic() == true) && (this.crossBoundaryA == true))
	    {
		if (increase > 0.0)
		    increase -= parameterDomainA.section().absIncrease();
		else
		    increase += parameterDomainA.section().absIncrease();
	    }

	    return increase;
	}

	/**
	 * Ȑ B ł̃p[^̑lvZĕԂ
	 *
	 * @return	Ȑ B ł̃p[^̑l
	 */
	private double computeIncreaseB()
	{
	    double increase = this.tailPoint.paramB - this.headPoint.paramB;

	    if ((parameterDomainB.isPeriodic() == true) && (this.crossBoundaryB == true))
	    {
		if (increase > 0.0)
		    increase -= parameterDomainB.section().absIncrease();
		else
		    increase += parameterDomainB.section().absIncrease();
	    }

	    return increase;
	}

	/**
	 * ^ꂽdqĂ΁Athis Ƀ}[W
	 *
	 * @param	mate	d
	 * @return	qĂ trueAłȂ false
	 */
	boolean mergeIfConnectWith(OverlapInfo mate)
	{
	    if (this == mate)
		return false;

	    ParametricalIdentityOfTwoIntersections identity;

	    // this   mate
	    // -----------
	    // Head - Head	: this.increase = this.increase - mate.increase;
	    identity = this.headPoint.getParametricalIdentityWith(mate.headPoint);
	    if (identity.isIdentical() == true)
	    {
		this.headPoint = mate.tailPoint;
		this.setCrossBoundaryFlags(mate, identity);
		return true;
	    }

	    // Head - Tail	: this.increase = this.increase + mate.increase;
	    identity = this.headPoint.getParametricalIdentityWith(mate.tailPoint);
	    if (identity.isIdentical() == true)
	    {
		this.headPoint = mate.headPoint;
		this.setCrossBoundaryFlags(mate, identity);
		return true;
	    }

	    // Tail - Head	: this.increase = this.increase + mate.increase;
	    identity = this.tailPoint.getParametricalIdentityWith(mate.headPoint);
	    if (identity.isIdentical() == true)
	    {
		this.tailPoint = mate.tailPoint;
		this.setCrossBoundaryFlags(mate, identity);
		return true;
	    }

	    // Tail - Tail	: this.increase = this.increase - mate.increase;
	    identity = this.tailPoint.getParametricalIdentityWith(mate.tailPoint);
	    if (identity.isIdentical() == true)
	    {
		this.tailPoint = mate.headPoint;
		this.setCrossBoundaryFlags(mate, identity);
		return true;
	    }

	    return false;
	}

	/**
	 * ̏dɊ܂܂Ă邩ۂ
	 *
	 * @param	mate	d
	 * @return	̏dɊ܂܂ trueAłȂ false
	 */
	boolean isContainedIn(OverlapInfo mate)
	{
	    if (mate == this)
		return false;

	    boolean thisCrossBoundary;
	    double thisHead;
	    double thisTail;

	    boolean mateCrossBoundary;
	    double mateHead;
	    double mateTail;

	    double mateHeadPTol;
	    double mateTailPTol;

	    double mateLower;
	    double mateUpper;

	    for (int i = 0; i < 2; i++)
	    {
		if (i == 0)
		{   // for curve A
		    thisCrossBoundary = this.crossBoundaryA;
		    thisHead = this.headPoint.paramA;
		    thisTail = this.tailPoint.paramA;

		    mateCrossBoundary = mate.crossBoundaryA;
		    mateHead = mate.headPoint.paramA;
		    mateTail = mate.tailPoint.paramA;

		    mateHeadPTol = mate.headPoint.pTolA;
		    mateTailPTol = mate.tailPoint.pTolA;
		}
		else
		{   // for curve B
		    thisCrossBoundary = this.crossBoundaryB;
		    thisHead = this.headPoint.paramB;
		    thisTail = this.tailPoint.paramB;

		    mateCrossBoundary = mate.crossBoundaryB;
		    mateHead = mate.headPoint.paramB;
		    mateTail = mate.tailPoint.paramB;

		    mateHeadPTol = mate.headPoint.pTolB;
		    mateTailPTol = mate.tailPoint.pTolB;
		}

		if (mateCrossBoundary == false)
		{
		    if (thisCrossBoundary == true)
		    {
			/*
			 * mate:  |---------------|
			 * this: - -|          |- - -
			 */
			return false;
		    }

		    if (mateHead < mateTail)
		    {
			mateLower = mateHead - mateHeadPTol;
			mateUpper = mateTail + mateTailPTol;
		    }
		    else
		    {
			mateLower = mateTail - mateTailPTol;
			mateUpper = mateHead + mateHeadPTol;
		    }
		    if ((thisHead < mateLower) || (mateUpper < thisHead) ||
			(thisTail < mateLower) || (mateUpper < thisTail))
		    {
			/*
			 * mate:  |---------------|
			 * this:       |-------------|
			 */
			return false;
		    }

		}
		else
		{
		    if (mateHead < mateTail)
		    {
			mateLower = mateTail - mateTailPTol;
			mateUpper = mateHead + mateHeadPTol;
		    }
		    else
		    {
			mateLower = mateHead - mateHeadPTol;
			mateUpper = mateTail + mateTailPTol;
		    }
		    if (((mateUpper < thisHead) && (thisHead < mateLower)) ||
			((mateUpper < thisTail) && (thisTail < mateLower)))
		    {
			/*
		     * mate: ----|    |----------
		     * this:       |--------|
		     */
			return false;
		    }

		    if (thisCrossBoundary == false)
		    {
			if (((mateUpper < thisHead) || (mateUpper < thisTail)) &&
			    ((thisHead < mateLower) || (thisTail < mateLower)))
			{
			    /*
			     * mate: ----|    |----------
			     * this:  |----------|
			     */
			    return false;
			}
		    }
		}
	    }

	    return true;
	}
    }

    /**
     * dǉ
     *
     * ɗ^ꂽd P ƐڑĂƂ݂Ȃd Q ɑ݂Ƃɂ́A
     * P  Q }[W
     *
     * @param	theOverlap	d
     */
    void addOverlap(OverlapInfo theOverlap)
    {
	while (true) {
	    OverlapInfo mergedMate = null;

	    for (Enumeration e = listOfOverlaps.elements(); e.hasMoreElements();) {
		OverlapInfo mate = (OverlapInfo)e.nextElement();
		if (theOverlap.mergeIfConnectWith(mate) == true) {
		    mergedMate = mate;
		    break;
		}
	    }

	    if (mergedMate == null)
		break;

	    listOfOverlaps.removeElement(mergedMate);
	}

	listOfOverlaps.addElement(theOverlap);
    }

    /**
     * dǉ
     *
     * ɗ^ꂽd P ƐڑĂƂ݂Ȃd Q ɑ݂Ƃɂ́A
     * P  Q }[W
     *
     * @param	headParamA	d̊Jn_̋Ȑ A ł̃p[^l
     * @param	headParamB	d̊Jn_̋Ȑ B ł̃p[^l
     * @param	increaseParamA	d̋Ȑ A ł̃p[^l
     * @param	increaseParamB	d̋Ȑ B ł̃p[^l
     */
    void addAsOverlap(double headParamA,
		      double headParamB,
		      double increaseParamA,
		      double increaseParamB)
    {
	addOverlap(new OverlapInfo(headParamA, headParamB, increaseParamA, increaseParamB));
    }

    /**
     * dǉ
     *
     * ɗ^ꂽd P ƐڑĂƂ݂Ȃd Q ɑ݂Ƃɂ́A
     * P  Q }[W
     *
     * @param	headParamA	d̊Jn_̋Ȑ A ł̃p[^l
     * @param	headParamB	d̊Jn_̋Ȑ B ł̃p[^l
     * @param	increaseParamA	d̋Ȑ A ł̃p[^l
     * @param	increaseParamB	d̋Ȑ B ł̃p[^l
     * @param	headPTolA	Ȑ A ̊Jn_t߂ł̃p[^̋e덷
     * @param	headPTolB	Ȑ B ̊Jn_t߂ł̃p[^̋e덷
     * @param	tailPTolA	Ȑ A ̏I_t߂ł̃p[^̋e덷
     * @param	tailPTolB	Ȑ B ̏I_t߂ł̃p[^̋e덷
     */
    void addAsOverlap(double headParamA,
		      double headParamB,
		      double increaseParamA,
		      double increaseParamB,
		      double headPTolA,
		      double headPTolB,
		      double tailPTolA,
		      double tailPTolB)
    {
	addOverlap(new OverlapInfo(headParamA, headParamB, increaseParamA, increaseParamB,
				   headPTolA, headPTolB, tailPTolA, tailPTolB));
    }

    /**
     * ̏dɊ܂܂Ăd폜
     */
    void removeOverlapsContainedInOtherOverlap()
    {
	Vector clonedList = (Vector)(listOfOverlaps.clone());
	listOfOverlaps.removeAllElements();

	for (Enumeration e1 = clonedList.elements(); e1.hasMoreElements();)
	{
	    OverlapInfo overlap = (OverlapInfo)e1.nextElement();
	    boolean contained = false;

	    for (Enumeration e2 = clonedList.elements(); e2.hasMoreElements();)
	    {
		if (overlap.isContainedIn((OverlapInfo)e2.nextElement()) == true)
		{
		    contained = true;
		    break;
		}
	    }

	    if (contained != true)
		listOfOverlaps.addElement(overlap);
	}
    }

    /**
     * _Əd̃Xg JgclCurveCurveInterference2D ̔zƂĕԂ
     */
    JgclCurveCurveInterference2D[] toJgclCurveCurveInterference2DArray(boolean doExchange)
    {
	if (dimension != 2)
	    throw new JgclDimensionsMismatch();

	int totalSize = listOfIntersections.size() + listOfOverlaps.size();
	int i;

	JgclCurveCurveInterference2D[] result = new JgclCurveCurveInterference2D[totalSize];
	i = 0;

	for (Enumeration e = listOfIntersections.elements(); e.hasMoreElements();)
	{
	    IntersectionInfo ints = (IntersectionInfo)e.nextElement();
	    if (!doExchange) {
		result[i++] = (ints.coord == null)
		    ? new JgclIntersectionPoint2D((JgclParametricCurve2D)curveA, ints.paramA,
						  (JgclParametricCurve2D)curveB, ints.paramB,
						  JgclGeometry.doCheckDebug)
		    : new JgclIntersectionPoint2D((JgclPoint2D)ints.coord,
						  (JgclParametricCurve2D)curveA, ints.paramA,
						  (JgclParametricCurve2D)curveB, ints.paramB,
						  JgclGeometry.doCheckDebug);
	    } else {
		result[i++] = (ints.coord == null)
		    ? new JgclIntersectionPoint2D((JgclParametricCurve2D)curveB, ints.paramB,
						  (JgclParametricCurve2D)curveA, ints.paramA,
						  JgclGeometry.doCheckDebug)
		    : new JgclIntersectionPoint2D((JgclPoint2D)ints.coord,
						  (JgclParametricCurve2D)curveB, ints.paramB,
						  (JgclParametricCurve2D)curveA, ints.paramA,
						  JgclGeometry.doCheckDebug);
	    }
	}

	for (Enumeration e = listOfOverlaps.elements(); e.hasMoreElements();)
	{
	    OverlapInfo ovlp = (OverlapInfo)e.nextElement();
	    if (!doExchange) {
		result[i++] = new JgclOverlapCurve2D((JgclParametricCurve2D)curveA,
						     ovlp.headPoint.paramA, ovlp.computeIncreaseA(),
						     (JgclParametricCurve2D)curveB,
						     ovlp.headPoint.paramB, ovlp.computeIncreaseB(),
						     false);
	    } else {
		result[i++] = new JgclOverlapCurve2D((JgclParametricCurve2D)curveB,
						     ovlp.headPoint.paramB, ovlp.computeIncreaseB(),
						     (JgclParametricCurve2D)curveA,
						     ovlp.headPoint.paramA, ovlp.computeIncreaseA(),
						     false);
	    }
	}

	return result;
    }

    /**
     * _Əd̃XgׂČ_Ƃ JgclIntersectionPoint2D ̔zƂĕԂ
     */
    JgclIntersectionPoint2D[] toJgclIntersectionPoint2DArray(boolean doExchange)
    {
	if (dimension != 2)
	    throw new JgclDimensionsMismatch();

	int totalSize = listOfIntersections.size() + (listOfOverlaps.size() * 2);
	int i;

	JgclIntersectionPoint2D[] result = new JgclIntersectionPoint2D[totalSize];
	i = 0;

	for (Enumeration e = listOfIntersections.elements(); e.hasMoreElements();)
	{
	    IntersectionInfo ints = (IntersectionInfo)e.nextElement();
	    if (!doExchange)
		result[i++] = (ints.coord == null)
		    ? new JgclIntersectionPoint2D((JgclParametricCurve2D)curveA, ints.paramA,
						  (JgclParametricCurve2D)curveB, ints.paramB,
						  JgclGeometry.doCheckDebug)
		    : new JgclIntersectionPoint2D((JgclPoint2D)ints.coord,
						  (JgclParametricCurve2D)curveA, ints.paramA,
						  (JgclParametricCurve2D)curveB, ints.paramB,
						  JgclGeometry.doCheckDebug);
	    else
		result[i++] = (ints.coord == null)
		    ? new JgclIntersectionPoint2D((JgclParametricCurve2D)curveB, ints.paramB,
						  (JgclParametricCurve2D)curveA, ints.paramA,
						  JgclGeometry.doCheckDebug)
		    : new JgclIntersectionPoint2D((JgclPoint2D)ints.coord,
						  (JgclParametricCurve2D)curveB, ints.paramB,
						  (JgclParametricCurve2D)curveA, ints.paramA,
						  JgclGeometry.doCheckDebug);
	}

	for (Enumeration e = listOfOverlaps.elements(); e.hasMoreElements();)
	{
	    OverlapInfo ovlp = (OverlapInfo)e.nextElement();
	    if (!doExchange) {
		result[i++] = new JgclIntersectionPoint2D((JgclParametricCurve2D)curveA,
							  ovlp.headPoint.paramA,
							  (JgclParametricCurve2D)curveB,
							  ovlp.headPoint.paramB,
							  JgclGeometry.doCheckDebug);
		result[i++] = new JgclIntersectionPoint2D((JgclParametricCurve2D)curveA,
							  ovlp.tailPoint.paramA,
							  (JgclParametricCurve2D)curveB,
							  ovlp.tailPoint.paramB,
							  JgclGeometry.doCheckDebug);
	    } else {
		result[i++] = new JgclIntersectionPoint2D((JgclParametricCurve2D)curveB,
							  ovlp.headPoint.paramB,
							  (JgclParametricCurve2D)curveA,
							  ovlp.headPoint.paramA,
							  JgclGeometry.doCheckDebug);
		result[i++] = new JgclIntersectionPoint2D((JgclParametricCurve2D)curveB,
							  ovlp.tailPoint.paramB,
							  (JgclParametricCurve2D)curveA,
							  ovlp.tailPoint.paramA,
							  JgclGeometry.doCheckDebug);
	    }
	}

	return result;
    }

    /**
     * _Əd̃Xg JgclCurveCurveInterference3D ̔zƂĕԂ
     */
    JgclCurveCurveInterference3D[] toJgclCurveCurveInterference3DArray(boolean doExchange)
    {
	if (dimension != 3)
	    throw new JgclDimensionsMismatch();

	int totalSize = listOfIntersections.size() + listOfOverlaps.size();
	int i;

	JgclCurveCurveInterference3D[] result = new JgclCurveCurveInterference3D[totalSize];
	i = 0;

	for (Enumeration e = listOfIntersections.elements(); e.hasMoreElements();)
	{
	    IntersectionInfo ints = (IntersectionInfo)e.nextElement();
	    if (!doExchange) {
		result[i++] = (ints.coord == null)
		    ? new JgclIntersectionPoint3D((JgclParametricCurve3D)curveA, ints.paramA,
						  (JgclParametricCurve3D)curveB, ints.paramB,
						  JgclGeometry.doCheckDebug)
		    : new JgclIntersectionPoint3D((JgclPoint3D)ints.coord,
						  (JgclParametricCurve3D)curveA, ints.paramA,
						  (JgclParametricCurve3D)curveB, ints.paramB,
						  JgclGeometry.doCheckDebug);
	    } else {
		result[i++] = (ints.coord == null)
		    ? new JgclIntersectionPoint3D((JgclParametricCurve3D)curveB, ints.paramB,
						  (JgclParametricCurve3D)curveA, ints.paramA,
						  JgclGeometry.doCheckDebug)
		    : new JgclIntersectionPoint3D((JgclPoint3D)ints.coord,
						  (JgclParametricCurve3D)curveB, ints.paramB,
						  (JgclParametricCurve3D)curveA, ints.paramA,
						  JgclGeometry.doCheckDebug);
	    }
	}

	for (Enumeration e = listOfOverlaps.elements(); e.hasMoreElements();)
	{
	    OverlapInfo ovlp = (OverlapInfo)e.nextElement();
	    if (!doExchange) {
		result[i++] = new JgclOverlapCurve3D((JgclParametricCurve3D)curveA,
						     ovlp.headPoint.paramA, ovlp.computeIncreaseA(),
						     (JgclParametricCurve3D)curveB,
						     ovlp.headPoint.paramB, ovlp.computeIncreaseB(),
						     false);
	    } else {
		result[i++] = new JgclOverlapCurve3D((JgclParametricCurve3D)curveB,
						     ovlp.headPoint.paramB, ovlp.computeIncreaseB(),
						     (JgclParametricCurve3D)curveA,
						     ovlp.headPoint.paramA, ovlp.computeIncreaseA(),
						     false);
	    }
	}

	return result;
    }

    /**
     * _Əd̃XgׂČ_Ƃ JgclIntersectionPoint3D ̔zƂĕԂ
     */
    JgclIntersectionPoint3D[] toJgclIntersectionPoint3DArray(boolean doExchange)
    {
	if (dimension != 3)
	    throw new JgclDimensionsMismatch();

	int totalSize = listOfIntersections.size() + (listOfOverlaps.size() * 2);
	int i;

	JgclIntersectionPoint3D[] result = new JgclIntersectionPoint3D[totalSize];
	i = 0;

	for (Enumeration e = listOfIntersections.elements(); e.hasMoreElements();)
	{
	    IntersectionInfo ints = (IntersectionInfo)e.nextElement();
	    if (!doExchange)
		result[i++] = (ints.coord == null)
		    ? new JgclIntersectionPoint3D((JgclParametricCurve3D)curveA, ints.paramA,
						  (JgclParametricCurve3D)curveB, ints.paramB,
						  JgclGeometry.doCheckDebug)
		    : new JgclIntersectionPoint3D((JgclPoint3D)ints.coord,
						  (JgclParametricCurve3D)curveA, ints.paramA,
						  (JgclParametricCurve3D)curveB, ints.paramB,
						  JgclGeometry.doCheckDebug);
	    else
		result[i++] = (ints.coord == null)
		    ? new JgclIntersectionPoint3D((JgclParametricCurve3D)curveB, ints.paramB,
						  (JgclParametricCurve3D)curveA, ints.paramA,
						  JgclGeometry.doCheckDebug)
		    : new JgclIntersectionPoint3D((JgclPoint3D)ints.coord,
						  (JgclParametricCurve3D)curveB, ints.paramB,
						  (JgclParametricCurve3D)curveA, ints.paramA,
						  JgclGeometry.doCheckDebug);
	}

	for (Enumeration e = listOfOverlaps.elements(); e.hasMoreElements();)
	{
	    OverlapInfo ovlp = (OverlapInfo)e.nextElement();
	    if (!doExchange) {
		result[i++] = new JgclIntersectionPoint3D((JgclParametricCurve3D)curveA,
							  ovlp.headPoint.paramA,
							  (JgclParametricCurve3D)curveB,
							  ovlp.headPoint.paramB,
							  JgclGeometry.doCheckDebug);
		result[i++] = new JgclIntersectionPoint3D((JgclParametricCurve3D)curveA,
							  ovlp.tailPoint.paramA,
							  (JgclParametricCurve3D)curveB,
							  ovlp.tailPoint.paramB,
							  JgclGeometry.doCheckDebug);
	    } else {
		result[i++] = new JgclIntersectionPoint3D((JgclParametricCurve3D)curveB,
							  ovlp.headPoint.paramB,
							  (JgclParametricCurve3D)curveA,
							  ovlp.headPoint.paramA,
							  JgclGeometry.doCheckDebug);
		result[i++] = new JgclIntersectionPoint3D((JgclParametricCurve3D)curveB,
							  ovlp.tailPoint.paramB,
							  (JgclParametricCurve3D)curveA,
							  ovlp.tailPoint.paramA,
							  JgclGeometry.doCheckDebug);
	    }
	}

	return result;
    }

    /**
     * JgclCurveCurveInterference2D ̔z񂩂_o
     *
     * @param	array	JgclCurveCurveInterference2D ̔z
     */
    static Vector extractIntersections(JgclCurveCurveInterference2D[] array)
    {
	Vector result = new Vector();

	for (int i = 0; i < array.length; i++)
	    if (array[i].isIntersectionPoint() == true)
		result.addElement(array[i]);

	return result;
    }

    /**
     * JgclCurveCurveInterference2D ̔z񂩂do
     *
     * @param	array	JgclCurveCurveInterference2D ̔z
     */
    static Vector extractOverlaps(JgclCurveCurveInterference2D[] array)
    {
	Vector result = new Vector();

	for (int i = 0; i < array.length; i++)
	    if (array[i].isOverlapCurve() == true)
		result.addElement(array[i]);

	return result;
    }

    /**
     * JgclCurveCurveInterference3D ̔z񂩂_o
     *
     * @param	array	JgclCurveCurveInterference3D ̔z
     */
    static Vector extractIntersections(JgclCurveCurveInterference3D[] array)
    {
	Vector result = new Vector();

	for (int i = 0; i < array.length; i++)
	    if (array[i].isIntersectionPoint() == true)
		result.addElement(array[i]);

	return result;
    }

    /**
     * JgclCurveCurveInterference3D ̔z񂩂do
     *
     * @param	array	JgclCurveCurveInterference3D ̔z
     */
    static Vector extractOverlaps(JgclCurveCurveInterference3D[] array)
    {
	Vector result = new Vector();

	for (int i = 0; i < array.length; i++)
	    if (array[i].isOverlapCurve() == true)
		result.addElement(array[i]);

	return result;
    }
}

// end of file
