/*
 * Ȑ̋ȗ\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCurveCurvature.java,v 1.7 2000/04/26 09:38:52 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * Ȑ̋ȗ\ۃNXB
 * <p>
 * ̃NX̃CX^X
 * ȗ̒l (l) curvature
 * B
 * </p>
 *
 * @version $Revision: 1.7 $, $Date: 2000/04/26 09:38:52 $
 * @author Information-technology Promotion Agency, Japan
 */

public abstract class JgclCurveCurvature {
    /**
     * ȗ̒lB
     */
    private final double curvature;

    /**
     * ȗ̒lw肵ăIuWFNg\zB
     * 
     * @param curvature	ȗ̒l
     */
    protected JgclCurveCurvature(double curvature) {
	super();
        this.curvature = curvature;
    }

    /**
     * ̋ȗIuWFNg̋ȗ̒lԂB
     * 
     * @return	ȗ̒l
     */
    public double curvature() {
	return curvature;
    }

    /**
     * ^ꂽ̋ȗ̒lƂ݂Ȃ邩ۂԂB
     * <p>
     * a, b ꂼ̋t̍A
     * ݐݒ肳Ă鉉Z̋̋e덷ȓł΁A
     * a  b ͓̋ȗł̂ƂB
     * </p>
     *
     * @param a	ȗ̒l1
     * @param b	ȗ̒l2
     * @return	a  b  ̋ȗƂ݂Ȃ trueAłȂ false
     */
    static boolean identical(double a, double b) {
	if (JgclUtil.isReciprocatable(a)) {
	    if (!JgclUtil.isReciprocatable(b))
		return false;

	    double a_rad = 1.0 / a;
	    double b_rad = 1.0 / b;
	    double tol_d = JgclConditionOfOperation.getCondition().getToleranceForDistance();
	    if (Math.abs(a_rad - b_rad) > tol_d)
		return false;
	} else {
	    if (JgclUtil.isReciprocatable(b))
		return false;
	}

	return true;
    }
}

