/*
 * Z
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclConditionOfOperation.java,v 1.16 2000/04/26 09:38:50 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Hashtable;
import java.util.Stack;

/**
 * JgclConditionOfOperation ́AZ\NXłB
 * <p>
 * ZƂ́AJGCL ̃IuWFNg̃\bh
 * e̊􉽉ZsȂŎQƂ鋖e덷܂Ƃ߂̂łB
 * <br>
 * ̉ŹAȉ̋e덷Ă܂B
 * <ul>
 * <li>	{@link JgclToleranceForDistance  ̋e덷}
 * <li>	{@link JgclToleranceForAngle     px̋e덷}
 * <li>	{@link JgclToleranceForParameter p[^l̋e덷}
 * <li>	{@link JgclTolerance             @Ȃl̋e덷}
 * </ul>
 * </p>
 * <p>
 * JGCL ł́AJava ̃XbhɈقȂ鉉Zݒ肷邱Ƃł܂B
 * <br>
 * X̃Xbhɂ́AZ܂ރX^bNΉ܂B
 * ̃X^bN͏Ԃł͋ (empty) łB
 * [ÚÃX^bNɔCӂ̉Z push/pop 邱Ƃł܂B
 * <br>
 * JGCL ̃IuWFNg̃\bh́A
 * 炩̋e덷fKvȏꍇɁA
 * ꂪsXbhɑΉ
 * ZX^bN̈ԏɂ鉉ZQƂ܂B
 * X^bN̏ꍇɂ́AftHg̉ZQƂ܂B
 * </p>
 *
 * @version $Revision: 1.16 $, $Date: 2000/04/26 09:38:50 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclConditionOfOperation extends java.lang.Object {

    /**
     * ̋e덷B
     */
    private final JgclToleranceForDistance dTol;

    /**
     * px̋e덷B
     */
    private final JgclToleranceForAngle aTol;

    /**
     * p[^l̋e덷B
     */
    private final JgclToleranceForParameter pTol;

    /**
     * @Ȃl̋e덷B
     */
    private final JgclTolerance rTol;

    /**
     * Thread L[ƂAZX^bÑnbVe[uB
     */
    private static final Hashtable threadTable;

    /**
     * ftHg̉ZB
     * <p>
     * lƂĐݒ肳鉉Z̊ee덷̒l͈ȉ̒ʂB
     * <pre>
     * ̋e덷 : 1.0e-4
     * px̋e덷 : Math.PI * 0.1 / 180.0
     * p[^l̋e덷 : 1.0e-8
     * @Ȃl̋e덷 : 1.0e-8
     * </pre>
     * </p>
     */
    private static JgclConditionOfOperation defaultCondition;

    /**
     * static ȃtB[hɒlݒ肷B
     */
    static {
	defaultCondition = new JgclConditionOfOperation();
	threadTable = new Hashtable();
    }

    /**
     * ȉ̋e덷lŃIuWFNg\zB
     * <p>
     * <pre>
     * ̋e덷 : 1.0e-4
     * px̋e덷 : Math.PI * 0.1 / 180.0
     * p[^l̋e덷 : 1.0e-8
     * @Ȃl̋e덷 : 1.0e-8
     * </pre>
     * </p>
     */
    public JgclConditionOfOperation() {
	// these values from GHL3 src/util/gh_utilInit.c

	dTol = new JgclToleranceForDistance(1.0e-4);
	aTol = new JgclToleranceForAngle(Math.PI * 0.1 / 180.0);
	pTol = new JgclToleranceForParameter(1.0e-8);
	rTol = new JgclTolerance(1.0e-8);
    }

    /**
     * e덷w肵ăIuWFNg\zB
     *
     * @param dTol	̋e덷
     * @param aTol	px̋e덷
     * @param pTol	p[^l̋e덷
     * @param rTol	@Ȃl̋e덷
     */
    public JgclConditionOfOperation(JgclToleranceForDistance dTol,
				    JgclToleranceForAngle aTol,
				    JgclToleranceForParameter pTol,
				    JgclTolerance rTol)
    {
	this.dTol = dTol;
	this.aTol = aTol;
	this.pTol = pTol;
	this.rTol = rTol;
    }

    /**
     * ̉ZA̋e덷w̒lɕύXԂB
     * 
     * @param dTol	ݒ肷鋗̋e덷
     */
    public JgclConditionOfOperation makeCopy(JgclToleranceForDistance dTol) {
	return new JgclConditionOfOperation(dTol, this.aTol, this.pTol, this.rTol);
    }

    /**
     * ̉ZA̋e덷w̒lɕύXԂB
     * 
     * @param value	ݒ肷鋗̋e덷
     * @see	JgclToleranceForDistance
     */
    public JgclConditionOfOperation makeCopyWithToleranceForDistance(double value) {
	JgclToleranceForDistance dTol = new JgclToleranceForDistance(value);
	return makeCopy(dTol);
    }

    /**
     * ̉ZApx̋e덷w̒lɕύXԂ
     * 
     * @param aTol	ݒ肷px̋e덷
     */
    public JgclConditionOfOperation makeCopy(JgclToleranceForAngle aTol) {
	return new JgclConditionOfOperation(this.dTol, aTol, this.pTol, this.rTol);
    }

    /**
     * ̉ZApx̋e덷w̒lɕύXԂ
     * 
     * @param value	ݒ肷px̋e덷
     * @see	JgclToleranceForAngle
     */
    public JgclConditionOfOperation makeCopyWithToleranceForAngle(double value) {
	JgclToleranceForAngle aTol = new JgclToleranceForAngle(value);
	return makeCopy(aTol);
    }

    /**
     * ̉ZAp[^l̋e덷w̒lɕύXԂ
     * 
     * @param pTol	ݒ肷p[^l̋e덷
     */
    public JgclConditionOfOperation makeCopy(JgclToleranceForParameter pTol) {
	return new JgclConditionOfOperation(this.dTol, this.aTol, pTol, this.rTol);
    }

    /**
     * ̉ZAp[^l̋e덷w̒lɕύXԂ
     * 
     * @param value	ݒ肷p[^l̋e덷
     * @see	JgclToleranceForParameter
     */
    public JgclConditionOfOperation makeCopyWithToleranceForParameter(double value) {
	JgclToleranceForParameter pTol = new JgclToleranceForParameter(value);
	return makeCopy(pTol);
    }

    /**
     * ̉ZA@Ȃl̋e덷w̒lɕύXԂ
     * 
     * @param rTol	ݒ肷鐡@Ȃl̋e덷
     */
    public JgclConditionOfOperation makeCopy(JgclTolerance rTol) {
	return new JgclConditionOfOperation(this.dTol, this.aTol, this.pTol, rTol);
    }

    /**
     * ̉ZA@Ȃl̋e덷w̒lɕύXԂ
     * 
     * @param value	ݒ肷鐡@Ȃl̋e덷
     * @see	JgclTolerance
     */
    public JgclConditionOfOperation makeCopyWithToleranceForRealNumber(double value) {
	JgclTolerance rTol = new JgclTolerance(value);
	return makeCopy(rTol);
    }

    /**
     * ̉Z̋̋e덷ԂB
     * 
     * @return	̋e덷
     */
    public double getToleranceForDistance() {
	return dTol.value();
    }

    /**
     * ̉Z̋̋e덷ԂB
     * 
     * @return	̋e덷
     */
    public JgclToleranceForDistance getToleranceForDistanceAsObject() {
	return dTol;
    }

    /**
     * ̉Z̋̋e덷̎ԂB
     * 
     * @return	̋e덷̎
     */
    public double getToleranceForDistance2() {
	return dTol.value2();
    }

    /**
     * ̉Z̊px̋e덷ԂB
     * 
     * @return	px̋e덷
     */
    public double getToleranceForAngle() {
	return aTol.value();
    }

    /**
     * ̉Z̊px̋e덷ԂB
     * 
     * @return	px̋e덷
     */
    public JgclToleranceForAngle getToleranceForAngleAsObject() {
	return aTol;
    }

    /**
     * ̉Z̃p[^l̋e덷ԂB
     * 
     * @return	p[^l̋e덷
     */
    public double getToleranceForParameter() {
	return pTol.value();
    }

    /**
     * ̉Z̃p[^l̋e덷ԂB
     * 
     * @return	p[^l̋e덷
     */
    public JgclToleranceForParameter getToleranceForParameterAsObject() {
	return pTol;
    }

    /**
     * ̉Z̐@Ȃl̋e덷ԂB
     * 
     * @return	@Ȃl̋e덷
     */
    public double getToleranceForRealNumber() {
	return rTol.value();
    }

    /**
     * ̉Z̐@Ȃl̋e덷ԂB
     * 
     * @return	@Ȃl̋e덷
     */
    public JgclTolerance getToleranceForRealNumberAsObject() {
	return rTol;
    }

    /**
     * ftHgƂĐݒ肳Ă鉉ZԂB
     */
    public static JgclConditionOfOperation getDefaultCondition() {
	return defaultCondition;
    }

    /**
     * ^ꂽZftHgƂĐݒ肷B
     *
     * @param cond	ftHgƂĐݒ肷鉉Z
     */
    public synchronized static void setDefaultCondition(JgclConditionOfOperation cond) {
	defaultCondition = cond;
    }

    /**
     * ^ꂽXbhɑΉ鉉ZX^bNoB
     *
     * @param	theThread	Xbh
     */
    private static Stack getStack(Thread theThread) {
	Object obj = threadTable.get(theThread);
	Stack stack;

	if (obj == null) {
	    stack = new Stack();
	    threadTable.put(theThread, stack);
	} else {
	    stack = (Stack)obj;
	}

	return stack;
    }

    /**
     * ݎs̃XbhɂĎQƂׂZoB
     * <p>
     * ݎs̃XbhɑΉ鉉ZX^bNł΁A
     * ftHg̉ZԂB
     * </p>
     *
     * @return	ݎs̃XbhɂĎQƂׂZ
     */
    public static JgclConditionOfOperation getCondition() {
	JgclConditionOfOperation cond = peek();
	if (cond == null)
	    cond = defaultCondition;
	return cond;
    }

    /**
     * ݎs̃XbhɑΉ鉉ZX^bN󂩔ۂԂB
     *
     * @return	ݎs̃XbhɑΉ鉉ZX^bN󂩔ۂ
     */
    public static boolean empty() {
	Stack stack = getStack(Thread.currentThread());
	return stack.empty();
    }

    /**
     * ݎs̃XbhɑΉ鉉ZX^bN̈ԏɂ鉉ZԂB
     * <p>
     * ݎs̃XbhɑΉ鉉ZX^bNł null ԂB
     * </p>
     * <p>
     * ̃\bh́AZX^bN̏ԂύXȂB
     * </p>
     *
     * @return	ݎs̃XbhɑΉ鉉ZX^bN̈ԏɂ鉉Z
     */
    public static JgclConditionOfOperation peek() {
	Stack stack = getStack(Thread.currentThread());
	if (stack.empty())
	    return null;

	return (JgclConditionOfOperation)stack.peek();
    }

    /**
     * ^ꂽZAݎs̃XbhɑΉ鉉ZX^bN push B
     * 
     * @param condition	push 鉉Z
     */
    public static void push(JgclConditionOfOperation condition) {
	Stack stack = getStack(Thread.currentThread());

	stack.push(condition);
    }

    /**
     * ݎs̃XbhɑΉ鉉ZX^bN牉Z pop B
     * <p>
     * ݎs̃XbhɑΉ鉉ZX^bN̏ꍇɂ null ԂB
     * </p>
     *
     * @return	pop ꂽZ
     */
    public static JgclConditionOfOperation pop() {
	Stack stack = getStack(Thread.currentThread());
	if (stack.empty())
	    return null;

	JgclConditionOfOperation cond = (JgclConditionOfOperation)stack.peek();
	stack.pop();
	return cond;
    }

    /**
     * ̉ZAftHg̉ZƂĐݒ肷B
     */
    public synchronized void setDefault() {
	setDefaultCondition(this);
    }

    /**
     * ̉ZAݎs̃XbhɑΉ鉉ZX^bN push B
     */
    public void push() {
	push(this);
    }
}
