/*
 * R : 􉽓IȕϊsȂZq\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCartesianTransformationOperator3D.java,v 1.23 2000/08/11 06:18:44 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : 􉽓IȕϊsȂZq\NXB
 * <p>
 * 􉽓IȕΐAsړA]ړA~[OAψȃXP[O
 * ō\B
 * ̕ϊł́AϊOƕϊŔCӂ̓_Ԃ͈̋̔łB
 * </p>
 * <p>
 * ܂APʉꂽ̃xNg U1, U2, U3 Ae`钼s T lB
 * U1, U2, U3 ݂͌ɒxNgłB
 * ̒PʃxNǵAxNg axis1, axis2, axis3 
 * {@link JgclGeometrySchemaFunction#baseAxis(JgclVector3D, JgclVector3D, JgclVector3D)
 * JgclGeometrySchemaFunction.baseAxis}(axis1, axis2, axis3) ŌvZB
 * T ̍s񎮂 -1 ̏ꍇɂ́AT ̍\vfƂĊ܂ޕϊ̓~[O܂ށB
 * <br>
 * 􉽓IȕΐAT ɉāA
 * sړ̗ʂ߂ǏIȌ_ A (localOrigin)
 *  XP[O̗ʂ߂l S
 * Œ`B
 * </p>
 * <p>
 * ȉ̋LqŁAA.b ͓_ (邢̓xNg) A  b \B
 * </p>
 * <p>
 * _ P ̕ΐAϊ̓_ Q ƂāAȉŒ`B
 * <pre>
 *	Q.x = A.x + S * (P.x * U1.x + P.y * U2.x + P.z * U3.x)
 *	Q.y = A.y + S * (P.x * U1.y + P.y * U2.y + P.z * U3.y)
 *	Q.z = A.z + S * (P.x * U1.z + P.y * U2.z + P.z * U3.z)
 * </pre>
 * </p>
 * <p>
 * xNg V ̕ΐAϊ̃xNg W ƂāAȉŒ`B
 * <pre>
 *	W.x = S * (V.x * U1.x + V.y * U2.x + V.z * U3.x)
 *	W.y = S * (V.x * U1.y + V.y * U2.y + V.z * U3.y)
 *	W.z = S * (V.x * U1.z + V.y * U2.z + V.z * U3.z)
 * </pre>
 * </p>
 * <p>
 *  L ̕ΐAϊ̒ M ƂāAȉŒ`B
 * <pre>
 *	M = S * L
 * </pre>
 * </p>
 *
 * @version $Revision: 1.23 $, $Date: 2000/08/11 06:18:44 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclCartesianTransformationOperator2D
 */

public class JgclCartesianTransformationOperator3D extends JgclCartesianTransformationOperator {
    /**
     * ϊ̑ꎲ U1 K肷xNgB
     * @serial
     * @see JgclGeometrySchemaFunction#baseAxis(JgclVector3D, JgclVector3D, JgclVector3D)
     */
    private JgclVector3D axis1;

    /**
     * ϊ̑ U2 K肷xNg
     * @serial
     * @see JgclGeometrySchemaFunction#baseAxis(JgclVector3D, JgclVector3D, JgclVector3D)
     */
    private JgclVector3D axis2;

    /**
     * ϊ̑O U3 K肷xNg
     * @serial
     * @see JgclGeometrySchemaFunction#baseAxis(JgclVector3D, JgclVector3D, JgclVector3D)
     */
    private JgclVector3D axis3;

    /**
     * sړ̗ʂK肷ǏIȌ_ AB
     * <p>
     * _̕ϊł́AIȌ_ (0, 0, 0) 炱̓_܂ł̕sړ܂ށB
     * </p>
     * @serial
     */
    private JgclPoint3D localOrigin;

    /**
     * ϊ̎ƂȂPʃxNg U1, U2, U3B
     * <p>
     * s T ̊eB
     * </p>
     * <p>
     * KvɉăLbVB
     * </p>
     * @serial
     */
    private JgclVector3D u[];

    /**
     * etB[h̒l𒼐ڎw肵āAIuWFNg\zB
     * <p>
     * axis1  null ł\ȂB
     * </p>
     * <p>
     * axis2  null ł\ȂB
     * </p>
     * <p>
     * axis3  null ł\ȂB
     * </p>
     * <p>
     * localOgirin  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * scale ̒l͐łȂ΂ȂȂB
     * scale ̒lAݐݒ肳Ă鉉Z
     * ̋e덷ȉ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param axis1	ϊ̑ꎲ U1 K肷xNg
     * @param axis2	ϊ̑ U2 K肷xNg
     * @param axis3	ϊ̑O U3 K肷xNg
     * @param localOrigin	sړ̗ʂ߂ǏIȌ_ A
     * @param scale	XP[Oʂ߂l S
     * @see JgclInvalidArgumentValue
     */
    public JgclCartesianTransformationOperator3D(JgclVector3D axis1, JgclVector3D axis2,
						 JgclVector3D axis3, JgclPoint3D localOrigin,
						 double scale)
    {
	super(scale);
	setFields(axis1, axis2, axis3, localOrigin);
    }

    /**
     * ǏWn (zu) IȍWnւ̕ϊ\IuWFNg\zB
     * <p>
     * position ̌_/X /Y/Z ꂼ
     * localOrigin/axis1/axis2/axis3 ƂB
     * </p>
     * <p>
     * position  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * scale ̒l͐łȂ΂ȂȂB
     * scale ̒lAݐݒ肳Ă鉉Z
     * ̋e덷ȉ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param position	ǏWn (zu)
     * @param scale	XP[Ol
     * @see JgclInvalidArgumentValue
     */
    public JgclCartesianTransformationOperator3D(JgclAxis2Placement3D position, double scale)
    {
	super(scale);
	fromAxis2Placement(position);
    }

    /**
     * XP[Ol 1 ƂāA
     * ǏWn (zu) IȍWnւ̕ϊ\IuWFNg\zB
     * <p>
     * position ̌_/X /Y/Z ꂼ
     * localOrigin/axis1/axis2/axis3 ƂB
     * </p>
     * <p>
     * position  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param position	ǏWn (zu)
     * @see JgclInvalidArgumentValue
     */
    public JgclCartesianTransformationOperator3D(JgclAxis2Placement3D position)
    {
	super(1.0);
	fromAxis2Placement(position);
    }

    /**
     * etB[h̒lݒ肷B
     * <p>
     * axis1  null ł\ȂB
     * </p>
     * <p>
     * axis2  null ł\ȂB
     * </p>
     * <p>
     * axis3  null ł\ȂB
     * </p>
     * <p>
     * localOgirin  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param axis1	ϊ̑ꎲ U1 K肷xNg
     * @param axis2	ϊ̑ U2 K肷xNg
     * @param axis3	ϊ̑O U3 K肷xNg
     * @param localOrigin	sړ̗ʂ߂ǏIȌ_ A
     * @see JgclInvalidArgumentValue
     */
    private void setFields(JgclVector3D axis1,
			   JgclVector3D axis2,
			   JgclVector3D axis3,
			   JgclPoint3D localOrigin)
    {
	if (localOrigin == null) {
	    throw new JgclInvalidArgumentValue();
	}
	// check more ???
	this.localOrigin = localOrigin;
	this.axis1 = axis1;
	this.axis2 = axis2;
	this.axis3 = axis3;
    }

    /**
     * ǏWn(zu) IȍWnւ̕ϊ\悤
     * etB[h̒lݒ肷B
     * <p>
     * position ̌_/X /Y/Z ꂼ
     * localOrigin/axis1/axis2/axis3 ƂB
     * </p>
     * <p>
     * position  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param position	ǏWn (zu)
     * @see JgclInvalidArgumentValue
     */
    private void fromAxis2Placement(JgclAxis2Placement3D position)
    {
	if (position == null) {
	    throw new JgclInvalidArgumentValue();
	}
	u = position.axes();
	this.localOrigin = position.location();
	this.axis1 = u1();
	this.axis2 = u2();
	this.axis3 = u3();
    }

    /**
     * ̉Zq̎ԂB
     * <p>
     *  3 ԂB
     * </p>
     * 
     * @return	RȂ̂ŁA 3
     */
    public int dimension() {
	return 3;
    }

    /**
     * ̉Zq̕ϊ̑ꎲ U1 K肷xNgԂB
     *
     * @return	ϊ̑ꎲ U1 K肷xNg
     */
    public JgclVector3D axis1() {
	return axis1;
    }

    /**
     * ̉Zq̕ϊ̑ U2 K肷xNgԂB
     *
     * @return	ϊ̑ U2 K肷xNg
     */
    public JgclVector3D axis2() {
	return axis2;
    }

    /**
     * ̉Zq̕ϊ̑O U3 K肷xNgԂB
     *
     * @return	ϊ̑O U3 K肷xNg
     */
    public JgclVector3D axis3() {
	return axis3;
    }

    /**
     * ̉Zq̕sړ̗ʂK肷ǏIȌ_ԂB
     *
     * @return	sړ̗ʂK肷ǏIȌ_
     */
    public JgclPoint3D localOrigin() {
	return localOrigin;
    }

    /**
     * ̉Zq̕ϊ̑ꎲƂȂPʃxNg U1 ԂB
     *
     * @return	ϊ̑ꎲƂȂPʃxNg U1
     */
    public JgclVector3D u1() {
	if (u == null)
	    u();
	return u[0];
    }

    /**
     * ̉Zq̕ϊ̑񎲂ƂȂPʃxNg U2 ԂB
     *
     * @return	ϊ̑񎲂ƂȂPʃxNg U2
     */
    public JgclVector3D u2() {
	if (u == null)
	    u();
	return u[1];
    }

    /**
     * ̉Zq̕ϊ̑OƂȂPʃxNg U3 ԂB
     *
     * @return	ϊ̑OƂȂPʃxNg U3
     */
    public JgclVector3D u3() {
	if (u == null)
	    u();
	return u[2];
    }

    /**
     * ̉Zq̕ϊ̎ƂȂPʃxNg U1, U2, U3 ԂB
     * <p>
     * ʂƂĕԂz̗vf 3 ŁA
     * ŏ̗vf U1AԖڂ̗vf U2AŌ̗vf U3 ܂ށB
     * </p>
     *
     * @return	ϊ̎ƂȂPʃxNg̔z
     */
    public JgclVector3D[] u() {
	if (u == null) {
	    u = JgclGeometrySchemaFunction.baseAxis(axis1, axis2, axis3);
	}
	return (JgclVector3D[])u.clone();
    }

    /**
     * ^ꂽxNg̉ZqŕϊB
     *
     * @param vector	xNg
     * @return	ϊ̃xNg
     */
    public JgclVector3D transform(JgclVector3D vector) {
	double x, y, z;

	x = scale()*(vector.x() * u1().x() + vector.y() * u2().x() + vector.z() * u3().x());
	y = scale()*(vector.x() * u1().y() + vector.y() * u2().y() + vector.z() * u3().y());
	z = scale()*(vector.x() * u1().z() + vector.y() * u2().z() + vector.z() * u3().z());
	return new JgclLiteralVector3D(x, y, z);
    }

    /**
     * ^ꂽ_̉ZqŕϊB
     *
     * @param point	_
     * @return	ϊ̓_
     */
    public JgclPoint3D transform(JgclPoint3D point) {
	double x, y, z;

	x = localOrigin.x() + scale()
	    * (point.x() * u1().x() + point.y() * u2().x() + point.z() * u3().x());
	y = localOrigin.y() + scale()
	    * (point.x() * u1().y() + point.y() * u2().y() + point.z() * u3().y());
	z = localOrigin.z() + scale()
	    * (point.x() * u1().z() + point.y() * u2().z() + point.z() * u3().z());
	return new JgclCartesianPoint3D(x, y, z);
    }

    /**
     * ^ꂽxNg̉ZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * vector  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * vector  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł vector L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * vector  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  vector  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param vector	xNg
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̃xNg
     */
    public JgclVector3D transform(JgclVector3D vector,
				  java.util.Hashtable transformedGeometries)
    {
	return vector.transformBy(this, transformedGeometries);
    }

    /**
     * ^ꂽ_̉ZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * point  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * point  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł point L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * point  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  point  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param point	_
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̓_
     */
    public JgclPoint3D transform(JgclPoint3D point,
				 java.util.Hashtable transformedGeometries)
    {
	return point.transformBy(this, transformedGeometries);
    }

    /**
     * ^ꂽȐ̉ZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * curve  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * curve  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł curve L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * curve  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  curve  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param curve	Ȑ
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̋Ȑ
     */
    public JgclParametricCurve3D transform(JgclParametricCurve3D curve,
					   java.util.Hashtable transformedGeometries)
    {
	return curve.transformBy(this, transformedGeometries);
    }

    /**
     * ^ꂽȖʂ̉ZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * surface  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * surface  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł surface L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * surface  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  surface  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param surface	Ȗ
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̋Ȗ
     */
    public JgclParametricSurface3D transform(JgclParametricSurface3D surface,
					     java.util.Hashtable transformedGeometries)
    {
	return surface.transformBy(this, transformedGeometries);
    }

    /**
     * ^ꂽxNg̉ZqŋtϊB
     *
     * @param vector	xNg
     * @return	tϊ̃xNg
     */
    public JgclVector3D reverseTransform(JgclVector3D vector) {
	double x, y, z;

	x = (vector.x() * u1().x() + vector.y() * u1().y() + vector.z() * u1().z())/scale();
	y = (vector.x() * u2().x() + vector.y() * u2().y() + vector.z() * u2().z())/scale();
	z = (vector.x() * u3().x() + vector.y() * u3().y() + vector.z() * u3().z())/scale();
	return new JgclLiteralVector3D(x, y, z);
    }

    /**
     * ^ꂽ_̉ZqŋtϊB
     *
     * @param point	_
     * @return	tϊ̓_
     */
    public JgclPoint3D reverseTransform(JgclPoint3D point) {
	JgclVector3D wk;
	double x, y, z;

	wk = point.subtract(localOrigin);
	x = (wk.x() * u1().x() + wk.y() * u1().y() + wk.z() * u1().z()) / scale();
	y = (wk.x() * u2().x() + wk.y() * u2().y() + wk.z() * u2().z()) / scale();
	z = (wk.x() * u3().x() + wk.y() * u3().y() + wk.z() * u3().z()) / scale();

	return new JgclCartesianPoint3D(x, y, z);
    }

    /**
     * ^ꂽxNg̉ZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * vector  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * vector  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł vector L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * vector  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  point  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param vector	xNg
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̃xNg
     */
    public JgclVector3D reverseTransform(JgclVector3D vector,
					 java.util.Hashtable transformedGeometries)
    {
	return vector.reverseTransformBy(this, transformedGeometries);
    }

    /**
     * ^ꂽ_̉ZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * point  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * point  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł point L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * point  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  point  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param point	_
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̓_
     */
    public JgclPoint3D reverseTransform(JgclPoint3D point,
					java.util.Hashtable transformedGeometries)
    {
	return point.reverseTransformBy(this, transformedGeometries);
    }

    /**
     * ^ꂽȐ̉ZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * curve  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * curve  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł curve L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * curve  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  curve  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param curve	Ȑ
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̋Ȑ
     */
    public JgclParametricCurve3D reverseTransform(JgclParametricCurve3D curve,
						  java.util.Hashtable transformedGeometries)
    {
	return curve.reverseTransformBy(this, transformedGeometries);
    }

    /**
     * ^ꂽȖʂ̉ZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * surface  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * surface  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł surface L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * surface  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  surface  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param surface	Ȗ
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̋Ȗ
     */
    public JgclParametricSurface3D reverseTransform(JgclParametricSurface3D surface,
						    java.util.Hashtable transformedGeometries)
    {
	return surface.reverseTransformBy(this, transformedGeometries);
    }

    /**
     * {@link #transform(JgclVector3D) transform(JgclVector3D)} ̕ʖ\bhB
     * <p>
     * localW -> enclosed (global) W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param vector	xNg
     * @return	ϊ̃xNg
     */
    public JgclVector3D toEnclosed(JgclVector3D vector) {
	return transform(vector);
    }

    /**
     * {@link #transform(JgclPoint3D) transform(JgclPoint3D)} ̕ʖ\bhB
     * <p>
     * localW -> enclosed (global) W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param point	_
     * @return	ϊ̓_
     */
    public JgclPoint3D toEnclosed(JgclPoint3D point) {
	return transform(point);
    }

    /**
     * {@link #transform(JgclVector3D, java.util.Hashtable)
     * transform(JgclVector3D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * localW -> enclosed (global) W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param vector	xNg
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̃xNg
     */
    public JgclVector3D toEnclosed(JgclVector3D vector,
				   java.util.Hashtable transformedGeometries)
    {
	return transform(vector, transformedGeometries);
    }

    /**
     * {@link #transform(JgclPoint3D, java.util.Hashtable)
     * transform(JgclPoint3D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * localW -> enclosed (global) W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param point	_
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̓_
     */
    public JgclPoint3D toEnclosed(JgclPoint3D point,
				  java.util.Hashtable transformedGeometries)
    {
	return transform(point, transformedGeometries);
    }

    /**
     * {@link #transform(JgclParametricCurve3D, java.util.Hashtable)
     * transform(JgclParametricCurve3D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * localW -> enclosed (global) W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param curve	Ȑ
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̋Ȑ
     */
    public JgclParametricCurve3D toEnclosed(JgclParametricCurve3D curve,
					    java.util.Hashtable transformedGeometries)
    {
	return transform(curve, transformedGeometries);
    }

    /**
     * {@link #transform(JgclParametricSurface3D, java.util.Hashtable)
     * transform(JgclParametricSurface3D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * localW -> enclosed (global) W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param surface	Ȗ
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̋Ȗ
     */
    public JgclParametricSurface3D toEnclosed(JgclParametricSurface3D surface,
					      java.util.Hashtable transformedGeometries)
    {
	return transform(surface, transformedGeometries);
    }

    /**
     * {@link #reverseTransform(JgclVector3D) reverseTransform(JgclVector3D)} ̕ʖ\bhB
     * <p>
     * enclosed (global) W -> localW̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param vector	xNg
     * @return	ϊ̃xNg
     */
    public JgclVector3D toLocal(JgclVector3D vector) {
	return reverseTransform(vector);
    }

    /**
     * {@link #reverseTransform(JgclPoint3D) reverseTransform(JgclPoint3D)} ̕ʖ\bhB
     * <p>
     * enclosed (global) W -> local W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param point	_
     * @return	ϊ̓_
     */
    public JgclPoint3D toLocal(JgclPoint3D point) {
	return reverseTransform(point);
    }

    /**
     * {@link #reverseTransform(JgclVector3D, java.util.Hashtable)
     * reverseTransform(JgclVector3D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * enclosed (global) W -> local W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param vector	xNg
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̃xNg
     */
    public JgclVector3D toLocal(JgclVector3D vector,
				java.util.Hashtable transformedGeometries)
    {
	return reverseTransform(vector, transformedGeometries);
    }

    /**
     * {@link #reverseTransform(JgclPoint3D, java.util.Hashtable)
     * reverseTransform(JgclPoint3D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * enclosed (global) W -> local W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param point	_
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̓_
     */
    public JgclPoint3D toLocal(JgclPoint3D point,
				java.util.Hashtable transformedGeometries)
    {
	return reverseTransform(point, transformedGeometries);
    }

    /**
     * {@link #reverseTransform(JgclParametricCurve3D, java.util.Hashtable)
     * reverseTransform(JgclParametricCurve3D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * enclosed (global) W -> local W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param curve	Ȑ
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̋Ȑ
     */
    public JgclParametricCurve3D toLocal(JgclParametricCurve3D curve,
					 java.util.Hashtable transformedGeometries)
    {
	return reverseTransform(curve, transformedGeometries);
    }

    /**
     * {@link #reverseTransform(JgclParametricSurface3D, java.util.Hashtable)
     * reverseTransform(JgclParametricSurface3D, java.util.Hashtable)} ̕ʖ\bhB
     * <p>
     * enclosed (global) W -> local W̕ϊł邱Ƃ킩₷B
     * </p>
     *
     * @param surface	Ȗ
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̋Ȗ
     */
    public JgclParametricSurface3D toLocal(JgclParametricSurface3D surface,
					   java.util.Hashtable transformedGeometries)
    {
	return reverseTransform(surface, transformedGeometries);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tscale\t" + scale());
	if (axis1 != null) {
	    writer.println(indent_tab + "\taxis1");
	    axis1.output(writer, indent + 2);
	}
	if (axis2 != null) {
	    writer.println(indent_tab + "\taxis2");
	    axis2.output(writer, indent + 2);
	}
	if (axis3 != null) {
	    writer.println(indent_tab + "\taxis3");
	    axis3.output(writer, indent + 2);
	}
        writer.println(indent_tab + "\tlocalOrigin");
        localOrigin.output(writer, indent + 2);
        writer.println("End");
    }
}

