/*
 * RFeWl萔Œ`ꂽ_\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCartesianPoint3D.java,v 1.18 2000/04/26 09:38:46 hideit Exp $
 *
 */

package jp.go.ipa.jgcl;

import java.io.PrintWriter;

/**
 * RFeWl萔Œ`ꂽ_\NXB
 *
 * @version $Revision: 1.18 $, $Date: 2000/04/26 09:38:46 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclHomogeneousPoint3D
 */

public class JgclCartesianPoint3D extends JgclPoint3D {
    /** 
     * X WlB
     * @serial
     */
    private final double x;

    /** 
     * Y WlB
     * @serial
     */
    private final double y;

    /** 
     * Z WlB
     * @serial
     */
    private final double z;

    /**
     * (x, y, z) Œ`IuWFNg\zB
     * 
     * @param x X Wl
     * @param y Y Wl
     * @param z Z Wl
     */
    public JgclCartesianPoint3D(double x, double y, double z) {
        super();
        this.x = x;
        this.y = y;
        this.z = z;
    }

    /**
     * (components[0], components[1], components[2]) Œ`
     * IuWFNg\zB
     * 
     * @param components Wl̔z
     */
    public JgclCartesianPoint3D(double[] components) {
        super();
        this.x = components[0];
        this.y = components[1];
        this.z = components[2];
    }

    /**
     * X WlԂB
     *
     * @return X Wl
     */
    public double x() {
        return x;
    }

    /**
     * Y WlԂB
     *
     * @return Y Wl
     */
    public double y() {
        return y;
    }

    /**
     * Z WlԂB
     *
     * @return Z Wl
     */
    public double z() {
        return z;
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclPoint3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	if (reverseTransform == false)
	    return transformationOperator.transform(this);
	else
	    return transformationOperator.reverseTransform(this);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab +
                       getClassName() +
                       " " + x() +
                       " " + y() +
                       " " + z() +
                       " End");
    }
}
