/*
 * R : LȋȐ\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclBoundedCurve3D.java,v 1.19 2000/04/26 09:38:42 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * R : LȋȐ\ۃNXB
 * <p>
 * ̃NXɂ̓CX^Xׂ͂ȂB
 * </p>
 *
 * @version $Revision: 1.19 $, $Date: 2000/04/26 09:38:42 $
 * @author Information-technology Promotion Agency, Japan
 */

public abstract class JgclBoundedCurve3D extends JgclParametricCurve3D {
    /**
     * ^ɃIuWFNg\zB
     */
    protected JgclBoundedCurve3D() {
	super();
    }

    /**
     * ̗LȐŜ̎ԏł̒ (̂) ԂB
     * <p>
     * []
     * <br>
     * g̃p[^` section ^
     * this.{@link JgclParametricCurve#length(JgclParameterSection)
     * length}(section)
     * ĂяoB
     * </p>
     * 
     * @return	ȐŜ̒
     */
    public double length() {
	try {
	    return length(parameterDomain().section());
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̗LȐŜA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_ JgclPointOnCurve3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * []
     * <br>
     * g̃p[^` section ^
     * this.{@link JgclParametricCurve3D#toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline}(section, tolerance)
     * ĂяoB
     * </p>
     *
     * @param tolerance	̋e덷
     * @return	̋ȐŜ𒼐ߎ|C
     * @see	JgclPointOnCurve3D
     */
    public JgclPolyline3D toPolyline(JgclToleranceForDistance tolerance) {
	try {
	    return toPolyline(parameterDomain().section(), tolerance);
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̗LȐŜɍČL Bspline ȐԂB
     * <p>
     * []
     * <br>
     * g̃p[^` section ^
     * this.{@link JgclParametricCurve3D#toBsplineCurve(JgclParameterSection)
     * toBsplineCurve}(section)
     * ĂяoB
     * </p>
     * 
     * @return	̋ȐŜČL Bspline Ȑ
     */
    public JgclBsplineCurve3D toBsplineCurve() {
	try {
	    return toBsplineCurve(parameterDomain().section());
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̗LȐƑ̗LȐ̊߂钊ۃ\bhB
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ
     * @return		Ȑ̊̔z
     */
    abstract public JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate);

    /**
     * ̗LȐƑ̗LȐ () ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ ()
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate,
						      boolean doExchange);

    /**
     * ̗LȐƑ̗LȐ (|C) ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (|C)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference3D[] interfere(JgclPolyline3D mate,
						      boolean doExchange);

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (xWGȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference3D[] interfere(JgclPureBezierCurve3D mate,
						      boolean doExchange);

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (aXvCȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference3D[] interfere(JgclBsplineCurve3D mate,
						      boolean doExchange);

    /**
     * ̗LȐƑ̗LȐ (gȐ) ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference3D[] interfere(JgclTrimmedCurve3D mate,
						      boolean doExchange);

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference3D[] interfere(JgclCompositeCurveSegment3D mate,
						      boolean doExchange);

    /**
     * ̗LȐƑ̗LȐ (Ȑ) ̊߂钊ۃ\bhB
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    abstract JgclCurveCurveInterference3D[] interfere(JgclCompositeCurve3D mate,
						      boolean doExchange);

    /**
     * ̗LȐ̊Jn_ԂB
     * <p>
     * Ȑ`̏ꍇ null ԂB
     * </p>
     *
     * @return	Jn_
     */
    public JgclPoint3D startPoint() {
	if (isPeriodic())
	    return null;

	try {
	    return coordinates(parameterDomain().section().start());
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();	// should not be occured
	}
    }

    /**
     * ̗LȐ̏I_ԂB
     * <p>
     * Ȑ`̏ꍇ null ԂB
     * </p>
     *
     * @return	I_
     */
    public JgclPoint3D endPoint() {
	if (isPeriodic())
	    return null;

	try {
	    return coordinates(parameterDomain().section().end());
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();	// should not be occured
	}
    }

    /**
     * ̗LȐ􉽓IɕĂ邩ۂԂB
     * <p>
     * Ȑ`ł true ԂB
     * </p>
     * <p>
     * ȐJ`ł΁AJn_ƏI_̓ꐫ𒲂ׂB
     * </p>
     *
     * @return	􉽓IɕĂ trueAłȂ false
     * @see	JgclPoint3D#identical(JgclPoint3D)
     */
    boolean getClosedFlag() {
	if (isPeriodic()) {
	    return true;
	} else {
	    return startPoint().identical(endPoint());
	}
    }
}

