/*
 * 񕪖؏̊Kw\\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclBinaryTree.java,v 1.14 2000/04/26 09:38:42 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 񕪖؏̊Kw\\NXB
 * <p>
 * ň񕪖؂́A
 *  (root) ƌĂ΂A̃m[hƂāA
 * em[hE̎qm[hƂłf[^\łB
 * </p>
 * <p>
 * 񕪖؏̃m[h́ÃNX̓NX
 * {@link JgclBinaryTree.Node JgclBinaryTree.Node}
 * ̃CX^XłB
 * ̃m[hɂ́Ãm[h́uf[^vƂāA
 * Cӂ̃IuWFNg () ֘AÂ邱ƂłB
 * </p>
 *
 * @version $Revision: 1.14 $, $Date: 2000/04/26 09:38:42 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclQuadTree
 */

class JgclBinaryTree {
    /**
     * root m[hB
     */
    private Node root;

    /**
     * ^ꂽIuWFNg root m[h́uf[^vƂ񕪖؂\zB
     *
     * @param data	root m[h́uf[^vƂIuWFNg
     */
    JgclBinaryTree(Object data) {
	super();
	root = new JgclBinaryTree.Node(null, data);
    }

    /**
     * ̓񕪖؂ root m[hԂB
     * 
     * @return	root m[h
     */
    Node rootNode() {
	return root;
    }

    /**
     * 񕪖؏̂̃m[h\ JgclBinaryTree ̓NXB
     * <p>
     * m[h͍E̎qm[hƂł (ȂĂ\Ȃ) B
     * </p>
     * <p>
     * ܂Am[hɂ́Ãm[h́uf[^vƂāA
     * Cӂ̃IuWFNg () ֘AÂ邱ƂłB
     * </p>
     * @see	JgclBinaryTree
     */
    class Node {
	/**
	 * ̃m[h́uf[^vƂĊ֘AtꂽIuWFNgB
	 */
	private final Object data;

	/**
	 * em[hB
	 */
	private final Node parent;

	/**
	 * ̎qm[hB
	 */
	private Node left;

	/**
	 * E̎qm[hB
	 */
	private Node right;

	/**
	 * ^ꂽIuWFNguf[^vƂm[h\zB
	 * <p>
	 * data  null ł\ȂB
	 * </p>
	 * <p>
	 * parent  null ł\ȂB
	 * </p>
	 *
	 * @param data	m[h́uf[^vƂIuWFNg
	 * @param parent	em[h
	 */
	Node(Node parent, Object data) {
	    super();
	    this.data = data;
	    this.parent = parent;
	}

	/**
	 * ̃m[h́uf[^vԂB
	 *
	 * @return	m[h́uf[^v
	 */
	Object data() {
	    return data;
	}

	/**
	 * ̃m[h̐em[hԂB
	 * <p>
	 * em[h null ł邩ȂB
	 * </p>
	 *
	 * @return	em[h
	 */
	Node parent() {
	    return parent;
	}

	/**
	 * ̃m[h̍̎qm[hԂB
	 * <p>
	 * ̎qm[h null ł邩ȂB
	 * </p>
	 *
	 * @return	̎qm[h
	 */
	synchronized Node left() {
	    return left;
	}

	/**
	 * ̃m[h̉E̎qm[hԂB
	 * <p>
	 * E̎qm[h null ł邩ȂB
	 * </p>
	 *
	 * @return	E̎qm[h
	 */
	synchronized Node right() {
	    return right;
	}

	/**
	 * ^ꂽm[hÃm[h̍̎qm[hƂĐݒ肷B
	 * <p>
	 * left  null ł\ȂB
	 * </p>
	 *
	 * @param left	̎qm[hƂĐݒ肷m[h
	 */
	synchronized void left(Node left) {
	    this.left = left;
	}

	/**
	 * ^ꂽm[hÃm[h̉E̎qm[hƂĐݒ肷B
	 * <p>
	 * right  null ł\ȂB
	 * </p>
	 *
	 * @param right	E̎qm[hƂĐݒ肷m[h
	 */
	synchronized void right(Node right) {
	    this.right = right;
	}

	/**
	 * ̃m[hɍ̎qm[hVɐB
	 * <p>
	 * ŗ^ꂽIuWFNgVɐ鍶̎qm[h́uf[^vƂȂB
	 * </p>
	 * <p>
	 * ̃m[hɂłɍ̎qm[hݒ肳Ăꍇɂ
	 * JgclFatal ̗O𔭐B
	 * </p>
	 * 
	 * @param data	Vɐm[h́uf[^v
	 * @return	̎qƂĐVɐm[h
	 * @see	JgclFatal
	 */
	synchronized Node makeLeft(Object data) {
	    if (left() != null)
		throw new JgclFatal();

	    left(new Node(this, data));
	    return left();
	}

	/**
	 * ̃m[hɉE̎qm[hVɐB
	 * <p>
	 * ŗ^ꂽIuWFNgVɐE̎qm[h́uf[^vƂȂB
	 * </p>
	 * <p>
	 * ̃m[hɂłɉE̎qm[hݒ肳Ăꍇɂ
	 * JgclFatal ̗O𔭐B
	 * </p>
	 * 
	 * @param data	Vɐm[h́uf[^v
	 * @return	E̎qƂĐVɐm[h
	 * @see	JgclFatal
	 */
	synchronized Node makeRight(Object data) {
	    if (right() != null)
		throw new JgclFatal();

	    right(new Node(this, data));
	    return right();
	}

	/**
	 * ̃m[h艺ɍL镔؂̊em[hɂāAw̏{B
	 * <p>
	 * ̃m[hg܂ޕ؂̊em[hɂ tproc.doit() ĂяoB
	 * m[hɂāAtproc.doit() ĂяoԂ́Au/̎q/E̎qvłB
	 * </p>
	 * <p>
	 * tproc.doit()  false ԂԁAtproc.doit() ̌Ăяo𑱂A
	 * ׂẴm[hɂĂ̌ĂяoI邩A
	 * ܂ tproc.doit()  true  Ԃ_ŏIB
	 * </p>
	 * <p>
	 * m[hɂ tproc.doit()  true Ԃꍇɂ́A
	 * ̃m[hԂB
	 * ̃m[hɑ΂ tproc.doit()  true ԂȂꍇɂ
	 * null ԂB
	 * </p>
	 *
	 * @param tproc {@link JgclBinaryTree.TraverseProc TraverseProc}
	 *		C^[tFCXNX̃CX^X
	 * @param pdata	tproc.doit() ̑Oɗ^Cӂ̃IuWFNg
	 * @return	tproc.doit()  true Ԃm[h
	 * @see	#preOrderEnumeration()
	 */
	synchronized Node preOrderTraverse(TraverseProc tproc, Object pdata) {
	    return myPreOrderTraverse(0, this, tproc, pdata);
	}

	/**
	 * ̃m[h艺ɍL镔؂̊em[hɂāAw̏{B
	 * <p>
	 * ̃m[hg܂ޕ؂̊em[hɂ tproc.doit() ĂяoB
	 * m[hɂāAtproc.doit() ĂяoԂ́Au̎q//E̎qvłB
	 * </p>
	 * <p>
	 * tproc.doit()  false ԂԁAtproc.doit() ̌Ăяo𑱂A
	 * ׂẴm[hɂĂ̌ĂяoI邩A
	 * ܂ tproc.doit()  true  Ԃ_ŏIB
	 * </p>
	 * <p>
	 * m[hɂ tproc.doit()  true Ԃꍇɂ́A
	 * ̃m[hԂB
	 * ̃m[hɑ΂ tproc.doit()  true ԂȂꍇɂ
	 * null ԂB
	 * </p>
	 *
	 * @param tproc {@link JgclBinaryTree.TraverseProc TraverseProc}
	 *		C^[tFCXNX̃CX^X
	 * @param pdata	tproc.doit() ̑Oɗ^Cӂ̃IuWFNg
	 * @return	tproc.doit()  true Ԃm[h
	 * @see	#inOrderEnumeration()
	 */
	synchronized Node inOrderTraverse(TraverseProc tproc, Object pdata) {
	    return myInOrderTraverse(0, this, tproc, pdata);
	}

	/**
	 * ̃m[h艺ɍL镔؂̊em[hɂāAw̏{B
	 * <p>
	 * ̃m[hg܂ޕ؂̊em[hɂ tproc.doit() ĂяoB
	 * m[hɂāAtproc.doit() ĂяoԂ́Au̎q/E̎q/vłB
	 * </p>
	 * <p>
	 * tproc.doit()  false ԂԁAtproc.doit() ̌Ăяo𑱂A
	 * ׂẴm[hɂĂ̌ĂяoI邩A
	 * ܂ tproc.doit()  true  Ԃ_ŏIB
	 * </p>
	 * <p>
	 * m[hɂ tproc.doit()  true Ԃꍇɂ́A
	 * ̃m[hԂB
	 * ̃m[hɑ΂ tproc.doit()  true ԂȂꍇɂ
	 * null ԂB
	 * </p>
	 *
	 * @param tproc {@link JgclBinaryTree.TraverseProc TraverseProc}
	 *		C^[tFCXNX̃CX^X
	 * @param pdata	tproc.doit() ̑Oɗ^Cӂ̃IuWFNg
	 * @return	tproc.doit()  true Ԃm[h
	 * @see	#postOrderEnumeration()
	 */
	synchronized Node postOrderTraverse(TraverseProc tproc, Object pdata) {
	    return myPostOrderTraverse(0, this, tproc, pdata);
	}

	/**
	 * {@link #preOrderTraverse(JgclBinaryTree.TraverseProc, Object) preOrderTraverse()} ̖{́B
	 *
	 * @param ctl	Jnm[h̐[
	 * @param node	ΏۂƂȂm[h
	 * @param tproc {@link JgclBinaryTree.TraverseProc TraverseProc}
	 *		C^[tFCXNX̃CX^X
	 * @param pdata	tproc.doit() ̑Oɗ^Cӂ̃IuWFNg
	 */
	private Node myPreOrderTraverse(int ctl,
					Node node,
					TraverseProc tproc,
					Object pdata) {
	    boolean rvalh;
	    Node leftVal = null;
	    Node rightVal = null;

	    if (node == null) return null;

	    if (((rvalh = tproc.doit(node, ctl, pdata)) == true) ||
		((leftVal = myPreOrderTraverse(ctl + 1, node.left(), tproc, pdata)) != null) ||
		((rightVal = myPreOrderTraverse(ctl + 1, node.right(), tproc, pdata)) !=  null)) {
		if (rvalh == true)
		    return node;
		if (leftVal != null)
		    return leftVal;
		return rightVal;
	    }

	    return null;
	}

	/**
	 * {@link #inOrderTraverse(JgclBinaryTree.TraverseProc, Object) inOrderTraverse()} ̖{́B
	 *
	 * @param ctl	Jnm[h̐[
	 * @param node	ΏۂƂȂm[h
	 * @param tproc {@link JgclBinaryTree.TraverseProc TraverseProc}
	 *		C^[tFCXNX̃CX^X
	 * @param pdata	tproc.doit() ̑Oɗ^Cӂ̃IuWFNg
	 */
	private Node myInOrderTraverse(int ctl, Node node,
				       TraverseProc tproc,
				       Object pdata) {
	    boolean rvalh = false;
	    Node leftVal;
	    Node rightVal = null;

	    if (node == null) return null;

	    if (((leftVal = myInOrderTraverse(ctl + 1, node.left(), tproc, pdata)) != null) ||
		((rvalh = tproc.doit(node, ctl, pdata)) == true) ||
		((rightVal = myInOrderTraverse(ctl + 1, node.right(), tproc, pdata)) != null)) {
		if (leftVal != null)
		    return leftVal;
		if (rvalh == true)
		    return node;
		return rightVal;
	    }

	    return null;
	}

	/**
	 * {@link #postOrderTraverse(JgclBinaryTree.TraverseProc, Object) postOrderTraverse()} ̖{́B
	 *
	 * @param ctl	Jnm[h̐[
	 * @param node	ΏۂƂȂm[h
	 * @param tproc {@link JgclBinaryTree.TraverseProc TraverseProc}
	 *		C^[tFCXNX̃CX^X
	 * @param pdata	tproc.doit() ̑Oɗ^Cӂ̃IuWFNg
	 */
	private Node myPostOrderTraverse(int ctl, Node node,
					 TraverseProc tproc,
					 Object pdata) {
	    boolean rvalh;
	    Node leftVal;
	    Node rightVal = null;

	    if (node == null) return null;

	    if (((leftVal = myPostOrderTraverse(ctl + 1, node.left(), tproc, pdata)) != null) ||
		((rightVal = myPostOrderTraverse(ctl + 1, node.right(), tproc, pdata)) != null) ||
		((rvalh = tproc.doit(node, ctl, pdata)) == true)) {
		if (leftVal != null)
		    return leftVal;
		if (rightVal != null)
		    return rightVal;
		return node;
	    }

	    return null;
	}

	/**
	 * ̃m[h艺ɍL镔 (̃m[h)  Enumeration ƂĕԂB
	 * <p>
	 * ̃m[hg܂ޕ؂ Enumeration ƂĕԂB
	 * m[hi[鏇́Am[hɂāu/̎q/E̎qvłB
	 * </p>
	 * <p>
	 * ̃\bȟʂƂē Enumeration  nextElement() ԂIuWFNǵA
	 * JgclBinaryTree.Node ̃CX^XłB
	 * </p>
	 *
	 * @return	؂ Enumeration
	 * @see	#preOrderTraverse(JgclBinaryTree.TraverseProc, Object)
	 */
	synchronized Enumeration preOrderEnumeration() {
	    Vector nodes = new Vector();

	    preOrderTraverse(new addNodeProc(), nodes);

	    return nodes.elements();
	}

	/**
	 * ̃m[h艺ɍL镔 (̃m[h)  Enumeration ƂĕԂB
	 * <p>
	 * ̃m[hg܂ޕ؂ Enumeration ƂĕԂB
	 * m[hi[鏇́Am[hɂāu̎q//E̎qvłB
	 * </p>
	 * <p>
	 * ̃\bȟʂƂē Enumeration  nextElement() ԂIuWFNǵA
	 * JgclBinaryTree.Node ̃CX^XłB
	 * </p>
	 *
	 * @return	؂ Enumeration
	 * @see	#inOrderTraverse(JgclBinaryTree.TraverseProc, Object)
	 */
	synchronized Enumeration inOrderEnumeration() {
	    Vector nodes = new Vector();

	    inOrderTraverse(new addNodeProc(), nodes);

	    return nodes.elements();
	}

	/**
	 * ̃m[h艺ɍL镔 (̃m[h)  Enumeration ƂĕԂB
	 * <p>
	 * ̃m[hg܂ޕ؂ Enumeration ƂĕԂB
	 * m[hi[鏇́Am[hɂāu̎q/E̎q/vłB
	 * </p>
	 * <p>
	 * ̃\bȟʂƂē Enumeration  nextElement() ԂIuWFNǵA
	 * JgclBinaryTree.Node ̃CX^XłB
	 * </p>
	 *
	 * @return	؂ Enumeration
	 * @see	#postOrderTraverse(JgclBinaryTree.TraverseProc, Object)
	 */
	synchronized Enumeration postOrderEnumeration() {
	    Vector nodes = new Vector();

	    postOrderTraverse(new addNodeProc(), nodes);

	    return nodes.elements();
	}
    }

    /**
     * 񕪖؏̂m[hɂĎ{
     * Cӂ̑ () \ JgclBinaryTree ̓C^[tF[XB
     *
     * @see JgclBinaryTree.Node#preOrderTraverse(JgclBinaryTree.TraverseProc, Object)
     * @see JgclBinaryTree.Node#inOrderTraverse(JgclBinaryTree.TraverseProc, Object)
     * @see JgclBinaryTree.Node#postOrderTraverse(JgclBinaryTree.TraverseProc, Object)
     */
    interface TraverseProc {
	/**
	 * @param node	ΏۂƂȂm[h
	 * @param ctl	Jnm[h node ܂ł̐[ (㐔AJnm[h 0 Ƃ)
	 * @param pdata	[U̎w肵Cӂ̃IuWFNg
	 * @return	̃m[hɏ𑱂Ȃ trueÃm[hŏIȂ false
	 */
	public boolean doit(Node node,
			    int ctl,
			    Object pdata);
    }

    /**
     * m[h^ꂽXgɒǉ TraverseProcB
     */
    private class addNodeProc implements TraverseProc {
	/**
	 * ^ꂽXgɃm[hǉB
	 * <p>
	 * pdata  Vector NX̃CX^XłȂ΂ȂȂB
	 * </p>
	 *
	 * @param node	pdata ɒǉm[h
	 * @param ctl	Jnm[h node ܂ł̐[ (QƂȂ)
	 * @param pdata	Xg
	 * @return	 false
	 */
	public boolean doit(Node node, int ctl, Object pdata) {
	    Vector nodes = (Vector)pdata;

	    nodes.addElement(node);

	    return false;
	}
    }

    /**
     * m[hw̃m[hł邩ۂ`FbN TraverseProcB
     */
    private class checkNode implements TraverseProc {
	/**
	 * m[hw̃m[hł邩ۂ`FbNB
	 * <p>
	 * pdata  JgclBinaryTree.Node NX̃CX^XłȂ΂ȂȂB
	 * </p>
	 *
	 * @param node	pdata Ɣrm[h
	 * @param ctl	Jnm[h node ܂ł̐[ (QƂȂ)
	 * @param pdata	w̃m[h
	 * @return	node  pdata ł trueAłȂ false
	 */
	public boolean doit(Node node, int ctl, Object pdata) {
	    Node givenNode = (Node)pdata;

	    if (node == givenNode) {
		return true;
	    }
	    return false;
	}
    }
}
