/*
 * R : _̍WƂyтww肷Œ`ꂽǏWn (zu) \NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclAxis2Placement3D.java,v 1.31 2000/04/26 09:38:41 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : _̍WƂyтww肷Œ`ꂽǏWn (zu) \NXB
 * <p>
 * ̃NX́A
 * ~Ȑ񎟋Ȗʂ̈ʒuXA
 * Wϊ̕ϊs̎wȂǂɗp܂B
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * ǏWň_ƂȂ_ location
 * ƁA
 * ǏWn̂y̕xNg axis
 * 
 * axis @Ƃ镽ʂɐe邱Ƃ
 * w̕肷xNg refDirection
 * ێ܂B
 * ̋ǏWńAEn̒Wn\̂ŁA
 * x́̕Ay^w̕莩IɌ肳܂B
 * yƂẘOϕx̕ɂȂ܂B
 * wxẙexNǵAɂ̑傫 1 ɒPʉĈ܂B
 * ȂÃxNg
 * {@link JgclGeometrySchemaFunction#buildAxes(JgclVector3D, JgclVector3D)
 * JgclGeometrySchemaFunction.buildAxes}(axis, refDirection)
 * ɂċ߂Ă܂B
 * </p>
 * <p>
 * location ɗ^_ɂ͓ɐ͂ȂA
 * {@link JgclPoint3D JgclPoint3D} NX̔Cӂ̓_^邱Ƃł܂A
 * null w肷邱Ƃ͂ł܂B
 * axis  refDirection ɗ^xNg {@link JgclVector3D JgclVector3D}
 * ͓ɒPʉĂKv͂܂񂪁A
 * [xNg^邱Ƃ͂ł܂B
 * ȂAaxis  refDirection ɗ^xNg
 * w肵Ȃ (null w肷) Ƃł܂B
 * axis  null ƂƁAy̕ (0, 0, 1) ɓ̂Ɖ߂܂B
 * refDirection  null ƂƁA
 * refDirection ̕ (1, 0, 0) ɓ̂Ɖ߂܂B
 * </p>
 * <p>
 * ܂Aaxis  refDirection ́At܂߂āA
 * ̕wĂ͂܂B
 * </p>
 *
 * @version $Revision: 1.31 $, $Date: 2000/04/26 09:38:41 $
 * @author Information-technology Promotion Agency, Japan
 * @see JgclAxis1Placement3D
 * @see JgclAxis2Placement2D
 */

public class JgclAxis2Placement3D extends JgclPlacement3D {
    /**
     * WnB
     * <p>
     * (0, 0, 0) _A
     * (0, 0, 1)  Z ̕A
     * (1, 0, 0)  X ̕ƂWnB
     * </p>
     */
    public static final JgclAxis2Placement3D origin;

    /**
     * static ȃtB[hɒlݒ肷B
     */
    static {
	origin = new JgclAxis2Placement3D(JgclPoint3D.origin,
					  JgclVector3D.zUnitVector,
					  JgclVector3D.xUnitVector);
    }

    /**
     * y̕\xNgB
     * @serial
     */
    private final JgclVector3D axis;

    /**
     * w̕肷xNgB
     * @serial
     */
    private final JgclVector3D refDirection;

    /**
     * w/x/y\PʃxNgB
     * <p>
     * KvɉăLbVB
     * </p>
     * @serial
     */
    private JgclVector3D[] axes;

    /**
     * ǏWň_ƂȂ_
     * y̕xNg
     * w̕肷xNg^āA
     * IuWFNg\zB
     * <p>
     * location  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * axis  null ł\ȂB
     * axis  null ̏ꍇɂ́A
     * y̕ (0, 0, 1) ɓ̂Ɖ߂B
     * </p>
     * <p>
     * refDirection  null ł\ȂB
     * refDirection  null ̏ꍇɂ́A
     * refDirection ̕ (1, 0, 0) ɓ̂Ɖ߂B
     * </p>
     * <p>
     * axis 邢 refDirection ̑傫A
     * ݐݒ肳Ă鉉Z̋̋e덷ȉ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * ɁAaxis  refDirection ̊Oς̑傫
     * ݐݒ肳Ă鉉Z̋̋e덷ȉ̏ꍇɂA
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param location		ǏWň_
     * @param axis		y̕xNg
     * @param refDirection	w̕肷xNg
     * @see	JgclConditionOfOperation
     * @see	JgclInvalidArgumentValue
     */
    public JgclAxis2Placement3D(JgclPoint3D location,
				JgclVector3D axis,
				JgclVector3D refDirection)
    {
	super(location);
	this.axis = axis;
	this.refDirection = refDirection;
	checkFields();
    }

    /**
     * y̕xNgA
     * w̕肷xNg̑Ó`FbNB
     * <p>
     * axis  null ł\ȂB
     * axis  null ̏ꍇɂ́A
     * y̕ (0, 0, 1) ɓ̂Ɖ߂B
     * </p>
     * <p>
     * refDirection  null ł\ȂB
     * refDirection  null ̏ꍇɂ́A
     * refDirection ̕ (1, 0, 0) ɓ̂Ɖ߂B
     * </p>
     * <p>
     * axis 邢 refDirection ̑傫A
     * ݐݒ肳Ă鉉Z̋̋e덷ȉ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * ɁAaxis  refDirection ̊Oς̑傫
     * ݐݒ肳Ă鉉Z̋̋e덷ȉ̏ꍇɂA
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @see	JgclConditionOfOperation
     * @see	JgclInvalidArgumentValue
     */
    private void checkFields()
    {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double tol_2d = condition.getToleranceForDistance();

	tol_2d *= tol_2d;

	if (axis != null) {
	    if (axis.norm() <= tol_2d) {
		throw new JgclInvalidArgumentValue();
	    }
	}

	if (refDirection != null) {
	    if (refDirection.norm() <= tol_2d) {
		throw new JgclInvalidArgumentValue();
	    }
	}

	if (axis != null || refDirection != null) {
	    JgclVector3D a, b;
	    if (axis == null) {
		a = JgclVector3D.zUnitVector;
	    } else {
		a = axis;
	    }
	    if (refDirection == null) {
		b = JgclVector3D.xUnitVector;
	    } else {
		b = refDirection;
	    }
	    if (true) {
		/* see p30 of ISO10303-42 */
		JgclVector3D c;
		c = a.crossProduct(b);
		if (c.norm() <= tol_2d) {
		    throw new JgclInvalidArgumentValue();
		}
	    } else {
		if (a.identicalDirection(b)) {
		    throw new JgclInvalidArgumentValue();
		}
	    }
	}
    }

    /**
     * ̋ǏWn̂y̕\xNgԂB
     * <p>
     * IuWFNg̍\zɗ^ꂽ axis ԂB
     * āAnull Ԃ邱Ƃ肤B
     * </p>
     *
     * @return	y̕\xNg
     */
    public JgclVector3D axis() {
	return axis;
    }

    /**
     * ̋ǏWn̂y̕\ (I) xNgԂB
     * <p>
     * axis  null łȂ΁Aaxis ԂB
     * axis  null Ȃ΁A(0, 0, 1) ̃xNgԂB
     * </p>
     *
     * @return	y̕\ (I) xNg
     */
    public JgclVector3D effectiveAxis() {
	return (axis != null)
	    ? axis : JgclGeometrySchemaFunction.defaultAxis3D;
    }

    /**
     * ̋ǏWn̂w̕肷xNgԂB
     * <p>
     * IuWFNg̍\zɗ^ꂽ refDirection ԂB
     * āAnull Ԃ邱Ƃ肤B
     * </p>
     *
     * @return	w̕肷xNg
     */
    public JgclVector3D refDirection() {
	return refDirection;
    }

    /**
     * ̋ǏWn̂w̕肷 (I) xNgԂB
     * <p>
     * refDirection  null łȂ΁ArefDirection ԂB
     * refDirection  null Ȃ΁A(1, 0, 0) ̃xNgԂB
     * </p>
     *
     * @return	w̕肷 (I) xNg
     */
    public JgclVector3D effectiveRefDirection() {
	return (refDirection != null)
	    ? refDirection : JgclGeometrySchemaFunction.defaultRefDirection3D;
    }

    /**
     * ̋ǏWn̂w\PʃxNgԂB
     *
     * @return	w\PʃxNg
     */
    public JgclVector3D x() {
	if (axes == null)
	    axes();
	return axes[0];
    }

    /**
     * ̋ǏWn̂x\PʃxNgԂB
     *
     * @return	x\PʃxNg
     */
    public JgclVector3D y() {
	if (axes == null)
	    axes();
	return axes[1];
    }

    /**
     * ̋ǏWn̂y\PʃxNgԂB
     *
     * @return	y\PʃxNg
     */
    public JgclVector3D z() {
	if (axes == null)
	    axes();
	return axes[2];
    }

    /**
     * ̋ǏWn̂w/x/y\PʃxNgԂB
     * <p>
     * ʂƂĕԂz̍ŏ̗vfwA
     * Ԗڂ̗vfxA
     * OԖڂ̗vfy\B
     * </p>
     *
     * @return	w/x/y\PʃxNg̔z
     * @see	JgclGeometrySchemaFunction#buildAxes(JgclVector3D, JgclVector3D)
     */
    public JgclVector3D[] axes() {
	if (axes == null) {
	    axes = JgclGeometrySchemaFunction.buildAxes(axis, refDirection);
	}
	return (JgclVector3D[])axes.clone();
    }

    /**
     * ̋ǏWň_ƂȂ_A^ꂽxNgɏ]
     * sړǏWnԂB
     *
     * @param moveVec	sړƗʂw肷xNg
     * @return		sړ̋ǏWn
     */
    public JgclAxis2Placement3D parallelTranslate(JgclVector3D moveVec) {
	return new JgclAxis2Placement3D(location().add(moveVec), axis, refDirection);
    }

    /**
     * ̋ǏWnA
     * ^ꂽǏWn̂y̎ɁA
     * ^ꂽpx]ǏWnԂB
     * <p>
     * ĂяóA(rCos * rCos + rSin * rSin) ̒l 1 ł邱Ƃ
     * ۏ؂Ȃ΂ȂȂB
     * </p>
     *
     * @param trns	]̎^ǏWnWϊZq
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̋ǏWn
     * @see	JgclPoint3D#rotateZ(JgclCartesianTransformationOperator3D, double, double)
     * @see	JgclVector3D#rotateZ(JgclCartesianTransformationOperator3D, double, double)
     */
    JgclAxis2Placement3D rotateZ(JgclCartesianTransformationOperator3D trns,
				 double rCos, double rSin) {
	JgclPoint3D rloc = location().rotateZ(trns, rCos, rSin);
	JgclVector3D raxis = z().rotateZ(trns, rCos, rSin);
	JgclVector3D rref = x().rotateZ(trns, rCos, rSin);
	return new JgclAxis2Placement3D(rloc, raxis, rref);
    }

    /**
     * ̋ǏWnIȍWnւ̍WϊZqԂB
     *
     * @param scale	XP[O̗ʂK肷l
     * @return	XP[O܂ލWϊZq
     * @see	#toCartesianTransformationOperator()
     */
    public JgclCartesianTransformationOperator3D
    toCartesianTransformationOperator(double scale) {
	return new JgclCartesianTransformationOperator3D(this, scale);
    }

    /**
     * ̋ǏWnIȍWnւ̍WϊZq (kڔ 1 : 1) ԂB
     *
     * @return	XP[O܂܂ȂWϊZq
     * @see	#toCartesianTransformationOperator(double)
     */
    public JgclCartesianTransformationOperator3D
    toCartesianTransformationOperator() {
	return new JgclCartesianTransformationOperator3D(this);
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclAxis2Placement3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint3D tLocation =
	    this.location().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	JgclVector3D tAxis =
	    this.effectiveAxis().transformBy(reverseTransform,
					     transformationOperator,
					     transformedGeometries);
	JgclVector3D tRefDirection =
	    this.effectiveRefDirection().transformBy(reverseTransform,
						     transformationOperator,
						     transformedGeometries);
	return new JgclAxis2Placement3D(tLocation, tAxis, tRefDirection);
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclAxis2Placement3D
    transformBy(boolean reverseTransform,
		JgclCartesianTransformationOperator3D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	if (transformedGeometries == null)
	    return this.doTransformBy(reverseTransform,
				      transformationOperator,
				      transformedGeometries);

	JgclAxis2Placement3D transformed = (JgclAxis2Placement3D)transformedGeometries.get(this);
	if (transformed == null) {
	    transformed = this.doTransformBy(reverseTransform,
					     transformationOperator,
					     transformedGeometries);
	    transformedGeometries.put(this, transformed);
	}
	return transformed;
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclAxis2Placement3D
    transformBy(JgclCartesianTransformationOperator3D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(false,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̊􉽗vf
     */
    public synchronized JgclAxis2Placement3D
    reverseTransformBy(JgclCartesianTransformationOperator3D transformationOperator,
		       java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(true,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tlocation");
        location().output(writer, indent + 2);
	if (axis != null) {
	    writer.println(indent_tab + "\taxis");
	    axis.output(writer, indent + 2);
	}
	if (refDirection != null) {
	    writer.println(indent_tab + "\trefDirection");
	    refDirection.output(writer, indent + 2);
	}
        writer.println(indent_tab + "End");
    }
}

