/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBoundedLine2D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFilletObject2D;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclOfst2D;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterConversion2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmingPreference;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclWhichSide;

public class JgclTrimmedCurve2D
extends JgclBoundedCurve2D {
    private JgclParametricCurve2D basisCurve;
    private JgclPoint2D tPnt1;
    private JgclPoint2D tPnt2;
    private double tParam1;
    private double tParam2;
    private int masterRepresentation1;
    private int masterRepresentation2;
    private boolean senseAgreement;

    private double checkParamValidity(double param) {
        if (this.basisCurve.isPeriodic()) {
            JgclParameterDomain domain = this.basisCurve.parameterDomain();
            return domain.wrap(param);
        }
        this.basisCurve.checkValidity(param);
        return param;
    }

    private void checkPointValidity(JgclPoint2D pnt, double param) {
        if (pnt != null && !this.basisCurve.coordinates(param).identical(pnt)) {
            throw new JgclInvalidArgumentValue();
        }
    }

    private void setParams(JgclParametricCurve2D basisCurve, JgclPoint2D tPnt1, JgclPoint2D tPnt2, double tParam1, double tParam2, int masterRepresentation1, int masterRepresentation2, boolean senseAgreement) {
        this.basisCurve = basisCurve;
        this.tParam1 = tParam1 = this.checkParamValidity(tParam1);
        this.tParam2 = tParam2 = this.checkParamValidity(tParam2);
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double pTol = condition.getToleranceForParameter();
        if (Math.abs(tParam2 - tParam1) < pTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.checkPointValidity(tPnt1, tParam1);
        this.tPnt1 = tPnt1;
        this.checkPointValidity(tPnt2, tParam2);
        this.tPnt2 = tPnt2;
        this.masterRepresentation1 = masterRepresentation1;
        this.masterRepresentation2 = masterRepresentation2;
        if (basisCurve.isPeriodic()) {
            JgclParameterSection sec = basisCurve.parameterDomain().section();
            if (senseAgreement) {
                if (tParam1 > tParam2) {
                    this.tParam2 = tParam2 += sec.increase();
                }
            } else if (tParam1 < tParam2) {
                this.tParam1 = tParam1 += sec.increase();
            }
        } else if (senseAgreement ? tParam1 > tParam2 : tParam1 < tParam2) {
            throw new JgclInvalidArgumentValue();
        }
        this.senseAgreement = senseAgreement;
    }

    JgclTrimmedCurve2D(JgclParametricCurve2D basisCurve, JgclPoint2D tPnt1, JgclPoint2D tPnt2, double tParam1, double tParam2, int masterRepresentation1, int masterRepresentation2, boolean senseAgreement) {
        this.setParams(basisCurve, tPnt1, tPnt2, tParam1, tParam2, masterRepresentation1, masterRepresentation2, senseAgreement);
    }

    public JgclTrimmedCurve2D(JgclParametricCurve2D basisCurve, JgclPoint2D tPnt1, JgclPoint2D tPnt2, boolean senseAgreement) {
        this.setParams(basisCurve, tPnt1, tPnt2, basisCurve.pointToParameter(tPnt1), basisCurve.pointToParameter(tPnt2), 0, 0, senseAgreement);
    }

    public JgclTrimmedCurve2D(JgclParametricCurve2D basisCurve, double tParam1, double tParam2, boolean senseAgreement) {
        this.setParams(basisCurve, basisCurve.coordinates(tParam1), basisCurve.coordinates(tParam2), tParam1, tParam2, 1, 1, senseAgreement);
    }

    public JgclTrimmedCurve2D(JgclParametricCurve2D basisCurve, JgclParameterSection pint) {
        this.setParams(basisCurve, null, null, pint.start(), pint.end(), 1, 1, pint.increase() > 0.0);
    }

    public JgclParametricCurve2D basisCurve() {
        return this.basisCurve;
    }

    public JgclPoint2D tPnt1() {
        return this.tPnt1;
    }

    public JgclPoint2D tPnt2() {
        return this.tPnt2;
    }

    public double tParam1() {
        return this.tParam1;
    }

    public double tParam2() {
        return this.tParam2;
    }

    public int masterRepresentation1() {
        return this.masterRepresentation1;
    }

    public int masterRepresentation2() {
        return this.masterRepresentation2;
    }

    public boolean senseAgreement() {
        return this.senseAgreement;
    }

    public double toBasisParameter(double param) {
        this.checkValidity(param);
        if (this.senseAgreement) {
            return param + this.tParam1;
        }
        return this.tParam1 - param;
    }

    public JgclParameterSection toBasisParameter(JgclParameterSection pint) {
        double start = this.toBasisParameter(pint.start());
        double end = this.toBasisParameter(pint.end());
        return new JgclParameterSection(start, end - start);
    }

    /*
     * Unable to fully structure code
     */
    public double toOwnParameter(double param) {
        block8: {
            if (!this.basisCurve.isPeriodic()) break block8;
            absInc = this.basisCurve.parameterDomain().section().absIncrease();
            if (!this.senseAgreement) ** GOTO lbl14
            while (param < this.tParam1) {
                param += absInc;
            }
            while (this.tParam2 < param) {
                param -= absInc;
            }
            if (!(param < this.tParam1) || !(this.tParam1 - param > param + absInc - this.tParam2)) break block8;
            param += absInc;
            break block8;
lbl-1000:
            // 1 sources

            {
                param += absInc;
lbl14:
                // 2 sources

                ** while (param < this.tParam2)
            }
lbl15:
            // 2 sources

            while (this.tParam1 < param) {
                param -= absInc;
            }
            if (param < this.tParam2 && this.tParam2 - param > param + absInc - this.tParam1) {
                param += absInc;
            }
        }
        return this.senseAgreement != false ? param - this.tParam1 : this.tParam1 - param;
    }

    public double length(JgclParameterSection pint) {
        return this.basisCurve.length(this.toBasisParameter(pint));
    }

    public JgclPoint2D coordinates(double param) {
        return this.basisCurve.coordinates(this.toBasisParameter(param));
    }

    public JgclVector2D tangentVector(double param) {
        JgclVector2D tang = this.basisCurve.tangentVector(this.toBasisParameter(param));
        if (this.senseAgreement) {
            return tang;
        }
        return tang.multiply(-1.0);
    }

    public JgclCurveCurvature2D curvature(double param) {
        return this.basisCurve.curvature(this.toBasisParameter(param));
    }

    public JgclCurveDerivative2D evaluation(double param) {
        JgclCurveDerivative2D curv = this.basisCurve.evaluation(this.toBasisParameter(param));
        if (this.senseAgreement) {
            return curv;
        }
        JgclCurveDerivative2D rcurv = new JgclCurveDerivative2D(curv.d0D(), curv.d1D().multiply(-1.0), curv.d2D());
        return rcurv;
    }

    private double forceComputedParameter(double param) {
        switch (this.parameterValidity(param)) {
            case 3: {
                param = Double.NaN;
                break;
            }
            case 1: {
                param = this.parameterDomain().section().lower();
                break;
            }
            case 2: {
                param = this.parameterDomain().section().upper();
                break;
            }
        }
        return param;
    }

    public JgclPointOnCurve2D[] singular() throws JgclIndefiniteSolution {
        Vector<JgclPointOnCurve2D> singularVec = new Vector<JgclPointOnCurve2D>();
        JgclPointOnCurve2D[] singular = this.basisCurve.singular();
        JgclParameterDomain domain = this.parameterDomain();
        int i = 0;
        while (i < singular.length) {
            double param = this.toOwnParameter(singular[i].parameter());
            if (!Double.isNaN(param = this.forceComputedParameter(param))) {
                try {
                    singularVec.addElement(new JgclPointOnCurve2D(this, param, false));
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
            }
            ++i;
        }
        Object[] thisSingular = new JgclPointOnCurve2D[singularVec.size()];
        singularVec.copyInto(thisSingular);
        return thisSingular;
    }

    public JgclPointOnCurve2D[] inflexion() throws JgclIndefiniteSolution {
        Vector<JgclPointOnCurve2D> inflexionVec = new Vector<JgclPointOnCurve2D>();
        JgclPointOnCurve2D[] inflexion = this.basisCurve.inflexion();
        JgclParameterDomain domain = this.parameterDomain();
        int i = 0;
        while (i < inflexion.length) {
            double param = this.toOwnParameter(inflexion[i].parameter());
            if (!Double.isNaN(param = this.forceComputedParameter(param))) {
                try {
                    inflexionVec.addElement(new JgclPointOnCurve2D(this, param, false));
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
            }
            ++i;
        }
        Object[] thisInflexion = new JgclPointOnCurve2D[inflexionVec.size()];
        inflexionVec.copyInto(thisInflexion);
        return thisInflexion;
    }

    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) throws JgclIndefiniteSolution {
        Vector<JgclPointOnCurve2D> projvec = new Vector<JgclPointOnCurve2D>();
        JgclPointOnCurve2D[] proj = this.basisCurve.projectFrom(point);
        JgclParameterDomain domain = this.parameterDomain();
        int i = 0;
        while (i < proj.length) {
            double param = this.toOwnParameter(proj[i].parameter());
            if (!Double.isNaN(param = this.forceComputedParameter(param))) {
                JgclPointOnCurve2D proj2;
                try {
                    proj2 = new JgclPointOnCurve2D(this, param, false);
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
                projvec.addElement(proj2);
            }
            ++i;
        }
        Object[] prj = new JgclPointOnCurve2D[projvec.size()];
        projvec.copyInto(prj);
        return prj;
    }

    public JgclPolyline2D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        JgclPolyline2D pl = this.basisCurve.toPolyline(this.toBasisParameter(pint), tol);
        JgclPoint2D[] pnts = new JgclPoint2D[pl.nPoints()];
        int i = 0;
        while (i < pnts.length) {
            JgclPointOnCurve2D p = (JgclPointOnCurve2D)pl.pointAt(i);
            pnts[i] = new JgclPointOnCurve2D(this, this.toOwnParameter(p.parameter()), false);
            ++i;
        }
        return new JgclPolyline2D(pnts);
    }

    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
        return this.basisCurve.toBsplineCurve(this.toBasisParameter(pint));
    }

    private JgclIntersectionPoint2D[] doIntersect(JgclParametricCurve2D mate, boolean doExchange) {
        JgclIntersectionPoint2D[] ints;
        Vector<JgclIntersectionPoint2D> intsvec = new Vector<JgclIntersectionPoint2D>();
        try {
            ints = this.basisCurve.intersect(mate);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            ints = new JgclIntersectionPoint2D[]{};
        }
        JgclParameterDomain domain = this.parameterDomain();
        int i = 0;
        while (i < ints.length) {
            double param = this.toOwnParameter(ints[i].pointOnCurve1().parameter());
            if (!Double.isNaN(param = this.forceComputedParameter(param))) {
                JgclPointOnCurve2D pnts = new JgclPointOnCurve2D(this, param, false);
                JgclIntersectionPoint2D ints2 = new JgclIntersectionPoint2D(pnts, ints[i].pointOnCurve2(), false);
                intsvec.addElement(ints2);
            }
            ++i;
        }
        Object[] xints = new JgclIntersectionPoint2D[intsvec.size()];
        intsvec.copyInto(xints);
        if (doExchange) {
            int i2 = 0;
            while (i2 < xints.length) {
                xints[i2] = ((JgclIntersectionPoint2D)xints[i2]).exchange();
                ++i2;
            }
        }
        return xints;
    }

    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
        return this.doIntersect(mate, false);
    }

    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
        return this.interfere(mate, false);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate, boolean doExchange) {
        JgclParameterConversion2D conv;
        JgclBoundedCurve2D bcurve;
        JgclCurveCurveInterferenceList intfList = new JgclCurveCurveInterferenceList(this, mate);
        JgclParameterDomain domain = this.parameterDomain();
        JgclParameterSection sec = new JgclParameterSection(this.tParam1, this.tParam2 - this.tParam1);
        if (this.basisCurve instanceof JgclBoundedCurve2D) {
            bcurve = (JgclBoundedCurve2D)this.basisCurve;
            conv = new ToTrimConversion(this);
        } else {
            bcurve = this.basisCurve.toBsplineCurve(sec);
            conv = new BsplineConversion(this, bcurve);
        }
        JgclCurveCurveInterference2D[] intf = !doExchange ? bcurve.interfere(mate) : mate.interfere(bcurve);
        Vector<JgclCurveCurveInterference2D> vec = new Vector<JgclCurveCurveInterference2D>();
        int i = 0;
        while (i < intf.length) {
            JgclCurveCurveInterference2D trimintf = !doExchange ? intf[i].trim1(sec, conv) : intf[i].trim2(sec, conv);
            if (trimintf != null) {
                vec.addElement(trimintf);
            }
            ++i;
        }
        Object[] interf = new JgclCurveCurveInterference2D[vec.size()];
        vec.copyInto(interf);
        return interf;
    }

    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst2D doObj = new JgclOfst2D(this, pint, magni, side, tol);
        return doObj.offset();
    }

    public JgclBoundedCurve2D offsetByBoundedCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclParameterSection basisPint = this.toBasisParameter(pint);
        int basisSide = this.senseAgreement() ? side : JgclWhichSide.reverse(side);
        return this.basisCurve().offsetByBoundedCurve(basisPint, magni, basisSide, tol);
    }

    JgclFilletObject2D[] doFillet(JgclParameterSection pint1, int side1, JgclParametricCurve2D mate, JgclParameterSection pint2, int side2, double radius, boolean doExchange) throws JgclIndefiniteSolution {
        JgclFilletObject2D[] flts;
        Vector intsvec = new Vector();
        try {
            flts = this.basisCurve.fillet(this.toBasisParameter(pint1), side1, mate, pint2, side2, radius);
        }
        catch (JgclIndefiniteSolution e) {
            flts = new JgclFilletObject2D[]{(JgclFilletObject2D)e.suitable()};
        }
        JgclParameterDomain domain = this.parameterDomain();
        int i = 0;
        while (i < flts.length) {
            double param = this.toOwnParameter(flts[i].pointOnCurve1().parameter());
            JgclPointOnCurve2D pnt = new JgclPointOnCurve2D(this, param, false);
            flts[i] = !doExchange ? new JgclFilletObject2D(radius, flts[i].center(), pnt, flts[i].pointOnCurve2()) : new JgclFilletObject2D(radius, flts[i].center(), flts[i].pointOnCurve2(), pnt);
            ++i;
        }
        return flts;
    }

    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    JgclParameterDomain getParameterDomain() {
        try {
            return new JgclParameterDomain(false, 0.0, Math.abs(this.tParam2 - this.tParam1));
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    public boolean isFreeform() {
        return this.basisCurve.isFreeform();
    }

    public JgclPoint2D startPoint() {
        JgclPoint2D pnt1;
        try {
            pnt1 = this.tPnt1 == null || this.masterRepresentation1 == 1 ? this.basisCurve.coordinates(this.tParam1) : this.tPnt1;
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        if (this.tPnt1 == null) {
            this.tPnt1 = pnt1;
        }
        return pnt1;
    }

    public JgclPoint2D endPoint() {
        JgclPoint2D pnt2;
        try {
            pnt2 = this.tPnt2 == null || this.masterRepresentation2 == 1 ? this.basisCurve.coordinates(this.tParam2) : this.tPnt2;
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        if (this.tPnt2 == null) {
            this.tPnt2 = pnt2;
        }
        return pnt2;
    }

    int type() {
        return 23;
    }

    protected synchronized JgclParametricCurve2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclParametricCurve2D tBasisCurve = this.basisCurve().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclPoint2D tTPnt1 = null;
        JgclPoint2D tTPnt2 = null;
        if (this.masterRepresentation1() == 0) {
            tTPnt1 = this.tPnt1().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        if (this.masterRepresentation2() == 0) {
            tTPnt2 = this.tPnt2().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        return new JgclTrimmedCurve2D(tBasisCurve, tTPnt1, tTPnt2, this.tParam1(), this.tParam2(), this.masterRepresentation1(), this.masterRepresentation2(), this.senseAgreement());
    }

    protected boolean hasPolyline() {
        return this.basisCurve.hasPolyline();
    }

    protected boolean isComposedOfOnlyPolylines() {
        return this.basisCurve.isComposedOfOnlyPolylines();
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tbasisCurve");
        this.basisCurve.output(writer, indent + 2);
        if (this.tPnt1 != null) {
            writer.println(String.valueOf(indent_tab) + "\ttPnt1");
            this.tPnt1.output(writer, indent + 2);
        }
        if (this.tPnt2 != null) {
            writer.println(String.valueOf(indent_tab) + "\ttPnt2");
            this.tPnt2.output(writer, indent + 2);
        }
        writer.println(String.valueOf(indent_tab) + "\ttParam1\t" + this.tParam1);
        writer.println(String.valueOf(indent_tab) + "\ttParam2\t" + this.tParam2);
        writer.println(String.valueOf(indent_tab) + "\tmasterRepresentation1\t" + JgclTrimmingPreference.toString(this.masterRepresentation1));
        writer.println(String.valueOf(indent_tab) + "\tmasterRepresentation2\t" + JgclTrimmingPreference.toString(this.masterRepresentation2));
        writer.println(String.valueOf(indent_tab) + "\tsenseAgreement\t" + this.senseAgreement);
        writer.println(String.valueOf(indent_tab) + "End");
    }

    class ToTrimConversion
    extends JgclParameterConversion2D {
        JgclTrimmedCurve2D curve;

        ToTrimConversion(JgclTrimmedCurve2D curve) {
            JgclTrimmedCurve2D.this = JgclTrimmedCurve2D.this;
            this.curve = curve;
        }

        double convParameter(double param) {
            return this.curve.toOwnParameter(param);
        }

        JgclParametricCurve2D convCurve(double param) {
            return this.curve;
        }
    }

    class BsplineConversion
    extends JgclParameterConversion2D {
        JgclTrimmedCurve2D curve;
        JgclBoundedCurve2D bcurve;

        BsplineConversion(JgclTrimmedCurve2D curve, JgclBoundedCurve2D bcurve) {
            JgclTrimmedCurve2D.this = JgclTrimmedCurve2D.this;
            this.curve = curve;
            this.bcurve = bcurve;
        }

        double convParameter(double param) {
            JgclPointOnCurve2D pnt = new JgclPointOnCurve2D(this.bcurve, param, false);
            double bparam = this.curve.basisCurve().pointToParameter(pnt);
            return this.curve.toOwnParameter(bparam);
        }

        JgclParametricCurve2D convCurve(double param) {
            return this.curve;
        }
    }
}

