/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclPoint3D;

class JgclTabcylSurface3D {
    private final JgclBsplineCurve3D basisCurve1;
    private final JgclBsplineCurve3D basisCurve2;

    JgclTabcylSurface3D(JgclBsplineCurve3D basisCurve1, JgclBsplineCurve3D basisCurve2) {
        this.basisCurve1 = basisCurve1;
        this.basisCurve2 = basisCurve2;
    }

    JgclBsplineSurface3D getSurface() {
        JgclBsplineCurve3D[] crvs = new JgclBsplineCurve3D[]{this.basisCurve1, this.basisCurve2};
        JgclParameterSection[] sec = new JgclParameterSection[2];
        int i = 0;
        while (i < 2) {
            sec[i] = crvs[i].parameterDomain().section();
            ++i;
        }
        double sleng = crvs[0].coordinates(sec[0].start()).distance(crvs[1].coordinates(sec[1].start()));
        double eleng = crvs[0].coordinates(sec[0].end()).distance(crvs[1].coordinates(sec[1].end()));
        double leng = (sleng + eleng) / 2.0;
        JgclParameterSection uSec = new JgclParameterSection(0.0, leng);
        crvs = JgclBsplineCurve3D.identicalKnotSequences(crvs, uSec);
        boolean hasRational = false;
        int i2 = 0;
        while (i2 < crvs.length) {
            if (crvs[i2].isRational()) {
                hasRational = true;
            }
            ++i2;
        }
        if (hasRational) {
            int i3 = 0;
            while (i3 < crvs.length) {
                crvs[i3] = crvs[i3].toBsplineCurve();
                ++i3;
            }
        }
        int uNControlPoints = 2;
        int vNControlPoints = crvs[0].nControlPoints();
        JgclPoint3D[][] controlPoints = new JgclPoint3D[uNControlPoints][vNControlPoints];
        int i4 = 0;
        while (i4 < uNControlPoints) {
            int j = 0;
            while (j < vNControlPoints) {
                controlPoints[i4][j] = crvs[i4].controlPointAt(j);
                ++j;
            }
            ++i4;
        }
        double[][] weights = null;
        if (hasRational) {
            weights = new double[uNControlPoints][vNControlPoints];
            int i5 = 0;
            while (i5 < uNControlPoints) {
                int j = 0;
                while (j < vNControlPoints) {
                    weights[i5][j] = crvs[i5].weightAt(j);
                    ++j;
                }
                ++i5;
            }
        }
        int uDegree = 1;
        double[] uKnots = new double[]{uSec.start(), uSec.end()};
        int[] uKnotMulti = new int[2];
        uKnotMulti[1] = 2;
        uKnotMulti[0] = 2;
        JgclBsplineKnot uKnotData = new JgclBsplineKnot(uDegree, 1, false, uKnotMulti, uKnots, uNControlPoints);
        return new JgclBsplineSurface3D(uKnotData, crvs[0].knotData().beautify(), controlPoints, weights);
    }
}

