/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis1Placement3D;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclOfst3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclReducedToPoint;
import jp.go.ipa.jgcl.JgclSurfaceDerivative3D;
import jp.go.ipa.jgcl.JgclSweptSurface3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclSurfaceOfRevolution3D
extends JgclSweptSurface3D {
    private JgclAxis1Placement3D axisPosition;
    private JgclCartesianTransformationOperator3D transformationOperator;
    private transient double maxRadius;

    public JgclSurfaceOfRevolution3D(JgclParametricCurve3D sweptCurve, JgclAxis1Placement3D axisPosition) {
        super(sweptCurve);
        this.setAxisPosition(axisPosition);
        this.setTransformationOperator();
    }

    private void setAxisPosition(JgclAxis1Placement3D axisPosition) {
        if (axisPosition == null) {
            throw new JgclInvalidArgumentValue();
        }
        this.axisPosition = axisPosition;
    }

    private void setTransformationOperator() {
        JgclParameterDomain pd = this.vParameterDomain();
        double sp = 0.0;
        double ep = 1000.0;
        if (pd.isFinite()) {
            sp = pd.section().start();
            ep = pd.section().end();
        }
        double ip = (ep - sp) / 1000.0;
        double dTol2 = this.getToleranceForDistance2();
        double cosATol = Math.cos(this.getToleranceForAngle());
        JgclPoint3D location = this.axisPosition().location();
        JgclVector3D axis = this.axisPosition().z();
        JgclVector3D refDir = null;
        int i = 0;
        while (i <= 1000) {
            refDir = this.sweptCurve().coordinates(sp + (double)i * ip).subtract(location);
            if (refDir.norm() > dTol2 && Math.abs(axis.dotProduct(refDir = refDir.unitized())) < cosATol) {
                this.transformationOperator = new JgclCartesianTransformationOperator3D(new JgclAxis2Placement3D(location, axis, refDir), 1.0);
                return;
            }
            ++i;
        }
        throw new JgclFatal("Maybe the surface is degenate.");
    }

    public JgclAxis1Placement3D axisPosition() {
        return this.axisPosition;
    }

    public JgclLine3D axisLine() {
        return this.axisPosition().toLine();
    }

    public JgclPoint3D coordinates(double uParam, double vParam) {
        JgclPoint3D cpnt = this.sweptCurve().coordinates(vParam);
        double u_cos = Math.cos(uParam);
        double u_sin = Math.sin(uParam);
        JgclPoint3D lpnt = this.transformationOperator.reverseTransform(cpnt);
        return this.transformationOperator.transform(this.XYRotation(lpnt, u_cos, u_sin));
    }

    public JgclVector3D[] tangentVector(double uParam, double vParam) {
        JgclPoint3D cpnt = this.sweptCurve().coordinates(vParam);
        JgclVector3D ctng = this.sweptCurve().tangentVector(vParam);
        JgclVector3D[] tng = new JgclVector3D[2];
        double u_cos = Math.cos(uParam);
        double u_sin = Math.sin(uParam);
        JgclPoint3D lpnt = this.transformationOperator.reverseTransform(cpnt);
        JgclLiteralVector3D lUtng = new JgclLiteralVector3D(-lpnt.y(), lpnt.x(), 0.0);
        JgclVector3D lVtng = this.transformationOperator.reverseTransform(ctng);
        tng[0] = this.transformationOperator.transform(this.XYRotation(lUtng, u_cos, u_sin));
        tng[1] = this.transformationOperator.transform(this.XYRotation(lVtng, u_cos, u_sin));
        return tng;
    }

    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
        JgclCurveDerivative3D crv_drv = this.sweptCurve().evaluation(vParam);
        double u_cos = Math.cos(uParam);
        double u_sin = Math.sin(uParam);
        JgclPoint3D L = this.transformationOperator.reverseTransform(crv_drv.d0D());
        JgclVector3D Lv = this.transformationOperator.reverseTransform(crv_drv.d1D());
        JgclVector3D Lvv = this.transformationOperator.reverseTransform(crv_drv.d2D());
        JgclLiteralVector3D Lu = new JgclLiteralVector3D(-L.y(), L.x(), 0.0);
        JgclLiteralVector3D Luu = new JgclLiteralVector3D(-L.x(), -L.y(), 0.0);
        JgclLiteralVector3D Luv = new JgclLiteralVector3D(-Lv.y(), Lv.x(), 0.0);
        JgclPoint3D d0 = this.transformationOperator.transform(this.XYRotation(L, u_cos, u_sin));
        JgclVector3D du = this.transformationOperator.transform(this.XYRotation(Lu, u_cos, u_sin));
        JgclVector3D dv = this.transformationOperator.transform(this.XYRotation(Lv, u_cos, u_sin));
        JgclVector3D duu = this.transformationOperator.transform(this.XYRotation(Luu, u_cos, u_sin));
        JgclVector3D dvv = this.transformationOperator.transform(this.XYRotation(Lvv, u_cos, u_sin));
        JgclVector3D duv = this.transformationOperator.transform(this.XYRotation(Luv, u_cos, u_sin));
        return new JgclSurfaceDerivative3D(d0, du, dv, duu, duv, dvv);
    }

    private void indefiniteFoot(JgclPoint3D point) throws JgclIndefiniteSolution {
        JgclPointOnCurve3D p;
        try {
            p = this.sweptCurve().projectFrom(point)[0];
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        throw new JgclIndefiniteSolution(p);
    }

    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point) throws JgclIndefiniteSolution {
        double vParam;
        if (point.isOn(this.axisLine())) {
            this.indefiniteFoot(point);
        }
        JgclCartesianTransformationOperator3D cto = this.getCartesianTransformationOperator();
        JgclPoint3D local_point = cto.toLocal(point);
        local_point = JgclPoint3D.of(local_point.x(), local_point.y(), 0.0);
        JgclVector3D local_vector = local_point.toVector3D().unitized();
        double angle1 = Math.acos(local_vector.x());
        if (local_point.y() < 0.0) {
            angle1 = Math.PI * 2 - angle1;
        }
        JgclParametricCurve3D curve = this.sweptCurve();
        JgclParametricCurve3D rotated_curve1 = curve.rotateZ(cto, Math.cos(angle1), Math.sin(angle1));
        JgclPointOnCurve3D[][] proj_on_curve = new JgclPointOnCurve3D[2][];
        proj_on_curve[0] = rotated_curve1.projectFrom(point);
        double angle2 = angle1 + Math.PI;
        if (angle2 > Math.PI * 2) {
            angle2 -= Math.PI * 2;
        }
        JgclParametricCurve3D rotated_curve2 = curve.rotateZ(cto, Math.cos(angle2), Math.sin(angle2));
        proj_on_curve[1] = rotated_curve2.projectFrom(point);
        JgclPointOnSurface3D[] proj = new JgclPointOnSurface3D[proj_on_curve[0].length + proj_on_curve[1].length];
        int i = 0;
        double uParam = angle1;
        int j = 0;
        while (j < proj_on_curve[0].length) {
            vParam = proj_on_curve[0][j].parameter();
            proj[i] = new JgclPointOnSurface3D(this, uParam, vParam, false);
            ++i;
            ++j;
        }
        uParam = angle2;
        int k = 0;
        while (k < proj_on_curve[1].length) {
            vParam = proj_on_curve[1][k].parameter();
            proj[i] = new JgclPointOnSurface3D(this, uParam, vParam, false);
            ++i;
            ++k;
        }
        return proj;
    }

    public JgclMesh3D toMesh(JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        int u_npnts;
        JgclPolyline3D pol = this.sweptCurve().toPolyline(vPint, tol);
        int v_npnts = pol.nPoints();
        JgclLine3D lin = new JgclLine3D(this.axisPosition.location(), this.axisPosition.z());
        this.maxRadius = 0.0;
        int i = 0;
        while (i < v_npnts) {
            JgclPointOnCurve3D foot;
            JgclPoint3D pnt = pol.pointAt(i);
            try {
                foot = lin.project1From(pnt);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            double dist = foot.distance2(pnt);
            if (dist > this.maxRadius) {
                this.maxRadius = dist;
            }
            ++i;
        }
        this.maxRadius = Math.sqrt(this.maxRadius);
        if (this.maxRadius <= JgclConditionOfOperation.getCondition().getToleranceForDistance()) {
            u_npnts = 2;
        } else {
            try {
                JgclCircle3D cir = new JgclCircle3D(this.axisPosition.location(), this.axisPosition.z(), this.maxRadius);
                u_npnts = cir.toPolyline(uPint, tol).nPoints();
                if (u_npnts < 2) {
                    u_npnts = 2;
                }
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
        }
        JgclPoint3D[][] mesh = new JgclPointOnSurface3D[u_npnts][v_npnts];
        double uDelta = uPint.increase() / (double)(u_npnts - 1);
        double uParam = uPint.start();
        i = 0;
        while (i < u_npnts) {
            int j = 0;
            while (j < v_npnts) {
                JgclPointOnCurve3D poc = (JgclPointOnCurve3D)pol.pointAt(j);
                double vParam = poc.parameter();
                try {
                    mesh[i][j] = new JgclPointOnSurface3D(this, uParam, vParam, false);
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
                ++j;
            }
            uParam = i == u_npnts - 2 ? uPint.end() : (uParam += uDelta);
            ++i;
        }
        return new JgclMesh3D(mesh, false);
    }

    public JgclBsplineSurface3D toBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint) {
        JgclCircle2D uUnitCircle2D = new JgclCircle2D(JgclAxis2Placement2D.origin, 1.0);
        JgclBsplineCurve2D uUnitBsplineCurve2D = uUnitCircle2D.toBsplineCurve(uPint);
        JgclBsplineCurve3D vBsplineCurve = this.sweptCurve().toBsplineCurve(vPint);
        int uNPoints = uUnitBsplineCurve2D.nControlPoints();
        int vNPoints = vBsplineCurve.nControlPoints();
        JgclPoint3D[] vLocalControlPoints = new JgclPoint3D[vNPoints];
        int vi = 0;
        while (vi < vNPoints) {
            vLocalControlPoints[vi] = this.transformationOperator.toLocal(vBsplineCurve.controlPointAt(vi));
            ++vi;
        }
        JgclPoint3D[][] controlPoints = new JgclPoint3D[uNPoints][vNPoints];
        double[][] weights = new double[uNPoints][vNPoints];
        int ui = 0;
        while (ui < uNPoints) {
            JgclPoint2D uPoint = uUnitBsplineCurve2D.controlPointAt(ui);
            int vi2 = 0;
            while (vi2 < vNPoints) {
                controlPoints[ui][vi2] = this.transformationOperator.toEnclosed(this.XYRotation(vLocalControlPoints[vi2], uPoint.x(), uPoint.y()));
                weights[ui][vi2] = uUnitBsplineCurve2D.weightAt(ui) * vBsplineCurve.weightAt(vi2);
                ++vi2;
            }
            ++ui;
        }
        return new JgclBsplineSurface3D(uUnitBsplineCurve2D.knotData(), vBsplineCurve.knotData(), controlPoints, weights);
    }

    public JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst3D doObj = new JgclOfst3D(this, uPint, vPint, magni, side, tol);
        return doObj.offset();
    }

    private JgclCartesianTransformationOperator3D getCartesianTransformationOperator() {
        JgclLine3D line = this.axisLine();
        JgclPoint3D x = this.sweptCurve().getPointNotOnLine(line);
        JgclVector3D xv = x.subtract(line.project1From(x));
        JgclAxis2Placement3D local_position = new JgclAxis2Placement3D(this.axisPosition().location(), this.axisPosition().z(), xv);
        return local_position.toCartesianTransformationOperator();
    }

    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
        JgclCartesianTransformationOperator3D cto = this.getCartesianTransformationOperator();
        return this.sweptCurve().rotateZ(cto, Math.cos(uParam), Math.sin(uParam));
    }

    public JgclParametricCurve3D vIsoParametricCurve(double vParam) throws JgclReducedToPoint {
        JgclCartesianPoint3D prj;
        JgclPoint3D pnt = this.sweptCurve().coordinates(vParam);
        double radius = pnt.distance(prj = this.axisLine().project1From(pnt).literal());
        if (radius <= this.getToleranceForDistance()) {
            throw new JgclReducedToPoint(prj);
        }
        JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(prj, this.axisPosition().z(), pnt.subtract(prj));
        return new JgclCircle3D(a2p, radius);
    }

    JgclParameterDomain getUParameterDomain() {
        try {
            return new JgclParameterDomain(true, 0.0, Math.PI * 2);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    JgclParameterDomain getVParameterDomain() {
        return this.sweptCurve().parameterDomain();
    }

    int type() {
        return 21;
    }

    private JgclPoint3D XYRotation(JgclPoint3D pnt, double cosValue, double sinValue) {
        double x = cosValue * pnt.x() - sinValue * pnt.y();
        double y = sinValue * pnt.x() + cosValue * pnt.y();
        double z = pnt.z();
        return new JgclCartesianPoint3D(x, y, z);
    }

    private JgclVector3D XYRotation(JgclVector3D vec, double cosValue, double sinValue) {
        double x = cosValue * vec.x() - sinValue * vec.y();
        double y = sinValue * vec.x() + cosValue * vec.y();
        double z = vec.z();
        return new JgclLiteralVector3D(x, y, z);
    }

    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection, JgclParameterSection vParameterSection, double tolerance, double[] scalingFactor) {
        Vector<JgclPoint3D> result = new Vector<JgclPoint3D>();
        JgclMesh3D mesh = this.toMesh(uParameterSection, vParameterSection, new JgclToleranceForDistance(tolerance));
        int u = 0;
        while (u < mesh.uNPoints()) {
            int v = 0;
            while (v < mesh.vNPoints()) {
                result.addElement(mesh.pointAt(u, v));
                ++v;
            }
            ++u;
        }
        double vScale = 0.0;
        int v = 1;
        while (v < mesh.vNPoints()) {
            vScale += mesh.pointAt(0, v).distance(mesh.pointAt(0, v - 1));
            ++v;
        }
        scalingFactor[0] = this.maxRadius;
        scalingFactor[1] = vScale /= vParameterSection.increase();
        return result;
    }

    protected synchronized JgclParametricSurface3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclParametricCurve3D tSweptCurve = this.sweptCurve().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclAxis1Placement3D tAxisPosition = this.axisPosition.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclSurfaceOfRevolution3D(tSweptCurve, tAxisPosition);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tsweptCurve");
        this.sweptCurve().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\taxisPosition");
        this.axisPosition.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

