/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsQrdBzs3D;
import jp.go.ipa.jgcl.JgclIntsSphCon3D;
import jp.go.ipa.jgcl.JgclIntsSphCyl3D;
import jp.go.ipa.jgcl.JgclIntsSrfBss3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclOfst3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclReducedToPoint;
import jp.go.ipa.jgcl.JgclSurfaceCurvature3D;
import jp.go.ipa.jgcl.JgclSurfaceDerivative3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclSphericalSurface3D
extends JgclElementarySurface3D {
    private double radius;

    private void setRadius(double radius) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        if (radius < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.radius = radius;
    }

    public JgclSphericalSurface3D(JgclAxis2Placement3D position, double radius) {
        super(position);
        this.setRadius(radius);
    }

    public JgclSphericalSurface3D(JgclPoint3D cntr, double radius) {
        this(new JgclAxis2Placement3D(cntr, JgclVector3D.zUnitVector, JgclVector3D.xUnitVector), radius);
    }

    public double radius() {
        return this.radius;
    }

    public JgclPoint3D coordinates(double uParam, double vParam) {
        this.checkVValidity(vParam);
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        double x = this.radius * Math.cos(uParam) * Math.cos(vParam);
        double y = this.radius * Math.sin(uParam) * Math.cos(vParam);
        double z = this.radius * Math.sin(vParam);
        JgclCartesianPoint3D pnt = new JgclCartesianPoint3D(x, y, z);
        return gtrans.transform(pnt);
    }

    public JgclVector3D[] tangentVector(double uParam, double vParam) {
        this.checkVValidity(vParam);
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        double dux = -this.radius * Math.sin(uParam) * Math.cos(vParam);
        double duy = this.radius * Math.cos(uParam) * Math.cos(vParam);
        double dvx = -this.radius * Math.cos(uParam) * Math.sin(vParam);
        double dvy = -this.radius * Math.sin(uParam) * Math.sin(vParam);
        double dvz = this.radius * Math.cos(vParam);
        JgclLiteralVector3D dup = new JgclLiteralVector3D(dux, duy, 0.0);
        JgclLiteralVector3D dvp = new JgclLiteralVector3D(dvx, dvy, dvz);
        JgclVector3D[] tang = new JgclVector3D[]{gtrans.transform(dup), gtrans.transform(dvp)};
        return tang;
    }

    public JgclVector3D normalVector(double uParam, double vParam) {
        this.checkVValidity(vParam);
        JgclPoint3D pnt = this.coordinates(uParam, vParam);
        return pnt.subtract(this.position().location()).unitized();
    }

    public JgclSurfaceCurvature3D curvature(double uParam, double vParam) {
        this.checkVValidity(vParam);
        JgclVector3D[] tangent = this.tangentVector(uParam, vParam);
        return new JgclSurfaceCurvature3D(-1.0 / this.radius, tangent[0].unitized(), -1.0 / this.radius, tangent[1].unitized());
    }

    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
        this.checkVValidity(vParam);
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        double x = this.radius * Math.cos(uParam) * Math.cos(vParam);
        double y = this.radius * Math.sin(uParam) * Math.cos(vParam);
        double z = this.radius * Math.sin(vParam);
        double dvx = -this.radius * Math.cos(uParam) * Math.sin(vParam);
        double dvy = -this.radius * Math.sin(uParam) * Math.sin(vParam);
        double dvz = this.radius * Math.cos(vParam);
        JgclCartesianPoint3D pnt = new JgclCartesianPoint3D(x, y, z);
        JgclLiteralVector3D dup = new JgclLiteralVector3D(-y, x, 0.0);
        JgclLiteralVector3D dvp = new JgclLiteralVector3D(dvx, dvy, dvz);
        JgclLiteralVector3D duup = new JgclLiteralVector3D(-x, -y, 0.0);
        JgclLiteralVector3D duvp = new JgclLiteralVector3D(-dvy, dvx, 0.0);
        JgclLiteralVector3D dvvp = new JgclLiteralVector3D(-x, -y, -z);
        return new JgclSurfaceDerivative3D(gtrans.transform(pnt), gtrans.transform(dup), gtrans.transform(dvp), gtrans.transform(duup), gtrans.transform(duvp), gtrans.transform(dvvp));
    }

    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point) throws JgclIndefiniteSolution {
        JgclPointOnSurface3D foot2;
        JgclPointOnSurface3D foot1;
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        JgclPoint3D lpoint = gtrans.reverseTransform(point);
        JgclVector3D eduvec = lpoint.toVector3D();
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = Math.abs(condition.getToleranceForDistance());
        double aTol = condition.getToleranceForAngle();
        if (eduvec.length() < dTol) {
            JgclPointOnSurface3D p;
            try {
                p = new JgclPointOnSurface3D(this, 0.0, 0.0, false);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            throw new JgclIndefiniteSolution(p);
        }
        double sin_v = (eduvec = eduvec.unitized()).z();
        double v = Math.asin(sin_v);
        if (v < -Math.PI + aTol || Math.PI - aTol < v) {
            foot1 = new JgclPointOnSurface3D(this, 0.0, v, false);
            foot2 = new JgclPointOnSurface3D(this, 0.0, -v, false);
        } else {
            double u = Math.atan2(eduvec.y(), eduvec.x());
            if (u < 0.0) {
                u += Math.PI * 2;
            }
            foot1 = new JgclPointOnSurface3D(this, u, v, false);
            if ((u += Math.PI) >= Math.PI * 2) {
                u -= Math.PI * 2;
            }
            foot2 = new JgclPointOnSurface3D(this, u, -v, false);
        }
        JgclPointOnSurface3D[] proj = new JgclPointOnSurface3D[]{foot1, foot2};
        return proj;
    }

    public JgclMesh3D toMesh(JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        double vStart = vPint.start();
        double vEnd = vPint.end();
        double rad = this.maxRadius(vPint);
        int u_npnts = JgclCircle2D.toPolylineNDivision(rad, uPint.increase(), tol) + 1;
        int v_npnts = JgclCircle2D.toPolylineNDivision(this.radius(), vPint.increase(), tol) + 1;
        JgclPoint3D[][] mesh = new JgclPointOnSurface3D[u_npnts][v_npnts];
        double uDelta = uPint.increase() / (double)(u_npnts - 1);
        double vDelta = vPint.increase() / (double)(v_npnts - 1);
        double uParam = uPint.start();
        int i = 0;
        while (i < u_npnts) {
            double vParam = vStart;
            int j = 0;
            while (j < v_npnts) {
                try {
                    mesh[i][j] = new JgclPointOnSurface3D(this, uParam, vParam, false);
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
                vParam = j == v_npnts - 2 ? vEnd : (vParam += vDelta);
                ++j;
            }
            uParam = i == u_npnts - 2 ? uPint.end() : (uParam += uDelta);
            ++i;
        }
        return new JgclMesh3D(mesh, false);
    }

    private double maxRadius(JgclParameterSection vPint) {
        double vLow = vPint.lower();
        this.checkVValidity(vLow);
        double vUpp = vPint.upper();
        this.checkVValidity(vUpp);
        double rad = vLow <= 0.0 && vUpp >= 0.0 ? this.radius() : (Math.abs(vLow) < Math.abs(vUpp) ? this.radius() * Math.cos(vLow) : this.radius() * Math.cos(vUpp));
        return rad;
    }

    public JgclBsplineSurface3D toBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint) {
        JgclCircle2D circle2D = new JgclCircle2D(JgclAxis2Placement2D.origin, this.radius());
        JgclBsplineCurve2D uBsplineCurve2D = circle2D.toBsplineCurve(uPint);
        int uDegree = uBsplineCurve2D.degree();
        boolean uPeriodic = uBsplineCurve2D.isPeriodic();
        int uNPoints = uBsplineCurve2D.nControlPoints();
        JgclBsplineCurve2D vBsplineCurve2D = circle2D.toBsplineCurve(vPint);
        int vDegree = vBsplineCurve2D.degree();
        boolean vPeriodic = vBsplineCurve2D.isPeriodic();
        int vNPoints = vBsplineCurve2D.nControlPoints();
        JgclPoint3D[][] controlPoints = new JgclPoint3D[uNPoints][vNPoints];
        double[][] weights = new double[uNPoints][vNPoints];
        JgclCartesianTransformationOperator3D localTransformationOperator = this.position().toCartesianTransformationOperator(1.0);
        int vi = 0;
        while (vi < vNPoints) {
            JgclPoint2D vPoint = vBsplineCurve2D.controlPointAt(vi);
            double scale = vPoint.x() / this.radius();
            int ui = 0;
            while (ui < uNPoints) {
                JgclPoint2D uPoint = uBsplineCurve2D.controlPointAt(ui);
                JgclCartesianPoint3D localPoint = JgclPoint3D.of(scale * uPoint.x(), scale * uPoint.y(), vPoint.y());
                controlPoints[ui][vi] = localTransformationOperator.toEnclosed(localPoint);
                weights[ui][vi] = vBsplineCurve2D.weightAt(vi) * uBsplineCurve2D.weightAt(ui);
                ++ui;
            }
            ++vi;
        }
        return new JgclBsplineSurface3D(uBsplineCurve2D.knotData(), vBsplineCurve2D.knotData(), controlPoints, weights);
    }

    boolean checkSolution(JgclPoint3D point) {
        double dTol = this.getToleranceForDistance();
        return Math.abs(point.distance(JgclPoint3D.origin) - this.radius()) < dTol;
    }

    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
        JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
        JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
        JgclRealPolynomial zPoly = poly[2].multiply(poly[2]);
        double radius2 = this.radius() * this.radius();
        boolean isPoly = poly.length < 4;
        int degree = xPoly.degree();
        double[] coef = new double[degree + 1];
        if (isPoly) {
            int j = 0;
            while (j <= degree) {
                coef[j] = xPoly.coefficientAt(j) + yPoly.coefficientAt(j) + zPoly.coefficientAt(j);
                ++j;
            }
            coef[0] = coef[0] - radius2;
        } else {
            JgclRealPolynomial wPoly = poly[3].multiply(poly[3]);
            int j = 0;
            while (j <= degree) {
                coef[j] = xPoly.coefficientAt(j) + yPoly.coefficientAt(j) + zPoly.coefficientAt(j) - radius2 * wPoly.coefficientAt(j);
                ++j;
            }
        }
        return new JgclRealPolynomial(coef);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
        JgclPoint3D[] int_pnt;
        double dTol = this.getToleranceForDistance();
        JgclPoint3D center = this.position().location();
        JgclPointOnCurve3D pA = mate.project1From(center);
        double distance = pA.distance(center);
        if (Math.abs(this.radius() - distance) < dTol) {
            int_pnt = new JgclPoint3D[]{pA};
        } else if (this.radius() > distance) {
            int_pnt = new JgclPoint3D[2];
            JgclVector3D unitVector = mate.dir().unitized();
            JgclPoint3D line_pnt = mate.pnt();
            double offset = Math.sqrt(this.radius() * this.radius() - distance * distance);
            JgclVector3D dir_vec = unitVector.multiply(offset);
            int_pnt[0] = pA.add(dir_vec);
            int_pnt[1] = pA.subtract(dir_vec);
        } else {
            int_pnt = new JgclPoint3D[]{};
        }
        JgclIntersectionPoint3D[] return_pnt = new JgclIntersectionPoint3D[int_pnt.length];
        int i = 0;
        while (i < int_pnt.length) {
            JgclVector3D pnt_to_int = int_pnt[i].subtract(mate.pnt());
            double dT = pnt_to_int.length() / mate.dir().length();
            if (pnt_to_int.dotProduct(mate.dir()) < 0.0) {
                dT *= -1.0;
            }
            JgclCartesianTransformationOperator3D trans = new JgclCartesianTransformationOperator3D(this.position(), 1.0);
            JgclPoint3D transformed_int_pnt = trans.reverseTransform(int_pnt[i]);
            JgclVector3D center_to_int = transformed_int_pnt.toVector3D();
            JgclVector3D unit_center_to_int = center_to_int.unitized();
            double dV = Math.asin(unit_center_to_int.z());
            JgclVector2D dir2D = center_to_int.to2D();
            JgclVector2D center_to_int_2D = dir2D.unitized();
            double dU = Math.acos(center_to_int_2D.x());
            if (center_to_int_2D.y() < 0.0) {
                dU = Math.PI * 2 - dU;
            }
            JgclPointOnCurve3D PonC = new JgclPointOnCurve3D(int_pnt[i], mate, dT, false);
            JgclPointOnSurface3D PonS = new JgclPointOnSurface3D(int_pnt[i], this, dU, dV, false);
            return_pnt[i] = doExchange ? new JgclIntersectionPoint3D(int_pnt[i], PonC, PonS, false) : new JgclIntersectionPoint3D(int_pnt[i], PonS, PonC, false);
            ++i;
        }
        return return_pnt;
    }

    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        double d_tol = this.getToleranceForDistance();
        JgclVector3D vector2 = this.position().location().subtract(mate.position().location());
        double dist = vector2.length();
        if (dist < d_tol) {
            if (Math.abs(this.radius() - mate.radius()) < d_tol) {
                JgclCircle3D res = new JgclCircle3D(this.position(), (this.radius() + mate.radius()) / 2.0);
                JgclIntersectionCurve3D ints = this.curveToIntersectionCurve(res, mate, doExchange);
                throw new JgclIndefiniteSolution(ints);
            }
            return new JgclSurfaceSurfaceInterference3D[0];
        }
        double Ar = this.radius();
        double Br = mate.radius();
        JgclVector3D vector = vector2.divide(dist);
        if (Math.abs(dist - (Ar + Br)) < d_tol || Math.abs(dist - (Ar - Br)) < d_tol || Math.abs(dist - (Br - Ar)) < d_tol) {
            JgclPoint3D Bint;
            JgclPoint3D Aint;
            if (Math.abs(dist - (Ar + Br)) < d_tol) {
                Aint = this.position().location().subtract(vector.multiply(Ar));
                Bint = mate.position().location().add(vector.multiply(Br));
            } else if (Math.abs(dist - (Ar - Br)) < d_tol) {
                Aint = this.position().location().subtract(vector.multiply(Ar));
                Bint = mate.position().location().subtract(vector.multiply(Br));
            } else {
                Aint = this.position().location().add(vector.multiply(Ar));
                Bint = mate.position().location().add(vector.multiply(Br));
            }
            JgclPoint3D res = Aint.linearInterpolate(Bint, 0.5);
            double[] params = this.pointToParameter(Aint);
            JgclPointOnSurface3D ponA = new JgclPointOnSurface3D(Aint, this, params[0], params[1], false);
            params = mate.pointToParameter(Bint);
            JgclPointOnSurface3D ponB = new JgclPointOnSurface3D(Bint, mate, params[0], params[1], false);
            JgclIntersectionPoint3D intp = !doExchange ? new JgclIntersectionPoint3D(res, ponA, ponB, false) : new JgclIntersectionPoint3D(res, ponB, ponA, false);
            JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{intp};
            return sol;
        }
        if (dist < Ar + Br && dist > Math.abs(Ar - Br)) {
            double Adist = Math.abs((Ar * Ar - Br * Br + dist * dist) / (2.0 * dist));
            JgclPoint3D Apnt = this.position().location().subtract(vector.multiply(Adist));
            double Bdist = Math.abs((Br * Br - Ar * Ar + dist * dist) / (2.0 * dist));
            JgclPoint3D Bpnt = mate.position().location().add(vector.multiply(Bdist));
            JgclPoint3D loc = Apnt.linearInterpolate(Bpnt, 0.5);
            JgclVector3D axis = vector2;
            JgclVector3D refDir = Math.abs(axis.y()) < d_tol && Math.abs(axis.z()) < d_tol ? JgclVector3D.zUnitVector : JgclVector3D.xUnitVector;
            JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(loc, axis, refDir);
            double radius = Math.sqrt((Ar * Ar - Adist * Adist + (Br * Br - Bdist * Bdist)) / 2.0);
            JgclCircle3D res = new JgclCircle3D(a2p, radius);
            JgclIntersectionCurve3D ints = this.curveToIntersectionCurve(res, mate, doExchange);
            JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
            return sol;
        }
        return new JgclSurfaceSurfaceInterference3D[0];
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate, boolean doExchange) {
        return JgclIntsSphCyl3D.intersection(this, mate, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate, boolean doExchange) {
        JgclIntsSphCon3D doObj = new JgclIntsSphCon3D(this, mate);
        return doObj.getInterference(doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        return JgclIntsQrdBzs3D.intersection(this, mate, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        return JgclIntsSrfBss3D.intersection(this, mate, doExchange);
    }

    public JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst3D doObj = new JgclOfst3D(this, uPint, vPint, magni, side, tol);
        return doObj.offset();
    }

    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
        JgclCartesianTransformationOperator3D trns = this.position().toCartesianTransformationOperator();
        JgclPoint3D cntr = this.position().location();
        JgclVector3D xVec = this.position().x().multiply(Math.cos(uParam)).add(this.position().y().multiply(Math.sin(uParam)));
        xVec = trns.toEnclosed(xVec);
        JgclVector3D yVec = trns.toEnclosed(this.position().z());
        JgclVector3D zVec = xVec.crossProduct(yVec);
        JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(cntr, zVec, xVec);
        JgclCircle3D cir = new JgclCircle3D(a2p, this.radius());
        JgclParameterSection sec = new JgclParameterSection(-1.5707963267948966, Math.PI);
        return new JgclTrimmedCurve3D(cir, sec);
    }

    public JgclParametricCurve3D vIsoParametricCurve(double vParam) throws JgclReducedToPoint {
        this.checkVValidity(vParam);
        JgclCartesianTransformationOperator3D trns = this.position().toCartesianTransformationOperator();
        JgclPoint3D cntr = new JgclCartesianPoint3D(0.0, 0.0, this.radius() * Math.sin(vParam));
        cntr = trns.toEnclosed(cntr);
        double cRadius = this.radius() * Math.cos(vParam);
        if (cRadius <= this.getToleranceForDistance()) {
            throw new JgclReducedToPoint(cntr);
        }
        JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(cntr, this.position().z(), this.position().x());
        return new JgclCircle3D(a2p, cRadius);
    }

    JgclParameterDomain getUParameterDomain() {
        try {
            return new JgclParameterDomain(true, 0.0, Math.PI * 2);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    JgclParameterDomain getVParameterDomain() {
        try {
            return new JgclParameterDomain(false, -1.5707963267948966, Math.PI);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    int type() {
        return 12;
    }

    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection, JgclParameterSection vParameterSection, double tolerance, double[] scalingFactor) {
        double vCircleRadius;
        Vector<JgclPoint3D> result = new Vector<JgclPoint3D>();
        JgclMesh3D mesh = this.toMesh(uParameterSection, vParameterSection, new JgclToleranceForDistance(tolerance));
        int u = 0;
        while (u < mesh.uNPoints()) {
            int v = 0;
            while (v < mesh.vNPoints()) {
                result.addElement(mesh.pointAt(u, v));
                ++v;
            }
            ++u;
        }
        double uCircleRadius = vParameterSection.start() > 0.0 ? this.radius() * Math.cos(vParameterSection.start()) : (vParameterSection.end() < 0.0 ? this.radius() * Math.cos(vParameterSection.end()) : this.radius());
        scalingFactor[0] = uCircleRadius;
        scalingFactor[1] = vCircleRadius = this.radius();
        return result;
    }

    protected synchronized JgclParametricSurface3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclAxis2Placement3D tPosition = this.position().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        double tRadius = !reverseTransform ? transformationOperator.transform(this.radius()) : transformationOperator.reverseTransform(this.radius());
        return new JgclSphericalSurface3D(tPosition, tRadius);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tposition");
        this.position().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tradius\t" + this.radius);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

