/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclInvalidArgumentValue;

class JgclPureBezierCurveEvaluation {
    private JgclPureBezierCurveEvaluation() {
    }

    static double[] coordinates(double[][] controlPoints, double param) {
        double[] d0D = new double[controlPoints[0].length];
        JgclPureBezierCurveEvaluation.evaluation(controlPoints, param, d0D, null, null, null);
        return d0D;
    }

    static void evaluation(double[][] controlPoints, double param, double[] d0D, double[] d1D, double[] d2D, double[] d3D) {
        double param1 = 1.0 - param;
        int uicp = controlPoints.length;
        int degree = uicp - 1;
        int dimension = controlPoints[0].length;
        double[][] auxpnts0 = new double[uicp][dimension];
        double[][] auxpnts = controlPoints;
        int i = 1;
        while (i < uicp) {
            int j;
            if (i == uicp - 3 && d3D != null) {
                j = 0;
                while (j < dimension) {
                    d3D[j] = (double)(degree * (degree - 1) * (degree - 2)) * (auxpnts[i + 2][j] - 3.0 * (auxpnts[i + 1][j] - auxpnts[i][j]) - auxpnts[i - 1][j]);
                    ++j;
                }
            }
            if (i == uicp - 2 && d2D != null) {
                j = 0;
                while (j < dimension) {
                    d2D[j] = (double)(degree * (degree - 1)) * (auxpnts[i + 1][j] - 2.0 * auxpnts[i][j] + auxpnts[i - 1][j]);
                    ++j;
                }
            }
            if (i == uicp - 1 && d1D != null) {
                j = 0;
                while (j < dimension) {
                    d1D[j] = (double)degree * (auxpnts[i][j] - auxpnts[i - 1][j]);
                    ++j;
                }
            }
            j = uicp - 1;
            while (j >= i) {
                int k = 0;
                while (k < dimension) {
                    auxpnts0[j][k] = param * auxpnts[j][k] + param1 * auxpnts[j - 1][k];
                    ++k;
                }
                --j;
            }
            auxpnts = auxpnts0;
            ++i;
        }
        if (d0D != null) {
            i = 0;
            while (i < dimension) {
                d0D[i] = auxpnts[uicp - 1][i];
                ++i;
            }
        }
        if (d2D != null && degree < 2) {
            i = 0;
            while (i < dimension) {
                d2D[i] = 0.0;
                ++i;
            }
        }
        if (d3D != null && degree < 3) {
            i = 0;
            while (i < dimension) {
                d3D[i] = 0.0;
                ++i;
            }
        }
    }

    static double[] blossoming(double[][] controlPoints, double[] parameters) {
        int uicp = controlPoints.length;
        int dimension = controlPoints[0].length;
        double[][] auxpnts0 = new double[uicp][dimension];
        double[][] auxpnts = controlPoints;
        int ti = 0;
        while (ti < uicp - 1) {
            double rearWeight = parameters[ti];
            double frontWeight = 1.0 - rearWeight;
            int pi = uicp - 1;
            while (pi > ti) {
                int di = 0;
                while (di < dimension) {
                    auxpnts0[pi][di] = rearWeight * auxpnts[pi][di] + frontWeight * auxpnts[pi - 1][di];
                    ++di;
                }
                --pi;
            }
            auxpnts = auxpnts0;
            ++ti;
        }
        double[] result = new double[dimension];
        int di = 0;
        while (di < dimension) {
            result[di] = auxpnts0[uicp - 1][di];
            ++di;
        }
        return result;
    }

    static double[][][] divide(double[][] controlPoints, double param) {
        double[][][] cpArray = new double[2][controlPoints.length][controlPoints[0].length];
        return JgclPureBezierCurveEvaluation.divide(controlPoints, param, cpArray);
    }

    static double[][][] divide(double[][] controlPoints, double param, double[][][] cpArray) {
        int uicp = controlPoints.length;
        int lp = uicp - 1;
        int dimension = controlPoints[0].length;
        double t1 = param;
        double t2 = 1.0 - t1;
        switch (dimension) {
            case 2: {
                int i = 0;
                while (i < uicp) {
                    if (controlPoints[i].length != dimension) {
                        throw new JgclInvalidArgumentValue();
                    }
                    cpArray[0][i][0] = controlPoints[i][0];
                    cpArray[0][i][1] = controlPoints[i][1];
                    ++i;
                }
                i = 0;
                int k = lp;
                while (i < uicp) {
                    cpArray[1][k][0] = cpArray[0][lp][0];
                    cpArray[1][k][1] = cpArray[0][lp][1];
                    int j = lp;
                    while (j > i) {
                        cpArray[0][j][0] = t1 * cpArray[0][j][0] + t2 * cpArray[0][j - 1][0];
                        cpArray[0][j][1] = t1 * cpArray[0][j][1] + t2 * cpArray[0][j - 1][1];
                        --j;
                    }
                    ++i;
                    --k;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < uicp) {
                    if (controlPoints[i].length != dimension) {
                        throw new JgclInvalidArgumentValue();
                    }
                    cpArray[0][i][0] = controlPoints[i][0];
                    cpArray[0][i][1] = controlPoints[i][1];
                    cpArray[0][i][2] = controlPoints[i][2];
                    ++i;
                }
                i = 0;
                int k = lp;
                while (i < uicp) {
                    cpArray[1][k][0] = cpArray[0][lp][0];
                    cpArray[1][k][1] = cpArray[0][lp][1];
                    cpArray[1][k][2] = cpArray[0][lp][2];
                    int j = lp;
                    while (j > i) {
                        cpArray[0][j][0] = t1 * cpArray[0][j][0] + t2 * cpArray[0][j - 1][0];
                        cpArray[0][j][1] = t1 * cpArray[0][j][1] + t2 * cpArray[0][j - 1][1];
                        cpArray[0][j][2] = t1 * cpArray[0][j][2] + t2 * cpArray[0][j - 1][2];
                        --j;
                    }
                    ++i;
                    --k;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < uicp) {
                    if (controlPoints[i].length != dimension) {
                        throw new JgclInvalidArgumentValue();
                    }
                    cpArray[0][i][0] = controlPoints[i][0];
                    cpArray[0][i][1] = controlPoints[i][1];
                    cpArray[0][i][2] = controlPoints[i][2];
                    cpArray[0][i][3] = controlPoints[i][3];
                    ++i;
                }
                i = 0;
                int k = lp;
                while (i < uicp) {
                    cpArray[1][k][0] = cpArray[0][lp][0];
                    cpArray[1][k][1] = cpArray[0][lp][1];
                    cpArray[1][k][2] = cpArray[0][lp][2];
                    cpArray[1][k][3] = cpArray[0][lp][3];
                    int j = lp;
                    while (j > i) {
                        cpArray[0][j][0] = t1 * cpArray[0][j][0] + t2 * cpArray[0][j - 1][0];
                        cpArray[0][j][1] = t1 * cpArray[0][j][1] + t2 * cpArray[0][j - 1][1];
                        cpArray[0][j][2] = t1 * cpArray[0][j][2] + t2 * cpArray[0][j - 1][2];
                        cpArray[0][j][3] = t1 * cpArray[0][j][3] + t2 * cpArray[0][j - 1][3];
                        --j;
                    }
                    ++i;
                    --k;
                }
                break;
            }
            default: {
                int j;
                int i = 0;
                while (i < uicp) {
                    if (controlPoints[i].length != dimension) {
                        throw new JgclInvalidArgumentValue();
                    }
                    j = 0;
                    while (j < dimension) {
                        cpArray[0][i][j] = controlPoints[i][j];
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                int k = lp;
                while (i < uicp) {
                    j = 0;
                    while (j < dimension) {
                        cpArray[1][k][j] = cpArray[0][lp][j];
                        ++j;
                    }
                    j = lp;
                    while (j > i) {
                        int l = 0;
                        while (l < dimension) {
                            cpArray[0][j][l] = t1 * cpArray[0][j][l] + t2 * cpArray[0][j - 1][l];
                            ++l;
                        }
                        --j;
                    }
                    ++i;
                    --k;
                }
                break block0;
            }
        }
        return cpArray;
    }

    static void elevateOneDegree(int uicp, double[][] controlPoints) {
        int dimension = controlPoints[0].length;
        int j = 0;
        while (j < dimension) {
            controlPoints[uicp][j] = controlPoints[uicp - 1][j];
            ++j;
        }
        int i = uicp - 1;
        while (i >= 1) {
            double tF = (double)i / (double)uicp;
            double tR = 1.0 - tF;
            int j2 = 0;
            while (j2 < dimension) {
                controlPoints[i][j2] = tF * controlPoints[i - 1][j2] + tR * controlPoints[i][j2];
                ++j2;
            }
            --i;
        }
    }
}

