/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBinaryTree;
import jp.go.ipa.jgcl.JgclBoundedCurve3D;
import jp.go.ipa.jgcl.JgclBoundedLine3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclComplexPolynomial;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFreeformCurveWithControlPoints3D;
import jp.go.ipa.jgcl.JgclHomogeneousPoint3D;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsBzcBsc3D;
import jp.go.ipa.jgcl.JgclIntsBzcBzc3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMachineEpsilon;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnGeometryList;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPolynomialCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierCurveEvaluation;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclRealFunctionWithOneVariable;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;
import jp.go.ipa.jgcl.JgclZeroLength;

public class JgclPureBezierCurve3D
extends JgclFreeformCurveWithControlPoints3D {
    public JgclPureBezierCurve3D(JgclPoint3D[] controlPoints) {
        super(controlPoints);
    }

    public JgclPureBezierCurve3D(JgclPoint3D[] controlPoints, double[] weights) {
        super(controlPoints, weights);
    }

    public JgclPureBezierCurve3D(JgclPoint3D[] controlPoints, double[] weights, boolean doCheck) {
        super(controlPoints, weights, doCheck);
    }

    JgclPureBezierCurve3D(double[][] cpArray) {
        super(cpArray);
    }

    public int degree() {
        return this.nControlPoints() - 1;
    }

    public JgclRealPolynomial[] polynomial(boolean isPoly) {
        int uicp = this.nControlPoints();
        double[][] dDcoef = this.toDoubleArray(isPoly);
        int npoly = dDcoef[0].length;
        double[] coef = new double[uicp];
        JgclRealPolynomial[] polynomial = new JgclRealPolynomial[npoly];
        int klm = 0;
        while (klm < npoly) {
            int ijk = 0;
            while (ijk < uicp) {
                coef[ijk] = dDcoef[ijk][klm];
                ++ijk;
            }
            ijk = 0;
            while (ijk < uicp) {
                int mno = uicp - 1;
                while (ijk < mno) {
                    int n = mno;
                    coef[n] = coef[n] - coef[mno - 1];
                    --mno;
                }
                ++ijk;
            }
            int binml = 1;
            ijk = 1;
            int kji = uicp - 2;
            while (ijk < kji) {
                binml = binml * (uicp - ijk) / ijk;
                int n = ijk++;
                coef[n] = coef[n] * (double)binml;
                int n2 = kji--;
                coef[n2] = coef[n2] * (double)binml;
            }
            if (ijk == kji) {
                binml = binml * (uicp - ijk) / ijk;
                int n = ijk;
                coef[n] = coef[n] * (double)binml;
            }
            polynomial[klm] = new JgclRealPolynomial(coef);
            ++klm;
        }
        return polynomial;
    }

    public JgclPolynomialCurve3D polynomialCurve(boolean isPoly) {
        JgclRealPolynomial[] poly = this.polynomial(isPoly);
        if (isPoly) {
            return new JgclPolynomialCurve3D(poly[0], poly[1], poly[2]);
        }
        return new JgclPolynomialCurve3D(poly[0], poly[1], poly[2], poly[3]);
    }

    JgclParameterSection checkBoundary(JgclParameterSection pint) {
        this.checkValidity(pint);
        double start = pint.start();
        if (start < 0.0) {
            start = 0.0;
        } else if (start > 1.0) {
            start = 1.0;
        }
        double end = pint.end();
        if (end < 0.0) {
            end = 0.0;
        } else if (end > 1.0) {
            end = 1.0;
        }
        return new JgclParameterSection(start, end - start);
    }

    public double length(JgclParameterSection pint) {
        JgclRealFunctionWithOneVariable realFunction;
        pint = this.checkBoundary(pint);
        if (!this.isPolynomial()) {
            realFunction = new 1();
        } else {
            JgclRealPolynomial[] poly = this.polynomial(this.isPolynomial());
            JgclRealPolynomial[] deriv = new JgclRealPolynomial[poly.length];
            int ijk = 0;
            while (ijk < 3) {
                deriv[ijk] = poly[ijk].derive();
                ++ijk;
            }
            realFunction = new 2(deriv);
        }
        double dTol = this.getToleranceForDistance() / 2.0;
        return JgclMath.getDefiniteIntegral(realFunction, pint, dTol);
    }

    public JgclPoint3D coordinates(double param) {
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        double[] d0D = JgclPureBezierCurveEvaluation.coordinates(cntlPnts, param);
        if (!isPoly) {
            this.convRational0Deriv(d0D);
        }
        return new JgclCartesianPoint3D(d0D[0], d0D[1], d0D[2]);
    }

    public JgclVector3D tangentVector(double param) {
        double[] d1D = new double[4];
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        if (isPoly) {
            JgclPureBezierCurveEvaluation.evaluation(cntlPnts, param, null, d1D, null, null);
        } else {
            double[] d0D = new double[4];
            JgclPureBezierCurveEvaluation.evaluation(cntlPnts, param, d0D, d1D, null, null);
            this.convRational1Deriv(d0D, d1D);
        }
        return new JgclLiteralVector3D(d1D[0], d1D[1], d1D[2]);
    }

    public JgclCurveCurvature3D curvature(double param) {
        JgclVector3D dDnrm;
        double dDcrv;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double tol_d = condition.getToleranceForDistance();
        int degree = this.degree();
        JgclCurveDerivative3D deriv = this.evaluation(param);
        double tang_leng = deriv.d1D().norm();
        boolean tang0 = tang_leng < tol_d * tol_d;
        if (degree < 2 || tang0) {
            dDcrv = 0.0;
            dDnrm = JgclVector3D.zeroVector;
        } else {
            tang_leng = Math.sqrt(tang_leng);
            dDcrv = tang_leng * tang_leng * tang_leng;
            JgclVector3D ewvec = deriv.d1D().crossProduct(deriv.d2D());
            dDcrv = ewvec.magnitude() / dDcrv;
            dDnrm = ewvec.crossProduct(deriv.d1D()).unitized();
        }
        return new JgclCurveCurvature3D(dDcrv, dDnrm);
    }

    public double torsion(double param) {
        double dDtsn;
        JgclVector3D ewvec;
        double ewrk2;
        boolean curv0;
        double dDcrv;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double tol_d = condition.getToleranceForDistance();
        int degree = this.degree();
        JgclCurveDerivative3D deriv = this.evaluation(param);
        double tang_leng = deriv.d1D().norm();
        boolean tang0 = tang_leng < tol_d * tol_d;
        if (degree < 2 || tang0) {
            dDcrv = 0.0;
            curv0 = true;
            ewrk2 = 0.0;
            ewvec = null;
        } else {
            tang_leng = Math.sqrt(tang_leng);
            ewrk2 = dDcrv = tang_leng * tang_leng * tang_leng;
            ewvec = deriv.d1D().crossProduct(deriv.d2D());
            dDcrv = ewvec.magnitude() / dDcrv;
            curv0 = false;
        }
        if (degree < 3 || curv0) {
            dDtsn = 0.0;
        } else {
            double ewrk1 = ewvec.dotProduct(deriv.d3D());
            ewrk2 = ewrk2 * ewrk2 * dDcrv * dDcrv;
            dDtsn = ewrk1 / ewrk2;
        }
        return dDtsn;
    }

    public JgclCurveDerivative3D evaluation(double param) {
        double[] ld0D = new double[4];
        double[] ld1D = new double[4];
        double[] ld2D = new double[4];
        double[] ld3D = new double[4];
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        JgclPureBezierCurveEvaluation.evaluation(cntlPnts, param, ld0D, ld1D, ld2D, ld3D);
        if (!isPoly) {
            this.convRational3Deriv(ld0D, ld1D, ld2D, ld3D);
        }
        JgclCartesianPoint3D d0D = new JgclCartesianPoint3D(ld0D[0], ld0D[1], ld0D[2]);
        JgclLiteralVector3D d1D = new JgclLiteralVector3D(ld1D[0], ld1D[1], ld1D[2]);
        JgclLiteralVector3D d2D = new JgclLiteralVector3D(ld2D[0], ld2D[1], ld2D[2]);
        JgclLiteralVector3D d3D = new JgclLiteralVector3D(ld3D[0], ld3D[1], ld3D[2]);
        return new JgclCurveDerivative3D(d0D, d1D, d2D, d3D);
    }

    public JgclPoint3D blossoming(double[] parameters) {
        double[] adjustedParameters = new double[this.nControlPoints() - 1];
        int i = 0;
        while (i < this.nControlPoints() - 1) {
            adjustedParameters[i] = this.checkParameter(parameters[i]);
            ++i;
        }
        boolean isPoly = this.isPolynomial();
        double[] d0D = JgclPureBezierCurveEvaluation.blossoming(this.toDoubleArray(isPoly), adjustedParameters);
        if (isPoly) {
            return new JgclCartesianPoint3D(d0D[0], d0D[1], d0D[2]);
        }
        return new JgclHomogeneousPoint3D(d0D[0], d0D[1], d0D[2], d0D[3]);
    }

    public JgclPointOnCurve3D[] singular() throws JgclIndefiniteSolution {
        JgclComplex[] root;
        JgclComplexPolynomial dtPoly;
        int uicp = this.nControlPoints();
        int uicp_1 = uicp - 1;
        Vector<Double> paramVec = new Vector<Double>();
        Vector<JgclPoint3D> snglrVec = new Vector<JgclPoint3D>();
        int ijk = 1;
        while (ijk < uicp) {
            if (!this.startPoint().identical(this.controlPointAt(ijk))) break;
            ++ijk;
        }
        if (ijk == uicp) {
            throw new JgclIndefiniteSolution(this);
        }
        if (this.startPoint().identical(this.controlPointAt(1))) {
            paramVec.addElement(new Double(0.0));
            snglrVec.addElement(this.startPoint());
        }
        if (this.endPoint().identical(this.controlPointAt(uicp_1 - 1))) {
            paramVec.addElement(new Double(1.0));
            snglrVec.addElement(this.endPoint());
        }
        JgclRealPolynomial[] pointPoly = this.polynomial(this.isPolynomial());
        int polySize = pointPoly.length;
        JgclRealPolynomial[] tangPoly = new JgclRealPolynomial[polySize];
        JgclRealPolynomial[] dotePoly = new JgclRealPolynomial[3];
        int klm = 0;
        while (klm < polySize) {
            tangPoly[klm] = pointPoly[klm].derive();
            ++klm;
        }
        if (!this.isRational()) {
            klm = 0;
            while (klm < 3) {
                dotePoly[klm] = tangPoly[klm].multiply(tangPoly[klm]);
                ++klm;
            }
        } else {
            klm = 0;
            while (klm < 3) {
                JgclRealPolynomial work0 = pointPoly[3].multiply(tangPoly[klm]);
                JgclRealPolynomial work1 = tangPoly[3].multiply(pointPoly[klm]);
                JgclRealPolynomial work2 = work0.subtract(work1);
                double[] work3 = work2.coefficientsBetween(0, work2.degree() - 1);
                JgclRealPolynomial sub = new JgclRealPolynomial(work3);
                dotePoly[klm] = pointPoly[klm].multiply(sub);
                ++klm;
            }
        }
        try {
            dtPoly = dotePoly[0].add(dotePoly[1]).add(dotePoly[2]).toComplexPolynomial();
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        try {
            root = dtPoly.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            root = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
            throw new JgclFatal();
        }
        JgclParameterDomain pdmn = this.parameterDomain();
        double pTol = this.getToleranceForParameter();
        ijk = 0;
        while (ijk < dtPoly.degree()) {
            if (pdmn.isValid(root[ijk].real()) && !(root[ijk].real() < 0.0 - pTol) && !(root[ijk].real() > 1.0 + pTol)) {
                if (root[ijk].real() < 0.0) {
                    root[ijk] = new JgclComplex(0.0);
                }
                if (root[ijk].real() > 1.0) {
                    root[ijk] = new JgclComplex(1.0);
                }
                if (!(Math.abs(root[ijk].imag()) > 0.5)) {
                    JgclVector3D tangent;
                    JgclPoint3D point;
                    try {
                        point = this.coordinates(root[ijk].real());
                        tangent = this.tangentVector(root[ijk].real());
                    }
                    catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
                        throw new JgclFatal();
                    }
                    double dTol2 = this.getToleranceForDistance();
                    if (!(tangent.norm() > dTol2)) {
                        klm = 0;
                        while (klm < paramVec.size()) {
                            if (this.identicalParameter(root[ijk].real(), (Double)paramVec.elementAt(klm))) break;
                            ++klm;
                        }
                        if (klm >= paramVec.size()) {
                            paramVec.addElement(new Double(root[ijk].real()));
                            snglrVec.addElement(point);
                        }
                    }
                }
            }
            ++ijk;
        }
        JgclPointOnCurve3D[] singularPoint = new JgclPointOnCurve3D[paramVec.size()];
        ijk = 0;
        while (ijk < paramVec.size()) {
            singularPoint[ijk] = new JgclPointOnCurve3D(this, (Double)paramVec.elementAt(ijk), false);
            ++ijk;
        }
        return singularPoint;
    }

    public JgclPointOnCurve3D[] inflexion() throws JgclIndefiniteSolution {
        JgclComplex[] root;
        JgclCurveCurvature3D crv;
        int uicp = this.nControlPoints();
        int uicp_1 = uicp - 1;
        JgclPoint3D[] cp = this.controlPoints();
        if (uicp_1 < 2) {
            throw new JgclIndefiniteSolution(this);
        }
        Vector<Double> paramVec = new Vector<Double>();
        Vector<JgclCurveCurvature3D> crvVec = new Vector<JgclCurveCurvature3D>();
        JgclVector3D collinearDir = JgclPoint3D.collinear(cp, 0, uicp_1);
        if (collinearDir != null) {
            throw new JgclIndefiniteSolution(this);
        }
        collinearDir = JgclPoint3D.collinear(cp, 0, 2);
        if (collinearDir != null) {
            crv = this.curvature(0.0);
            paramVec.addElement(new Double(0.0));
            crvVec.addElement(crv);
        }
        if ((collinearDir = JgclPoint3D.collinear(cp, uicp_1 - 2, uicp_1)) != null) {
            crv = this.curvature(1.0);
            paramVec.addElement(new Double(1.0));
            crvVec.addElement(crv);
        }
        JgclPolynomialCurve3D polyCurve = this.polynomialCurve(this.isPolynomial());
        JgclRealPolynomial[] crossPoly = polyCurve.crossProductD1D2();
        int ijk = 0;
        while (ijk < crossPoly.length) {
            crossPoly[ijk] = crossPoly[ijk].multiply(crossPoly[ijk]).normalize();
            ++ijk;
        }
        JgclComplexPolynomial complexPoly = crossPoly[0].add(crossPoly[1]).add(crossPoly[2]).toComplexPolynomial();
        try {
            root = complexPoly.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            root = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
            throw new JgclFatal();
        }
        JgclParameterDomain pdmn = this.parameterDomain();
        ijk = 0;
        while (ijk < root.length) {
            if (pdmn.isValid(root[ijk].real())) {
                double pTol = this.getToleranceForParameter();
                if (!(root[ijk].real() < 0.0 - pTol) && !(root[ijk].real() > 1.0 + pTol)) {
                    if (root[ijk].real() < 0.0) {
                        root[ijk] = new JgclComplex(0.0);
                    }
                    if (root[ijk].real() > 1.0) {
                        root[ijk] = new JgclComplex(1.0);
                    }
                    crv = this.curvature(root[ijk].real());
                    double dTol = this.getToleranceForDistance();
                    if (!(Math.abs(crv.curvature()) > dTol)) {
                        double intvl = 1.0 / (double)uicp_1;
                        int klm = 0;
                        while (klm < paramVec.size()) {
                            if (Math.abs(root[ijk].real() - (Double)paramVec.elementAt(klm)) < intvl) {
                                int mno = 1;
                                while (mno < uicp_1) {
                                    double stake = (double)mno * intvl;
                                    if ((root[ijk].real() - stake) * (Double)paramVec.elementAt(klm) - stake < 0.0) break;
                                    ++mno;
                                }
                                if (mno == uicp_1) {
                                    if (!(Math.abs(crv.curvature()) < Math.abs((Double)crvVec.elementAt(klm)))) break;
                                    paramVec.addElement(new Double(root[ijk].real()));
                                    crvVec.addElement(crv);
                                    break;
                                }
                            }
                            ++klm;
                        }
                        if (klm >= paramVec.size()) {
                            paramVec.addElement(new Double(root[ijk].real()));
                            crvVec.addElement(crv);
                        }
                    }
                }
            }
            ++ijk;
        }
        JgclPointOnCurve3D[] inflexion = new JgclPointOnCurve3D[paramVec.size()];
        ijk = 0;
        while (ijk < paramVec.size()) {
            inflexion[ijk] = new JgclPointOnCurve3D(this, (Double)paramVec.elementAt(ijk), false);
            ++ijk;
        }
        return inflexion;
    }

    public JgclBsplineCurve3D toBsplineCurve() {
        double[] www = this.isRational() ? this.weights : this.makeUniformWeights();
        return new JgclBsplineCurve3D(JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment, this.controlPoints, www);
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
        return this.truncate(pint).toBsplineCurve();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
        JgclComplex[] roots;
        JgclComplexPolynomial compPoly;
        JgclAxis2Placement3D placement = new JgclAxis2Placement3D(mate.pnt(), mate.dir().verticalVector(), mate.dir());
        JgclCartesianTransformationOperator3D transform = new JgclCartesianTransformationOperator3D(placement, 1.0);
        int uicp = this.nControlPoints();
        JgclPoint3D[] newCp = new JgclPoint3D[uicp];
        int i = 0;
        while (i < uicp) {
            newCp[i] = transform.toLocal(this.controlPointAt(i));
            ++i;
        }
        double[] weights = this.weights();
        if (this.isRational()) {
            double max_weight = 0.0;
            int i2 = 0;
            while (i2 < uicp) {
                if (Math.abs(weights[i2]) > max_weight) {
                    max_weight = weights[i2];
                }
                ++i2;
            }
            if (max_weight > 0.0) {
                int i3 = 0;
                while (i3 < uicp) {
                    int n = i3++;
                    weights[n] = weights[n] / max_weight;
                }
            }
        }
        JgclPureBezierCurve3D bzc = new JgclPureBezierCurve3D(newCp, weights, false);
        JgclPoint3D[] anotherCp = new JgclPoint3D[uicp + 2];
        int m = 0;
        while (m < uicp) {
            anotherCp[m] = bzc.controlPointAt(m);
            ++m;
        }
        anotherCp[m++] = JgclPoint3D.origin;
        anotherCp[m] = new JgclCartesianPoint3D(1.0, 0.0, 0.0);
        JgclVector3D verticalVector = JgclPlane3D.coplaner(anotherCp);
        JgclPureBezierCurve3D oldBzc = null;
        if (verticalVector != null) {
            if (verticalVector.norm() < this.getToleranceForDistance()) {
                return new JgclIntersectionPoint3D[0];
            }
            JgclVector3D crossVector = verticalVector.crossProduct(JgclVector3D.xUnitVector).unitized();
            JgclCartesianTransformationOperator3D transformToPlane = new JgclCartesianTransformationOperator3D(JgclVector3D.xUnitVector, crossVector, verticalVector, JgclPoint3D.origin, 1.0);
            JgclPoint3D[] cpOnPlane = new JgclPoint3D[uicp];
            int i4 = 0;
            while (i4 < uicp) {
                cpOnPlane[i4] = transformToPlane.toLocal(anotherCp[i4]);
                ++i4;
            }
            oldBzc = bzc;
            bzc = new JgclPureBezierCurve3D(cpOnPlane, weights, false);
        }
        JgclRealPolynomial[] realPoly = bzc.polynomial(this.isPolynomial());
        if (oldBzc != null) {
            bzc = oldBzc;
            compPoly = realPoly[1].toComplexPolynomial();
        } else {
            JgclRealPolynomial yPoly = realPoly[1].multiply(realPoly[1]);
            JgclRealPolynomial zPoly = realPoly[2].multiply(realPoly[2]);
            compPoly = yPoly.add(zPoly).toComplexPolynomial();
        }
        try {
            roots = compPoly.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            roots = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
            throw new JgclFatal();
        }
        int nRoots = roots.length;
        Vector<Double> lineParam = new Vector<Double>();
        Vector<Double> bzcParam = new Vector<Double>();
        Vector<JgclPoint3D> bzcPoints = new Vector<JgclPoint3D>();
        int j = 0;
        while (j < nRoots) {
            double realRoot = roots[j].real();
            if (bzc.parameterValidity(realRoot) != 3) {
                if (realRoot < 0.0) {
                    realRoot = 0.0;
                }
                if (realRoot > 1.0) {
                    realRoot = 1.0;
                }
                JgclPoint3D workPoint = bzc.coordinates(realRoot);
                double dTol = bzc.getToleranceForDistance();
                int paramNum = bzcParam.size();
                if (workPoint.y() * workPoint.y() + workPoint.z() * workPoint.z() < this.getToleranceForDistance2()) {
                    int k = 0;
                    while (k < paramNum) {
                        double paramA = (Double)bzcParam.elementAt(k);
                        double paramB = (Double)lineParam.elementAt(k);
                        if (Math.abs(paramB - workPoint.x()) < dTol && bzc.identicalParameter(realRoot, paramA)) break;
                        ++k;
                    }
                    if (k >= paramNum) {
                        bzcParam.addElement(new Double(realRoot));
                        lineParam.addElement(new Double(workPoint.x()));
                        bzcPoints.addElement(transform.toEnclosed(workPoint));
                    }
                }
            }
            ++j;
        }
        int num = bzcParam.size();
        JgclIntersectionPoint3D[] intersectPoint = new JgclIntersectionPoint3D[num];
        double mateLength = mate.dir().length();
        int i5 = 0;
        while (i5 < num) {
            double work = (Double)lineParam.elementAt(i5) / mateLength;
            JgclPointOnCurve3D pointOnLine = new JgclPointOnCurve3D(mate, work, false);
            work = (Double)bzcParam.elementAt(i5);
            JgclPointOnCurve3D pointOnBzc = new JgclPointOnCurve3D(this, work, false);
            JgclPoint3D coordinates = (JgclPoint3D)bzcPoints.elementAt(i5);
            intersectPoint[i5] = !doExchange ? new JgclIntersectionPoint3D(coordinates, pointOnBzc, pointOnLine, false) : new JgclIntersectionPoint3D(coordinates, pointOnLine, pointOnBzc, false);
            ++i5;
        }
        return intersectPoint;
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        return JgclIntsBzcBzc3D.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        return JgclIntsBzcBsc3D.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    public JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate) {
        return mate.intersect(this, true);
    }

    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate) {
        return mate.interfere(this, true);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclPolyline3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclPureBezierCurve3D mate, boolean doExchange) {
        return JgclIntsBzcBzc3D.interference(this, mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBsplineCurve3D mate, boolean doExchange) {
        return JgclIntsBzcBsc3D.interference(this, mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclTrimmedCurve3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    public JgclPureBezierCurve3D[] divide(double param) {
        double[][][] bzcs_array;
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        try {
            bzcs_array = JgclPureBezierCurveEvaluation.divide(cntlPnts, param);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        JgclPureBezierCurve3D[] bzcs = new JgclPureBezierCurve3D[2];
        int i = 0;
        while (i < 2) {
            try {
                bzcs[i] = new JgclPureBezierCurve3D(bzcs_array[i]);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return bzcs;
    }

    public JgclPureBezierCurve3D truncate(JgclParameterSection section) {
        double start_par = this.checkParameter(section.lower());
        double end_par = this.checkParameter(section.upper());
        JgclPureBezierCurve3D t_bzc = this.divide(start_par)[1];
        end_par = (end_par - start_par) / (1.0 - start_par);
        t_bzc = t_bzc.divide(end_par)[0];
        if (section.increase() < 0.0) {
            t_bzc = t_bzc.reverse();
        }
        return t_bzc;
    }

    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D mate) {
        JgclComplex[] root;
        JgclComplexPolynomial dtPoly;
        JgclRealPolynomial[] pointPoly = this.polynomial(this.isPolynomial());
        JgclRealPolynomial[] offsPoly = new JgclRealPolynomial[3];
        int coef_size = pointPoly.length;
        if (this.isRational()) {
            offsPoly[0] = pointPoly[3].multiply(mate.x());
            offsPoly[1] = pointPoly[3].multiply(mate.y());
            offsPoly[2] = pointPoly[3].multiply(mate.z());
        } else {
            double[][] coef = new double[][]{{mate.x()}, {mate.y()}, {mate.z()}};
            offsPoly[0] = new JgclRealPolynomial(coef[0]);
            offsPoly[1] = new JgclRealPolynomial(coef[1]);
            offsPoly[2] = new JgclRealPolynomial(coef[2]);
        }
        int i = 0;
        while (i < 3) {
            pointPoly[i] = pointPoly[i].subtract(offsPoly[i]);
            ++i;
        }
        JgclRealPolynomial[] tangPoly = new JgclRealPolynomial[coef_size];
        JgclRealPolynomial[] dotePoly = new JgclRealPolynomial[3];
        int klm = 0;
        while (klm < coef_size) {
            tangPoly[klm] = pointPoly[klm].derive();
            ++klm;
        }
        if (!this.isRational()) {
            int klm2 = 0;
            while (klm2 < 3) {
                dotePoly[klm2] = pointPoly[klm2].multiply(tangPoly[klm2]);
                ++klm2;
            }
        } else {
            int klm3 = 0;
            while (klm3 < 3) {
                JgclRealPolynomial work0 = pointPoly[3].multiply(tangPoly[klm3]);
                JgclRealPolynomial work1 = tangPoly[3].multiply(pointPoly[klm3]);
                JgclRealPolynomial work2 = work0.subtract(work1);
                double[] work3 = work2.coefficientsBetween(0, work2.degree() - 1);
                JgclRealPolynomial sub = new JgclRealPolynomial(work3);
                dotePoly[klm3] = pointPoly[klm3].multiply(sub);
                ++klm3;
            }
        }
        JgclRealPolynomial rpoly = dotePoly[0].add(dotePoly[1]).add(dotePoly[2]);
        try {
            dtPoly = rpoly.toComplexPolynomial();
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        try {
            root = dtPoly.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            root = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
            throw new JgclFatal();
        }
        JgclPointOnGeometryList projList = new JgclPointOnGeometryList();
        JgclParameterDomain domain = this.parameterDomain();
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        int i2 = 0;
        while (i2 < root.length) {
            double par = root[i2].real();
            if (domain.isValid(par)) {
                JgclPointOnCurve3D proj;
                if (par > 1.0) {
                    par = 1.0;
                }
                if (par < 0.0) {
                    par = 0.0;
                }
                if ((proj = this.checkProjection(par, mate, dTol * dTol)) != null) {
                    projList.addPoint(proj);
                }
            }
            ++i2;
        }
        return projList.toJgclPointOnCurve3DArray();
    }

    public JgclPolyline3D toPolyline(JgclParameterSection section, JgclToleranceForDistance tolerance) {
        double tol = tolerance.value();
        double tol_2 = tol * tol;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double tol_p = condition.getToleranceForParameter();
        JgclPureBezierCurve3D root_bzc = this.truncate(section.positiveIncrease());
        double sp = this.checkParameter(section.lower());
        double ep = this.checkParameter(section.upper());
        IntervalInfo root_info = new IntervalInfo(root_bzc, sp, ep);
        JgclBinaryTree pnt_tree = new JgclBinaryTree(root_info);
        int no_pnts = this.divideInterval(2, pnt_tree.rootNode(), tol_2);
        JgclPoint3D[] pnts = new JgclPoint3D[no_pnts];
        FillInfo fill_info = new FillInfo(this, pnts, 0, tol_p, ep);
        pnt_tree.rootNode().preOrderTraverse(new fillArray(), fill_info);
        if (no_pnts == 2 && pnts[0].identical(pnts[1])) {
            throw new JgclZeroLength();
        }
        if (section.increase() > 0.0) {
            return new JgclPolyline3D(pnts);
        }
        return new JgclPolyline3D(pnts).reverse();
    }

    private int divideInterval(int no_pnts, JgclBinaryTree.Node crnt_node, double tol_2) {
        JgclPureBezierCurve3D[] div_bzcs;
        double half_point = 0.5;
        ++no_pnts;
        IntervalInfo crnt_info = (IntervalInfo)crnt_node.data();
        double mid_param = (crnt_info.sp() + crnt_info.ep()) / 2.0;
        try {
            div_bzcs = crnt_info.bzc().divide(half_point);
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        JgclPureBezierCurve3D left_bzc = div_bzcs[0];
        JgclPureBezierCurve3D right_bzc = div_bzcs[1];
        IntervalInfo left_info = new IntervalInfo(left_bzc, crnt_info.sp(), mid_param);
        JgclBinaryTree.Node left_node = crnt_node.makeLeft(left_info);
        IntervalInfo right_info = new IntervalInfo(right_bzc, mid_param, crnt_info.ep());
        JgclBinaryTree.Node right_node = crnt_node.makeRight(right_info);
        if (!this.checkInterval(left_info, tol_2)) {
            no_pnts = this.divideInterval(no_pnts, left_node, tol_2);
        }
        if (!this.checkInterval(right_info, tol_2)) {
            no_pnts = this.divideInterval(no_pnts, right_node, tol_2);
        }
        return no_pnts;
    }

    private boolean checkInterval(IntervalInfo bi, double tol_2) {
        JgclPureBezierCurve3D bzc = bi.bzc();
        int uicp_1 = bzc.nControlPoints() - 1;
        JgclVector3D edirs = bzc.controlPointAt(uicp_1).subtract(bzc.controlPointAt(0));
        int i = 1;
        while (i < uicp_1) {
            JgclPoint3D ppnt = this.projectPointLine(bzc.controlPointAt(i), bzc.controlPointAt(0), edirs);
            double dist = bzc.controlPointAt(i).subtract(ppnt).norm();
            if (dist > tol_2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private JgclPoint3D projectPointLine(JgclPoint3D dApnt, JgclPoint3D dB_pnt, JgclVector3D dB_dir) {
        double d;
        double m_eps = JgclMachineEpsilon.DOUBLE;
        double magni_dir = dB_dir.magnitude();
        JgclVector3D euvec = d < m_eps ? JgclVector3D.zeroVector : dB_dir.divide(magni_dir);
        JgclVector3D evpp = dApnt.subtract(dB_pnt);
        double edot = euvec.dotProduct(evpp);
        return dB_pnt.add(euvec.multiply(edot));
    }

    public JgclPoint3D startPoint() {
        return this.controlPointAt(0);
    }

    public JgclPoint3D endPoint() {
        int index = this.nControlPoints() - 1;
        return this.controlPointAt(index);
    }

    JgclPureBezierCurve3D reverse() {
        boolean isRat = this.isRational();
        int uicp = this.nControlPoints();
        JgclPoint3D[] rCp = new JgclPoint3D[uicp];
        double[] rWt = null;
        if (isRat) {
            rWt = new double[uicp];
        }
        int i = 0;
        int j = uicp - 1;
        while (i < uicp) {
            rCp[i] = this.controlPointAt(j);
            if (isRat) {
                rWt[i] = this.weightAt(j);
            }
            ++i;
            --j;
        }
        try {
            if (isRat) {
                return new JgclPureBezierCurve3D(rCp, rWt);
            }
            return new JgclPureBezierCurve3D(rCp);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        JgclPoint3D[] pnts = new JgclPoint3D[this.nControlPoints()];
        int i = 0;
        while (i < this.nControlPoints()) {
            pnts[i] = this.controlPointAt(i).add(moveVec);
            ++i;
        }
        if (this.isPolynomial()) {
            return new JgclPureBezierCurve3D(pnts);
        }
        return new JgclPureBezierCurve3D(pnts, this.weights);
    }

    JgclParameterDomain getParameterDomain() {
        try {
            return new JgclParameterDomain(false, 0.0, 1.0);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    private double checkParameter(double param) {
        this.checkValidity(param);
        return this.parameterDomain().force(param);
    }

    public JgclPureBezierCurve3D elevateOneDegree() {
        boolean isPoly = this.isPolynomial();
        int nCP = this.nControlPoints();
        double[][] newCP = JgclFreeformCurveWithControlPoints3D.allocateDoubleArray(isPoly, nCP + 1);
        this.setCoordinatesToDoubleArray(isPoly, nCP, newCP);
        JgclPureBezierCurveEvaluation.elevateOneDegree(nCP, newCP);
        return new JgclPureBezierCurve3D(newCP);
    }

    int type() {
        return 22;
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        int n_pnts = this.nControlPoints();
        JgclPoint3D[] pnts = new JgclPoint3D[n_pnts];
        int i = 0;
        while (i < n_pnts) {
            pnts[i] = this.controlPointAt(i).rotateZ(trns, rCos, rSin);
            ++i;
        }
        JgclPureBezierCurve3D result = this.isRational() ? new JgclPureBezierCurve3D(pnts, this.weights()) : new JgclPureBezierCurve3D(pnts);
        return result;
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        JgclVector3D vector;
        JgclPoint3D point;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol2 = condition.getToleranceForDistance2();
        int itry = 0;
        int limit = this.nControlPoints();
        do {
            if (itry >= limit) {
                throw new JgclFatal();
            }
            point = this.controlPointAt(itry);
            vector = point.subtract(line.project1From(point));
            ++itry;
        } while (point.isOn(line) || vector.norm() < dTol2);
        return point;
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D[] tControlPoints = JgclPoint3D.transform(this.controlPoints, reverseTransform, transformationOperator, transformedGeometries);
        if (this.isPolynomial()) {
            return new JgclPureBezierCurve3D(tControlPoints);
        }
        return new JgclPureBezierCurve3D(tControlPoints, this.weights);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        StringBuffer buf = new StringBuffer();
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tcontrolPoints");
        int i = 0;
        while (i < this.nControlPoints()) {
            this.controlPointAt(i).output(writer, indent + 2);
            ++i;
        }
        if (this.weights() != null) {
            writer.println(String.valueOf(indent_tab) + "\tweights ");
            int i2 = 0;
            while (true) {
                int j = 0;
                while (j < 10 && i2 < this.weights().length) {
                    writer.print(" " + this.weightAt(i2));
                    ++j;
                    ++i2;
                }
                writer.println();
                if (i2 >= this.weights().length) break;
                writer.print(String.valueOf(indent_tab) + "\t");
            }
        }
        writer.println(String.valueOf(indent_tab) + "End");
    }

    private final class 1
    implements JgclRealFunctionWithOneVariable {
        public double evaluate(double parameter) {
            return JgclPureBezierCurve3D.this.tangentVector(parameter).length();
        }

        /* synthetic */ 1() {
        }
    }

    private static final class 2
    implements JgclRealFunctionWithOneVariable {
        private final /* synthetic */ JgclRealPolynomial[] val$deriv;

        public double evaluate(double parameter) {
            double[] tang = new double[3];
            int ijk = 0;
            while (ijk < 3) {
                tang[ijk] = this.val$deriv[ijk].evaluate(parameter);
                ++ijk;
            }
            return Math.sqrt(tang[0] * tang[0] + tang[1] * tang[1] + tang[2] * tang[2]);
        }

        /* synthetic */ 2(JgclRealPolynomial[] val$deriv) {
            this.val$deriv = val$deriv;
        }
    }

    private class IntervalInfo {
        private JgclPureBezierCurve3D bzc;
        private double sp;
        private double ep;

        private IntervalInfo(JgclPureBezierCurve3D bzc, double sp, double ep) {
            JgclPureBezierCurve3D.this = JgclPureBezierCurve3D.this;
            this.bzc = bzc;
            this.sp = sp;
            this.ep = ep;
        }

        private JgclPureBezierCurve3D bzc() {
            return this.bzc;
        }

        private double sp() {
            return this.sp;
        }

        private double ep() {
            return this.ep;
        }
    }

    private class FillInfo {
        private JgclParametricCurve3D basisCurve;
        private JgclPoint3D[] pnts;
        private int index;
        private double tol_p;
        private double ep;

        private FillInfo(JgclParametricCurve3D basisCurve, JgclPoint3D[] pnts, int index, double tol_p, double ep) {
            JgclPureBezierCurve3D.this = JgclPureBezierCurve3D.this;
            this.basisCurve = basisCurve;
            this.pnts = pnts;
            this.index = index;
            this.tol_p = tol_p;
            this.ep = ep;
        }
    }

    private class fillArray
    implements JgclBinaryTree.TraverseProc {
        public boolean doit(JgclBinaryTree.Node node, int ctl, Object pdata) {
            if (node.left() == null && node.right() == null) {
                try {
                    FillInfo fill_info = (FillInfo)pdata;
                    int idx = fill_info.index;
                    IntervalInfo bi = (IntervalInfo)node.data();
                    ((FillInfo)fill_info).pnts[idx++] = new JgclPointOnCurve3D(bi.bzc().controlPointAt(0), fill_info.basisCurve, bi.sp());
                    if (idx == fill_info.pnts.length - 1) {
                        ((FillInfo)fill_info).pnts[idx++] = new JgclPointOnCurve3D(bi.bzc().controlPointAt(bi.bzc().nControlPoints() - 1), fill_info.basisCurve, bi.ep());
                    }
                    fill_info.index = idx;
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
            }
            return false;
        }

        fillArray() {
            JgclPureBezierCurve3D.this = JgclPureBezierCurve3D.this;
        }
    }
}

