/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedCurve3D;
import jp.go.ipa.jgcl.JgclBoundedLine3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclCurveSurfaceInterferenceList;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclEnclosingBox3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsPolPol3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnGeometryList;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclSelfIntsPol3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;
import jp.go.ipa.jgcl.JgclZeroLength;

public class JgclPolyline3D
extends JgclBoundedCurve3D {
    private static final boolean CHECK_SAME_POINTS = false;
    private JgclPoint3D[] points;
    private boolean closed;

    private void setPoints(JgclPoint3D[] points, boolean closed) {
        if (!closed && points.length < 2 || closed && points.length < 3) {
            throw new JgclInvalidArgumentValue();
        }
        this.closed = closed;
        this.points = new JgclPoint3D[points.length];
        this.points[0] = points[0];
        int i = 1;
        while (i < points.length) {
            this.points[i] = points[i];
            ++i;
        }
    }

    public JgclPolyline3D(JgclPoint3D[] points, boolean closed) {
        this.setPoints(points, closed);
    }

    public JgclPolyline3D(JgclPoint3D[] points) {
        this.setPoints(points, false);
    }

    public JgclPolyline3D(JgclBoundedCurve3D curve, JgclToleranceForDistance tol) {
        JgclPolyline3D pl = curve.toPolyline(tol);
        this.points = pl.points;
        this.closed = pl.closed;
    }

    public JgclPolyline3D(JgclParametricCurve3D curve, JgclParameterSection pint, JgclToleranceForDistance tol) {
        JgclPolyline3D pl = curve.toPolyline(pint, tol);
        this.points = pl.points;
        this.closed = pl.closed;
    }

    public JgclPoint3D[] points() {
        JgclPoint3D[] pnts = new JgclPoint3D[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            pnts[i] = this.points[i];
            ++i;
        }
        return pnts;
    }

    public JgclPoint3D pointAt(int i) {
        if (this.closed() && i == this.nPoints()) {
            return this.points[0];
        }
        return this.points[i];
    }

    public boolean closed() {
        return this.closed;
    }

    public int nPoints() {
        return this.points.length;
    }

    public int nSegments() {
        if (this.closed()) {
            return this.nPoints();
        }
        return this.nPoints() - 1;
    }

    private PolyParam checkParameter(double param) {
        int n;
        PolyParam p = new PolyParam();
        int n2 = n = this.closed ? this.points.length : this.points.length - 1;
        if (this.closed) {
            param = this.parameterDomain().wrap(param);
        } else {
            this.checkValidity(param);
        }
        int idx = (int)Math.floor(param);
        if (idx < 0) {
            idx = 0;
        }
        if (n - 1 < idx) {
            idx = n - 1;
        }
        p.sp = this.points[idx];
        p.ep = idx + 1 == this.points.length ? this.points[0] : this.points[idx + 1];
        p.weight = param - (double)idx;
        p.param = param;
        p.index = idx;
        return p;
    }

    public double length(JgclParameterSection pint) {
        if (pint.increase() < 0.0) {
            return this.length(new JgclParameterSection(pint.end(), -pint.increase()));
        }
        LengthAccumulator acc = new LengthAccumulator();
        acc.accumulate(pint);
        return acc.extract();
    }

    public JgclPoint3D coordinates(double param) {
        PolyParam p = this.checkParameter(param);
        return p.ep.linearInterpolate(p.sp, p.weight);
    }

    public JgclVector3D tangentVector(double param) {
        PolyParam p = this.checkParameter(param);
        return p.ep.subtract(p.sp);
    }

    public JgclCurveCurvature3D curvature(double param) {
        this.checkParameter(param);
        return new JgclCurveCurvature3D(0.0, JgclVector3D.zeroVector());
    }

    public double torsion(double param) {
        this.checkParameter(param);
        return 0.0;
    }

    public JgclCurveDerivative3D evaluation(double param) {
        return new JgclCurveDerivative3D(this.coordinates(param), this.tangentVector(param), JgclVector3D.zeroVector(), JgclVector3D.zeroVector());
    }

    public JgclPointOnCurve3D[] singular() {
        SingularAccumulator acc = new SingularAccumulator(this);
        acc.accumulate(this.parameterDomain().section());
        return acc.extract();
    }

    public JgclPointOnCurve3D[] inflexion() {
        return new JgclPointOnCurve3D[0];
    }

    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point) {
        double dTol = this.getToleranceForDistance();
        ProjectionAccumulator acc = new ProjectionAccumulator(this, point, dTol);
        try {
            acc.accumulate(this.parameterDomain().section());
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        return acc.extract();
    }

    public JgclPolyline3D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        if (pint.increase() < 0.0) {
            return this.toPolyline(pint.reverse(), tol).reverse();
        }
        ToPolylineAccumulator acc = new ToPolylineAccumulator(this);
        acc.accumulate(pint);
        return acc.extract();
    }

    public JgclBsplineCurve3D toBsplineCurve() {
        int ik;
        int degree = 1;
        boolean periodic = this.closed();
        int uicp = this.nPoints();
        int uik = !periodic ? uicp : uicp + 2;
        int[] knotMultiplicities = new int[uik];
        double[] knots = new double[uik];
        JgclPoint3D[] controlPoints = new JgclPoint3D[uicp];
        double[] weights = new double[uicp];
        int n = ik = !periodic ? 0 : 1;
        if (!periodic) {
            ik = 0;
        } else {
            ik = 1;
            knots[0] = -1.0;
            knots[uik - 1] = uicp + 1;
            knotMultiplicities[0] = 1;
            knotMultiplicities[uik - 1] = 1;
        }
        int i = 0;
        while (i < uicp) {
            knots[ik] = i;
            knotMultiplicities[ik] = !periodic && (i == 0 || i == this.nPoints() - 1) ? 2 : 1;
            controlPoints[i] = this.pointAt(i);
            weights[i] = 1.0;
            ++i;
            ++ik;
        }
        return new JgclBsplineCurve3D(degree, periodic, knotMultiplicities, knots, controlPoints, weights);
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
        JgclPolyline3D target;
        if (this.closed()) {
            if (pint.absIncrease() >= this.parameterDomain().section().absIncrease()) {
                target = this;
                if (pint.increase() < 0.0) {
                    target = target.reverse();
                }
            } else {
                target = this.toPolyline(pint, this.getToleranceForDistanceAsObject());
            }
        } else {
            target = this.toPolyline(pint, this.getToleranceForDistanceAsObject());
        }
        return target.toBsplineCurve();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    private double segLength(int nseg, int segIdx) {
        if (this.closed()) {
            while (segIdx < 0) {
                segIdx += nseg;
            }
            while (segIdx > nseg - 1) {
                segIdx -= nseg;
            }
        }
        int head_pnt_idx = segIdx;
        int tail_pnt_idx = this.closed() && head_pnt_idx == this.nSegments() ? 0 : head_pnt_idx + 1;
        return this.points[head_pnt_idx].distance(this.points[tail_pnt_idx]);
    }

    /*
     * Unable to fully structure code
     */
    private JgclIntersectionPoint3D[] doIntersect(JgclParametricCurve3D mate, boolean doExchange) {
        nSeg = this.nSegments();
        intf = new JgclCurveCurveInterferenceList(this, mate);
        i = 0;
        while (i < nSeg) {
            block13: {
                try {
                    realSegment = new JgclLine3D(this.pointAt(i), this.pointAt(i + 1));
                    segment = new JgclBoundedLine3D(this.pointAt(i), this.pointAt(i + 1));
                }
                catch (JgclInvalidArgumentValue v0) {
                    break block13;
                }
                try {
                    segIntersect = realSegment.intersect(mate);
                }
                catch (JgclIndefiniteSolution v1) {
                    segIntersect = new JgclIntersectionPoint3D[1];
                    segmentMidPoint = realSegment.coordinates(0.5);
                    paramOnMate = mate.pointToParameter(segmentMidPoint);
                    segIntersect[0] = new JgclIntersectionPoint3D(realSegment, 0.5, mate, paramOnMate, false);
                }
                if (segIntersect == null || segIntersect.length == 0) break block13;
                segResolution = segIntersect.length;
                j = 0;
                while (j < segResolution) {
                    point = segIntersect[j].coordinates();
                    segParam = segIntersect[j].pointOnCurve1().parameter();
                    validity = segment.parameterValidity(segParam);
                    switch (validity) {
                        case 1: {
                            if (segParam < 0.0) {
                                segParam = !this.closed() && i == 0 ? 0.0 : this.segLength(nSeg, i) * segParam / this.segLength(nSeg, i - 1);
                            }
                            ** GOTO lbl34
                        }
                        case 2: {
                            if (segParam > 1.0) {
                                segParam = this.closed() == false && i == nSeg - 1 ? 1.0 : 1.0 + this.segLength(nSeg, i) * (segParam - 1.0) / this.segLength(nSeg, i + 1);
                            }
                        }
lbl34:
                        // 5 sources

                        default: {
                            intf.addAsIntersection(point, segParam + (double)i, segIntersect[j].pointOnCurve2().parameter());
                        }
                        case 3: 
                    }
                    ++j;
                }
            }
            ++i;
        }
        return intf.toJgclIntersectionPoint3DArray(doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        return JgclIntsPolPol3D.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] doIntersect(JgclParametricSurface3D mate, boolean doExchange) {
        IntersectWithSurfaceAccumulator acc = new IntersectWithSurfaceAccumulator(this, mate);
        acc.accumulate(this.parameterDomain().section());
        return acc.extract(doExchange);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) {
        return this.doIntersect(mate, false);
    }

    JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclPolyline3D mate, boolean doExchange) {
        if (!doExchange) {
            return JgclIntsPolPol3D.interference(this, mate);
        }
        return JgclIntsPolPol3D.interference(mate, this);
    }

    private JgclCurveCurveInterference3D[] convertInterferences(JgclCurveCurveInterference3D[] sourceInterferences, boolean doExchange) {
        Vector<JgclCurveCurveInterference3D> resultVector = new Vector<JgclCurveCurveInterference3D>();
        int i = 0;
        while (i < sourceInterferences.length) {
            JgclCurveCurveInterference3D intf = !doExchange ? sourceInterferences[i].changeCurve1(this) : sourceInterferences[i].changeCurve2(this);
            if (intf != null) {
                resultVector.addElement(intf);
            }
            ++i;
        }
        Object[] result = new JgclCurveCurveInterference3D[resultVector.size()];
        resultVector.copyInto(result);
        return result;
    }

    JgclCurveCurveInterference3D[] interfere(JgclPureBezierCurve3D mate, boolean doExchange) {
        return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange), doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBsplineCurve3D mate, boolean doExchange) {
        return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange), doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclTrimmedCurve3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    public JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate) {
        return mate.interfere(this, true);
    }

    public JgclIntersectionPoint3D[] selfIntersect() {
        return JgclSelfIntsPol3D.intersection(this);
    }

    public JgclCurveCurveInterference3D[] selfInterfere() {
        return JgclSelfIntsPol3D.interference(this);
    }

    JgclPolyline3D reverse() {
        int i;
        int uip = this.nPoints();
        JgclPoint3D[] rPnts = new JgclPoint3D[uip];
        if (this.closed) {
            rPnts[0] = this.points[0];
            i = 1;
        } else {
            i = 0;
        }
        int j = uip - 1;
        while (i < uip) {
            rPnts[i] = this.points[j];
            ++i;
            --j;
        }
        return new JgclPolyline3D(rPnts, this.closed);
    }

    JgclEnclosingBox3D enclosingBox() {
        double min_crd_z;
        double min_crd_y;
        double min_crd_x;
        double max_crd_x = min_crd_x = this.pointAt(0).x();
        double max_crd_y = min_crd_y = this.pointAt(0).y();
        double max_crd_z = min_crd_z = this.pointAt(0).z();
        int i = 1;
        while (i < this.nPoints()) {
            min_crd_x = Math.min(min_crd_x, this.pointAt(i).x());
            min_crd_y = Math.min(min_crd_y, this.pointAt(i).y());
            min_crd_z = Math.min(min_crd_z, this.pointAt(i).z());
            max_crd_x = Math.max(max_crd_x, this.pointAt(i).x());
            max_crd_y = Math.max(max_crd_y, this.pointAt(i).y());
            max_crd_z = Math.max(max_crd_z, this.pointAt(i).z());
            ++i;
        }
        return new JgclEnclosingBox3D(min_crd_x, min_crd_y, min_crd_z, max_crd_x, max_crd_y, max_crd_z);
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        JgclPoint3D[] pnts = new JgclPoint3D[this.nPoints()];
        int i = 0;
        while (i < this.nPoints()) {
            pnts[i] = this.pointAt(i).add(moveVec);
            ++i;
        }
        return new JgclPolyline3D(pnts, this.closed);
    }

    JgclParameterDomain getParameterDomain() {
        double n = this.closed ? this.points.length : this.points.length - 1;
        try {
            return new JgclParameterDomain(this.closed, 0.0, n);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    public boolean isFreeform() {
        return true;
    }

    public JgclPoint3D startPoint() {
        if (this.isPeriodic()) {
            return null;
        }
        return this.points[0];
    }

    public JgclPoint3D endPoint() {
        if (this.isPeriodic()) {
            return null;
        }
        return this.points[this.points.length - 1];
    }

    int type() {
        return 20;
    }

    public JgclBoundedLine3D[] toBoundedLines(JgclParameterSection pint) {
        ToBoundedLinesAccumulator acc = new ToBoundedLinesAccumulator(pint.increase() < 0.0);
        acc.accumulate(pint);
        return acc.extract();
    }

    public JgclBoundedLine3D[] toBoundedLines() {
        return this.toBoundedLines(this.parameterDomain().section());
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        int n_pnts = this.nPoints();
        JgclPoint3D[] pnts = new JgclPoint3D[n_pnts];
        int i = 0;
        while (i < n_pnts) {
            pnts[i] = this.pointAt(i).rotateZ(trns, rCos, rSin);
            ++i;
        }
        return new JgclPolyline3D(pnts, this.closed());
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        JgclVector3D vector;
        JgclPoint3D point;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol2 = condition.getToleranceForDistance2();
        int itry = 0;
        int limit = this.nPoints();
        do {
            if (itry >= limit) {
                throw new JgclFatal();
            }
            point = this.pointAt(itry);
            vector = point.subtract(line.project1From(point));
            ++itry;
        } while (point.isOn(line) || vector.norm() < dTol2);
        return point;
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D[] tPoints = JgclPoint3D.transform(this.points, reverseTransform, transformationOperator, transformedGeometries);
        return new JgclPolyline3D(tPoints, this.closed);
    }

    protected boolean hasPolyline() {
        return true;
    }

    protected boolean isComposedOfOnlyPolylines() {
        return true;
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tpoints");
        int i = 0;
        while (i < this.nPoints()) {
            this.points[i].output(writer, indent + 2);
            ++i;
        }
        writer.println(String.valueOf(indent_tab) + "\tclosed\t" + this.closed);
        writer.println(String.valueOf(indent_tab) + "End");
    }

    private class PolyParam {
        JgclPoint3D sp;
        JgclPoint3D ep;
        double weight;
        double param;
        int index;

        PolyParam() {
            JgclPolyline3D.this = JgclPolyline3D.this;
        }
    }

    private abstract class LineSegmentAccumulator {
        abstract void doit(JgclPoint3D var1, JgclPoint3D var2, double var3, double var5);

        abstract void allocate(int var1);

        void accumulate(JgclParameterSection pint) {
            PolyParam sPolyParam = JgclPolyline3D.this.checkParameter(pint.start());
            PolyParam ePolyParam = JgclPolyline3D.this.checkParameter(pint.end());
            JgclParameterDomain domain = JgclPolyline3D.this.parameterDomain();
            boolean wrapAround = domain.isPeriodic() ? sPolyParam.param > ePolyParam.param : false;
            if (wrapAround) {
                this.allocate(JgclPolyline3D.this.nPoints() - sPolyParam.index + ePolyParam.index);
                JgclPoint3D sPoint = JgclPolyline3D.this.coordinates(sPolyParam.param);
                JgclPoint3D ePoint = sPolyParam.ep;
                this.doit(sPoint, ePoint, sPolyParam.param, (double)sPolyParam.index + 1.0);
                int seg = sPolyParam.index + 1;
                while (seg < JgclPolyline3D.this.nPoints()) {
                    int wrappedSeg1 = (seg + 1) % JgclPolyline3D.this.nPoints();
                    this.doit(JgclPolyline3D.this.points[seg], JgclPolyline3D.this.points[wrappedSeg1], seg, seg + 1);
                    ++seg;
                }
                int seg2 = 0;
                while (seg2 < ePolyParam.index) {
                    int wrappedSeg1 = (seg2 + 1) % JgclPolyline3D.this.nPoints();
                    this.doit(JgclPolyline3D.this.points[seg2], JgclPolyline3D.this.points[wrappedSeg1], seg2, seg2 + 1);
                    ++seg2;
                }
                sPoint = ePolyParam.sp;
                ePoint = JgclPolyline3D.this.coordinates(ePolyParam.param);
                this.doit(sPoint, ePoint, ePolyParam.index, ePolyParam.param);
            } else if (sPolyParam.index == ePolyParam.index) {
                this.allocate(1);
                JgclPoint3D sPoint = JgclPolyline3D.this.coordinates(sPolyParam.param);
                JgclPoint3D ePoint = JgclPolyline3D.this.coordinates(ePolyParam.param);
                this.doit(sPoint, ePoint, sPolyParam.param, ePolyParam.param);
            } else {
                this.allocate(ePolyParam.index - sPolyParam.index + 1);
                JgclPoint3D sPoint = JgclPolyline3D.this.coordinates(sPolyParam.param);
                JgclPoint3D ePoint = sPolyParam.ep;
                this.doit(sPoint, ePoint, sPolyParam.param, (double)sPolyParam.index + 1.0);
                int seg = sPolyParam.index + 1;
                while (seg < ePolyParam.index) {
                    this.doit(JgclPolyline3D.this.points[seg], JgclPolyline3D.this.points[seg + 1], seg, seg + 1);
                    ++seg;
                }
                sPoint = ePolyParam.sp;
                ePoint = JgclPolyline3D.this.coordinates(ePolyParam.param);
                this.doit(sPoint, ePoint, ePolyParam.index, ePolyParam.param);
            }
        }

        LineSegmentAccumulator() {
            JgclPolyline3D.this = JgclPolyline3D.this;
        }
    }

    private class LengthAccumulator
    extends LineSegmentAccumulator {
        double leng;

        void allocate(int nsegs) {
            this.leng = 0.0;
        }

        void doit(JgclPoint3D sp, JgclPoint3D ep, double sParam, double eParam) {
            this.leng += sp.distance(ep);
        }

        double extract() {
            return this.leng;
        }

        LengthAccumulator() {
            JgclPolyline3D.this = JgclPolyline3D.this;
        }
    }

    private class SingularAccumulator
    extends LineSegmentAccumulator {
        private JgclParametricCurve3D curve;
        private Vector singularVec;
        private JgclVector3D prevTangVec;

        SingularAccumulator(JgclParametricCurve3D curve) {
            JgclPolyline3D.this = JgclPolyline3D.this;
            this.curve = curve;
        }

        void allocate(int nsegs) {
            this.singularVec = new Vector();
            this.prevTangVec = null;
        }

        void doit(JgclPoint3D sp, JgclPoint3D ep, double sParam, double eParam) {
            JgclVector3D tangVec = ep.subtract(sp);
            if (this.prevTangVec != null && !tangVec.identicalDirection(this.prevTangVec)) {
                JgclPointOnCurve3D candidate = new JgclPointOnCurve3D(this.curve, sParam, false);
                this.singularVec.addElement(candidate);
            }
            this.prevTangVec = tangVec;
        }

        JgclPointOnCurve3D[] extract() {
            Object[] singular = new JgclPointOnCurve3D[this.singularVec.size()];
            this.singularVec.copyInto(singular);
            return singular;
        }
    }

    private class ProjectionAccumulator
    extends LineSegmentAccumulator {
        JgclPointOnGeometryList projList;
        JgclPoint3D point;
        double dTol;
        JgclPolyline3D curv;

        ProjectionAccumulator(JgclPolyline3D curv, JgclPoint3D point, double dTol) {
            JgclPolyline3D.this = JgclPolyline3D.this;
            this.point = point;
            this.dTol = dTol;
            this.curv = curv;
        }

        void allocate(int nsegs) {
            this.projList = new JgclPointOnGeometryList();
        }

        void doit(JgclPoint3D sp, JgclPoint3D ep, double sParam, double eParam) {
            JgclLine3D line;
            try {
                line = new JgclLine3D(sp, ep);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                return;
            }
            JgclPointOnCurve3D proj = line.project1From(this.point);
            double length = line.dir().length();
            double param = proj.parameter();
            double fromSp = param * length;
            if (-this.dTol <= fromSp && fromSp <= length + this.dTol) {
                if (param < 0.0) {
                    param = 0.0;
                } else if (param > 1.0) {
                    param = 1.0;
                }
                double p2 = sParam + (eParam - sParam) * param;
                JgclPointOnCurve3D proj2 = new JgclPointOnCurve3D(this.curv, p2, false);
                this.projList.addPoint(this.curv, p2);
            }
        }

        JgclPointOnCurve3D[] extract() {
            return this.projList.toJgclPointOnCurve3DArray();
        }
    }

    private class ToPolylineAccumulator
    extends LineSegmentAccumulator {
        Vector pntVec;
        JgclPoint3D lastPoint;
        JgclPolyline3D curv;

        ToPolylineAccumulator(JgclPolyline3D curv) {
            JgclPolyline3D.this = JgclPolyline3D.this;
            this.curv = curv;
        }

        void allocate(int nsegs) {
            this.pntVec = new Vector();
            this.lastPoint = null;
        }

        void doit(JgclPoint3D sp, JgclPoint3D ep, double sParam, double eParam) {
            JgclPointOnCurve3D newPoint;
            if (this.lastPoint == null) {
                this.lastPoint = new JgclPointOnCurve3D(this.curv, sParam, false);
                this.pntVec.addElement(this.lastPoint);
            }
            if (!(newPoint = new JgclPointOnCurve3D(this.curv, eParam, false)).identical(this.lastPoint)) {
                this.pntVec.addElement(newPoint);
                this.lastPoint = newPoint;
            }
        }

        JgclPolyline3D extract() {
            int nPnts = this.pntVec.size();
            if (nPnts < 2) {
                throw new JgclZeroLength();
            }
            Object[] pntsArray = new JgclPoint3D[nPnts];
            this.pntVec.copyInto(pntsArray);
            return new JgclPolyline3D((JgclPoint3D[])pntsArray);
        }
    }

    private class IntersectWithSurfaceAccumulator
    extends LineSegmentAccumulator {
        JgclPolyline3D curve;
        JgclParametricSurface3D surface;
        JgclCurveSurfaceInterferenceList intfList;

        IntersectWithSurfaceAccumulator(JgclPolyline3D curve, JgclParametricSurface3D surface) {
            JgclPolyline3D.this = JgclPolyline3D.this;
            this.curve = curve;
            this.surface = surface;
        }

        void allocate(int nsegs) {
            this.intfList = new JgclCurveSurfaceInterferenceList(this.curve, this.surface);
        }

        void doit(JgclPoint3D sp, JgclPoint3D ep, double sParam, double eParam) {
            JgclIntersectionPoint3D[] intp;
            JgclLine3D line;
            try {
                line = new JgclLine3D(sp, ep);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                return;
            }
            double dTol = JgclPolyline3D.this.getToleranceForDistance();
            double segtol = Math.abs(line.dir().norm());
            segtol = segtol < dTol ? -1.0 : dTol / segtol;
            try {
                intp = line.intersect(this.surface);
            }
            catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                throw new JgclFatal();
            }
            int i = 0;
            while (i < intp.length) {
                double crvParam = ((JgclPointOnCurve3D)intp[i].pointOnGeometry1()).parameter();
                double srfUParam = ((JgclPointOnSurface3D)intp[i].pointOnGeometry2()).uParameter();
                double srfVParam = ((JgclPointOnSurface3D)intp[i].pointOnGeometry2()).vParameter();
                if (!(crvParam < 0.0 - segtol) && !(crvParam > 1.0 + segtol)) {
                    if (crvParam < 0.0) {
                        crvParam = 0.0;
                    }
                    if (crvParam > 1.0) {
                        crvParam = 1.0;
                    }
                    this.intfList.addAsIntersection(intp[i].coordinates(), crvParam += sParam, srfUParam, srfVParam);
                }
                ++i;
            }
        }

        JgclIntersectionPoint3D[] extract(boolean doExchange) {
            return this.intfList.toJgclIntersectionPoint3DArray(doExchange);
        }
    }

    private class ToBoundedLinesAccumulator
    extends LineSegmentAccumulator {
        JgclBoundedLine3D[] boundedLines;
        int index;
        boolean rvrs;

        ToBoundedLinesAccumulator(boolean reverse) {
            JgclPolyline3D.this = JgclPolyline3D.this;
            this.rvrs = reverse;
        }

        void allocate(int nsegs) {
            this.boundedLines = new JgclBoundedLine3D[nsegs];
            this.index = !this.rvrs ? 0 : nsegs - 1;
        }

        void doit(JgclPoint3D sp, JgclPoint3D ep, double sParam, double eParam) {
            if (!this.rvrs) {
                this.boundedLines[this.index++] = new JgclBoundedLine3D(sp, ep, false);
            } else {
                this.boundedLines[this.index--] = new JgclBoundedLine3D(ep, sp, false);
            }
        }

        JgclBoundedLine3D[] extract() {
            return this.boundedLines;
        }
    }
}

