/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclPoint1D;

class JgclPolyline1D {
    private static final boolean CHECK_SAME_POINTS = false;
    private JgclPoint1D[] points;
    private boolean closed;
    JgclParameterDomain parameterDomain;

    JgclParameterDomain getParameterDomain() {
        double n = this.closed ? this.points.length : this.points.length - 1;
        try {
            return new JgclParameterDomain(this.closed, 0.0, n);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    private void setPoints(JgclPoint1D[] points, boolean closed) {
        if (!closed && points.length < 2 || closed && points.length < 3) {
            throw new JgclInvalidArgumentValue();
        }
        this.closed = closed;
        this.points = new JgclPoint1D[points.length];
        this.points[0] = points[0];
        int i = 1;
        while (i < points.length) {
            this.points[i] = points[i];
            ++i;
        }
    }

    public JgclPolyline1D(JgclPoint1D[] points, boolean closed) {
        this.setPoints(points, closed);
    }

    public JgclPolyline1D(JgclPoint1D[] points) {
        this.setPoints(points, false);
    }

    public JgclPoint1D[] points() {
        JgclPoint1D[] pnts = new JgclPoint1D[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            pnts[i] = this.points[i];
            ++i;
        }
        return pnts;
    }

    public JgclPoint1D pointAt(int n) {
        if (this.closed() && n == this.nPoints()) {
            return this.points[0];
        }
        return this.points[n];
    }

    public boolean closed() {
        return this.closed;
    }

    public int nPoints() {
        return this.points.length;
    }

    public int nSegments() {
        if (this.closed()) {
            return this.nPoints();
        }
        return this.nPoints() - 1;
    }

    JgclParameterDomain parameterDomain() {
        return this.parameterDomain;
    }

    public void checkValidity(double value) {
        this.parameterDomain().checkValidity(value);
    }

    private PolyParam checkParameter(double param) {
        int n;
        PolyParam p = new PolyParam();
        int n2 = n = this.closed ? this.points.length : this.points.length - 1;
        if (this.closed) {
            param = this.parameterDomain().wrap(param);
        } else {
            this.checkValidity(param);
        }
        int idx = (int)Math.floor(param);
        if (idx < 0) {
            idx = 0;
        }
        if (n - 1 < idx) {
            idx = n - 1;
        }
        p.sp = this.points[idx];
        p.ep = idx + 1 == this.points.length ? this.points[0] : this.points[idx + 1];
        p.weight = param - (double)idx;
        p.param = param;
        p.index = idx;
        return p;
    }

    public JgclPoint1D coordinates(double param) {
        PolyParam p = this.checkParameter(param);
        return p.ep.linearInterpolate(p.sp, p.weight);
    }

    private class PolyParam {
        JgclPoint1D sp;
        JgclPoint1D ep;
        double weight;
        double param;
        int index;

        PolyParam() {
            JgclPolyline1D.this = JgclPolyline1D.this;
        }
    }
}

