/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclComplexPolynomial;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConic2D;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntsLinCnc2D;
import jp.go.ipa.jgcl.JgclIntsParCnc2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclOfst2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPointOnGeometryList;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclRealFunctionWithOneVariable;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;

public class JgclParabola2D
extends JgclConic2D {
    private double focalDist;

    private void setFocalDist(double focalDist) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        if (focalDist < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.focalDist = focalDist;
    }

    public JgclParabola2D(JgclAxis2Placement2D position, double focalDist) {
        super(position);
        this.setFocalDist(focalDist);
    }

    public double focalDist() {
        return this.focalDist;
    }

    public double length(JgclParameterSection pint) {
        double m2pbl_2fcldst = 2.0 * this.focalDist();
        double dTol = this.getToleranceForDistance() / 2.0;
        return JgclMath.getDefiniteIntegral(new 1(m2pbl_2fcldst), pint, dTol);
    }

    public JgclPoint2D coordinates(double param) {
        JgclAxis2Placement2D ax = this.position();
        JgclVector2D x = ax.x().multiply(param * param * this.focalDist);
        JgclVector2D y = ax.y().multiply(2.0 * param * this.focalDist);
        return ax.location().add(x.add(y));
    }

    public JgclVector2D tangentVector(double param) {
        JgclAxis2Placement2D ax = this.position();
        JgclVector2D x1 = ax.x().multiply(2.0 * param * this.focalDist);
        JgclVector2D y1 = ax.y().multiply(2.0 * this.focalDist);
        return x1.add(y1);
    }

    public JgclCurveCurvature2D curvature(double param) {
        JgclAxis2Placement2D ax = this.position();
        double x1len = 2.0 * param * this.focalDist;
        double y1len = 2.0 * this.focalDist;
        double x2len = 2.0 * this.focalDist;
        double tlen = Math.sqrt(x1len * x1len + y1len * y1len);
        double crv = Math.abs(y1len * x2len) / (tlen * tlen * tlen);
        JgclVector2D ex1 = ax.x().multiply(x1len);
        JgclVector2D ey1 = ax.y().multiply(y1len);
        JgclVector2D tangent = ex1.add(ey1);
        JgclLiteralVector2D nrmDir = new JgclLiteralVector2D(tangent.y(), -tangent.x());
        return new JgclCurveCurvature2D(crv, nrmDir.unitized());
    }

    public JgclCurveDerivative2D evaluation(double param) {
        JgclAxis2Placement2D ax = this.position();
        JgclVector2D ex = ax.x().multiply(param * param * this.focalDist);
        JgclVector2D ey = ax.y().multiply(2.0 * param * this.focalDist);
        JgclVector2D ex1 = ax.x().multiply(2.0 * param * this.focalDist);
        JgclVector2D ey1 = ax.y().multiply(2.0 * this.focalDist);
        JgclVector2D ex2 = ax.x().multiply(2.0 * this.focalDist);
        JgclPoint2D d0 = ax.location().add(ex.add(ey));
        JgclVector2D d1 = ex1.add(ey1);
        return new JgclCurveDerivative2D(d0, d1, ex2);
    }

    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) {
        JgclComplex[] root;
        JgclCartesianTransformationOperator2D trans;
        double dTol2 = this.getToleranceForDistance2();
        try {
            trans = new JgclCartesianTransformationOperator2D(this.position(), 1.0);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        JgclVector2D Bc2A = point.subtract(this.position().location());
        JgclVector2D eAir = trans.reverseTransform(Bc2A);
        double[] ercoef = new double[4];
        ercoef[3] = this.focalDist;
        ercoef[2] = 0.0;
        ercoef[1] = 2.0 * this.focalDist - eAir.x();
        ercoef[0] = -eAir.y();
        if (ercoef[1] * ercoef[1] < dTol2 && ercoef[0] * ercoef[0] < dTol2) {
            root = new JgclComplex[]{new JgclComplex(0.0)};
        } else {
            JgclComplexPolynomial pol;
            try {
                pol = new JgclComplexPolynomial(ercoef);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            try {
                root = pol.getRootsByDKA();
            }
            catch (JgclComplexPolynomial.DKANotConverge e) {
                root = e.getValues();
            }
            catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
                throw new JgclFatal();
            }
            catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
                throw new JgclFatal();
            }
        }
        JgclPointOnGeometryList projList = new JgclPointOnGeometryList();
        int i = 0;
        while (i < root.length) {
            double epara = root[i].real();
            JgclPointOnCurve2D proj = this.checkProjection(epara, point, dTol2);
            if (proj != null) {
                projList.addPoint(proj);
            }
            ++i;
        }
        return projList.toJgclPointOnCurve2DArray();
    }

    double getPeak(double left, double right) {
        return (left + right) / 2.0;
    }

    public JgclPureBezierCurve2D[] toPolyBezierCurves(JgclParameterSection pint) {
        double[] weights = new double[]{1.0, 1.0, 1.0};
        JgclPureBezierCurve2D[] bzcs = new JgclPureBezierCurve2D[]{new JgclPureBezierCurve2D(this.getControlPointsOfBezierCurve(pint), weights)};
        return bzcs;
    }

    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
        JgclPureBezierCurve2D[] bzcs = this.toPolyBezierCurves(pint);
        return bzcs[0].toBsplineCurve();
    }

    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
        JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
        double dA4fd = 4.0 * this.focalDist();
        boolean isPoly = poly.length < 3;
        int degree = yPoly.degree();
        double[] coef = new double[degree + 1];
        if (isPoly) {
            int deg = poly[1].degree();
            int j = 0;
            while (j <= degree) {
                coef[j] = j > degree - deg ? yPoly.coefficientAt(j) : yPoly.coefficientAt(j) - dA4fd * poly[0].coefficientAt(j);
                ++j;
            }
        } else {
            JgclRealPolynomial xwPoly = poly[0].multiply(poly[2]);
            int j = 0;
            while (j <= degree) {
                coef[j] = yPoly.coefficientAt(j) - dA4fd * xwPoly.coefficientAt(j);
                ++j;
            }
        }
        return new JgclRealPolynomial(coef);
    }

    boolean checkSolution(JgclPoint2D point) {
        double param = this.getParameter(point);
        double px = this.focalDist() * param * param;
        double py = 2.0 * this.focalDist() * param;
        return point.identical(new JgclCartesianPoint2D(px, py));
    }

    double getParameter(JgclPoint2D point) {
        return point.y() / (2.0 * this.focalDist());
    }

    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
        JgclIntsLinCnc2D doObj = new JgclIntsLinCnc2D(mate, this);
        return doObj.intersection(mate, this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) throws JgclIndefiniteSolution {
        if (this.position().location().identical(mate.position().location()) && this.position().x().identicalDirection(mate.position().x())) {
            double d_tol = this.getToleranceForDistance();
            if (Math.abs(this.focalDist() - mate.focalDist()) <= d_tol) {
                JgclIntersectionPoint2D one_sol = !doExchange ? new JgclIntersectionPoint2D(this, 0.0, mate, 0.0, false) : new JgclIntersectionPoint2D(mate, 0.0, this, 0.0, false);
                throw new JgclIndefiniteSolution(one_sol);
            }
        }
        JgclIntsParCnc2D doObj = new JgclIntsParCnc2D();
        return doObj.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
        JgclIntsParCnc2D doObj = new JgclIntsParCnc2D();
        return doObj.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst2D doObj = new JgclOfst2D(this, pint, magni, side, tol);
        return doObj.offset();
    }

    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    JgclParameterDomain getParameterDomain() {
        return new JgclParameterDomain();
    }

    boolean getClosedFlag() {
        return false;
    }

    int type() {
        return 13;
    }

    protected synchronized JgclParametricCurve2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclAxis2Placement2D tPosition = this.position().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        double tFocalDist = !reverseTransform ? transformationOperator.transform(this.focalDist()) : transformationOperator.reverseTransform(this.focalDist());
        return new JgclParabola2D(tPosition, tFocalDist);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tposition");
        this.position().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tfocalDist " + this.focalDist);
        writer.println(String.valueOf(indent_tab) + "End");
    }

    private static final class 1
    implements JgclRealFunctionWithOneVariable {
        private final /* synthetic */ double val$m2pbl_2fcldst;

        public double evaluate(double parameter) {
            return this.val$m2pbl_2fcldst * Math.sqrt(parameter * parameter + 1.0);
        }

        /* synthetic */ 1(double val$m2pbl_2fcldst) {
            this.val$m2pbl_2fcldst = val$m2pbl_2fcldst;
        }
    }
}

