/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclNonParametricCurve3D;
import jp.go.ipa.jgcl.JgclParameterConversion3D;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;

public class JgclOverlapCurve3D
extends JgclNonParametricCurve3D
implements JgclCurveCurveInterference3D {
    private JgclGeometry geom1;
    private JgclGeometry geom2;

    private JgclOverlapCurve3D() {
        this.geom1 = null;
        this.geom2 = null;
    }

    JgclOverlapCurve3D(JgclTrimmedCurve3D trc1, JgclTrimmedCurve3D trc2, boolean doCheck) {
        this.geom1 = trc1;
        this.geom2 = trc2;
    }

    JgclOverlapCurve3D(JgclParametricCurve3D curve1, JgclParameterSection section1, JgclParametricCurve3D curve2, JgclParameterSection section2, boolean doCheck) {
        this.geom1 = new JgclTrimmedCurve3D(curve1, section1);
        this.geom2 = new JgclTrimmedCurve3D(curve2, section2);
    }

    JgclOverlapCurve3D(JgclParametricCurve3D curve1, double start1, double inc1, JgclParametricCurve3D curve2, double start2, double inc2, boolean doCheck) {
        this.geom1 = new JgclTrimmedCurve3D(curve1, new JgclParameterSection(start1, inc1));
        this.geom2 = new JgclTrimmedCurve3D(curve2, new JgclParameterSection(start2, inc2));
    }

    public JgclParametricCurve3D curve1() {
        if (!this.geom1.isCurve()) {
            return null;
        }
        JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)this.geom1;
        return trc1.basisCurve();
    }

    public double start1() {
        if (!this.geom1.isCurve()) {
            throw new JgclFatal();
        }
        JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)this.geom1;
        return trc1.tParam1();
    }

    public double end1() {
        if (!this.geom1.isCurve()) {
            throw new JgclFatal();
        }
        JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)this.geom1;
        return trc1.tParam2();
    }

    public double increase1() {
        if (!this.geom1.isCurve()) {
            throw new JgclFatal();
        }
        JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)this.geom1;
        return this.end1() - this.start1();
    }

    public JgclParametricCurve3D curve2() {
        if (!this.geom2.isCurve()) {
            return null;
        }
        JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)this.geom2;
        return trc2.basisCurve();
    }

    public double start2() {
        if (!this.geom2.isCurve()) {
            throw new JgclFatal();
        }
        JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)this.geom2;
        return trc2.tParam1();
    }

    public double end2() {
        if (!this.geom2.isCurve()) {
            throw new JgclFatal();
        }
        JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)this.geom2;
        return trc2.tParam2();
    }

    public double increase2() {
        if (!this.geom2.isCurve()) {
            throw new JgclFatal();
        }
        JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)this.geom2;
        return this.end2() - this.start2();
    }

    public boolean isIntersectionPoint() {
        return false;
    }

    public boolean isOverlapCurve() {
        return true;
    }

    public JgclIntersectionPoint3D toIntersectionPoint() {
        return null;
    }

    public JgclOverlapCurve3D toOverlapCurve() {
        return this;
    }

    public JgclOverlapCurve3D exchange() {
        JgclOverlapCurve3D ex = new JgclOverlapCurve3D();
        ex.geom1 = this.geom2;
        ex.geom2 = this.geom1;
        return ex;
    }

    public JgclCurveCurveInterference3D trim1(JgclParameterSection sec, JgclParameterConversion3D conv) {
        double upper1;
        double lower1;
        JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)this.geom1;
        JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)this.geom2;
        if (trc1.senseAgreement()) {
            lower1 = sec.lower();
            upper1 = sec.upper();
        } else {
            lower1 = sec.upper();
            upper1 = sec.lower();
        }
        double lower = trc1.toOwnParameter(lower1);
        double upper = trc1.toOwnParameter(upper1);
        int lowerValidity = trc1.parameterValidity(lower);
        int upperValidity = trc1.parameterValidity(upper);
        if (lowerValidity == 3 && lower > 0.0) {
            return null;
        }
        if (upperValidity == 3 && upper <= 0.0) {
            return null;
        }
        if (lowerValidity == 2) {
            JgclPointOnCurve3D poc2 = new JgclPointOnCurve3D(trc2.basisCurve(), trc2.tParam2(), false);
            return new JgclIntersectionPoint3D(conv.convToPoint(lower1), poc2, false);
        }
        if (upperValidity == 1) {
            JgclPointOnCurve3D poc1 = new JgclPointOnCurve3D(trc2.basisCurve(), trc2.tParam1(), false);
            return new JgclIntersectionPoint3D(conv.convToPoint(upper1), poc1, false);
        }
        double lparam1 = 0.0;
        double uparam1 = Math.abs(trc1.tParam2() - trc1.tParam1());
        double lparam2 = 0.0;
        double uparam2 = Math.abs(trc2.tParam2() - trc2.tParam1());
        if (upperValidity == 0) {
            JgclPointOnCurve3D upoint1 = new JgclPointOnCurve3D(trc1.basisCurve(), upper1, false);
            uparam2 = trc2.pointToParameter(upoint1);
            uparam1 = upper;
        }
        if (lowerValidity == 0) {
            JgclPointOnCurve3D lpoint1 = new JgclPointOnCurve3D(trc1.basisCurve(), lower1, false);
            lparam2 = trc2.pointToParameter(lpoint1);
            lparam1 = lower;
        }
        JgclParameterSection pint1 = trc1.toBasisParameter(new JgclParameterSection(lparam1, uparam1 - lparam1));
        JgclParameterSection pint2 = trc2.toBasisParameter(new JgclParameterSection(lparam2, uparam2 - lparam2));
        if (upperValidity != 0 && lowerValidity != 0) {
            return new JgclOverlapCurve3D(conv.convToTrimmedCurve(pint1), trc2, false);
        }
        JgclTrimmedCurve3D trc = new JgclTrimmedCurve3D(trc2.basisCurve(), pint2);
        return new JgclOverlapCurve3D(conv.convToTrimmedCurve(pint1), trc, false);
    }

    public JgclCurveCurveInterference3D trim2(JgclParameterSection sec, JgclParameterConversion3D conv) {
        double upper2;
        double lower2;
        JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)this.geom1;
        JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)this.geom2;
        if (trc2.senseAgreement()) {
            lower2 = sec.lower();
            upper2 = sec.upper();
        } else {
            lower2 = sec.upper();
            upper2 = sec.lower();
        }
        double lower = trc2.toOwnParameter(lower2);
        double upper = trc2.toOwnParameter(upper2);
        int lowerValidity = trc2.parameterValidity(lower);
        int upperValidity = trc2.parameterValidity(upper);
        if (lowerValidity == 3 && lower > 0.0) {
            return null;
        }
        if (upperValidity == 3 && upper <= 0.0) {
            return null;
        }
        if (lowerValidity == 2) {
            JgclPointOnCurve3D poc2 = new JgclPointOnCurve3D(trc1.basisCurve(), trc1.tParam2(), false);
            return new JgclIntersectionPoint3D(poc2, conv.convToPoint(lower2), false);
        }
        if (upperValidity == 1) {
            JgclPointOnCurve3D poc1 = new JgclPointOnCurve3D(trc1.basisCurve(), trc1.tParam1(), false);
            return new JgclIntersectionPoint3D(poc1, conv.convToPoint(upper2), false);
        }
        double lparam1 = 0.0;
        double uparam1 = Math.abs(trc1.tParam2() - trc1.tParam1());
        double lparam2 = 0.0;
        double uparam2 = Math.abs(trc2.tParam2() - trc2.tParam1());
        if (upperValidity == 0) {
            JgclPointOnCurve3D upoint2 = new JgclPointOnCurve3D(trc2.basisCurve(), upper2, false);
            uparam2 = upper;
            uparam1 = trc1.pointToParameter(upoint2);
        }
        if (lowerValidity == 0) {
            JgclPointOnCurve3D lpoint2 = new JgclPointOnCurve3D(trc2.basisCurve(), lower2, false);
            lparam2 = lower;
            lparam1 = trc1.pointToParameter(lpoint2);
        }
        JgclParameterSection pint1 = trc1.toBasisParameter(new JgclParameterSection(lparam1, uparam1 - lparam1));
        JgclParameterSection pint2 = trc2.toBasisParameter(new JgclParameterSection(lparam2, uparam2 - lparam2));
        if (upperValidity != 0 && lowerValidity != 0) {
            return new JgclOverlapCurve3D(trc1, conv.convToTrimmedCurve(pint2), false);
        }
        JgclTrimmedCurve3D trc = new JgclTrimmedCurve3D(trc1.basisCurve(), pint1);
        return new JgclOverlapCurve3D(trc, conv.convToTrimmedCurve(pint2), false);
    }

    public JgclCurveCurveInterference3D changeCurve1(JgclParametricCurve3D newCurve) {
        if (!this.geom1.isCurve()) {
            throw new JgclFatal();
        }
        JgclTrimmedCurve3D trc1 = (JgclTrimmedCurve3D)this.geom1;
        JgclTrimmedCurve3D newTrc1 = new JgclTrimmedCurve3D(newCurve, trc1.tPnt1(), trc1.tPnt2(), trc1.tParam1(), trc1.tParam2(), trc1.masterRepresentation1(), trc1.masterRepresentation2(), trc1.senseAgreement());
        return new JgclOverlapCurve3D(newTrc1, (JgclTrimmedCurve3D)this.geom2, false);
    }

    public JgclCurveCurveInterference3D changeCurve2(JgclParametricCurve3D newCurve) {
        if (!this.geom2.isCurve()) {
            throw new JgclFatal();
        }
        JgclTrimmedCurve3D trc2 = (JgclTrimmedCurve3D)this.geom2;
        JgclTrimmedCurve3D newTrc2 = new JgclTrimmedCurve3D(newCurve, trc2.tPnt1(), trc2.tPnt2(), trc2.tParam1(), trc2.tParam2(), trc2.masterRepresentation1(), trc2.masterRepresentation2(), trc2.senseAgreement());
        return new JgclOverlapCurve3D((JgclTrimmedCurve3D)this.geom1, newTrc2, false);
    }

    public boolean isFreeform() {
        return this.geom1.isFreeform() && this.geom2.isFreeform();
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\ttrc1");
        this.geom1.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\ttrc2");
        this.geom2.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

