/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclOfst3D {
    private JgclParametricSurface3D surface;
    private static final int u_dir = 0;
    private static final int v_dir = 1;
    private JgclParameterSection upint;
    private JgclParameterSection vpint;
    private int side;
    private double magni;
    private JgclToleranceForDistance tolerance;
    private JgclMesh3D mesh;

    JgclOfst3D(JgclParametricSurface3D surface, JgclParameterSection upint, JgclParameterSection vpint, double magni, int side, JgclToleranceForDistance tolerance) {
        surface.checkUValidity(upint);
        surface.checkVValidity(vpint);
        this.surface = surface;
        this.upint = upint;
        this.vpint = vpint;
        this.magni = magni;
        this.side = side;
        this.tolerance = tolerance;
    }

    private JgclBsplineSurface3D offset_bss() {
        this.set_sampling_points();
        JgclPoint3D[][] offset_mesh = this.set_offset_points();
        double[] uparams = this.make_own_parameter(offset_mesh, 0);
        double[] vparams = this.make_own_parameter(offset_mesh, 1);
        JgclBsplineSurface3D obss = this.approx_bss(offset_mesh, uparams, vparams);
        return obss;
    }

    private void set_sampling_points() {
        JgclToleranceForDistance tol = new JgclToleranceForDistance(0.5 * this.tolerance.value());
        this.mesh = this.surface.toMesh(this.upint, this.vpint, tol);
    }

    private JgclPoint3D[][] set_offset_points() {
        JgclPoint3D[][] offset_mesh = new JgclPoint3D[this.mesh.uNPoints()][this.mesh.vNPoints()];
        int i = 0;
        while (i < this.mesh.uNPoints()) {
            int j = 0;
            while (j < this.mesh.vNPoints()) {
                offset_mesh[i][j] = this.make_offset_point(i, j);
                ++j;
            }
            ++i;
        }
        return offset_mesh;
    }

    private JgclBsplineSurface3D approx_bss(JgclPoint3D[][] offset_points, double[] uparams, double[] vparams) {
        JgclBsplineSurface3D bss = new JgclBsplineSurface3D(offset_points, uparams, vparams, this.mesh.uClosed(), this.mesh.vClosed(), this.tolerance);
        return bss;
    }

    private JgclPoint3D make_offset_point(int i, int j) {
        JgclPoint3D offset_point;
        JgclPointOnSurface3D base_point = (JgclPointOnSurface3D)this.mesh.pointAt(i, j);
        double[] params = base_point.parameters();
        JgclVector3D offset_vector = this.surface.normalVector(params[0], params[1]);
        offset_vector = offset_vector.unitized();
        offset_vector = offset_vector.multiply(this.magni);
        JgclPoint3D point = this.surface.coordinates(params[0], params[1]);
        if (this.side == 3) {
            offset_point = point.add(offset_vector);
        } else if (this.side == 4) {
            offset_vector = offset_vector.reverse();
            offset_point = point.add(offset_vector);
        } else {
            throw new JgclInvalidArgumentValue();
        }
        return offset_point;
    }

    private double[] make_own_parameter(JgclPoint3D[][] points, int dir) {
        int i;
        JgclPoint3D[] one_line;
        boolean is_closed;
        double inc;
        int num_of_line;
        int longest_line = this.get_longest_line(points, dir);
        if (dir == 0) {
            num_of_line = this.mesh.uNPoints();
            inc = this.upint.increase();
            is_closed = this.mesh.uClosed();
            one_line = new JgclPoint3D[num_of_line];
            i = 0;
            while (i < num_of_line) {
                one_line[i] = points[i][longest_line];
                ++i;
            }
        } else {
            num_of_line = this.mesh.vNPoints();
            inc = this.vpint.increase();
            is_closed = this.mesh.vClosed();
            one_line = new JgclPoint3D[num_of_line];
            i = 0;
            while (i < num_of_line) {
                one_line[i] = points[longest_line][i];
                ++i;
            }
        }
        double[] array_of_length = new double[num_of_line];
        array_of_length[0] = 0.0;
        JgclPoint3D source_point = one_line[0];
        i = 1;
        while (i < num_of_line) {
            array_of_length[i] = array_of_length[i - 1] + one_line[i].distance(source_point);
            source_point = one_line[i];
            ++i;
        }
        double increase_per_length = inc / array_of_length[num_of_line - 1];
        double[] own_params = new double[num_of_line];
        own_params[0] = 0.0;
        i = 1;
        while (i < num_of_line) {
            own_params[i] = array_of_length[i] * increase_per_length;
            ++i;
        }
        return own_params;
    }

    private int get_longest_line(JgclPoint3D[][] points, int dir) {
        double max_length = 0.0;
        int longest_line = -1;
        if (dir == 0) {
            int j = 0;
            while (j < this.mesh.vNPoints()) {
                double length = 0.0;
                int i = 1;
                while (i < this.mesh.uNPoints()) {
                    length += points[i][j].distance(points[i - 1][j]);
                    ++i;
                }
                if (this.mesh.uClosed()) {
                    length += points[0][j].distance(points[i - 1][j]);
                }
                if (length > max_length) {
                    max_length = length;
                    longest_line = j;
                }
                ++j;
            }
        } else {
            int i = 0;
            while (i < this.mesh.uNPoints()) {
                double length = 0.0;
                int j = 1;
                while (j < this.mesh.vNPoints()) {
                    length += points[i][j].distance(points[i][j - 1]);
                    ++j;
                }
                if (this.mesh.vClosed()) {
                    length += points[i][0].distance(points[i][j - 1]);
                }
                if (length > max_length) {
                    max_length = length;
                    longest_line = i;
                }
                ++i;
            }
        }
        return longest_line;
    }

    JgclBsplineSurface3D offset() {
        if (this.magni == 0.0) {
            return this.surface.toBsplineSurface(this.upint, this.vpint);
        }
        return this.offset_bss();
    }
}

