/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedSurface3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclNullArgument;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclSetOfTriangles3D;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceDerivative3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclMesh3D
extends JgclBoundedSurface3D {
    private JgclPoint3D[][] points;
    private boolean uClosed;
    private boolean vClosed;

    private void setPoints(JgclPoint3D[][] points) {
        int uUip = points.length;
        int vUip = points[0].length;
        this.points = new JgclPoint3D[uUip][vUip];
        int i = 0;
        while (i < uUip) {
            if (points[i].length != vUip) {
                throw new JgclInvalidArgumentValue();
            }
            int j = 0;
            while (j < vUip) {
                if (points[i][j] == null) {
                    throw new JgclNullArgument();
                }
                this.points[i][j] = points[i][j];
                ++j;
            }
            ++i;
        }
    }

    public JgclMesh3D(JgclPoint3D[][] points, boolean uClosed, boolean vClosed) {
        this.uClosed = uClosed;
        this.vClosed = vClosed;
        this.setPoints(points);
    }

    public JgclMesh3D(JgclPoint3D[][] points) {
        this.uClosed = false;
        this.vClosed = false;
        this.setPoints(points);
    }

    JgclMesh3D(JgclPoint3D[][] points, boolean doCheck) {
        this.uClosed = false;
        this.vClosed = false;
        if (doCheck) {
            this.setPoints(points);
        } else {
            this.points = points;
        }
    }

    public JgclMesh3D(JgclBoundedSurface3D surface, JgclToleranceForDistance tol) {
        JgclMesh3D mesh = surface.toMesh(tol);
        this.uClosed = mesh.uClosed;
        this.vClosed = mesh.vClosed;
        this.points = mesh.points;
    }

    public JgclMesh3D(JgclParametricSurface3D surface, JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        JgclMesh3D mesh = surface.toMesh(uPint, vPint, tol);
        this.uClosed = mesh.uClosed;
        this.vClosed = mesh.vClosed;
        this.points = mesh.points;
    }

    public JgclPoint3D[][] points() {
        JgclPoint3D[][] pnts = new JgclPoint3D[this.uNPoints()][this.vNPoints()];
        int i = 0;
        while (i < this.uNPoints()) {
            int j = 0;
            while (j < this.vNPoints()) {
                pnts[i][j] = this.pointAt(i, j);
                ++j;
            }
            ++i;
        }
        return pnts;
    }

    public JgclPoint3D pointAt(int i, int j) {
        if (this.uClosed() && i == this.uNPoints()) {
            i = 0;
        }
        if (this.vClosed() && j == this.vNPoints()) {
            j = 0;
        }
        return this.points[i][j];
    }

    public boolean uClosed() {
        return this.uClosed;
    }

    public boolean vClosed() {
        return this.vClosed;
    }

    public int uNPoints() {
        return this.points.length;
    }

    public int vNPoints() {
        return this.points[0].length;
    }

    public int uNSegments() {
        if (this.uClosed()) {
            return this.uNPoints();
        }
        return this.uNPoints() - 1;
    }

    public int vNSegments() {
        if (this.vClosed()) {
            return this.vNPoints();
        }
        return this.vNPoints() - 1;
    }

    public JgclPoint3D coordinates(double uParam, double vParam) {
        throw new JgclNotSupported();
    }

    public JgclVector3D[] tangentVector(double uParam, double vParam) {
        throw new JgclNotSupported();
    }

    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
        throw new JgclNotSupported();
    }

    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point) {
        throw new JgclNotSupported();
    }

    public JgclMesh3D toMesh(JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        throw new JgclNotSupported();
    }

    public JgclMesh3D toMesh(JgclToleranceForDistance tol) {
        throw new JgclNotSupported();
    }

    public JgclBsplineSurface3D toBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint) {
        throw new JgclNotSupported();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclConic3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate) {
        throw new JgclNotSupported();
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    public JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint, double magni, int side, JgclToleranceForDistance tol) {
        throw new JgclNotSupported();
    }

    public JgclParametricCurve3D uIsoParametricCurve(double parameter) {
        throw new JgclNotSupported();
    }

    public JgclParametricCurve3D vIsoParametricCurve(double parameter) {
        throw new JgclNotSupported();
    }

    public JgclSetOfTriangles3D toSetOfTriangles() {
        return new JgclSetOfTriangles3D(this);
    }

    JgclParameterDomain getUParameterDomain() {
        double n = this.uClosed ? this.uNPoints() : this.uNPoints() - 1;
        return new JgclParameterDomain(this.uClosed, 0.0, n);
    }

    JgclParameterDomain getVParameterDomain() {
        double n = this.vClosed ? this.vNPoints() : this.vNPoints() - 1;
        return new JgclParameterDomain(this.vClosed, 0.0, n);
    }

    int type() {
        return 40;
    }

    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection, JgclParameterSection vParameterSection, double tolerance, double[] scalingFactor) {
        throw new JgclNotSupported();
    }

    public boolean isFreeform() {
        return true;
    }

    protected synchronized JgclParametricSurface3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D[][] tPoints = new JgclPoint3D[this.uNPoints()][];
        int i = 0;
        while (i < this.uNPoints()) {
            tPoints[i] = JgclPoint3D.transform(this.points[i], reverseTransform, transformationOperator, transformedGeometries);
            ++i;
        }
        return new JgclMesh3D(tPoints, this.uClosed, this.vClosed);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tpoints");
        int i = 0;
        while (i < this.uNPoints()) {
            int j = 0;
            while (j < this.vNPoints()) {
                this.pointAt(i, j).output(writer, indent + 2);
                ++j;
            }
            ++i;
        }
        writer.println(String.valueOf(indent_tab) + "\tuClosed\t" + this.uClosed);
        writer.println(String.valueOf(indent_tab) + "\tvClosed\t" + this.vClosed);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

