/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBoundedLine2D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclZeroLength;

public class JgclLine2D
extends JgclParametricCurve2D {
    private final JgclPoint2D pnt;
    private final JgclVector2D dir;

    public JgclLine2D(JgclPoint2D pnt, JgclVector2D dir) {
        if (dir.norm() < this.getToleranceForDistance2()) {
            throw new JgclInvalidArgumentValue();
        }
        this.pnt = pnt;
        this.dir = dir;
    }

    public JgclLine2D(JgclPoint2D pnt1, JgclPoint2D pnt2) {
        if (pnt1.identical(pnt2)) {
            throw new JgclInvalidArgumentValue();
        }
        this.pnt = pnt1;
        this.dir = pnt2.subtract(pnt1);
    }

    public JgclPoint2D pnt() {
        return this.pnt;
    }

    public JgclVector2D dir() {
        return this.dir;
    }

    public double length(JgclParameterSection pint) {
        return this.dir.length() * Math.abs(pint.increase());
    }

    public JgclPoint2D coordinates(double param) {
        return this.pnt.add(this.dir.multiply(param));
    }

    public JgclVector2D tangentVector(double param) {
        return this.dir;
    }

    public JgclCurveCurvature2D curvature(double param) {
        return new JgclCurveCurvature2D(0.0, JgclVector2D.zeroVector);
    }

    public JgclCurveDerivative2D evaluation(double param) {
        return new JgclCurveDerivative2D(this.coordinates(param), this.dir, JgclVector2D.zeroVector);
    }

    public JgclPointOnCurve2D[] singular() {
        return new JgclPointOnCurve2D[0];
    }

    public JgclPointOnCurve2D[] inflexion() {
        return new JgclPointOnCurve2D[0];
    }

    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) {
        JgclPointOnCurve2D[] proj = new JgclPointOnCurve2D[]{this.project1From(point)};
        return proj;
    }

    public JgclPolyline2D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        JgclPoint2D[] points = new JgclPoint2D[]{new JgclPointOnCurve2D(this, pint.start(), false), new JgclPointOnCurve2D(this, pint.end(), false)};
        if (points[0].identical(points[1])) {
            throw new JgclZeroLength();
        }
        return new JgclPolyline2D(points);
    }

    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
        JgclPoint2D[] controlPoints = new JgclPoint2D[]{this.coordinates(pint.start()), this.coordinates(pint.end())};
        double[] weights = new double[]{1.0, 1.0};
        return new JgclBsplineCurve2D(JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment, controlPoints, weights);
    }

    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    public JgclIntersectionPoint2D intersect1Line(JgclLine2D mate) throws JgclIndefiniteSolution {
        JgclVector2D p = mate.pnt().subtract(this.pnt());
        double pa = p.zOfCrossProduct(this.dir());
        double pb = p.zOfCrossProduct(mate.dir());
        double dTol = this.getToleranceForDistance();
        if (this.dir().parallelDirection(mate.dir())) {
            if (Math.abs(pa / this.dir().length()) < dTol || Math.abs(pb / mate.dir().length()) < dTol) {
                JgclPointOnCurve2D pnt1 = new JgclPointOnCurve2D(this, 0.0, false);
                JgclPointOnCurve2D pnt2 = mate.project1From(pnt1);
                JgclIntersectionPoint2D ip = new JgclIntersectionPoint2D(pnt1, pnt2, false);
                throw new JgclIndefiniteSolution(ip);
            }
            return null;
        }
        double o = this.dir().zOfCrossProduct(mate.dir());
        return new JgclIntersectionPoint2D(this, pb / o, mate, pa / o, false);
    }

    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint2D ints = this.intersect1Line(mate);
        if (ints == null) {
            return new JgclIntersectionPoint2D[0];
        }
        if (doExchange) {
            ints = ints.exchange();
        }
        JgclIntersectionPoint2D[] sol = new JgclIntersectionPoint2D[]{ints};
        return sol;
    }

    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclVector2D offset_vector;
        int uicp = 4;
        int uik = 2;
        double start_param = pint.start();
        double end_param = start_param + pint.increase();
        double param_interval = pint.increase() / (double)(uicp - 1);
        double[] knots = new double[2];
        int[] knot_multi = new int[2];
        knots[0] = 0.0;
        knot_multi[0] = 4;
        knots[1] = Math.abs(pint.increase());
        knot_multi[1] = 4;
        if (side == 2) {
            offset_vector = new JgclLiteralVector2D(-1.0 * this.dir().y(), this.dir().x());
        } else if (side == 1) {
            offset_vector = new JgclLiteralVector2D(this.dir().y(), -1.0 * this.dir().x());
        } else {
            throw new JgclInvalidArgumentValue();
        }
        offset_vector = offset_vector.unitized();
        offset_vector = offset_vector.multiply(magni);
        if (pint.increase() < 0.0) {
            offset_vector = offset_vector.reverse();
        }
        JgclPoint2D[] crnt_pnt = new JgclPoint2D[uicp];
        crnt_pnt[0] = this.coordinates(start_param);
        crnt_pnt[0] = crnt_pnt[0].add(offset_vector);
        int i = 1;
        double crnt_param = start_param + param_interval;
        while (i < uicp - 1) {
            crnt_pnt[i] = this.coordinates(crnt_param);
            crnt_pnt[i] = crnt_pnt[i].add(offset_vector);
            ++i;
            crnt_param += param_interval;
        }
        crnt_pnt[i] = this.coordinates(end_param);
        crnt_pnt[i] = crnt_pnt[i].add(offset_vector);
        JgclBsplineCurve2D bsc = new JgclBsplineCurve2D(3, knot_multi, knots, crnt_pnt);
        return bsc;
    }

    public JgclBoundedCurve2D offsetByBoundedCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclVector2D lineDirection = this.tangentVector(0.0);
        JgclVector2D offsetVector = side == 1 ? JgclVector2D.of(lineDirection.y(), -lineDirection.x()) : JgclVector2D.of(-lineDirection.y(), lineDirection.x());
        offsetVector = offsetVector.unitized().multiply(magni);
        if (pint.increase() < 0.0) {
            offsetVector = offsetVector.reverse();
        }
        return new JgclBoundedLine2D(this.coordinates(pint.start()).add(offsetVector), this.coordinates(pint.end()).add(offsetVector));
    }

    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclPointOnCurve2D project1From(JgclPoint2D point) {
        JgclVector2D evpp = point.subtract(this.pnt);
        double edot = this.dir.dotProduct(evpp);
        double param = edot / this.dir.norm();
        return new JgclPointOnCurve2D(this, param, false);
    }

    int pointIsWhichSide(JgclPoint2D point) {
        JgclVector2D uDir;
        double d_tol = this.getToleranceForDistance();
        JgclVector2D eBAvec = point.subtract(this.pnt);
        double ework = eBAvec.zOfCrossProduct(uDir = this.dir.unitized());
        if (ework > d_tol) {
            return 1;
        }
        if (ework < -d_tol) {
            return 2;
        }
        return 0;
    }

    JgclParameterDomain getParameterDomain() {
        return new JgclParameterDomain();
    }

    boolean getClosedFlag() {
        return false;
    }

    int type() {
        return 1;
    }

    protected synchronized JgclParametricCurve2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint2D tPnt = this.pnt().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclVector2D tDir = this.dir().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclLine2D(tPnt, tDir);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tpnt");
        this.pnt.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tdir");
        this.dir.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

