/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclIntsSphCyl3D {
    static final int nst = 41;

    static JgclPoint3D UVpntfromT(JgclPoint3D c, JgclVector3D u, JgclVector3D v, double r, double t) {
        double cost = Math.cos(t);
        double sint = Math.sin(t);
        return c.add(u.multiply(cost).add(v.multiply(sint)).multiply(r));
    }

    static JgclSurfaceSurfaceInterference3D[] intersection(JgclSphericalSurface3D Sph, JgclCylindricalSurface3D Cyl, boolean doExchange) {
        JgclIntersectionPoint3D[] CCint;
        double d_tol;
        JgclLine3D C_axis = new JgclLine3D(Cyl.position().location(), Cyl.position().z());
        JgclPointOnCurve3D projp = C_axis.project1From(Sph.position().location());
        double dist = projp.distance(Sph.position().location());
        if (dist < (d_tol = Sph.getToleranceForDistance())) {
            if (Math.abs(Sph.radius() - Cyl.radius()) < d_tol) {
                JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(Sph.position().location(), Cyl.position().z(), Cyl.position().x());
                JgclCircle3D res = new JgclCircle3D(a2p, (Cyl.radius() + Sph.radius()) / 2.0);
                JgclIntersectionCurve3D ints = Sph.curveToIntersectionCurve(res, Cyl, doExchange);
                JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
                return sol;
            }
            if (Sph.radius() > Cyl.radius()) {
                double r = Math.sqrt(Sph.radius() * Sph.radius() - Cyl.radius() * Cyl.radius());
                JgclVector3D offset = Cyl.position().z().multiply(r);
                JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(Sph.position().location().add(offset), Cyl.position().z(), Cyl.position().x());
                JgclCircle3D res = new JgclCircle3D(a2p, Cyl.radius());
                JgclIntersectionCurve3D ints1 = Sph.curveToIntersectionCurve(res, Cyl, doExchange);
                a2p = new JgclAxis2Placement3D(Sph.position().location().subtract(offset), Cyl.position().z(), Cyl.position().x());
                res = new JgclCircle3D(a2p, Cyl.radius());
                JgclIntersectionCurve3D ints2 = Sph.curveToIntersectionCurve(res, Cyl, doExchange);
                JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints1, ints2};
                return sol;
            }
            return new JgclSurfaceSurfaceInterference3D[0];
        }
        JgclVector3D Cw = Cyl.position().z();
        JgclVector3D Cu = Sph.position().location().subtract(Cyl.position().location());
        JgclVector3D Cv = Cw.crossProduct(Cu);
        Cu = Cv.crossProduct(Cw).unitized();
        Cv = Cv.unitized();
        if (Math.abs(dist - (Cyl.radius() + Sph.radius())) < d_tol || Math.abs(dist - (Cyl.radius() - Sph.radius())) < d_tol) {
            JgclPoint3D res = Math.abs(dist - (Cyl.radius() + Sph.radius())) < d_tol ? Sph.position().location().subtract(Cu.multiply(Sph.radius())) : Sph.position().location().add(Cu.multiply(Sph.radius()));
            JgclIntersectionPoint3D intsPnt = Sph.pointToIntersectionPoint(res, Cyl, doExchange);
            JgclSurfaceSurfaceInterference3D[] intf = new JgclSurfaceSurfaceInterference3D[]{intsPnt};
            return intf;
        }
        if (Math.abs(dist - (Sph.radius() - Cyl.radius())) < d_tol || dist < Sph.radius() - Cyl.radius()) {
            double[] dA = new double[3];
            JgclPoint3D[] pnts1 = new JgclPoint3D[41];
            JgclPoint3D[] pnts2 = new JgclPoint3D[41];
            double step = 0.15707963267948966;
            JgclVector3D evec = Cyl.position().location().subtract(Sph.position().location());
            dA[2] = 1.0;
            dA[1] = 2.0 * evec.dotProduct(Cw);
            int i = 0;
            while (i < 41) {
                double dX0;
                double dX1;
                double t = -Math.PI + step * (double)i;
                JgclPoint3D UVp = JgclIntsSphCyl3D.UVpntfromT(Cyl.position().location(), Cu, Cv, Cyl.radius(), t);
                evec = UVp.subtract(Sph.position().location());
                dA[0] = evec.dotProduct(evec) - Sph.radius() * Sph.radius();
                JgclRealPolynomial pol = new JgclRealPolynomial(dA);
                double[] dX = pol.getAlwaysRootsIfQuadric();
                if (dX == null) {
                    throw new JgclFatal();
                }
                if (dX.length == 1) {
                    dX0 = dX1 = dX[0];
                } else if (dX[0] < dX[1]) {
                    dX0 = dX[1];
                    dX1 = dX[0];
                } else {
                    dX0 = dX[0];
                    dX1 = dX[1];
                }
                pnts1[i] = UVp.add(Cw.multiply(dX0));
                pnts2[i] = UVp.add(Cw.multiply(dX1));
                ++i;
            }
            JgclPolyline3D res = new JgclPolyline3D(pnts1);
            JgclIntersectionCurve3D ints1 = Sph.curveToIntersectionCurve(res, Cyl, doExchange);
            res = new JgclPolyline3D(pnts2);
            JgclIntersectionCurve3D ints2 = Sph.curveToIntersectionCurve(res, Cyl, doExchange);
            JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints1, ints2};
            return sol;
        }
        if (dist < Cyl.radius() - Sph.radius() || dist > Cyl.radius() + Sph.radius()) {
            return new JgclSurfaceSurfaceInterference3D[0];
        }
        double[] dA = new double[3];
        int my_nst = 81;
        JgclPoint3D[] pnts = new JgclPoint3D[my_nst];
        JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(Sph.position().location(), Cyl.position().z(), Cyl.position().x());
        JgclCircle3D Cir = new JgclCircle3D(a2p, Sph.radius());
        try {
            CCint = Cir.intersect(Cyl);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        JgclVector3D evec = CCint[0].subtract(Cyl.position().location());
        evec = evec.project(Cw).unitized();
        double t0 = Math.acos(evec.dotProduct(Cu));
        double step = 2.0 * t0 / 40.0;
        evec = Cyl.position().location().subtract(Sph.position().location());
        dA[2] = 1.0;
        dA[1] = 2.0 * evec.dotProduct(Cw);
        double t = -t0;
        JgclPoint3D UVp = JgclIntsSphCyl3D.UVpntfromT(Cyl.position().location(), Cu, Cv, Cyl.radius(), t);
        evec = UVp.subtract(Sph.position().location());
        dA[0] = evec.dotProduct(evec) - Sph.radius() * Sph.radius();
        JgclRealPolynomial pol = new JgclRealPolynomial(dA);
        double[] dX = pol.getAlwaysRootsIfQuadric();
        if (dX == null) {
            throw new JgclFatal();
        }
        JgclPoint3D jgclPoint3D = UVp.add(Cw.multiply(dX[0]));
        pnts[my_nst - 1] = jgclPoint3D;
        pnts[0] = jgclPoint3D;
        int i = 1;
        while (i < 40) {
            double dX1;
            double dX0;
            t = -t0 + (double)i * step;
            UVp = JgclIntsSphCyl3D.UVpntfromT(Cyl.position().location(), Cu, Cv, Cyl.radius(), t);
            evec = UVp.subtract(Sph.position().location());
            dA[0] = evec.dotProduct(evec) - Sph.radius() * Sph.radius();
            pol = new JgclRealPolynomial(dA);
            dX = pol.getAlwaysRootsIfQuadric();
            if (dX == null) {
                throw new JgclFatal();
            }
            if (dX[0] < dX[1]) {
                dX0 = dX[1];
                dX1 = dX[0];
            } else {
                dX0 = dX[0];
                dX1 = dX[1];
            }
            pnts[i] = UVp.add(Cw.multiply(dX0));
            pnts[my_nst - 1 - i] = UVp.add(Cw.multiply(dX1));
            ++i;
        }
        t = t0;
        UVp = JgclIntsSphCyl3D.UVpntfromT(Cyl.position().location(), Cu, Cv, Cyl.radius(), t);
        evec = UVp.subtract(Sph.position().location());
        dA[0] = evec.dotProduct(evec) - Sph.radius() * Sph.radius();
        pol = new JgclRealPolynomial(dA);
        dX = pol.getAlwaysRootsIfQuadric();
        if (dX == null) {
            throw new JgclFatal();
        }
        pnts[40] = UVp.add(Cw.multiply(dX[0]));
        JgclPolyline3D res = new JgclPolyline3D(pnts);
        JgclIntersectionCurve3D ints = Sph.curveToIntersectionCurve(res, Cyl, doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
        return sol;
    }

    JgclIntsSphCyl3D() {
    }
}

