/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBoundedLine3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclEnclosingBox3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclOverlapCurve3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclIntsPolPol3D {
    private JgclPolyline3D dA;
    private JgclVector3D[] dA_uvecs;
    private double[] dA_lengs;
    private JgclEnclosingBox3D dA_enrc;
    private JgclPolyline3D dB;
    private JgclVector3D[] dB_uvecs;
    private double[] dB_lengs;
    private JgclEnclosingBox3D dB_enrc;

    private JgclIntsPolPol3D(JgclPolyline3D dA, JgclPolyline3D dB) {
        this(dA, null, null, null, dB, null, null, null);
    }

    private JgclIntsPolPol3D(JgclPolyline3D dA, JgclVector3D[] dA_uvecs, double[] dA_lengs, JgclEnclosingBox3D dA_enrc, JgclPolyline3D dB, JgclVector3D[] dB_uvecs, double[] dB_lengs, JgclEnclosingBox3D dB_enrc) {
        this.dA = dA;
        this.dA_uvecs = dA_uvecs;
        this.dA_lengs = dA_lengs;
        this.dA_enrc = dA_enrc;
        this.dB = dB;
        this.dB_uvecs = dB_uvecs;
        this.dB_lengs = dB_lengs;
        this.dB_enrc = dB_enrc;
    }

    private JgclCurveCurveInterferenceList getInterference(boolean doRoughCheck) {
        JgclCurveCurveInterferenceList interferenceList = new JgclCurveCurveInterferenceList(this.dA, this.dB);
        if (doRoughCheck) {
            if (this.dA_enrc == null) {
                this.dA_enrc = this.dA.enclosingBox();
            }
            if (this.dB_enrc == null) {
                this.dB_enrc = this.dB.enclosingBox();
            }
            if (!this.dA_enrc.hasIntersection(this.dB_enrc)) {
                return interferenceList;
            }
        }
        int Anseg = this.dA.nSegments();
        int Bnseg = this.dB.nSegments();
        SegmentInfo[] Bsi = new SegmentInfo[Bnseg];
        int i = 0;
        while (i < Bnseg) {
            Bsi[i] = this.dB_uvecs == null ? new SegmentInfo(this.dB.pointAt(i), this.dB.pointAt(i + 1)) : new SegmentInfo(this.dB.pointAt(i), this.dB.pointAt(i + 1), this.dB_uvecs[i], this.dB_lengs[i]);
            ++i;
        }
        i = 0;
        while (i < Anseg) {
            SegmentInfo Asi = this.dA_uvecs == null ? new SegmentInfo(this.dA.pointAt(i), this.dA.pointAt(i + 1)) : new SegmentInfo(this.dA.pointAt(i), this.dA.pointAt(i + 1), this.dA_uvecs[i], this.dA_lengs[i]);
            if (!(Asi.tol < 0.0) && (this.dB_enrc == null && !doRoughCheck || Asi.box.hasIntersection(this.dB_enrc))) {
                int j = 0;
                while (j < Bnseg) {
                    JgclCurveCurveInterference3D intf;
                    if (!(Bsi[j].tol < 0.0) && Asi.box.hasIntersection(Bsi[j].box) && (intf = Asi.bln.interfere1(Bsi[j].bln, Asi.udir, Bsi[j].udir, Asi.leng, Bsi[j].leng)) != null) {
                        if (intf.isIntersectionPoint()) {
                            JgclIntersectionPoint3D ints = intf.toIntersectionPoint();
                            interferenceList.addAsIntersection(ints.coordinates(), ints.pointOnCurve1().parameter() + (double)i, ints.pointOnCurve2().parameter() + (double)j, Asi.tol, Bsi[j].tol);
                        } else {
                            JgclOverlapCurve3D ovlp = intf.toOverlapCurve();
                            interferenceList.addAsOverlap(ovlp.start1() + (double)i, ovlp.start2() + (double)j, ovlp.increase1(), ovlp.increase2(), Asi.tol, Bsi[j].tol, Asi.tol, Bsi[j].tol);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        interferenceList.removeOverlapsContainedInOtherOverlap();
        interferenceList.removeIntersectionsContainedInOverlap();
        return interferenceList;
    }

    static JgclIntersectionPoint3D[] intersection(JgclPolyline3D poly1, JgclPolyline3D poly2, boolean doExchange) {
        JgclIntsPolPol3D doObj = new JgclIntsPolPol3D(poly1, poly2);
        return doObj.getInterference(true).toJgclIntersectionPoint3DArray(doExchange);
    }

    static JgclCurveCurveInterference3D[] interference(JgclPolyline3D poly1, JgclPolyline3D poly2) {
        JgclIntsPolPol3D doObj = new JgclIntsPolPol3D(poly1, poly2);
        return doObj.getInterference(true).toJgclCurveCurveInterference3DArray(false);
    }

    static JgclCurveCurveInterference3D[] interference(JgclPolyline3D dA, JgclVector3D[] dA_uvecs, double[] dA_lengs, JgclEnclosingBox3D dA_enrc, JgclPolyline3D dB, JgclVector3D[] dB_uvecs, double[] dB_lengs, JgclEnclosingBox3D dB_enrc) {
        JgclIntsPolPol3D doObj = new JgclIntsPolPol3D(dA, dA_uvecs, dA_lengs, dA_enrc, dB, dB_uvecs, dB_lengs, dB_enrc);
        return doObj.getInterference(false).toJgclCurveCurveInterference3DArray(false);
    }

    private class SegmentInfo {
        private JgclBoundedLine3D bln;
        private JgclVector3D udir;
        private double leng;
        private double tol;
        private JgclEnclosingBox3D box;

        private SegmentInfo(JgclPoint3D spnt, JgclPoint3D epnt, JgclVector3D udir, double leng) {
            JgclIntsPolPol3D.this = JgclIntsPolPol3D.this;
            double d_tol = spnt.getToleranceForDistance();
            if (udir == null) {
                this.udir = epnt.subtract(spnt);
                this.leng = this.udir.length();
                this.udir = this.leng > d_tol ? this.udir.divide(this.leng) : JgclVector3D.zeroVector;
            } else {
                this.udir = udir;
                this.leng = leng;
            }
            if (this.leng <= d_tol) {
                this.tol = -1.0;
                this.bln = null;
                this.box = null;
            } else {
                this.tol = d_tol / this.leng;
                this.bln = new JgclBoundedLine3D(spnt, epnt, false);
                this.box = this.bln.enclosingBox();
            }
        }

        private SegmentInfo(JgclPoint3D spnt, JgclPoint3D epnt) {
            this(spnt, epnt, null, 0.0);
        }
    }
}

