/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclConic2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclVector2D;

class JgclIntsLinCnc2D {
    private JgclLine2D line;
    private JgclConic2D conic;

    JgclIntsLinCnc2D(JgclLine2D line, JgclConic2D conic) {
        this.line = line;
        this.conic = conic;
    }

    private double[] getRoot(double[] coef) {
        JgclRealPolynomial poly;
        try {
            poly = new JgclRealPolynomial(coef);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        double[] root = poly.getRootsIfQuadric();
        return root;
    }

    private double[] checkDuplicate(JgclLine2D line, double[] root) {
        double diff;
        double dTol2 = line.getToleranceForDistance2();
        if (root == null) {
            return null;
        }
        double[] realRoot = root.length == 2 ? ((diff = Math.abs(root[1] - root[0])) * diff * line.dir().norm() < dTol2 ? new double[]{root[0]} : root) : root;
        return realRoot;
    }

    private JgclIntersectionPoint2D[] getIntersect(JgclLine2D line, JgclConic2D conic, double[] root, boolean doExchange) {
        Vector<JgclIntersectionPoint2D> intervec = new Vector<JgclIntersectionPoint2D>();
        int i = 0;
        while (i < root.length) {
            block4: {
                double eBpara;
                double eApara = root[i];
                JgclPoint2D etmp = line.coordinates(eApara);
                try {
                    eBpara = conic.pointToParameter(etmp);
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    break block4;
                }
                JgclPointOnCurve2D pntA = new JgclPointOnCurve2D(line, eApara, false);
                JgclPointOnCurve2D pntB = new JgclPointOnCurve2D(conic, eBpara, false);
                JgclIntersectionPoint2D inter = !doExchange ? new JgclIntersectionPoint2D(pntB, pntA, pntB, false) : new JgclIntersectionPoint2D(pntB, pntB, pntA, false);
                if (inter != null && pntA.identical(pntB)) {
                    intervec.addElement(inter);
                }
            }
            ++i;
        }
        Object[] intersectPoints = new JgclIntersectionPoint2D[intervec.size()];
        intervec.copyInto(intersectPoints);
        return intersectPoints;
    }

    private double[] getCoef(JgclLine2D line, JgclCircle2D circle) {
        double[] ercoef = new double[3];
        JgclVector2D eApnt = line.pnt().subtract(circle.position().location());
        ercoef[2] = line.dir().x() * line.dir().x() + line.dir().y() * line.dir().y();
        ercoef[1] = 2.0 * (eApnt.x() * line.dir().x() + eApnt.y() * line.dir().y());
        ercoef[0] = eApnt.x() * eApnt.x() + eApnt.y() * eApnt.y() - circle.radius() * circle.radius();
        return ercoef;
    }

    JgclIntersectionPoint2D[] intersection(JgclLine2D line, JgclCircle2D circle, boolean doExchange) {
        double[] ercoef = this.getCoef(line, circle);
        double[] root = this.getRoot(ercoef);
        if (root == null) {
            return new JgclIntersectionPoint2D[0];
        }
        double[] realRoot = this.checkDuplicate(line, root);
        return this.getIntersect(line, circle, realRoot, doExchange);
    }

    private double[] getCoef(JgclLine2D line, JgclEllipse2D ell) {
        JgclCartesianTransformationOperator2D trans;
        double dBsrd;
        double dBlrd;
        if (ell.semiAxis1() < ell.semiAxis2()) {
            dBlrd = ell.semiAxis2();
            dBsrd = ell.semiAxis1();
            try {
                JgclAxis2Placement2D axis = new JgclAxis2Placement2D(ell.position().location(), ell.position().y());
                trans = new JgclCartesianTransformationOperator2D(axis, 1.0);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
        }
        dBlrd = ell.semiAxis1();
        dBsrd = ell.semiAxis2();
        try {
            trans = new JgclCartesianTransformationOperator2D(ell.position(), 1.0);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        JgclVector2D Bc2A = line.pnt().subtract(ell.position().location());
        JgclVector2D eAirpnt = trans.toLocal(Bc2A);
        JgclVector2D eAirvec = trans.toLocal(line.dir());
        double eA2 = dBlrd * dBlrd;
        double eB2 = dBsrd * dBsrd;
        double[] ercoef = new double[3];
        ercoef[2] = eA2 * eAirvec.y() * eAirvec.y() + eB2 * eAirvec.x() * eAirvec.x();
        ercoef[1] = 2.0 * (eA2 * eAirpnt.y() * eAirvec.y() + eB2 * eAirpnt.x() * eAirvec.x());
        ercoef[0] = eA2 * eAirpnt.y() * eAirpnt.y() + eB2 * eAirpnt.x() * eAirpnt.x() - eA2 * eB2;
        return ercoef;
    }

    JgclIntersectionPoint2D[] intersection(JgclLine2D line, JgclEllipse2D ell, boolean doExchange) {
        double[] ercoef = this.getCoef(line, ell);
        double[] root = this.getRoot(ercoef);
        if (root == null) {
            return new JgclIntersectionPoint2D[0];
        }
        double[] realRoot = this.checkDuplicate(line, root);
        return this.getIntersect(line, ell, realRoot, doExchange);
    }

    private double[] getCoef(JgclLine2D line, JgclParabola2D par) {
        JgclCartesianTransformationOperator2D trans;
        try {
            trans = new JgclCartesianTransformationOperator2D(par.position(), 1.0);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        JgclVector2D Bc2A = line.pnt().subtract(par.position().location());
        JgclVector2D eAirpnt = trans.reverseTransform(Bc2A);
        JgclVector2D eAirvec = trans.reverseTransform(line.dir());
        double[] ercoef = new double[3];
        ercoef[2] = eAirvec.y() * eAirvec.y();
        ercoef[1] = 2.0 * (eAirpnt.y() * eAirvec.y() - 2.0 * par.focalDist() * eAirvec.x());
        ercoef[0] = eAirpnt.y() * eAirpnt.y() - 4.0 * par.focalDist() * eAirpnt.x();
        return ercoef;
    }

    JgclIntersectionPoint2D[] intersection(JgclLine2D line, JgclParabola2D par, boolean doExchange) {
        double[] ercoef = this.getCoef(line, par);
        double[] root = this.getRoot(ercoef);
        if (root == null) {
            return new JgclIntersectionPoint2D[0];
        }
        double[] realRoot = this.checkDuplicate(line, root);
        return this.getIntersect(line, par, realRoot, doExchange);
    }

    private double[] getCoef(JgclLine2D line, JgclHyperbola2D hyp) {
        JgclCartesianTransformationOperator2D trans;
        try {
            trans = new JgclCartesianTransformationOperator2D(hyp.position(), 1.0);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        JgclVector2D Bc2A = line.pnt().subtract(hyp.position().location());
        JgclVector2D eAirpnt = trans.reverseTransform(Bc2A);
        JgclVector2D eAirvec = trans.reverseTransform(line.dir());
        double eA2 = hyp.semiAxis() * hyp.semiAxis();
        double eB2 = hyp.semiImagAxis() * hyp.semiImagAxis();
        double[] ercoef = new double[3];
        ercoef[2] = eB2 * eAirvec.x() * eAirvec.x() - eA2 * eAirvec.y() * eAirvec.y();
        ercoef[1] = 2.0 * (eB2 * eAirpnt.x() * eAirvec.x() - eA2 * eAirpnt.y() * eAirvec.y());
        ercoef[0] = eB2 * eAirpnt.x() * eAirpnt.x() - eA2 * eAirpnt.y() * eAirpnt.y() - eA2 * eB2;
        return ercoef;
    }

    JgclIntersectionPoint2D[] intersection(JgclLine2D line, JgclHyperbola2D hyp, boolean doExchange) {
        double[] ercoef = this.getCoef(line, hyp);
        double[] root = this.getRoot(ercoef);
        if (root == null) {
            return new JgclIntersectionPoint2D[0];
        }
        double[] realRoot = this.checkDuplicate(line, root);
        return this.getIntersect(line, hyp, realRoot, doExchange);
    }
}

