/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Vector;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntsCncCnc2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;

class JgclIntsHypCnc2D
extends JgclIntsCncCnc2D {
    JgclIntsHypCnc2D() {
    }

    double[] getCoefficent(JgclHyperbola2D hypA, JgclHyperbola2D hypB, JgclCartesianTransformationOperator2D trans) {
        JgclVector2D Ac2Bc = hypB.position().location().subtract(hypA.position().location());
        JgclPoint2D eiBc = trans.toLocal(Ac2Bc).toPoint2D();
        double dAslp = Math.atan2(hypA.position().x().y(), hypA.position().x().x());
        double dBslp = Math.atan2(hypB.position().x().y(), hypB.position().x().x());
        double eslope = dBslp - dAslp;
        double erc = Math.cos(eslope);
        double ers = Math.sin(eslope);
        double a = hypA.xRadius();
        double b = hypA.yRadius();
        double e = hypB.xRadius();
        double f = hypB.yRadius();
        double cx = eiBc.x();
        double cy = eiBc.y();
        double erc2 = erc * erc;
        double ers2 = ers * ers;
        double eA2 = a * a;
        double eB2 = b * b;
        double[] eprep = new double[6];
        double[] ercoef = new double[5];
        eprep[0] = f * f * (eB2 * ers2 - eA2 * erc2);
        eprep[1] = e * e * (eB2 * erc2 - eA2 * ers2);
        eprep[2] = -2.0 * e * f * erc * ers * (eA2 + eB2);
        eprep[3] = -2.0 * f * (eB2 * cx * ers + eA2 * cy * erc);
        eprep[4] = 2.0 * e * (eB2 * cx * erc - eA2 * cy * ers);
        eprep[5] = eB2 * cx * cx - eA2 * cy * cy - eA2 * eB2;
        ercoef[4] = eprep[0] + eprep[1];
        ercoef[0] = eprep[5] + eprep[1];
        ercoef[1] = eprep[2] * eprep[4];
        ercoef[3] = 2.0 * (ercoef[4] * eprep[3] - ercoef[1]);
        ercoef[1] = 2.0 * (ercoef[0] * eprep[3] - ercoef[1]);
        ercoef[2] = 2.0 * ercoef[4] * ercoef[0] + eprep[3] * eprep[3] - eprep[2] * eprep[2] - eprep[4] * eprep[4];
        ercoef[4] = ercoef[4] * ercoef[4] - eprep[2] * eprep[2];
        ercoef[0] = ercoef[0] * ercoef[0] - eprep[4] * eprep[4];
        return ercoef;
    }

    private JgclIntersectionPoint2D[] getIntersection(JgclHyperbola2D hypA, JgclHyperbola2D hypB, JgclComplex[] ecroot, JgclCartesianTransformationOperator2D trans, boolean doExchange) {
        double dTol = hypA.getToleranceForDistance();
        Vector<JgclIntersectionPoint2D> intervec = new Vector<JgclIntersectionPoint2D>();
        int i = 0;
        while (i < ecroot.length) {
            JgclIntersectionPoint2D inter;
            JgclPointOnCurve2D bPnt;
            double coshA;
            double coshB;
            double sinhB = ecroot[i].real();
            double bParam = Math.log(sinhB + (coshB = Math.sqrt(1.0 + sinhB * sinhB)));
            JgclPoint2D dDpnt = trans.toLocal(hypB.coordinates(bParam));
            double sinhA = dDpnt.y() / hypA.yRadius();
            double aParam = Math.log(sinhA + (coshA = Math.sqrt(1.0 + sinhA * sinhA)));
            JgclPointOnCurve2D aPnt = new JgclPointOnCurve2D(hypA, aParam, false);
            if (aPnt.identical(bPnt = new JgclPointOnCurve2D(hypB, bParam, false)) && (inter = new JgclIntersectionPoint2D(aPnt, bPnt, false)) != null && this.checkUnique(inter, intervec)) {
                intervec.addElement(inter);
            }
            ++i;
        }
        JgclIntersectionPoint2D[] intersectPoints = this.vectorToArray(intervec, doExchange);
        return intersectPoints;
    }

    JgclIntersectionPoint2D[] intersection(JgclHyperbola2D hypA, JgclHyperbola2D hypB, boolean doExchange) {
        JgclCartesianTransformationOperator2D trans = new JgclCartesianTransformationOperator2D(hypA.position(), 1.0);
        double[] coefficent = this.getCoefficent(hypA, hypB, trans);
        JgclComplex[] root = this.getRoot(coefficent);
        if (root == null) {
            return new JgclIntersectionPoint2D[0];
        }
        return this.getIntersection(hypA, hypB, root, trans, doExchange);
    }
}

