/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclComplexPolynomial;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;

abstract class JgclIntsCncCnc2D {
    protected JgclComplex[] getRoot(double[] eccoef) {
        JgclComplex[] root;
        JgclComplexPolynomial poly;
        try {
            poly = new JgclComplexPolynomial(eccoef);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        if (poly.degree() < 3) {
            root = poly.getRootsIfQuadric();
        } else {
            try {
                root = poly.getRootsByDKA();
            }
            catch (JgclComplexPolynomial.DKANotConverge e) {
                root = e.getValues();
            }
            catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
                throw new JgclFatal();
            }
            catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
                throw new JgclFatal();
            }
        }
        return root;
    }

    protected JgclIntersectionPoint2D[] vectorToArray(Vector intervec, boolean doExchange) {
        Object[] intersectPoints = new JgclIntersectionPoint2D[intervec.size()];
        intervec.copyInto(intersectPoints);
        if (doExchange) {
            int i = 0;
            while (i < intersectPoints.length) {
                intersectPoints[i] = ((JgclIntersectionPoint2D)intersectPoints[i]).exchange();
                ++i;
            }
        }
        return intersectPoints;
    }

    protected boolean checkUnique(JgclIntersectionPoint2D inter, Vector intervec) {
        Enumeration en = intervec.elements();
        double paramA = inter.pointOnCurve1().parameter();
        double paramB = inter.pointOnCurve2().parameter();
        JgclParametricCurve2D curveA = inter.pointOnCurve1().basisCurve();
        JgclParametricCurve2D curveB = inter.pointOnCurve2().basisCurve();
        while (en.hasMoreElements()) {
            JgclIntersectionPoint2D obj = (JgclIntersectionPoint2D)en.nextElement();
            JgclPointOnCurve2D pointA = obj.pointOnCurve1();
            if (curveA.identicalParameter(paramA, pointA.parameter())) {
                return false;
            }
            JgclPointOnCurve2D pointB = obj.pointOnCurve2();
            if (!curveB.identicalParameter(paramB, pointB.parameter())) continue;
            return false;
        }
        return true;
    }

    JgclIntsCncCnc2D() {
    }
}

