/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclCurveSurfaceInterferenceList;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;

final class JgclIntsBscBzs3D {
    private static final boolean DEBUG = false;

    private static JgclCurveSurfaceInterferenceList getInterference(JgclBsplineCurve3D bscA, JgclPureBezierSurface3D bzsB) {
        JgclBsplineKnot.ValidSegmentInfo vldsA = bscA.validSegments();
        JgclPureBezierCurve3D[] bzcsA = bscA.toPureBezierCurveArray();
        JgclCurveSurfaceInterferenceList interferenceList = new JgclCurveSurfaceInterferenceList(bscA, bzsB);
        int iA = 0;
        while (iA < bzcsA.length) {
            JgclIntersectionPoint3D[] ints;
            try {
                ints = bzcsA[iA].intersect(bzsB);
            }
            catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                throw new JgclFatal();
            }
            int i = 0;
            while (i < ints.length) {
                interferenceList.addAsIntersection(ints[i].coordinates(), vldsA.l2Gp(iA, ints[i].pointOnCurve1().parameter()), ints[i].pointOnSurface2().uParameter(), ints[i].pointOnSurface2().vParameter());
                ++i;
            }
            ++iA;
        }
        return interferenceList;
    }

    static JgclIntersectionPoint3D[] intersection(JgclBsplineCurve3D bscA, JgclPureBezierSurface3D bzsB, boolean doExchange) {
        return JgclIntsBscBzs3D.getInterference(bscA, bzsB).toJgclIntersectionPoint3DArray(doExchange);
    }

    JgclIntsBscBzs3D() {
    }
}

