/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntsBzcBzc2D;
import jp.go.ipa.jgcl.JgclOverlapCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;

final class JgclIntsBscBsc2D {
    private static JgclCurveCurveInterferenceList getInterference(JgclBsplineCurve2D bscA, JgclBsplineCurve2D bscB) {
        JgclBsplineKnot.ValidSegmentInfo vldsA = bscA.validSegments();
        JgclPureBezierCurve2D[] bzcsA = bscA.toPureBezierCurveArray();
        JgclBsplineKnot.ValidSegmentInfo vldsB = bscB.validSegments();
        JgclPureBezierCurve2D[] bzcsB = bscB.toPureBezierCurveArray();
        JgclCurveCurveInterferenceList interferenceList = new JgclCurveCurveInterferenceList(bscA, bscB);
        int iA = 0;
        while (iA < bzcsA.length) {
            int iB = 0;
            while (iB < bzcsB.length) {
                JgclCurveCurveInterference2D[] localInterferences = JgclIntsBzcBzc2D.interference(bzcsA[iA], bzcsB[iB], false);
                Vector intsList = JgclCurveCurveInterferenceList.extractIntersections(localInterferences);
                Enumeration e = intsList.elements();
                while (e.hasMoreElements()) {
                    JgclIntersectionPoint2D ints = (JgclIntersectionPoint2D)e.nextElement();
                    interferenceList.addAsIntersection(ints.coordinates(), vldsA.l2Gp(iA, ints.pointOnCurve1().parameter()), vldsB.l2Gp(iB, ints.pointOnCurve2().parameter()));
                }
                Vector ovlpList = JgclCurveCurveInterferenceList.extractOverlaps(localInterferences);
                Enumeration e2 = ovlpList.elements();
                while (e2.hasMoreElements()) {
                    JgclOverlapCurve2D ovlp = (JgclOverlapCurve2D)e2.nextElement();
                    interferenceList.addAsOverlap(vldsA.l2Gp(iA, ovlp.start1()), vldsB.l2Gp(iB, ovlp.start2()), vldsA.l2Gw(iA, ovlp.increase1()), vldsB.l2Gw(iB, ovlp.increase2()));
                }
                ++iB;
            }
            ++iA;
        }
        interferenceList.removeOverlapsContainedInOtherOverlap();
        interferenceList.removeIntersectionsContainedInOverlap();
        return interferenceList;
    }

    static JgclCurveCurveInterference2D[] interference(JgclBsplineCurve2D bscA, JgclBsplineCurve2D bscB, boolean doExchange) {
        return JgclIntsBscBsc2D.getInterference(bscA, bscB).toJgclCurveCurveInterference2DArray(doExchange);
    }

    static JgclIntersectionPoint2D[] intersection(JgclBsplineCurve2D bscA, JgclBsplineCurve2D bscB, boolean doExchange) {
        return JgclIntsBscBsc2D.getInterference(bscA, bscB).toJgclIntersectionPoint2DArray(doExchange);
    }

    public static void main(String[] argv) {
        int[] knotMulti1 = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1};
        double[] dArray = new double[9];
        dArray[4] = 1.0;
        dArray[5] = 2.0;
        dArray[6] = 2.0;
        dArray[7] = 2.0;
        dArray[8] = 2.0;
        double[] knots1 = dArray;
        JgclPoint2D[] controlPoints1 = new JgclPoint2D[]{new JgclCartesianPoint2D(0.0, 0.0), new JgclCartesianPoint2D(10.0, 10.0), new JgclCartesianPoint2D(20.0, -10.0), new JgclCartesianPoint2D(30.0, 0.0), new JgclCartesianPoint2D(40.0, 0.0)};
        JgclBsplineCurve2D bsc1 = new JgclBsplineCurve2D(3, knotMulti1, knots1, controlPoints1);
        int[] knotMulti2 = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1};
        double[] dArray2 = new double[9];
        dArray2[4] = 1.0;
        dArray2[5] = 2.0;
        dArray2[6] = 2.0;
        dArray2[7] = 2.0;
        dArray2[8] = 2.0;
        double[] knots2 = dArray2;
        JgclPoint2D[] controlPoints2 = new JgclPoint2D[]{new JgclCartesianPoint2D(50.0, 0.0), new JgclCartesianPoint2D(30.0, 1.0), new JgclCartesianPoint2D(10.0, 0.0), new JgclCartesianPoint2D(-10.0, 5.0), new JgclCartesianPoint2D(-30.0, 10.0)};
        JgclBsplineCurve2D bsc2 = new JgclBsplineCurve2D(3, knotMulti2, knots2, controlPoints2);
        JgclIntersectionPoint2D[] result = JgclIntsBscBsc2D.intersection(bsc1, bsc2, false);
        int i = 0;
        while (i < result.length) {
            result[i].output(System.out);
            ++i;
        }
    }

    JgclIntsBscBsc2D() {
    }
}

