/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclInterpolation;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclVector2D;

class JgclInterpolation2D {
    private JgclInterpolation info;
    private JgclPoint2D[] points;
    private JgclVector2D[] endvecs;

    JgclInterpolation2D(JgclPoint2D[] points, double[] params) {
        this.info = new JgclInterpolation(params, false);
        this.points = points;
        this.endvecs = JgclInterpolation2D.besselPoints(points, params);
    }

    JgclInterpolation2D(JgclPoint2D[] points, double[] params, JgclVector2D[] endvecs) {
        this.info = new JgclInterpolation(params, false);
        this.points = points;
        this.endvecs = endvecs;
    }

    JgclInterpolation2D(JgclPoint2D[] points, double[] params, JgclVector2D[] endvecs, boolean isClosed) {
        this.info = new JgclInterpolation(params, isClosed);
        this.points = points;
        if (!this.info.isClosed) {
            this.endvecs = endvecs != null ? endvecs : JgclInterpolation2D.besselPoints(points, params);
        }
    }

    static JgclVector2D[] besselPoints(JgclPoint2D[] points, double[] params) {
        int uip = points.length;
        JgclVector2D[] endvecs = new JgclVector2D[2];
        double delta = params[1] - params[0];
        if (uip == 2) {
            endvecs[0] = points[1].subtract(points[0]);
            endvecs[0] = endvecs[0].divide(delta);
            endvecs[1] = endvecs[0];
            return endvecs;
        }
        double t = delta / (params[2] - params[0]);
        double t1 = 1.0 - t;
        double b0 = t1 * t1;
        double b1 = 2.0 * t * t1;
        double b2 = t * t;
        JgclPoint2D mPoint = points[1].subtract(points[0].multiply(b0)).toPoint2D().subtract(points[2].multiply(b2)).toPoint2D().divide(b1);
        endvecs[0] = mPoint.subtract(points[0]).multiply(t * 2.0 / delta);
        int index = uip - 3;
        t = (params[index + 1] - params[index]) / (params[index + 2] - params[index]);
        t1 = 1.0 - t;
        b0 = t1 * t1;
        b1 = 2.0 * t * t1;
        b2 = t * t;
        mPoint = points[index + 1].subtract(points[index].multiply(b0)).toPoint2D().subtract(points[index + 2].multiply(b2)).toPoint2D().divide(b1);
        delta = params[index + 2] - params[index + 1];
        endvecs[1] = points[index + 2].subtract(mPoint).multiply(t1 * 2.0 / delta);
        return endvecs;
    }

    private JgclPoint2D[] solveLS(JgclPoint2D[] cp) {
        JgclPoint2D[] newCp = new JgclPoint2D[this.info.uip];
        int i = 0;
        while (i < this.info.uip) {
            newCp[i] = cp[i];
            ++i;
        }
        int i2 = 1;
        while (i2 < this.info.uip) {
            newCp[i2] = newCp[i2].subtract(newCp[i2 - 1].multiply(this.info.matrix.getElementAt(i2, 0))).toPoint2D();
            ++i2;
        }
        int i3 = this.info.uip - 2;
        while (i3 >= 0) {
            newCp[i3] = newCp[i3].subtract(newCp[i3 + 1].multiply(this.info.matrix.getElementAt(i3, 2))).toPoint2D();
            --i3;
        }
        int i4 = 0;
        while (i4 < this.info.uip) {
            newCp[i4] = newCp[i4].divide(this.info.matrix.getElementAt(i4, 1));
            ++i4;
        }
        return newCp;
    }

    private JgclPoint2D[] solveLSClosed(JgclPoint2D[] cp) {
        double[] wX = new double[this.info.uip];
        double[] wY = new double[this.info.uip];
        JgclPoint2D[] newCp = new JgclPoint2D[this.info.uip];
        int i = 0;
        while (i < this.info.uip) {
            wX[i] = cp[i].x();
            ++i;
        }
        wX = this.info.matrix.solveSimultaneousLinearEquations(wX);
        int i2 = 0;
        while (i2 < this.info.uip) {
            wY[i2] = cp[i2].y();
            ++i2;
        }
        wY = this.info.matrix.solveSimultaneousLinearEquations(wY);
        int i3 = 1;
        while (i3 < this.info.uip) {
            newCp[i3] = new JgclCartesianPoint2D(wX[i3 - 1], wY[i3 - 1]);
            ++i3;
        }
        newCp[0] = new JgclCartesianPoint2D(wX[i3 - 1], wY[i3 - 1]);
        return newCp;
    }

    private JgclPoint2D[] solveLinearSystem() {
        JgclPoint2D[] cp = new JgclPoint2D[this.info.uip];
        cp[0] = this.points[0].add(this.endvecs[0].multiply(this.info.pInt(0) / 3.0));
        int i = 1;
        while (i < this.info.uip - 1) {
            double ework = this.info.pInt(i - 1) + this.info.pInt(i);
            cp[i] = this.points[i].multiply(ework);
            ++i;
        }
        cp[i] = this.points[i].subtract(this.endvecs[1].multiply(this.info.pInt(this.info.uip - 2) / 3.0));
        cp = this.solveLS(cp);
        JgclPoint2D[] newCp = new JgclPoint2D[this.info.uip + 2];
        newCp[0] = this.points[0];
        i = 0;
        while (i < this.info.uip) {
            newCp[i + 1] = cp[i];
            ++i;
        }
        newCp[this.info.uip + 1] = this.points[this.info.uip - 1];
        return newCp;
    }

    private JgclPoint2D[] solveLinearSystemClosed() {
        JgclPoint2D[] cp = new JgclPoint2D[this.info.uip];
        int i = 0;
        while (i < this.info.uip) {
            double ework = this.info.pInt(i - 1) + this.info.pInt(i);
            cp[i] = this.points[i].multiply(ework);
            ++i;
        }
        cp = this.solveLSClosed(cp);
        return cp;
    }

    JgclBsplineKnot knotData() {
        return this.info.knotData();
    }

    JgclPoint2D[] controlPoints() {
        if (!this.info.isClosed) {
            return this.solveLinearSystem();
        }
        return this.solveLinearSystemClosed();
    }

    double[] weights() {
        return null;
    }

    public static void main(String[] argv) {
        JgclCartesianPoint2D p0 = new JgclCartesianPoint2D(0.0, 0.0);
        JgclCartesianPoint2D p1 = new JgclCartesianPoint2D(1.0, 1.0);
        JgclCartesianPoint2D p2 = new JgclCartesianPoint2D(2.0, 0.0);
        JgclCartesianPoint2D p3 = new JgclCartesianPoint2D(1.0, -1.0);
        JgclLiteralVector2D v = new JgclLiteralVector2D(0.0, -1.0);
        JgclPoint2D[] points = new JgclCartesianPoint2D[]{p0, p1, p2};
        double[] dArray = new double[3];
        dArray[1] = 0.5;
        dArray[2] = 1.0;
        double[] params = dArray;
        JgclVector2D[] vectors = new JgclLiteralVector2D[]{v, v};
        System.out.println("\n\n<for open case.>\n");
        JgclInterpolation2D open = new JgclInterpolation2D(points, params, vectors);
        JgclPoint2D[] cp = open.controlPoints();
        System.out.println("\n\n[interpolated points]\n");
        int i = 0;
        while (i < cp.length) {
            System.out.println("cp[" + i + "] = (" + cp[i].x() + ", " + cp[i].y() + ")");
            ++i;
        }
        JgclPoint2D[] pointsClosed = new JgclCartesianPoint2D[]{p0, p1, p2, p3};
        double[] dArray2 = new double[5];
        dArray2[1] = 0.25;
        dArray2[2] = 0.5;
        dArray2[3] = 0.75;
        dArray2[4] = 1.0;
        double[] paramsClosed = dArray2;
        System.out.println("\n\n<for closed case.>\n");
        JgclInterpolation2D closed = new JgclInterpolation2D(pointsClosed, paramsClosed, null, true);
        JgclPoint2D[] cpClosed = closed.controlPoints();
        System.out.println("\n[interpolated points]\n");
        int i2 = 0;
        while (i2 < cpClosed.length) {
            System.out.println("cp[" + i2 + "] = (" + cpClosed[i2].x() + ", " + cpClosed[i2].y() + ")");
            ++i2;
        }
    }
}

