/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclComplexPolynomial;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConic2D;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntsHypCnc2D;
import jp.go.ipa.jgcl.JgclIntsLinCnc2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclOfst2D;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPointOnGeometryList;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclRealFunctionWithOneVariable;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;

public class JgclHyperbola2D
extends JgclConic2D {
    private double semiAxis;
    private double semiImagAxis;

    private void setSemiAxis(double semiAxis, double semiImagAxis) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        if (semiAxis < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.semiAxis = semiAxis;
        if (semiImagAxis < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.semiImagAxis = semiImagAxis;
    }

    public JgclHyperbola2D(JgclAxis2Placement2D position, double semiAxis, double semiImagAxis) {
        super(position);
        this.setSemiAxis(semiAxis, semiImagAxis);
    }

    public double semiAxis() {
        return this.semiAxis;
    }

    public double xRadius() {
        return this.semiAxis;
    }

    public double semiImagAxis() {
        return this.semiImagAxis;
    }

    public double yRadius() {
        return this.semiImagAxis;
    }

    public double length(JgclParameterSection pint) {
        double m2hbl_majrd2 = this.semiAxis() * this.semiAxis();
        double m2hbl_minrd2 = this.semiImagAxis() * this.semiImagAxis();
        double dTol = this.getToleranceForDistance() / 2.0;
        return JgclMath.getDefiniteIntegral(new 1(m2hbl_majrd2, m2hbl_minrd2), pint, dTol);
    }

    public JgclPoint2D coordinates(double param) {
        JgclAxis2Placement2D ax = this.position();
        JgclVector2D x = ax.x().multiply(JgclMath.cosh(param) * this.semiAxis);
        JgclVector2D y = ax.y().multiply(JgclMath.sinh(param) * this.semiImagAxis);
        return ax.location().add(x.add(y));
    }

    public JgclVector2D tangentVector(double param) {
        JgclAxis2Placement2D ax = this.position();
        JgclVector2D x1 = ax.x().multiply(JgclMath.sinh(param) * this.semiAxis);
        JgclVector2D y1 = ax.y().multiply(JgclMath.cosh(param) * this.semiImagAxis);
        return x1.add(y1);
    }

    public JgclCurveCurvature2D curvature(double param) {
        JgclAxis2Placement2D ax = this.position();
        double x1len = JgclMath.sinh(param) * this.semiAxis;
        double y1len = JgclMath.cosh(param) * this.semiImagAxis;
        double x2len = JgclMath.cosh(param) * this.semiAxis;
        double y2len = JgclMath.sinh(param) * this.semiImagAxis;
        double tlen = Math.sqrt(x1len * x1len + y1len * y1len);
        double crv = Math.abs(x1len * y2len - y1len * x2len) / (tlen * tlen * tlen);
        JgclVector2D ex1 = ax.x().multiply(x1len);
        JgclVector2D ey1 = ax.y().multiply(y1len);
        JgclVector2D tangent = ex1.add(ey1);
        JgclLiteralVector2D nrmDir = new JgclLiteralVector2D(tangent.y(), -tangent.x());
        return new JgclCurveCurvature2D(crv, nrmDir.unitized());
    }

    public JgclCurveDerivative2D evaluation(double param) {
        JgclAxis2Placement2D ax = this.position();
        JgclVector2D ex = ax.x().multiply(JgclMath.cosh(param) * this.semiAxis);
        JgclVector2D ey = ax.y().multiply(JgclMath.sinh(param) * this.semiImagAxis);
        JgclVector2D ex1 = ax.x().multiply(JgclMath.sinh(param) * this.semiAxis);
        JgclVector2D ey1 = ax.y().multiply(JgclMath.cosh(param) * this.semiImagAxis);
        JgclVector2D d1 = ex1.add(ey1);
        JgclVector2D d2 = ex.add(ey);
        JgclPoint2D d0 = ax.location().add(d2);
        return new JgclCurveDerivative2D(d0, d1, d2);
    }

    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) {
        JgclComplex[] root;
        JgclCartesianTransformationOperator2D trans;
        double dTol2 = this.getToleranceForDistance2();
        try {
            trans = new JgclCartesianTransformationOperator2D(this.position(), 1.0);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        JgclVector2D Bc2A = point.subtract(this.position().location());
        JgclVector2D eAir = trans.reverseTransform(Bc2A);
        if ((eAir.x() - this.semiAxis) * (eAir.x() - this.semiAxis) < dTol2 && eAir.y() * eAir.y() < dTol2) {
            root = new JgclComplex[]{new JgclComplex(0.0)};
        } else {
            JgclComplexPolynomial pol;
            double eDDD = this.semiAxis * eAir.x();
            double eEEE = this.semiImagAxis * eAir.y();
            double eFFF = this.semiAxis * this.semiAxis + this.semiImagAxis * this.semiImagAxis;
            double[] ercoef = new double[5];
            ercoef[4] = eFFF * eFFF;
            ercoef[0] = eEEE * eEEE;
            ercoef[3] = -2.0 * eEEE * eFFF;
            ercoef[1] = ercoef[3];
            ercoef[2] = ercoef[4] + ercoef[0] - eDDD * eDDD;
            try {
                pol = new JgclComplexPolynomial(ercoef);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            try {
                root = pol.getRootsByDKA();
            }
            catch (JgclComplexPolynomial.DKANotConverge e) {
                root = e.getValues();
            }
            catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
                throw new JgclFatal();
            }
            catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
                throw new JgclFatal();
            }
        }
        JgclPointOnGeometryList projList = new JgclPointOnGeometryList();
        int i = 0;
        while (i < root.length) {
            double eSINH = root[i].real();
            JgclPointOnCurve2D proj = this.checkProjection(JgclMath.asinh(eSINH), point, dTol2);
            if (proj != null) {
                projList.addPoint(proj);
            }
            ++i;
        }
        return projList.toJgclPointOnCurve2DArray();
    }

    double getPeak(double left, double right) {
        return JgclMath.atanh((JgclMath.cosh(right) - JgclMath.cosh(left)) / (JgclMath.sinh(right) - JgclMath.sinh(left)));
    }

    public JgclPureBezierCurve2D[] toPolyBezierCurves(JgclParameterSection pint) {
        JgclPoint2D[] controlPoints = this.getControlPointsOfBezierCurve(pint);
        double[] weights = new double[]{1.0, 1.0, 1.0};
        JgclVector2D mvec = controlPoints[2].subtract(controlPoints[0]);
        JgclCartesianTransformationOperator2D localTransformationOperator = this.position().toCartesianTransformationOperator(1.0);
        JgclVector2D tmvec = localTransformationOperator.toLocal(mvec).unitized();
        double shoulderParam = JgclMath.atanh(this.yRadius() * tmvec.x() / (this.xRadius() * tmvec.y()));
        JgclPoint2D shoulderPoint = this.coordinates(shoulderParam);
        JgclPoint2D middlePoint = controlPoints[0].midPoint(controlPoints[2]);
        double vvv = Math.sqrt(shoulderPoint.subtract(middlePoint).norm() / controlPoints[1].subtract(middlePoint).norm());
        weights[1] = vvv / (1.0 - vvv);
        JgclPureBezierCurve2D[] bzcs = new JgclPureBezierCurve2D[]{new JgclPureBezierCurve2D(controlPoints, weights)};
        return bzcs;
    }

    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
        JgclPureBezierCurve2D[] bzcs = this.toPolyBezierCurves(pint);
        return bzcs[0].toBsplineCurve();
    }

    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
        JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
        JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
        double dAlrd2 = this.xRadius() * this.xRadius();
        double dAsrd2 = this.yRadius() * this.yRadius();
        boolean isPoly = poly.length < 3;
        int degree = xPoly.degree();
        double[] coef = new double[degree + 1];
        if (isPoly) {
            int j = 0;
            while (j <= degree) {
                coef[j] = xPoly.coefficientAt(j) / dAlrd2 - yPoly.coefficientAt(j) / dAsrd2;
                ++j;
            }
            coef[0] = coef[0] - 1.0;
        } else {
            JgclRealPolynomial wPoly = poly[2].multiply(poly[2]);
            int j = 0;
            while (j <= degree) {
                coef[j] = dAsrd2 * xPoly.coefficientAt(j) - dAlrd2 * yPoly.coefficientAt(j) - dAlrd2 * dAsrd2 * wPoly.coefficientAt(j);
                ++j;
            }
        }
        return new JgclRealPolynomial(coef);
    }

    boolean checkSolution(JgclPoint2D point) {
        double param = this.getParameter(point);
        double px = this.xRadius() * JgclMath.cosh(param);
        double py = this.yRadius() * JgclMath.sinh(param);
        return point.identical(new JgclCartesianPoint2D(px, py));
    }

    double getParameter(JgclPoint2D point) {
        double sinh = point.y() / this.yRadius();
        return JgclMath.asinh(sinh);
    }

    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
        JgclIntsLinCnc2D doObj = new JgclIntsLinCnc2D(mate, this);
        return doObj.intersection(mate, this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) throws JgclIndefiniteSolution {
        if (this.position().location().identical(mate.position().location()) && this.position().x().identicalDirection(mate.position().x())) {
            double d_tol = this.getToleranceForDistance();
            if (Math.abs(this.xRadius() - mate.xRadius()) <= d_tol && Math.abs(this.yRadius() - mate.yRadius()) <= d_tol) {
                JgclIntersectionPoint2D one_sol = !doExchange ? new JgclIntersectionPoint2D(this, 0.0, mate, 0.0, false) : new JgclIntersectionPoint2D(mate, 0.0, this, 0.0, false);
                throw new JgclIndefiniteSolution(one_sol);
            }
        }
        JgclIntsHypCnc2D doObj = new JgclIntsHypCnc2D();
        return doObj.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst2D doObj = new JgclOfst2D(this, pint, magni, side, tol);
        return doObj.offset();
    }

    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    JgclParameterDomain getParameterDomain() {
        return new JgclParameterDomain();
    }

    boolean getClosedFlag() {
        return false;
    }

    int type() {
        return 12;
    }

    protected synchronized JgclParametricCurve2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        double tSemiImagAxis;
        double tSemiAxis;
        JgclAxis2Placement2D tPosition = this.position().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        if (!reverseTransform) {
            tSemiAxis = transformationOperator.transform(this.semiAxis());
            tSemiImagAxis = transformationOperator.transform(this.semiImagAxis());
        } else {
            tSemiAxis = transformationOperator.reverseTransform(this.semiAxis());
            tSemiImagAxis = transformationOperator.reverseTransform(this.semiImagAxis());
        }
        return new JgclHyperbola2D(tPosition, tSemiAxis, tSemiImagAxis);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tposition");
        this.position().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tsemiAxis " + this.semiAxis);
        writer.println(String.valueOf(indent_tab) + "\tsemiImagAxis " + this.semiImagAxis);
        writer.println(String.valueOf(indent_tab) + "End");
    }

    private static final class 1
    implements JgclRealFunctionWithOneVariable {
        private final /* synthetic */ double val$m2hbl_minrd2;
        private final /* synthetic */ double val$m2hbl_majrd2;

        public double evaluate(double parameter) {
            double ecosh = JgclMath.cosh(parameter);
            double esinh = JgclMath.sinh(parameter);
            return Math.sqrt(this.val$m2hbl_majrd2 * esinh * esinh + this.val$m2hbl_minrd2 * ecosh * ecosh);
        }

        /* synthetic */ 1(double val$m2hbl_majrd2, double val$m2hbl_minrd2) {
            this.val$m2hbl_majrd2 = val$m2hbl_majrd2;
            this.val$m2hbl_minrd2 = val$m2hbl_minrd2;
        }
    }
}

