/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclPoint3D;

public class JgclHomogeneousPoint3D
extends JgclPoint3D {
    private double wx;
    private double wy;
    private double wz;
    private double w;

    private void setArgs(double wx, double wy, double wz, double w) {
        this.wx = wx;
        this.wy = wy;
        this.wz = wz;
        this.w = w;
    }

    public JgclHomogeneousPoint3D(double wx, double wy, double wz, double w) {
        this.setArgs(wx, wy, wz, w);
    }

    public JgclHomogeneousPoint3D(double[] c) {
        this.setArgs(c[0], c[1], c[2], c[3]);
    }

    public double x() {
        return this.wx / this.w;
    }

    public double y() {
        return this.wy / this.w;
    }

    public double z() {
        return this.wz / this.w;
    }

    public double wx() {
        return this.wx;
    }

    public double wy() {
        return this.wy;
    }

    public double wz() {
        return this.wz;
    }

    public double w() {
        return this.w;
    }

    protected synchronized JgclPoint3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D crd = !reverseTransform ? transformationOperator.transform(this) : transformationOperator.reverseTransform(this);
        return new JgclHomogeneousPoint3D(this.w * crd.x(), this.w * crd.y(), this.w * crd.z(), this.w);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName() + " " + this.wx() + " " + this.wy() + " " + this.wz() + " " + this.w() + " End");
    }
}

