/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclEnclosingBox2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclParametricSurface2D;

abstract class JgclFreeformSurfaceWithGivenControlPointsArray2D
extends JgclParametricSurface2D {
    protected double[][][] controlPointsArray;
    boolean isRational;

    protected JgclFreeformSurfaceWithGivenControlPointsArray2D(double[][][] cpArray) {
        this.controlPointsArray = cpArray;
        this.isRational = this.controlPointsArray[0][0].length == 3;
    }

    protected static double[][][] allocateDoubleArray(boolean isPoly, int uSize, int vSize) {
        return new double[uSize][vSize][isPoly ? 2 : 3];
    }

    protected double[][][] toDoubleArray() {
        return this.controlPointsArray;
    }

    public double xAt(int i, int j) {
        if (!this.isRational) {
            return this.controlPointsArray[i][j][0];
        }
        return this.controlPointsArray[i][j][0] / this.controlPointsArray[i][j][2];
    }

    public double yAt(int i, int j) {
        if (!this.isRational) {
            return this.controlPointsArray[i][j][1];
        }
        return this.controlPointsArray[i][j][1] / this.controlPointsArray[i][j][2];
    }

    public double weightAt(int i, int j) {
        if (!this.isRational) {
            throw new JgclInvalidArgumentValue();
        }
        return this.controlPointsArray[i][j][2];
    }

    public int uNControlPoints() {
        return this.controlPointsArray.length;
    }

    public int vNControlPoints() {
        return this.controlPointsArray[0].length;
    }

    public int nControlPoints() {
        return this.uNControlPoints() * this.vNControlPoints();
    }

    public boolean isRational() {
        return this.isRational;
    }

    public boolean isPolynomial() {
        return !this.isRational;
    }

    protected void convRational0Deriv(double[] d0) {
        int i = 0;
        while (i < 2) {
            int n = i++;
            d0[n] = d0[n] / d0[2];
        }
    }

    protected void convRational1Deriv(double[] d0, double[] du, double[] dv) {
        this.convRational0Deriv(d0);
        int i = 0;
        while (i < 2) {
            du[i] = (du[i] - du[2] * d0[i]) / d0[2];
            dv[i] = (dv[i] - dv[2] * d0[i]) / d0[2];
            ++i;
        }
    }

    protected void convRational2Deriv(double[] d0, double[] du, double[] dv, double[] duu, double[] duv, double[] dvv) {
        this.convRational1Deriv(d0, du, dv);
        int i = 0;
        while (i < 2) {
            duu[i] = (duu[i] - duu[2] * d0[i] - 2.0 * du[2] * du[i]) / d0[2];
            duv[i] = (duv[i] - duv[2] * d0[i] - du[2] * dv[i] - dv[2] * du[i]) / d0[2];
            dvv[i] = (dvv[i] - dvv[2] * d0[i] - 2.0 * dv[2] * dv[i]) / d0[2];
            ++i;
        }
    }

    JgclEnclosingBox2D approximateEnclosingBox() {
        double y;
        double x;
        double min_crd_y;
        double min_crd_x;
        int uN = this.uNControlPoints();
        int vN = this.vNControlPoints();
        double max_crd_x = min_crd_x = this.xAt(0, 0);
        double max_crd_y = min_crd_y = this.yAt(0, 0);
        int i = 1;
        while (i < uN) {
            x = this.xAt(i, 0);
            y = this.yAt(i, 0);
            if (x < min_crd_x) {
                min_crd_x = x;
            } else if (x > max_crd_x) {
                max_crd_x = x;
            }
            if (y < min_crd_y) {
                min_crd_y = y;
            } else if (y > max_crd_y) {
                max_crd_y = y;
            }
            ++i;
        }
        int j = 1;
        while (j < vN) {
            i = 0;
            while (i < uN) {
                x = this.xAt(i, j);
                y = this.yAt(i, j);
                if (x < min_crd_x) {
                    min_crd_x = x;
                } else if (x > max_crd_x) {
                    max_crd_x = x;
                }
                if (y < min_crd_y) {
                    min_crd_y = y;
                } else if (y > max_crd_y) {
                    max_crd_y = y;
                }
                ++i;
            }
            ++j;
        }
        return new JgclEnclosingBox2D(min_crd_x, min_crd_y, max_crd_x, max_crd_y);
    }

    public boolean isFreeform() {
        return true;
    }
}

