/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclNonParametricCurve3D;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnGeometry3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclFilletSection3D
extends JgclNonParametricCurve3D {
    private double radius;
    private JgclPoint3D center;
    private JgclPointOnGeometry3D pointOnGeometry1;
    private JgclPointOnGeometry3D pointOnGeometry2;

    JgclFilletSection3D(double radius, JgclPoint3D center, JgclPointOnGeometry3D pointOnGeometry1, JgclPointOnGeometry3D pointOnGeometry2) {
        this.radius = radius;
        this.center = center;
        this.pointOnGeometry1 = pointOnGeometry1;
        this.pointOnGeometry2 = pointOnGeometry2;
    }

    public double radius() {
        return this.radius;
    }

    public JgclPoint3D center() {
        return this.center;
    }

    public JgclPointOnGeometry3D pointOnGeometry1() {
        return this.pointOnGeometry1;
    }

    public JgclPointOnGeometry3D pointOnGeometry2() {
        return this.pointOnGeometry2;
    }

    public JgclPointOnSurface3D pointOnSurface1() {
        if (!this.pointOnGeometry1().geometry().isSurface()) {
            return null;
        }
        return (JgclPointOnSurface3D)this.pointOnGeometry1();
    }

    public JgclPointOnSurface3D pointOnSurface2() {
        if (!this.pointOnGeometry2().geometry().isSurface()) {
            return null;
        }
        return (JgclPointOnSurface3D)this.pointOnGeometry2();
    }

    public JgclTrimmedCurve3D toCurve(boolean smallFan) {
        JgclVector3D vecE;
        JgclVector3D vecS = this.pointOnSurface1().subtract(this.center()).unitized();
        if (vecS.parallelDirection(vecE = this.pointOnSurface2().subtract(this.center()).unitized())) {
            throw new JgclInvalidArgumentValue();
        }
        JgclVector3D nrm = vecS.crossProduct(vecE);
        double angle = vecS.angleWith(vecE, nrm);
        if (angle < Math.PI && !smallFan || angle > Math.PI && smallFan) {
            angle -= Math.PI * 2;
        }
        JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(this.center(), nrm, vecS);
        JgclCircle3D cir = new JgclCircle3D(a2p, this.radius);
        JgclParameterSection section = new JgclParameterSection(0.0, angle);
        return new JgclTrimmedCurve3D(cir, section);
    }

    JgclFilletSection3D exchange() {
        return new JgclFilletSection3D(this.radius(), this.center(), this.pointOnGeometry2(), this.pointOnGeometry1());
    }

    boolean parametricallyIdentical(JgclFilletSection3D mate) {
        if (!this.center.identical(mate.center())) {
            return false;
        }
        if (!this.pointOnGeometry1.identical(mate.pointOnGeometry1())) {
            return false;
        }
        return this.pointOnGeometry2.identical(mate.pointOnGeometry2());
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tradius " + this.radius);
        writer.println(String.valueOf(indent_tab) + "\tcenter");
        this.center().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tpointOnGeometry1");
        this.pointOnGeometry1().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tpointOnGeometry2");
        this.pointOnGeometry2().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

