/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import jp.go.ipa.jgcl.JgclFilletSection3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclNonParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPolyline3D;

public class JgclFilletObject3D
extends JgclNonParametricSurface3D {
    private JgclFilletSection3D[] sections;

    JgclFilletObject3D(JgclFilletSection3D[] sections) {
        int nSections = sections.length;
        if (nSections < 2) {
            throw new JgclInvalidArgumentValue();
        }
        this.sections = new JgclFilletSection3D[nSections];
        int i = 0;
        while (i < nSections) {
            this.sections[i] = sections[i];
            ++i;
        }
    }

    public JgclFilletSection3D[] sections() {
        JgclFilletSection3D[] copied = new JgclFilletSection3D[this.nSections()];
        int i = 0;
        while (i < this.nSections()) {
            copied[i] = this.sectionAt(i);
            ++i;
        }
        return copied;
    }

    public int nSections() {
        return this.sections.length;
    }

    public JgclFilletSection3D sectionAt(int n) {
        return this.sections[n];
    }

    JgclFilletObject3D exchange() {
        JgclFilletSection3D[] copied = this.sections();
        int i = 0;
        while (i < this.nSections()) {
            copied[i] = copied[i].exchange();
            ++i;
        }
        return new JgclFilletObject3D(copied);
    }

    public JgclPolyline3D curveOfCenter() {
        JgclPoint3D[] pnts3D = new JgclPoint3D[this.nSections()];
        int i = 0;
        while (i < this.nSections()) {
            pnts3D[i] = this.sectionAt(i).center();
            ++i;
        }
        return new JgclPolyline3D(pnts3D);
    }

    public JgclPolyline2D curveOnSurface1() {
        JgclPoint2D[] pnts2D = new JgclPoint2D[this.nSections()];
        int i = 0;
        while (i < this.nSections()) {
            JgclPointOnSurface3D pnt3D = this.sectionAt(i).pointOnSurface1();
            pnts2D[i] = JgclPoint2D.of(pnt3D.uParameter(), pnt3D.vParameter());
            ++i;
        }
        return new JgclPolyline2D(pnts2D);
    }

    public JgclPolyline2D curveOnSurface2() {
        JgclPoint2D[] pnts2D = new JgclPoint2D[this.nSections()];
        int i = 0;
        while (i < this.nSections()) {
            JgclPointOnSurface3D pnt3D = this.sectionAt(i).pointOnSurface2();
            pnts2D[i] = JgclPoint2D.of(pnt3D.uParameter(), pnt3D.vParameter());
            ++i;
        }
        return new JgclPolyline2D(pnts2D);
    }

    public boolean isFreeform() {
        return true;
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tsections");
        int i = 0;
        while (i < this.nSections()) {
            this.sectionAt(i).output(writer, indent + 2);
            ++i;
        }
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

