/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConic2D;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsCncBzs3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclEllipse3D
extends JgclConic3D {
    private double semiAxis1;
    private double semiAxis2;

    private void setSemiAxis(double semiAxis1, double semiAxis2) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        if (semiAxis1 < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.semiAxis1 = semiAxis1;
        if (semiAxis2 < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.semiAxis2 = semiAxis2;
    }

    public JgclEllipse3D(JgclAxis2Placement3D position, double semiAxis1, double semiAxis2) {
        super(position);
        this.setSemiAxis(semiAxis1, semiAxis2);
    }

    JgclConic2D toLocal2D(JgclAxis2Placement2D position) {
        return new JgclEllipse2D(position, this.semiAxis1(), this.semiAxis2());
    }

    public double semiAxis1() {
        return this.semiAxis1;
    }

    public double xRadius() {
        return this.semiAxis1;
    }

    public double semiAxis2() {
        return this.semiAxis2;
    }

    public double yRadius() {
        return this.semiAxis2;
    }

    public JgclPoint3D coordinates(double param) {
        param = this.parameterDomain().wrap(param);
        JgclAxis2Placement3D ax = this.position();
        JgclVector3D ex = ax.x().multiply(Math.cos(param) * this.semiAxis1);
        JgclVector3D ey = ax.y().multiply(Math.sin(param) * this.semiAxis2);
        return ax.location().add(ex.add(ey));
    }

    public JgclVector3D tangentVector(double param) {
        param = this.parameterDomain().wrap(param);
        JgclAxis2Placement3D ax = this.position();
        JgclVector3D ex1 = ax.x().multiply(-Math.sin(param) * this.semiAxis1);
        JgclVector3D ey1 = ax.y().multiply(Math.cos(param) * this.semiAxis2);
        return ex1.add(ey1);
    }

    public JgclCurveCurvature3D curvature(double param) {
        param = this.parameterDomain().wrap(param);
        JgclAxis2Placement3D ax = this.position();
        double xlen = Math.cos(param) * this.semiAxis1;
        double ylen = Math.sin(param) * this.semiAxis2;
        double x1len = -Math.sin(param) * this.semiAxis1;
        double y1len = Math.cos(param) * this.semiAxis2;
        double plen = Math.sqrt(x1len * x1len + y1len * y1len);
        double crv = Math.abs(x1len * ylen - y1len * xlen) / (plen * plen * plen);
        JgclVector3D ex1 = ax.x().multiply(x1len);
        JgclVector3D ey1 = ax.y().multiply(y1len);
        JgclVector3D tangent = ex1.add(ey1);
        JgclVector3D nrmDir = ax.z().crossProduct(tangent);
        return new JgclCurveCurvature3D(crv, nrmDir.unitized());
    }

    public JgclCurveDerivative3D evaluation(double param) {
        param = this.parameterDomain().wrap(param);
        JgclAxis2Placement3D ax = this.position();
        JgclVector3D ex = ax.x().multiply(Math.cos(param) * this.semiAxis1);
        JgclVector3D ey = ax.y().multiply(Math.sin(param) * this.semiAxis2);
        JgclVector3D ex1 = ax.x().multiply(-Math.sin(param) * this.semiAxis1);
        JgclVector3D ey1 = ax.y().multiply(Math.cos(param) * this.semiAxis2);
        JgclPoint3D d0 = ax.location().add(ex.add(ey));
        JgclVector3D d1 = ex1.add(ey1);
        JgclVector3D d2 = ex.add(ey).multiply(-1.0);
        JgclVector3D d3 = ex1.add(ey1).multiply(-1.0);
        return new JgclCurveDerivative3D(d0, d1, d2, d3);
    }

    double getPeak(double left, double right) {
        double peak = Math.atan2(Math.cos(left) - Math.cos(right), Math.sin(right) - Math.sin(left));
        while (peak < left) {
            peak += Math.PI;
        }
        while (peak > right) {
            peak -= Math.PI;
        }
        return peak;
    }

    public JgclPureBezierCurve3D[] toPolyBezierCurves(JgclParameterSection pint) {
        JgclEllipse2D this2D = (JgclEllipse2D)this.toLocal2D(JgclAxis2Placement2D.origin);
        JgclPureBezierCurve2D[] bzcs2D = this2D.toPolyBezierCurves(pint);
        return this.transformPolyBezierCurvesInLocal2DToGrobal3D(bzcs2D);
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
        JgclPureBezierCurve3D[] bzcs = this.toPolyBezierCurves(pint);
        boolean closed = Math.abs(pint.increase()) >= Math.PI * 2;
        return JgclConic3D.convertPolyBezierCurvesToOneBsplineCurve(bzcs, closed);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
        JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
        JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
        double dAlrd2 = this.xRadius() * this.xRadius();
        double dAsrd2 = this.yRadius() * this.yRadius();
        boolean isPoly = poly.length < 4;
        int degree = xPoly.degree();
        double[] coef = new double[degree + 1];
        if (isPoly) {
            int j = 0;
            while (j <= degree) {
                coef[j] = xPoly.coefficientAt(j) / dAlrd2 + yPoly.coefficientAt(j) / dAsrd2;
                ++j;
            }
            coef[0] = coef[0] - 1.0;
        } else {
            JgclRealPolynomial wPoly = poly[3].multiply(poly[3]);
            int j = 0;
            while (j <= degree) {
                coef[j] = dAsrd2 * xPoly.coefficientAt(j) + dAlrd2 * yPoly.coefficientAt(j) - dAlrd2 * dAsrd2 * wPoly.coefficientAt(j);
                ++j;
            }
        }
        return new JgclRealPolynomial(coef);
    }

    boolean checkSolution(JgclPoint3D point) {
        double param = this.getParameter(point);
        double px = this.xRadius() * Math.cos(param);
        double py = this.yRadius() * Math.sin(param);
        return point.identical(new JgclCartesianPoint3D(px, py, 0.0));
    }

    double getParameter(JgclPoint3D point) {
        double cos = point.x() / this.xRadius();
        if (cos > 1.0) {
            cos = 1.0;
        }
        if (cos < -1.0) {
            cos = -1.0;
        }
        double acos = Math.acos(cos);
        if (point.y() < 0.0) {
            acos = Math.PI * 2 - acos;
        }
        return acos;
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
        try {
            return this.intersectCnc(mate, doExchange);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.intersectCnc(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
        try {
            return this.intersectCnc(mate, doExchange);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
        try {
            return this.intersectCnc(mate, doExchange);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        return new JgclEllipse3D(this.position().parallelTranslate(moveVec), this.semiAxis1, this.semiAxis2);
    }

    JgclParameterDomain getParameterDomain() {
        try {
            return new JgclParameterDomain(true, 0.0, Math.PI * 2);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    boolean getClosedFlag() {
        return true;
    }

    int type() {
        return 11;
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        JgclAxis2Placement3D rpos = this.position().rotateZ(trns, rCos, rSin);
        return new JgclEllipse3D(rpos, this.semiAxis1(), this.semiAxis2());
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        JgclVector3D vector;
        JgclPoint3D point;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol2 = condition.getToleranceForDistance2();
        double start = 0.0;
        double increase = 1.5707963267948966;
        int itry = 0;
        int limit = 3;
        do {
            if (itry > limit) {
                throw new JgclFatal();
            }
            point = this.coordinates(start + increase * (double)itry);
            vector = point.subtract(line.project1From(point));
            ++itry;
        } while (point.isOn(line) || vector.norm() < dTol2);
        return point;
    }

    boolean checkInterfere(JgclIntsCncBzs3D.BezierSurfaceInfo bi) {
        double dTol = this.getToleranceForDistance();
        if (!(bi.box.min().z() < -dTol) || !(bi.box.max().z() > dTol)) {
            return false;
        }
        double ratio = this.yRadius() / this.xRadius();
        boolean all_in = true;
        boolean all_out = true;
        JgclPoint2D[] point = new JgclPoint2D[]{new JgclCartesianPoint2D(bi.box.min().x(), bi.box.min().y() / ratio), new JgclCartesianPoint2D(bi.box.max().x(), bi.box.min().y() / ratio), new JgclCartesianPoint2D(bi.box.max().x(), bi.box.max().y() / ratio), new JgclCartesianPoint2D(bi.box.min().x(), bi.box.max().y() / ratio)};
        int i = 0;
        while (i < 4) {
            double dist = point[i].toVector2D().length();
            if (dist < this.xRadius() - dTol) {
                all_out = false;
            } else if (dist > this.xRadius() + dTol) {
                all_in = false;
            } else {
                all_out = false;
                all_in = false;
            }
            ++i;
        }
        if (all_in) {
            return false;
        }
        if (all_out) {
            if (bi.box.min().x() > this.xRadius() + dTol || bi.box.min().y() > this.yRadius() + dTol || bi.box.max().x() < -(this.xRadius() + dTol) || bi.box.max().y() < -(this.yRadius() + dTol)) {
                return false;
            }
            return !(point[0].x() > 0.0 && point[0].y() > 0.0 || point[1].x() < 0.0 && point[1].y() > 0.0 || point[2].x() < 0.0 && point[2].y() < 0.0) && (!(point[3].x() > 0.0) || !(point[3].y() < 0.0));
        }
        return true;
    }

    JgclIntersectionPoint3D[] intersectConicPlane(JgclPlane3D plane) {
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(JgclPoint3D.origin, null, null);
        JgclEllipse3D ellipse = new JgclEllipse3D(position, this.xRadius(), this.yRadius());
        try {
            return ellipse.intersect(plane);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclPoint3D nlFunc(double parameter) {
        double x = this.xRadius() * Math.cos(parameter);
        double y = this.yRadius() * Math.sin(parameter);
        double z = 0.0;
        return new JgclCartesianPoint3D(x, y, z);
    }

    JgclVector3D dnlFunc(double parameter) {
        double x = -this.xRadius() * Math.sin(parameter);
        double y = this.yRadius() * Math.cos(parameter);
        double z = 0.0;
        return new JgclLiteralVector3D(x, y, z);
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        double tSemiAxis2;
        double tSemiAxis1;
        JgclAxis2Placement3D tPosition = this.position().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        if (!reverseTransform) {
            tSemiAxis1 = transformationOperator.transform(this.semiAxis1());
            tSemiAxis2 = transformationOperator.transform(this.semiAxis2());
        } else {
            tSemiAxis1 = transformationOperator.reverseTransform(this.semiAxis1());
            tSemiAxis2 = transformationOperator.reverseTransform(this.semiAxis2());
        }
        return new JgclEllipse3D(tPosition, tSemiAxis1, tSemiAxis2);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tposition");
        this.position().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tsemiAxis1 " + this.semiAxis1);
        writer.println(String.valueOf(indent_tab) + "\tsemiAxis2 " + this.semiAxis2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

