/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclComplexPolynomial;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclToParameterSpaceOfSurface3D;

public abstract class JgclElementarySurface3D
extends JgclParametricSurface3D {
    private final JgclAxis2Placement3D position;

    private JgclElementarySurface3D() {
        this.position = null;
    }

    protected JgclElementarySurface3D(JgclAxis2Placement3D position) {
        if (position == null) {
            throw new JgclInvalidArgumentValue("position is null.");
        }
        this.position = position;
    }

    public JgclAxis2Placement3D position() {
        return this.position;
    }

    JgclParametricCurve2D curveToParameterCurve(JgclParametricCurve3D curve) {
        return JgclToParameterSpaceOfSurface3D.convertCurve(curve, this);
    }

    JgclIntersectionCurve3D curveToIntersectionCurve(JgclParametricCurve3D curve, JgclElementarySurface3D mate, boolean doExchange) {
        JgclParametricCurve2D pcrv1 = this.curveToParameterCurve(curve);
        JgclParametricCurve2D pcrv2 = mate.curveToParameterCurve(curve);
        if (!doExchange) {
            return new JgclIntersectionCurve3D(curve, this, pcrv1, mate, pcrv2, 0);
        }
        return new JgclIntersectionCurve3D(curve, mate, pcrv2, this, pcrv1, 0);
    }

    protected JgclCartesianTransformationOperator3D toGlobal() {
        try {
            return new JgclCartesianTransformationOperator3D(this.position(), 1.0);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    abstract JgclRealPolynomial makePoly(JgclRealPolynomial[] var1);

    abstract boolean checkSolution(JgclPoint3D var1);

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclConic3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return mate.intersectQrd(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        JgclComplex[] roots;
        JgclCartesianTransformationOperator3D transform = this.toGlobal();
        int uicp = mate.nControlPoints();
        JgclPoint3D[] newCp = new JgclPoint3D[uicp];
        int i = 0;
        while (i < uicp) {
            newCp[i] = transform.toLocal(mate.controlPointAt(i));
            ++i;
        }
        double[] weights = mate.weights();
        if (mate.isRational()) {
            double max_weight = 0.0;
            int i2 = 0;
            while (i2 < uicp) {
                if (Math.abs(weights[i2]) > max_weight) {
                    max_weight = weights[i2];
                }
                ++i2;
            }
            if (max_weight > 0.0) {
                int i3 = 0;
                while (i3 < uicp) {
                    int n = i3++;
                    weights[n] = weights[n] / max_weight;
                }
            }
        }
        JgclPureBezierCurve3D bzc = new JgclPureBezierCurve3D(newCp, weights, false);
        JgclRealPolynomial[] poly = bzc.polynomial(mate.isPolynomial());
        JgclRealPolynomial realPoly = this.makePoly(poly);
        JgclComplexPolynomial compPoly = realPoly.toComplexPolynomial();
        try {
            roots = compPoly.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            roots = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
            throw new JgclFatal();
        }
        int nRoots = roots.length;
        Vector<Double> bzcParams = new Vector<Double>();
        Vector<JgclPoint3D> bzcPoints = new Vector<JgclPoint3D>();
        int j = 0;
        while (j < nRoots) {
            double realRoot = roots[j].real();
            if (bzc.parameterValidity(realRoot) != 3) {
                JgclPoint3D workPoint = bzc.coordinates(realRoot);
                int paramNum = bzcParams.size();
                if (this.checkSolution(workPoint)) {
                    int k = 0;
                    while (k < paramNum) {
                        double paramA = (Double)bzcParams.elementAt(k);
                        JgclPoint3D kthPoint = (JgclPoint3D)bzcPoints.elementAt(k);
                        if (workPoint.identical(kthPoint) && bzc.identicalParameter(realRoot, paramA)) break;
                        ++k;
                    }
                    if (k >= paramNum) {
                        bzcParams.addElement(new Double(realRoot));
                        bzcPoints.addElement(workPoint);
                    }
                }
            }
            ++j;
        }
        int num = bzcParams.size();
        JgclIntersectionPoint3D[] intersectPoints = new JgclIntersectionPoint3D[num];
        int i4 = 0;
        while (i4 < num) {
            double bzcParam = (Double)bzcParams.elementAt(i4);
            JgclPoint3D coordinates = mate.coordinates(bzcParam);
            double[] myParams = this.pointToParameter(coordinates);
            intersectPoints[i4] = doExchange ? new JgclIntersectionPoint3D(mate, bzcParam, this, myParams[0], myParams[1], false) : new JgclIntersectionPoint3D(this, myParams[0], myParams[1], (JgclParametricCurve3D)mate, bzcParam, false);
            ++i4;
        }
        return intersectPoints;
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        JgclCartesianTransformationOperator3D transform = this.toGlobal();
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = mate.validSegments();
        int uicp = mate.nControlPoints();
        JgclPoint3D[] newCp = new JgclPoint3D[uicp];
        int i = 0;
        while (i < uicp) {
            newCp[i] = transform.toLocal(mate.controlPointAt(i));
            ++i;
        }
        JgclBsplineCurve3D bsc = new JgclBsplineCurve3D(mate.knotData(), newCp, mate.weights());
        Vector<JgclPoint3D> pointVec = new Vector<JgclPoint3D>();
        Vector<Double> paramVec = new Vector<Double>();
        int nSeg = vsegInfo.nSegments();
        int i2 = 0;
        while (i2 < nSeg) {
            JgclComplex[] roots;
            JgclRealPolynomial[] poly = bsc.polynomial(vsegInfo.segmentNumber(i2), bsc.isPolynomial());
            JgclRealPolynomial realPoly = this.makePoly(poly);
            JgclComplexPolynomial compPoly = realPoly.toComplexPolynomial();
            try {
                roots = compPoly.getRootsByDKA();
            }
            catch (JgclComplexPolynomial.DKANotConverge e) {
                roots = e.getValues();
            }
            catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
                throw new JgclFatal();
            }
            catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
                throw new JgclFatal();
            }
            int k = 0;
            int nRoots = roots.length;
            int j = 0;
            while (j < nRoots) {
                double realRoot = roots[j].real();
                if (bsc.parameterValidity(realRoot) != 3) {
                    JgclPoint3D workPoint;
                    double[] knotParams = vsegInfo.knotPoint(i2);
                    if (realRoot < knotParams[0]) {
                        realRoot = knotParams[0];
                    }
                    if (realRoot > knotParams[1]) {
                        realRoot = knotParams[1];
                    }
                    if (this.checkSolution(workPoint = bsc.coordinates(realRoot))) {
                        int jj = 0;
                        while (jj < k) {
                            double dTol = bsc.getToleranceForDistance();
                            JgclPoint3D pnt = (JgclPoint3D)pointVec.elementAt(jj);
                            double param = (Double)paramVec.elementAt(jj);
                            if (pnt.identical(workPoint) && bsc.identicalParameter(param, realRoot)) break;
                            ++jj;
                        }
                        if (jj >= k) {
                            pointVec.addElement(workPoint);
                            paramVec.addElement(new Double(realRoot));
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i2;
        }
        int num = paramVec.size();
        JgclIntersectionPoint3D[] intersectPoints = new JgclIntersectionPoint3D[num];
        int i3 = 0;
        while (i3 < num) {
            double bscParam = (Double)paramVec.elementAt(i3);
            JgclPoint3D coordinates = mate.coordinates(bscParam);
            double[] myParams = this.pointToParameter(coordinates);
            intersectPoints[i3] = doExchange ? new JgclIntersectionPoint3D(mate, bscParam, this, myParams[0], myParams[1], false) : new JgclIntersectionPoint3D(this, myParams[0], myParams[1], (JgclParametricCurve3D)mate, bscParam, false);
            ++i3;
        }
        return intersectPoints;
    }
}

