/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBoundedLine2D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFilletObject2D;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclOfst2D;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterConversion2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTransitionCode;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclWhichSide;

public class JgclCompositeCurveSegment2D
extends JgclBoundedCurve2D {
    private int transition;
    private boolean sameSense;
    private JgclBoundedCurve2D parentCurve;

    public JgclCompositeCurveSegment2D(int transition, boolean sameSense, JgclBoundedCurve2D parentCurve) {
        if (parentCurve.isPeriodic() || parentCurve.isInfinite()) {
            throw new JgclInvalidArgumentValue();
        }
        this.transition = transition;
        this.sameSense = sameSense;
        this.parentCurve = parentCurve;
    }

    public int transition() {
        return this.transition;
    }

    public boolean sameSense() {
        return this.sameSense;
    }

    public JgclBoundedCurve2D parentCurve() {
        return this.parentCurve;
    }

    public JgclPoint2D startPoint() {
        if (this.sameSense) {
            return this.parentCurve.startPoint();
        }
        return this.parentCurve.endPoint();
    }

    public JgclPoint2D endPoint() {
        if (this.sameSense) {
            return this.parentCurve.endPoint();
        }
        return this.parentCurve.startPoint();
    }

    double sParameter() {
        return this.parameterDomain().section().start();
    }

    double eParameter() {
        return this.parameterDomain().section().end();
    }

    private double toBasisParameter(double param) {
        this.checkValidity(param);
        if (this.sameSense) {
            return param;
        }
        JgclParameterSection sec = this.parameterDomain().section();
        return sec.end() - (param - sec.start());
    }

    public JgclParameterSection toBasisParameter(JgclParameterSection pint) {
        double start = this.toBasisParameter(pint.start());
        double end = this.toBasisParameter(pint.end());
        return new JgclParameterSection(start, end - start);
    }

    private double toOwnParameter(double param) {
        double result;
        if (this.sameSense) {
            result = param;
        } else {
            JgclParameterSection sec = this.parameterDomain().section();
            result = sec.start() - (param - sec.end());
        }
        return result;
    }

    public double length(JgclParameterSection pint) {
        return this.parentCurve.length(this.toBasisParameter(pint));
    }

    public JgclPoint2D coordinates(double param) {
        return this.parentCurve.coordinates(this.toBasisParameter(param));
    }

    public JgclVector2D tangentVector(double param) {
        JgclVector2D tang = this.parentCurve.tangentVector(this.toBasisParameter(param));
        if (this.sameSense) {
            return tang;
        }
        return tang.multiply(-1.0);
    }

    public JgclCurveCurvature2D curvature(double param) {
        return this.parentCurve.curvature(this.toBasisParameter(param));
    }

    public JgclCurveDerivative2D evaluation(double param) {
        JgclCurveDerivative2D curv = this.parentCurve.evaluation(this.toBasisParameter(param));
        if (this.sameSense) {
            return curv;
        }
        JgclCurveDerivative2D rcurv = new JgclCurveDerivative2D(curv.d0D(), curv.d1D().multiply(-1.0), curv.d2D());
        return rcurv;
    }

    public JgclPointOnCurve2D[] singular() throws JgclIndefiniteSolution {
        JgclPointOnCurve2D[] singular = this.parentCurve.singular();
        JgclPointOnCurve2D[] thisSingular = new JgclPointOnCurve2D[singular.length];
        int i = 0;
        while (i < singular.length) {
            try {
                thisSingular[i] = new JgclPointOnCurve2D(this, this.toOwnParameter(singular[i].parameter()));
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return thisSingular;
    }

    public JgclPointOnCurve2D[] inflexion() throws JgclIndefiniteSolution {
        JgclPointOnCurve2D[] inflexion = this.parentCurve.inflexion();
        JgclPointOnCurve2D[] thisInflexion = new JgclPointOnCurve2D[inflexion.length];
        int i = 0;
        while (i < inflexion.length) {
            try {
                thisInflexion[i] = new JgclPointOnCurve2D(this, this.toOwnParameter(inflexion[i].parameter()));
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return thisInflexion;
    }

    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) throws JgclIndefiniteSolution {
        JgclPointOnCurve2D[] proj = this.parentCurve.projectFrom(point);
        JgclPointOnCurve2D[] thisProj = new JgclPointOnCurve2D[proj.length];
        int i = 0;
        while (i < proj.length) {
            try {
                thisProj[i] = new JgclPointOnCurve2D(this, this.toOwnParameter(proj[i].parameter()));
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return thisProj;
    }

    public JgclPolyline2D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        JgclPolyline2D pl = this.parentCurve.toPolyline(this.toBasisParameter(pint), tol);
        JgclPoint2D[] pnts = new JgclPoint2D[pl.nPoints()];
        int i = 0;
        while (i < pnts.length) {
            JgclPointOnCurve2D p = (JgclPointOnCurve2D)pl.pointAt(i);
            pnts[i] = new JgclPointOnCurve2D(this, this.toOwnParameter(p.parameter()), false);
            ++i;
        }
        return new JgclPolyline2D(pnts);
    }

    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
        return this.parentCurve.toBsplineCurve(this.toBasisParameter(pint));
    }

    private JgclIntersectionPoint2D[] doIntersect(JgclParametricCurve2D mate, boolean doExchange) {
        JgclIntersectionPoint2D[] ints;
        try {
            ints = this.parentCurve.intersect(mate);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            return new JgclIntersectionPoint2D[0];
        }
        JgclIntersectionPoint2D[] thisInts = new JgclIntersectionPoint2D[ints.length];
        int i = 0;
        while (i < ints.length) {
            double param = this.toOwnParameter(ints[i].pointOnCurve1().parameter());
            JgclPointOnCurve2D thisPnts = new JgclPointOnCurve2D(this, param, false);
            thisInts[i] = !doExchange ? new JgclIntersectionPoint2D(thisPnts, ints[i].pointOnCurve2(), false) : new JgclIntersectionPoint2D(ints[i].pointOnCurve2(), thisPnts, false);
            ++i;
        }
        return thisInts;
    }

    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
        return this.doIntersect(mate, false);
    }

    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
        return this.interfere(mate, false);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate, boolean doExchange) {
        ToSegmentConversion conv = new ToSegmentConversion();
        JgclParameterSection sec = this.parameterDomain().section();
        JgclCurveCurveInterference2D[] intf = !doExchange ? this.parentCurve.interfere(mate) : mate.interfere(this.parentCurve);
        Vector<JgclCurveCurveInterference2D> vec = new Vector<JgclCurveCurveInterference2D>();
        int i = 0;
        while (i < intf.length) {
            JgclCurveCurveInterference2D trimintf = !doExchange ? intf[i].trim1(sec, conv) : intf[i].trim2(sec, conv);
            if (trimintf != null) {
                vec.addElement(trimintf);
            }
            ++i;
        }
        Object[] interf = new JgclCurveCurveInterference2D[vec.size()];
        vec.copyInto(interf);
        return interf;
    }

    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate, boolean doExchange) {
        return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst2D doObj = new JgclOfst2D(this, pint, magni, side, tol);
        return doObj.offset();
    }

    public JgclBoundedCurve2D offsetByBoundedCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclParameterSection basisPint = this.toBasisParameter(pint);
        int basisSide = this.sameSense() ? side : JgclWhichSide.reverse(side);
        return this.parentCurve().offsetByBoundedCurve(basisPint, magni, basisSide, tol);
    }

    JgclFilletObject2D[] doFillet(JgclParameterSection pint1, int side1, JgclParametricCurve2D mate, JgclParameterSection pint2, int side2, double radius, boolean doExchange) throws JgclIndefiniteSolution {
        JgclFilletObject2D[] flts;
        try {
            flts = this.parentCurve.fillet(this.toBasisParameter(pint1), side1, mate, pint2, side2, radius);
        }
        catch (JgclIndefiniteSolution e) {
            flts = new JgclFilletObject2D[]{(JgclFilletObject2D)e.suitable()};
        }
        int i = 0;
        while (i < flts.length) {
            double param = this.toOwnParameter(flts[i].pointOnCurve1().parameter());
            JgclPointOnCurve2D thisPnt = new JgclPointOnCurve2D(this, param, false);
            flts[i] = !doExchange ? new JgclFilletObject2D(radius, flts[i].center(), thisPnt, flts[i].pointOnCurve2()) : new JgclFilletObject2D(radius, flts[i].center(), flts[i].pointOnCurve2(), thisPnt);
            ++i;
        }
        return flts;
    }

    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    JgclParameterDomain getParameterDomain() {
        return this.parentCurve.parameterDomain();
    }

    int type() {
        return 25;
    }

    public boolean isFreeform() {
        return this.parentCurve.isFreeform();
    }

    JgclCompositeCurveSegment2D makeCopyWithTransition(int transition) {
        return new JgclCompositeCurveSegment2D(transition, this.sameSense, this.parentCurve);
    }

    JgclCompositeCurveSegment2D makeReverseWithTransition(int transition) {
        return new JgclCompositeCurveSegment2D(transition, !this.sameSense, this.parentCurve);
    }

    JgclCompositeCurveSegment2D truncate(JgclParameterSection section, int transition) {
        JgclTrimmedCurve2D newParent;
        JgclParameterSection parentSection = this.toBasisParameter(section);
        if (this.parentCurve.type() == 23) {
            JgclTrimmedCurve2D trc = (JgclTrimmedCurve2D)this.parentCurve;
            newParent = new JgclTrimmedCurve2D(trc.basisCurve(), parentSection);
        } else {
            newParent = new JgclTrimmedCurve2D(this.parentCurve, parentSection);
        }
        return new JgclCompositeCurveSegment2D(transition, true, newParent);
    }

    protected synchronized JgclParametricCurve2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclBoundedCurve2D tParentCurve = (JgclBoundedCurve2D)this.parentCurve().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclCompositeCurveSegment2D(this.transition(), this.sameSense(), tParentCurve);
    }

    protected boolean hasPolyline() {
        return this.parentCurve.hasPolyline();
    }

    protected boolean isComposedOfOnlyPolylines() {
        return this.parentCurve.isComposedOfOnlyPolylines();
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\ttransition\t" + JgclTransitionCode.toString(this.transition));
        writer.println(String.valueOf(indent_tab) + "\tsameSense\t" + this.sameSense);
        writer.println(String.valueOf(indent_tab) + "\tparentCurve");
        this.parentCurve.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }

    class ToSegmentConversion
    extends JgclParameterConversion2D {
        ToSegmentConversion() {
            JgclCompositeCurveSegment2D.this = JgclCompositeCurveSegment2D.this;
        }

        double convParameter(double param) {
            return JgclCompositeCurveSegment2D.this.toOwnParameter(param);
        }

        JgclParametricCurve2D convCurve(double param) {
            return JgclCompositeCurveSegment2D.this;
        }
    }
}

