/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator;
import jp.go.ipa.jgcl.JgclGeometrySchemaFunction;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclVector2D;

public class JgclCartesianTransformationOperator2D
extends JgclCartesianTransformationOperator {
    private JgclVector2D axis1;
    private JgclVector2D axis2;
    private JgclPoint2D localOrigin;
    private JgclVector2D[] u;

    public JgclCartesianTransformationOperator2D(JgclVector2D axis1, JgclVector2D axis2, JgclPoint2D localOrigin, double scale) {
        super(scale);
        if (localOrigin == null) {
            throw new JgclInvalidArgumentValue();
        }
        this.localOrigin = localOrigin;
        this.axis1 = axis1;
        this.axis2 = axis2;
    }

    public JgclCartesianTransformationOperator2D(JgclAxis2Placement2D position, double scale) {
        super(scale);
        if (position == null) {
            throw new JgclInvalidArgumentValue();
        }
        this.u = position.axes();
        this.localOrigin = position.location();
        this.axis1 = this.u1();
        this.axis2 = this.u2();
    }

    public int dimension() {
        return 2;
    }

    public JgclVector2D axis1() {
        return this.axis1;
    }

    public JgclVector2D axis2() {
        return this.axis2;
    }

    public JgclPoint2D localOrigin() {
        return this.localOrigin;
    }

    public JgclVector2D u1() {
        if (this.u == null) {
            this.u();
        }
        return this.u[0];
    }

    public JgclVector2D u2() {
        if (this.u == null) {
            this.u();
        }
        return this.u[1];
    }

    public JgclVector2D[] u() {
        if (this.u == null) {
            this.u = JgclGeometrySchemaFunction.baseAxis(this.axis1, this.axis2);
        }
        return (JgclVector2D[])this.u.clone();
    }

    public JgclVector2D transform(JgclVector2D vector) {
        double x = this.scale() * (vector.x() * this.u1().x() + vector.y() * this.u2().x());
        double y = this.scale() * (vector.x() * this.u1().y() + vector.y() * this.u2().y());
        return new JgclLiteralVector2D(x, y);
    }

    public JgclPoint2D transform(JgclPoint2D point) {
        double x = this.localOrigin.x() + this.scale() * (point.x() * this.u1().x() + point.y() * this.u2().x());
        double y = this.localOrigin.y() + this.scale() * (point.x() * this.u1().y() + point.y() * this.u2().y());
        return new JgclCartesianPoint2D(x, y);
    }

    public JgclVector2D transform(JgclVector2D vector, Hashtable transformedGeometries) {
        return vector.transformBy(this, transformedGeometries);
    }

    public JgclPoint2D transform(JgclPoint2D point, Hashtable transformedGeometries) {
        return point.transformBy(this, transformedGeometries);
    }

    public JgclParametricCurve2D transform(JgclParametricCurve2D curve, Hashtable transformedGeometries) {
        return curve.transformBy(this, transformedGeometries);
    }

    public JgclVector2D reverseTransform(JgclVector2D vector) {
        double x = (vector.x() * this.u1().x() + vector.y() * this.u1().y()) / this.scale();
        double y = (vector.x() * this.u2().x() + vector.y() * this.u2().y()) / this.scale();
        return new JgclLiteralVector2D(x, y);
    }

    public JgclPoint2D reverseTransform(JgclPoint2D point) {
        JgclVector2D wk = point.subtract(this.localOrigin);
        double x = (wk.x() * this.u1().x() + wk.y() * this.u1().y()) / this.scale();
        double y = (wk.x() * this.u2().x() + wk.y() * this.u2().y()) / this.scale();
        return new JgclCartesianPoint2D(x, y);
    }

    public JgclVector2D reverseTransform(JgclVector2D vector, Hashtable transformedGeometries) {
        return vector.reverseTransformBy(this, transformedGeometries);
    }

    public JgclPoint2D reverseTransform(JgclPoint2D point, Hashtable transformedGeometries) {
        return point.reverseTransformBy(this, transformedGeometries);
    }

    public JgclParametricCurve2D reverseTransform(JgclParametricCurve2D curve, Hashtable transformedGeometries) {
        return curve.reverseTransformBy(this, transformedGeometries);
    }

    public JgclVector2D toEnclosed(JgclVector2D vector) {
        return this.transform(vector);
    }

    public JgclPoint2D toEnclosed(JgclPoint2D point) {
        return this.transform(point);
    }

    public JgclVector2D toEnclosed(JgclVector2D vector, Hashtable transformedGeometries) {
        return this.transform(vector, transformedGeometries);
    }

    public JgclPoint2D toEnclosed(JgclPoint2D point, Hashtable transformedGeometries) {
        return this.transform(point, transformedGeometries);
    }

    public JgclParametricCurve2D toEnclosed(JgclParametricCurve2D curve, Hashtable transformedGeometries) {
        return this.transform(curve, transformedGeometries);
    }

    public JgclVector2D toLocal(JgclVector2D vector) {
        return this.reverseTransform(vector);
    }

    public JgclPoint2D toLocal(JgclPoint2D point) {
        return this.reverseTransform(point);
    }

    public JgclVector2D toLocal(JgclVector2D vector, Hashtable transformedGeometries) {
        return this.reverseTransform(vector, transformedGeometries);
    }

    public JgclPoint2D toLocal(JgclPoint2D point, Hashtable transformedGeometries) {
        return this.reverseTransform(point, transformedGeometries);
    }

    public JgclParametricCurve2D toLocal(JgclParametricCurve2D curve, Hashtable transformedGeometries) {
        return this.reverseTransform(curve, transformedGeometries);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tscale\t" + this.scale());
        if (this.axis1 != null) {
            writer.println(String.valueOf(indent_tab) + "\taxis1");
            this.axis1.output(writer, indent + 2);
        }
        if (this.axis2 != null) {
            writer.println(String.valueOf(indent_tab) + "\taxis2");
            this.axis2.output(writer, indent + 2);
        }
        writer.println(String.valueOf(indent_tab) + "\tlocalOrigin");
        this.localOrigin.output(writer, indent + 2);
        writer.println("End");
    }
}

