/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;

public abstract class JgclCartesianTransformationOperator
extends JgclGeometry {
    private final double scale;

    protected JgclCartesianTransformationOperator(double scale) {
        if (scale <= JgclConditionOfOperation.getCondition().getToleranceForDistance()) {
            throw new JgclInvalidArgumentValue();
        }
        this.scale = scale;
    }

    public boolean isTransformationOperator() {
        return true;
    }

    public double scale() {
        return this.scale;
    }

    public double transform(double length) {
        return length * this.scale;
    }

    public double reverseTransform(double length) {
        return length / this.scale;
    }
}

