/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclKnotType;
import jp.go.ipa.jgcl.JgclParameterDomain;

public class JgclBsplineKnot
implements Serializable {
    private int degree;
    private int nControlPoints;
    private int knotSpec;
    private boolean periodic;
    private int[] knotMultiplicities;
    private double[] knots;
    static final String[][] keyWords = new String[][]{{"\tdegree\t", "\tnControlPoints\t", "\tknotSpec\t", "\tknotMultiplicities\t", "\tknots\t", "\tperiodic\t"}, {"\tuDegree\t", "\tuNControlPoints\t", "\tuKnotSpec\t", "\tuKnotMultiplicities\t", "\tuKnots\t", "\tuPeriodic\t"}, {"\tvDegree\t", "\tvNControlPoints\t", "\tvKnotSpec\t", "\tvKnotMultiplicities\t", "\tvKnots\t", "\tvPeriodic\t"}};
    static JgclBsplineKnot quasiUniformKnotsOfLinearOneSegment;

    public JgclBsplineKnot(int degree, int knotSpec, boolean periodic, int[] knotMultiplicities, double[] knots, int nControlPoints) {
        this(degree, knotSpec, periodic, knotMultiplicities, knots, nControlPoints, true);
    }

    JgclBsplineKnot(int degree, int knotSpec, boolean periodic, int[] knotMultiplicities, double[] knots, int nControlPoints, boolean doCheck) {
        this.setData(degree, knotSpec, periodic, knotMultiplicities, knots, nControlPoints, doCheck);
    }

    JgclBsplineKnot(int degree, int knotSpec, boolean periodic, int nKnots, int[] knotMultiplicities, double[] knots, int nControlPoints) {
        this(degree, knotSpec, periodic, nKnots, knotMultiplicities, knots, nControlPoints, true);
    }

    JgclBsplineKnot(int degree, int knotSpec, boolean periodic, int nKnots, int[] knotMultiplicities, double[] knots, int nControlPoints, boolean doCheck) {
        int[] new_multi = new int[nKnots];
        double[] new_knots = new double[nKnots];
        if (knots.length < nKnots || knotMultiplicities.length < nKnots) {
            throw new JgclInvalidArgumentValue();
        }
        int i = 0;
        while (i < nKnots) {
            new_multi[i] = knotMultiplicities[i];
            new_knots[i] = knots[i];
            ++i;
        }
        this.setData(degree, knotSpec, periodic, new_multi, new_knots, nControlPoints, doCheck);
    }

    private void setData(int degree, int knotSpec, boolean periodic, int[] knotMultiplicities, double[] knots, int nControlPoints, boolean doCheck) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double p_tol = condition.getToleranceForParameter();
        this.degree = degree;
        this.nControlPoints = nControlPoints;
        this.knotSpec = knotSpec;
        this.periodic = periodic;
        if (!doCheck) {
            if (knotSpec != 1) {
                this.knotMultiplicities = null;
                this.knots = null;
            } else {
                int uik = knotMultiplicities.length;
                this.knotMultiplicities = new int[uik];
                this.knots = new double[uik];
                int i = 0;
                while (i < uik) {
                    this.knotMultiplicities[i] = knotMultiplicities[i];
                    this.knots[i] = knots[i];
                    ++i;
                }
            }
            return;
        }
        if (degree < 1) {
            throw new JgclInvalidArgumentValue();
        }
        switch (knotSpec) {
            case 0: {
                if (knotMultiplicities != null) {
                    throw new JgclInvalidArgumentValue();
                }
                if (knots != null) {
                    throw new JgclInvalidArgumentValue();
                }
                this.knotMultiplicities = null;
                this.knots = null;
                break;
            }
            case 1: {
                if (knotMultiplicities == null) {
                    throw new JgclInvalidArgumentValue();
                }
                int uik = knotMultiplicities.length;
                if (uik < 1) {
                    throw new JgclInvalidArgumentValue();
                }
                if (knots == null) {
                    throw new JgclInvalidArgumentValue();
                }
                if (knots.length != uik) {
                    throw new JgclInvalidArgumentValue();
                }
                this.knotMultiplicities = new int[uik];
                this.knots = new double[uik];
                int sum = 0;
                int i = 0;
                while (i < uik) {
                    this.knotMultiplicities[i] = knotMultiplicities[i];
                    this.knots[i] = knots[i];
                    sum += knotMultiplicities[i];
                    if (i > 0 && knots[i - 1] > knots[i]) {
                        throw new JgclInvalidArgumentValue();
                    }
                    if (knotMultiplicities[i] > degree + 1) {
                        throw new JgclInvalidArgumentValue();
                    }
                    ++i;
                }
                if (periodic && 2 * degree + nControlPoints + 1 != sum || !periodic && degree + nControlPoints + 1 != sum) {
                    throw new JgclInvalidArgumentValue();
                }
                if (!periodic) break;
                int n2 = 2 * degree;
                int i2 = 0;
                double h_end = this.knotValueAt(0);
                int j = nControlPoints;
                double t_end = this.knotValueAt(j);
                while (i2 < n2) {
                    double h_start = h_end;
                    double t_start = t_end;
                    h_end = this.knotValueAt(i2++);
                    double h_intvl = h_end - h_start;
                    int n = j++;
                    t_end = this.knotValueAt(n);
                    double t_intvl = t_end - t_start;
                    if (!(Math.abs(h_intvl - t_intvl) > p_tol)) continue;
                    throw new JgclInvalidArgumentValue();
                }
                break;
            }
            default: {
                throw new JgclInvalidArgumentValue();
            }
        }
    }

    public int degree() {
        return this.degree;
    }

    public int nControlPoints() {
        return this.nControlPoints;
    }

    public int knotSpec() {
        return this.knotSpec;
    }

    public int nKnots() {
        if (this.knotSpec() != 1) {
            throw new JgclFatal();
        }
        return this.knots.length;
    }

    public int[] knotMultiplicities() {
        if (this.knotSpec() != 1) {
            throw new JgclFatal();
        }
        return (int[])this.knotMultiplicities.clone();
    }

    public double[] knots() {
        if (this.knotSpec() != 1) {
            throw new JgclFatal();
        }
        return (double[])this.knots.clone();
    }

    public int knotMultiplicityAt(int i) {
        if (this.knotSpec() != 1) {
            throw new JgclFatal();
        }
        return this.knotMultiplicities[i];
    }

    public int knotMultiplicityAt(double knot) {
        double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        if (this.knotSpec() != 1) {
            double lower = Math.floor(knot);
            double upper = Math.ceil(knot);
            double lowerLimit = -this.degree();
            double upperLimit = this.nKnotValues() - 1 - this.degree();
            if (knot - lower < pTol ? lowerLimit <= lower && lower <= upperLimit : upper - knot < pTol && lowerLimit <= upper && upper <= upperLimit) {
                return 1;
            }
        } else {
            int i = 0;
            while (i < this.nKnots()) {
                double ithKnot = this.knotAt(i);
                if (Math.abs(knot - ithKnot) < pTol) {
                    return this.knotMultiplicityAt(i);
                }
                if (knot < ithKnot) {
                    return 0;
                }
                ++i;
            }
        }
        return 0;
    }

    public double knotAt(int i) {
        if (this.knotSpec() != 1) {
            throw new JgclFatal();
        }
        return this.knots[i];
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    public boolean isNonPeriodic() {
        return !this.periodic;
    }

    JgclParameterDomain getParameterDomain() {
        double start = this.knotValueAt(this.degree);
        double increase = this.knotValueAt(this.degree + this.nSegments()) - start;
        try {
            return new JgclParameterDomain(this.periodic, start, increase);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    public int nSegments() {
        if (this.periodic) {
            return this.nControlPoints;
        }
        return this.nControlPoints - this.degree;
    }

    public int nKnotValues() {
        return 2 * this.degree + this.nSegments() + 1;
    }

    static double knotValueAt(int[] knotMultiplicities, double[] knots, int n) {
        int sum = 0;
        int i = 0;
        while (n >= sum) {
            sum += knotMultiplicities[i++];
        }
        return knots[i - 1];
    }

    public double knotValueAt(int n) {
        if (this.knotSpec == 0) {
            return n - this.degree;
        }
        return JgclBsplineKnot.knotValueAt(this.knotMultiplicities, this.knots, n);
    }

    public int segmentIndex(double param) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double p_tol = condition.getToleranceForParameter();
        int r = this.nSegments();
        if (Math.abs(this.knotValueAt(this.degree + r) - param) < p_tol) {
            while (--r >= 0 && Math.abs(this.knotValueAt(this.degree + r) - param) < p_tol) {
            }
            return r;
        }
        if (this.knotSpec == 0) {
            return (int)param;
        }
        int i = 0;
        int sum = 0;
        while (!(param < this.knots[i])) {
            sum += this.knotMultiplicities[i++];
            if (i < this.knots.length) continue;
            if (param > this.knots[--i] + p_tol) {
                return -1;
            }
            param = this.knots[i];
            while (!(param > this.knots[i])) {
                sum -= this.knotMultiplicities[i--];
            }
            break block1;
        }
        r = sum - this.degree - 1;
        if (r >= 0) {
            return r;
        }
        return -1;
    }

    ValidSegmentInfo validSegments() {
        double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        int nseg_p1 = this.nSegments() + 1;
        int[] sn = new int[nseg_p1];
        double[] kp = new double[nseg_p1];
        int nvseg = -1;
        int i = this.degree;
        double pval = this.knotValueAt(i) - 1.0;
        int k = 0;
        while (k < nseg_p1) {
            double d;
            double kval = this.knotValueAt(i);
            if (d - pval > tol_p) {
                sn[++nvseg] = i - this.degree;
                kp[nvseg] = kval;
            } else {
                sn[nvseg] = i - this.degree;
            }
            ++i;
            pval = kval;
            ++k;
        }
        return new ValidSegmentInfo(nvseg, sn, kp);
    }

    int getSegmentNumberThatStartIsEqualTo(double param) {
        double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        int i = this.degree + this.nSegments();
        while (i >= this.degree) {
            if (Math.abs(param - this.knotValueAt(i)) < pTol) {
                return i - this.degree;
            }
            --i;
        }
        return -1;
    }

    JgclBsplineKnot makeKnotsClosed() {
        double intvl;
        int n_kel = this.nKnotValues();
        int lower_idx = this.degree();
        int upper_idx = this.degree() + this.nSegments();
        double[] simple_knots = new double[n_kel];
        int[] simple_knot_multi = new int[n_kel];
        int i = 0;
        while (i < n_kel) {
            simple_knots[i] = this.knotValueAt(i);
            simple_knot_multi[i] = 1;
            ++i;
        }
        int j = lower_idx;
        int k = upper_idx;
        i = 0;
        while (i < this.degree()) {
            intvl = simple_knots[j + 1] - simple_knots[j];
            simple_knots[k + 1] = simple_knots[k] + intvl;
            ++j;
            ++k;
            ++i;
        }
        j = lower_idx;
        k = upper_idx;
        i = 0;
        while (i < this.degree()) {
            intvl = simple_knots[k] - simple_knots[k - 1];
            simple_knots[j - 1] = simple_knots[j] - intvl;
            --j;
            --k;
            ++i;
        }
        int uik = JgclBsplineKnot.beautify(n_kel, simple_knots, simple_knot_multi);
        return new JgclBsplineKnot(this.degree(), 1, this.isPeriodic(), uik, simple_knot_multi, simple_knots, this.nControlPoints());
    }

    static int beautify(int uik, double[] knots, int[] knotMultiplicities) {
        double kval = knots[0] - 1.0;
        double p_tol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        int j = 0;
        int i = 0;
        while (i < uik) {
            if (Math.abs(kval - knots[i]) > p_tol) {
                kval = knots[j] = knots[i];
                knotMultiplicities[j] = knotMultiplicities[i];
                ++j;
            } else {
                int n = j - 1;
                knotMultiplicities[n] = knotMultiplicities[n] + knotMultiplicities[i];
            }
            ++i;
        }
        return j;
    }

    public JgclBsplineKnot beautify() {
        if (this.knotSpec != 1) {
            return this;
        }
        int uik = this.nKnots();
        double[] new_knots = this.knots();
        int[] new_knot_multi = this.knotMultiplicities();
        int n_new_knots = JgclBsplineKnot.beautify(uik, new_knots, new_knot_multi);
        try {
            return new JgclBsplineKnot(this.degree, this.knotSpec, this.periodic, n_new_knots, new_knot_multi, new_knots, this.nControlPoints);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    public JgclBsplineKnot reverse() {
        if (this.knotSpec != 1) {
            return this;
        }
        int n_kel = this.nKnotValues();
        int[] new_multi = new int[n_kel];
        double[] new_knots = new double[n_kel];
        new_multi[this.degree] = 1;
        new_knots[this.degree] = 0.0;
        int lk_idx = this.degree + this.nSegments();
        int i = this.degree - 1;
        int j = lk_idx;
        while (i >= 0) {
            new_knots[i] = new_knots[i + 1] - (this.knotValueAt(j + 1) - this.knotValueAt(j));
            new_multi[i] = 1;
            --i;
            ++j;
        }
        i = this.degree + 1;
        j = lk_idx;
        while (i < n_kel) {
            new_knots[i] = new_knots[i - 1] + (this.knotValueAt(j) - this.knotValueAt(j - 1));
            new_multi[i] = 1;
            ++i;
            --j;
        }
        return new JgclBsplineKnot(this.degree, this.knotSpec, this.periodic, new_multi, new_knots, this.nControlPoints).beautify();
    }

    JgclBsplineKnot shift(int firstSegment) {
        if (!this.periodic) {
            throw new JgclFatal("knots should be closed form.");
        }
        if (firstSegment < 0 || this.nSegments() < firstSegment) {
            throw new JgclFatal("given index is wrong.");
        }
        if (this.knotSpec == 0) {
            return this;
        }
        int nKnots = this.nKnotValues();
        double[] newKnots = new double[nKnots];
        int[] newKnotMultiplicities = new int[nKnots];
        double upperParam = this.knotValueAt(this.degree + this.nSegments());
        double plusFactor = 0.0;
        double minusFactor = this.knotValueAt(this.degree + firstSegment) - this.knotValueAt(this.degree);
        int i = 0;
        while (i < nKnots) {
            int j = i + firstSegment;
            if (j >= nKnots) {
                j += 2 * this.degree + 1;
                plusFactor = upperParam;
            }
            newKnots[i] = this.knotValueAt(j % nKnots) + plusFactor - minusFactor;
            newKnotMultiplicities[i] = 1;
            ++i;
        }
        JgclBsplineKnot knotData = new JgclBsplineKnot(this.degree, this.knotSpec, true, newKnotMultiplicities, newKnots, this.nControlPoints);
        return knotData.beautify();
    }

    JgclBsplineKnot makeExplicit() {
        switch (this.knotSpec()) {
            case 1: {
                return this;
            }
            case 0: {
                int uik = this.nKnotValues();
                double[] new_knots = new double[uik];
                int[] new_knot_multi = new int[uik];
                int uj = 0;
                while (uj < uik) {
                    new_knots[uj] = uj - this.degree();
                    new_knot_multi[uj] = 1;
                    ++uj;
                }
                return new JgclBsplineKnot(this.degree(), 1, this.periodic, new_knot_multi, new_knots, this.nControlPoints());
            }
        }
        throw new JgclFatal();
    }

    private void evalUniform(int k0, int n, int i, double t, double[] r) {
        if (n == 0) {
            r[0] = 1.0;
        } else {
            double[] rTmp = new double[r.length - 1];
            int j = 0;
            while (j < r.length - 1) {
                rTmp[j] = r[j + 1];
                ++j;
            }
            this.evalUniform(k0, n - 1, i + 1, t, rTmp);
            j = 0;
            while (j < r.length - 1) {
                r[j + 1] = rTmp[j];
                ++j;
            }
            j = 0;
            int k = i;
            while (j <= n) {
                r[j] = j == 0 ? ((double)(k0 + (k + n + 1)) - t) * r[j + 1] / (double)n : (j == n ? (t - (double)k0 + (double)k) * r[j] / (double)n : ((t - (double)k0 + (double)k) * r[j] + ((double)(k0 + (k + n + 1)) - t) * r[j + 1]) / (double)n);
                ++j;
                ++k;
            }
        }
    }

    private int evalBsplineU(double t, double[] r) {
        int n_seg = this.nSegments();
        JgclParameterDomain dmn = this.getParameterDomain();
        if (!dmn.isValid(t)) {
            throw new JgclFatal();
        }
        t = dmn.wrap(dmn.force(t));
        int isckt = 1;
        while (!(t < (double)isckt)) {
            ++isckt;
        }
        if (--isckt >= n_seg) {
            isckt = n_seg - 1;
        }
        int i = 0;
        while (i <= this.degree()) {
            r[i] = 0.0;
            ++i;
        }
        this.evalUniform(-this.degree(), this.degree(), isckt, t, r);
        return isckt;
    }

    private void evalNonUniform(int n, int i, double t, double[] r, double pTol) {
        double w1 = 0.0;
        double w2 = 0.0;
        if (n == 0) {
            r[0] = 1.0;
        } else {
            double[] rTmp = new double[r.length - 1];
            int j = 0;
            while (j < r.length - 1) {
                rTmp[j] = r[j + 1];
                ++j;
            }
            this.evalNonUniform(n - 1, i + 1, t, rTmp, pTol);
            j = 0;
            while (j < r.length - 1) {
                r[j + 1] = rTmp[j];
                ++j;
            }
            j = 0;
            int k = i;
            while (j <= n) {
                double tk;
                if (j != 0) {
                    double d;
                    tk = this.knotValueAt(k);
                    w1 = this.knotValueAt(k + n) - tk;
                    w1 = d < pTol ? 0.0 : (t - tk) / w1;
                }
                if (j != n) {
                    double d;
                    tk = this.knotValueAt(k + n + 1);
                    w2 = tk - this.knotValueAt(k + 1);
                    w2 = d < pTol ? 0.0 : (tk - t) / w2;
                }
                r[j] = j == 0 ? w2 * r[j + 1] : (j == n ? w1 * r[j] : w1 * r[j] + w2 * r[j + 1]);
                ++j;
                ++k;
            }
        }
    }

    private int evalBspline(double t, double[] r) {
        int n_seg = this.nSegments();
        int n_seg_pd = n_seg + this.degree();
        JgclParameterDomain dmn = this.getParameterDomain();
        if (!dmn.isValid(t)) {
            throw new JgclFatal();
        }
        t = dmn.wrap(dmn.force(t));
        int isckt = this.degree() + 1;
        while (isckt <= n_seg_pd) {
            if (isckt < n_seg_pd ? t < this.knotValueAt(isckt) : !(t > this.knotValueAt(isckt))) break;
            ++isckt;
        }
        if (isckt > n_seg_pd) {
            throw new JgclFatal();
        }
        isckt -= this.degree() + 1;
        double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        int i = 0;
        while (i <= this.degree()) {
            r[i] = 0.0;
            ++i;
        }
        this.evalNonUniform(this.degree(), isckt, t, r, pTol);
        return isckt;
    }

    int evaluateBsplineFunction(double t, double[] r) {
        if (this.knotSpec() == 0) {
            return this.evalBsplineU(t, r);
        }
        return this.evalBspline(t, r);
    }

    protected void output(PrintWriter writer, int indent, int index) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < indent) {
            buf.append("\t");
            ++i;
        }
        String indent_tab = new String(buf);
        writer.println(String.valueOf(indent_tab) + keyWords[index][0] + this.degree);
        writer.println(String.valueOf(indent_tab) + keyWords[index][1] + this.nControlPoints);
        writer.println(String.valueOf(indent_tab) + keyWords[index][2] + JgclKnotType.toString(this.knotSpec));
        if (this.knotSpec == 1) {
            int j;
            writer.print(String.valueOf(indent_tab) + keyWords[index][3]);
            int i2 = 0;
            while (true) {
                writer.print(this.knotMultiplicities[i2++]);
                j = 0;
                while (j < 20 && i2 < this.knotMultiplicities.length) {
                    writer.print(" " + this.knotMultiplicities[i2]);
                    ++j;
                    ++i2;
                }
                writer.println();
                if (i2 >= this.knotMultiplicities.length) break;
                writer.print(String.valueOf(indent_tab) + "\t\t");
            }
            writer.print(String.valueOf(indent_tab) + keyWords[index][4]);
            i2 = 0;
            while (true) {
                writer.print(this.knots[i2++]);
                j = 0;
                while (j < 3 && i2 < this.knots.length) {
                    writer.print(" " + this.knots[i2]);
                    ++j;
                    ++i2;
                }
                writer.println();
                if (i2 >= this.knots.length) break;
                writer.print(String.valueOf(indent_tab) + "\t\t");
            }
        }
        writer.println(String.valueOf(indent_tab) + keyWords[index][5] + this.periodic);
    }

    public void output(OutputStream out) {
        PrintWriter writer = new PrintWriter(out, true);
        this.output(writer, 0, 0);
    }

    static {
        int[] knotMultiplicities = new int[]{2, 2};
        double[] dArray = new double[2];
        dArray[1] = 1.0;
        double[] knots = dArray;
        quasiUniformKnotsOfLinearOneSegment = new JgclBsplineKnot(1, 1, false, knotMultiplicities, knots, 2);
    }

    class ValidSegmentInfo {
        private int[] segmentNumber;
        private double[] knotPoint;

        ValidSegmentInfo(int nSegments, int[] segmentNumber, double[] knotPoint) {
            JgclBsplineKnot.this = JgclBsplineKnot.this;
            this.segmentNumber = new int[nSegments];
            this.knotPoint = new double[nSegments + 1];
            int i = 0;
            while (i < nSegments) {
                this.segmentNumber[i] = segmentNumber[i];
                this.knotPoint[i] = knotPoint[i];
                ++i;
            }
            this.knotPoint[nSegments] = knotPoint[nSegments];
        }

        int nSegments() {
            return this.segmentNumber.length;
        }

        int segmentNumber(int n) {
            return this.segmentNumber[n];
        }

        double[] knotPoint(int n) {
            double[] prms = new double[]{this.knotPoint[n], this.knotPoint[n + 1]};
            return prms;
        }

        double headKnotPoint(int n) {
            return this.knotPoint[n];
        }

        double tailKnotPoint(int n) {
            return this.knotPoint[n + 1];
        }

        int segmentIndex(double param) {
            double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();
            if (param < this.knotPoint[0]) {
                return -1;
            }
            int nseg = this.nSegments();
            int i = 0;
            while (i < nseg) {
                if (param < this.knotPoint[i + 1]) {
                    return i;
                }
                ++i;
            }
            if (Math.abs(param - this.knotPoint[nseg]) < tol_p) {
                return nseg - 1;
            }
            return -1;
        }

        int isValidSegment(int seg) {
            int nvseg = this.nSegments();
            int klm = 0;
            while (klm < nvseg) {
                if (this.segmentNumber(klm) == seg) {
                    return klm;
                }
                ++klm;
            }
            return -1;
        }

        double l2Gw(int index, double local) {
            double[] knots = this.knotPoint(index);
            return (knots[1] - knots[0]) * local;
        }

        double l2Gp(int index, double local) {
            double[] knots = this.knotPoint(index);
            return knots[0] + (knots[1] - knots[0]) * local;
        }

        int getSegmentNumberThatStartIsEqualTo(double param) {
            double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
            int i = 0;
            while (i <= this.segmentNumber.length) {
                if (Math.abs(param - this.knotPoint[i]) < pTol) {
                    return this.segmentNumber[i];
                }
                ++i;
            }
            return -1;
        }
    }
}

