/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclApproximation3D;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBoundedCurve3D;
import jp.go.ipa.jgcl.JgclBoundedLine3D;
import jp.go.ipa.jgcl.JgclBsplineCurveEvaluation;
import jp.go.ipa.jgcl.JgclBsplineCurveForm;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclComplexPolynomial;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFreeformCurveWithControlPoints3D;
import jp.go.ipa.jgcl.JgclHomogeneousPoint3D;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclInterpolation3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsBscBsc3D;
import jp.go.ipa.jgcl.JgclIntsBzcBsc3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclLoftSurface3D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclOpenCurve;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnGeometryList;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclRealFunctionWithOneVariable;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclTabcylSurface3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclTwoGeomertiesAreNotContinuous;
import jp.go.ipa.jgcl.JgclVector3D;
import jp.go.ipa.jgcl.JgclZeroLength;

public class JgclBsplineCurve3D
extends JgclFreeformCurveWithControlPoints3D {
    private JgclBsplineKnot knotData;
    private int curveForm = 5;

    public JgclBsplineCurve3D(int degree, boolean periodic, int[] knotMultiplicities, double[] knots, JgclPoint3D[] controlPoints) {
        super(controlPoints);
        this.knotData = new JgclBsplineKnot(degree, 1, periodic, knotMultiplicities, knots, this.nControlPoints());
    }

    public JgclBsplineCurve3D(int degree, int[] knotMultiplicities, double[] knots, JgclPoint3D[] controlPoints) {
        super(controlPoints);
        this.knotData = new JgclBsplineKnot(degree, 1, false, knotMultiplicities, knots, this.nControlPoints());
    }

    public JgclBsplineCurve3D(int degree, boolean periodic, int[] knotMultiplicities, double[] knots, JgclPoint3D[] controlPoints, double[] weights) {
        super(controlPoints, weights);
        this.knotData = new JgclBsplineKnot(degree, 1, periodic, knotMultiplicities, knots, this.nControlPoints());
    }

    public JgclBsplineCurve3D(int degree, int[] knotMultiplicities, double[] knots, JgclPoint3D[] controlPoints, double[] weights) {
        super(controlPoints, weights);
        this.knotData = new JgclBsplineKnot(degree, 1, false, knotMultiplicities, knots, this.nControlPoints());
    }

    public JgclBsplineCurve3D(int degree, boolean periodic, int knotSpec, JgclPoint3D[] controlPoints) {
        super(controlPoints);
        this.knotData = new JgclBsplineKnot(degree, knotSpec, periodic, null, null, this.nControlPoints());
    }

    public JgclBsplineCurve3D(int degree, int knotSpec, JgclPoint3D[] controlPoints) {
        super(controlPoints);
        this.knotData = new JgclBsplineKnot(degree, knotSpec, false, null, null, this.nControlPoints());
    }

    public JgclBsplineCurve3D(int degree, boolean periodic, int knotSpec, JgclPoint3D[] controlPoints, double[] weights) {
        super(controlPoints, weights);
        this.knotData = new JgclBsplineKnot(degree, knotSpec, periodic, null, null, this.nControlPoints());
    }

    public JgclBsplineCurve3D(int degree, int knotSpec, JgclPoint3D[] controlPoints, double[] weights) {
        super(controlPoints, weights);
        this.knotData = new JgclBsplineKnot(degree, knotSpec, false, null, null, this.nControlPoints());
    }

    JgclBsplineCurve3D(JgclBsplineKnot knotData, double[][] cpArray) {
        super(cpArray);
        if (knotData.nControlPoints() != this.nControlPoints()) {
            throw new JgclInvalidArgumentValue();
        }
        this.knotData = knotData;
    }

    JgclBsplineCurve3D(JgclBsplineKnot knotData, JgclPoint3D[] controlPoints, double[] weights) {
        super(controlPoints, weights, false);
        this.knotData = knotData;
    }

    public JgclBsplineCurve3D(JgclPoint3D[] points, double[] params) {
        JgclInterpolation3D doObj = new JgclInterpolation3D(points, params);
        this.controlPoints = doObj.controlPoints();
        this.knotData = doObj.knotData();
        this.weights = doObj.weights();
    }

    public JgclBsplineCurve3D(JgclPoint3D[] points, double[] params, JgclVector3D[] endvecs) {
        JgclInterpolation3D doObj = new JgclInterpolation3D(points, params, endvecs);
        this.controlPoints = doObj.controlPoints();
        this.knotData = doObj.knotData();
        this.weights = doObj.weights();
    }

    public JgclBsplineCurve3D(JgclPoint3D[] points, double[] params, JgclVector3D[] endvecs, boolean isClosed) {
        JgclInterpolation3D doObj = new JgclInterpolation3D(points, params, endvecs, isClosed);
        this.controlPoints = doObj.controlPoints();
        this.knotData = doObj.knotData();
        this.weights = doObj.weights();
    }

    public JgclBsplineCurve3D(JgclPoint3D[] points, double[] params, JgclVector3D[] endDir, boolean isClosed, JgclToleranceForDistance tol, JgclToleranceForDistance midTol) {
        JgclApproximation3D doObj = new JgclApproximation3D(points, params, endDir, isClosed);
        JgclBsplineCurve3D bsc = doObj.getApproximationWithTolerance(tol, midTol);
        this.controlPoints = bsc.controlPoints;
        this.knotData = bsc.knotData;
        this.weights = bsc.weights;
    }

    public int degree() {
        return this.knotData.degree();
    }

    public int knotSpec() {
        return this.knotData.knotSpec();
    }

    public int nKnotValues() {
        return this.knotData.nKnotValues();
    }

    public double knotValueAt(int n) {
        return this.knotData.knotValueAt(n);
    }

    int nSegments() {
        return this.knotData.nSegments();
    }

    JgclBsplineKnot.ValidSegmentInfo validSegments() {
        return this.knotData.validSegments();
    }

    JgclBsplineKnot knotData() {
        return this.knotData;
    }

    public boolean isPeriodic() {
        return this.knotData.isPeriodic();
    }

    public JgclPoint3D controlPointAt(int n) {
        if (this.isPeriodic()) {
            int ncp = this.nControlPoints();
            while (n < 0) {
                n += ncp;
            }
            while (n >= ncp) {
                n -= ncp;
            }
        }
        return this.controlPoints[n];
    }

    private void make_coef(double[] coef, int jjj, int seg, double pTol) {
        int degree = coef.length - 3;
        if (degree == 0) {
            coef[1] = jjj == seg ? 1.0 : 0.0;
        } else {
            double aaa;
            double kj;
            double[] coef_1 = new double[degree + 2];
            int ijk = 0;
            while (ijk <= degree) {
                coef[ijk + 1] = 0.0;
                ++ijk;
            }
            coef_1[degree + 1] = 0.0;
            coef_1[0] = 0.0;
            if (jjj != seg - degree) {
                kj = this.knotValueAt(jjj);
                aaa = this.knotValueAt(jjj + degree) - kj;
                if (aaa > pTol) {
                    this.make_coef(coef_1, jjj, seg, pTol);
                    ijk = 0;
                    while (ijk <= degree) {
                        int n = ijk + 1;
                        coef[n] = coef[n] + (coef_1[ijk + 1] - coef_1[ijk] * kj) / aaa;
                        ++ijk;
                    }
                }
            }
            if (jjj != seg && (aaa = (kj = this.knotValueAt(jjj + degree + 1)) - this.knotValueAt(jjj + 1)) > pTol) {
                this.make_coef(coef_1, jjj + 1, seg, pTol);
                ijk = 0;
                while (ijk <= degree) {
                    int n = ijk + 1;
                    coef[n] = coef[n] - (coef_1[ijk + 1] - coef_1[ijk] * kj) / aaa;
                    ++ijk;
                }
            }
        }
    }

    public JgclRealPolynomial[] polynomial(int iSseg, boolean isPoly) {
        int klm;
        int ijk;
        int degree = this.degree();
        int isckt = iSseg;
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        int uicp = this.nControlPoints();
        int dim = cntlPnts[0].length;
        double[][] coef = new double[dim][];
        int i = 0;
        while (i < dim) {
            coef[i] = new double[degree + 1];
            ++i;
        }
        double[] eA = new double[degree + 3];
        double pTol = this.getToleranceForParameter();
        JgclRealPolynomial[] polynomial = new JgclRealPolynomial[dim];
        i = 0;
        while (i < dim) {
            ijk = 0;
            while (ijk <= degree) {
                coef[i][ijk] = 0.0;
                ++ijk;
            }
            ++i;
        }
        ijk = 0;
        int pklm = klm = isckt;
        while (ijk <= degree) {
            this.make_coef(eA, klm, isckt + degree, pTol);
            if (this.isPeriodic() && pklm == uicp) {
                pklm = 0;
            }
            i = 0;
            while (i < dim) {
                int mno = 0;
                while (mno <= degree) {
                    double[] dArray = coef[i];
                    int n = degree - mno;
                    dArray[n] = dArray[n] + eA[mno + 1] * cntlPnts[pklm][i];
                    ++mno;
                }
                ++i;
            }
            ++ijk;
            ++pklm;
            ++klm;
        }
        i = 0;
        while (i < dim) {
            polynomial[i] = new JgclRealPolynomial(coef[i]);
            ++i;
        }
        return polynomial;
    }

    public double length(JgclParameterSection pint) {
        double length = 0.0;
        double dTol = this.getToleranceForDistance() / 2.0;
        double pTol = this.getToleranceForParameter();
        if (!this.isPolynomial() || Math.abs(pint.increase()) <= pTol) {
            1 realFunction = new 1();
            length = JgclMath.getDefiniteIntegral(realFunction, pint, dTol);
        } else {
            JgclBsplineCurve3D tbsc = this.truncate(pint);
            JgclBsplineKnot.ValidSegmentInfo vsegInfo = tbsc.knotData.validSegments();
            int nvseg = vsegInfo.nSegments();
            int ijk = 0;
            while (ijk < nvseg) {
                JgclRealPolynomial[] poly = tbsc.polynomial(ijk, this.isPolynomial());
                JgclRealPolynomial[] deriv = new JgclRealPolynomial[poly.length];
                int klm = 0;
                while (klm < poly.length) {
                    deriv[klm] = poly[klm].derive();
                    ++klm;
                }
                2 realFunction = new 2(deriv);
                JgclParameterSection psec = new JgclParameterSection(vsegInfo.knotPoint(ijk)[0], vsegInfo.knotPoint(ijk)[1]);
                length += JgclMath.getDefiniteIntegral(realFunction, psec, dTol);
                ++ijk;
            }
        }
        return length;
    }

    public JgclPoint3D coordinates(double param) {
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        double[] d0D = JgclBsplineCurveEvaluation.coordinates(this.knotData, cntlPnts, param);
        if (!isPoly) {
            this.convRational0Deriv(d0D);
        }
        return new JgclCartesianPoint3D(d0D[0], d0D[1], d0D[2]);
    }

    public JgclVector3D tangentVector(double param) {
        double[] d1D = new double[4];
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        if (isPoly) {
            JgclBsplineCurveEvaluation.evaluation(this.knotData, cntlPnts, param, null, d1D, null, null);
        } else {
            double[] d0D = new double[4];
            JgclBsplineCurveEvaluation.evaluation(this.knotData, cntlPnts, param, d0D, d1D, null, null);
            this.convRational1Deriv(d0D, d1D);
        }
        return new JgclLiteralVector3D(d1D[0], d1D[1], d1D[2]);
    }

    public JgclCurveCurvature3D curvature(double param) {
        JgclVector3D dDnrm;
        double dDcrv;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double tol_d = condition.getToleranceForDistance();
        int degree = this.degree();
        JgclCurveDerivative3D deriv = this.evaluation(param);
        double tang_leng = deriv.d1D().norm();
        boolean tang0 = tang_leng < tol_d * tol_d;
        if (degree < 2 || tang0) {
            dDcrv = 0.0;
            dDnrm = JgclVector3D.zeroVector;
        } else {
            tang_leng = Math.sqrt(tang_leng);
            dDcrv = tang_leng * tang_leng * tang_leng;
            JgclVector3D ewvec = deriv.d1D().crossProduct(deriv.d2D());
            dDcrv = ewvec.magnitude() / dDcrv;
            dDnrm = ewvec.crossProduct(deriv.d1D()).unitized();
        }
        return new JgclCurveCurvature3D(dDcrv, dDnrm);
    }

    public double torsion(double param) {
        double dDtsn;
        JgclVector3D ewvec;
        double ewrk2;
        boolean curv0;
        double dDcrv;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double tol_d = condition.getToleranceForDistance();
        int degree = this.degree();
        JgclCurveDerivative3D deriv = this.evaluation(param);
        double tang_leng = deriv.d1D().norm();
        boolean tang0 = tang_leng < tol_d * tol_d;
        if (degree < 2 || tang0) {
            dDcrv = 0.0;
            curv0 = true;
            ewrk2 = 0.0;
            ewvec = null;
        } else {
            tang_leng = Math.sqrt(tang_leng);
            ewrk2 = dDcrv = tang_leng * tang_leng * tang_leng;
            ewvec = deriv.d1D().crossProduct(deriv.d2D());
            dDcrv = ewvec.magnitude() / dDcrv;
            curv0 = false;
        }
        if (degree < 3 || curv0) {
            dDtsn = 0.0;
        } else {
            double ewrk1 = ewvec.dotProduct(deriv.d3D());
            ewrk2 = ewrk2 * ewrk2 * dDcrv * dDcrv;
            dDtsn = ewrk1 / ewrk2;
        }
        return dDtsn;
    }

    public JgclCurveDerivative3D evaluation(double param) {
        double[] ld0D = new double[4];
        double[] ld1D = new double[4];
        double[] ld2D = new double[4];
        double[] ld3D = new double[4];
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        JgclBsplineCurveEvaluation.evaluation(this.knotData, cntlPnts, param, ld0D, ld1D, ld2D, ld3D);
        if (!isPoly) {
            this.convRational3Deriv(ld0D, ld1D, ld2D, ld3D);
        }
        JgclCartesianPoint3D d0D = new JgclCartesianPoint3D(ld0D[0], ld0D[1], ld0D[2]);
        JgclLiteralVector3D d1D = new JgclLiteralVector3D(ld1D[0], ld1D[1], ld1D[2]);
        JgclLiteralVector3D d2D = new JgclLiteralVector3D(ld2D[0], ld2D[1], ld2D[2]);
        JgclLiteralVector3D d3D = new JgclLiteralVector3D(ld3D[0], ld3D[1], ld3D[2]);
        return new JgclCurveDerivative3D(d0D, d1D, d2D, d3D);
    }

    public JgclPoint3D blossoming(int segNumber, double[] parameters) {
        double[] adjustedParameters = new double[this.degree()];
        int i = 0;
        while (i < this.degree()) {
            adjustedParameters[i] = this.checkParameter(parameters[i]);
            ++i;
        }
        boolean isPoly = this.isPolynomial();
        double[] d0D = JgclBsplineCurveEvaluation.blossoming(this.knotData, this.toDoubleArray(isPoly), segNumber, adjustedParameters);
        if (isPoly) {
            return new JgclCartesianPoint3D(d0D[0], d0D[1], d0D[2]);
        }
        return new JgclHomogeneousPoint3D(d0D[0], d0D[1], d0D[2], d0D[3]);
    }

    private void checkEndPoint(double minParam, double maxParam, int minDegree, int seg, int nvseg, Vector paramVec) {
        if (this.degree() < minDegree) {
            if (this.isClosed() && paramVec.size() == 0) {
                paramVec.addElement(new Double(minParam));
            }
            if (seg != nvseg - 1) {
                int mno = 0;
                while (mno < paramVec.size()) {
                    if (this.identicalParameter((Double)paramVec.elementAt(mno), maxParam)) break;
                    ++mno;
                }
                if (mno == paramVec.size()) {
                    paramVec.addElement(new Double(maxParam));
                }
            }
        }
    }

    public JgclPointOnCurve3D[] singular() {
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = this.knotData.validSegments();
        int nvseg = vsegInfo.nSegments();
        int numseg = this.nSegments();
        JgclPureBezierCurve3D[] bzcs = this.toPureBezierCurveArray();
        int minDegree = 2;
        Vector<Double> snglrParam = new Vector<Double>();
        int ijk = 0;
        while (ijk < numseg) {
            block9: {
                double maxParam;
                double minParam;
                int klm = vsegInfo.isValidSegment(ijk);
                if (klm < 0) {
                    minParam = this.knotValueAt(this.degree() + ijk);
                    maxParam = this.knotValueAt(this.degree() + ijk + 1);
                    this.checkEndPoint(minParam, maxParam, minDegree, ijk, nvseg, snglrParam);
                } else {
                    JgclPointOnCurve3D[] singularOnBzc;
                    minParam = vsegInfo.knotPoint(klm)[0];
                    maxParam = vsegInfo.knotPoint(klm)[1];
                    this.checkEndPoint(minParam, maxParam, minDegree, klm, nvseg, snglrParam);
                    try {
                        singularOnBzc = bzcs[klm].singular();
                    }
                    catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                        break block9;
                    }
                    klm = 0;
                    while (klm < singularOnBzc.length) {
                        double candidateParam = (maxParam - minParam) * singularOnBzc[klm].parameter() + minParam;
                        int mno = 0;
                        while (mno < snglrParam.size()) {
                            if (this.identicalParameter((Double)snglrParam.elementAt(mno), candidateParam)) break;
                            ++mno;
                        }
                        if (mno == snglrParam.size()) {
                            snglrParam.addElement(new Double(candidateParam));
                        }
                        ++klm;
                    }
                }
            }
            ++ijk;
        }
        int numberOfSolution = snglrParam.size();
        JgclPointOnCurve3D[] singular = new JgclPointOnCurve3D[numberOfSolution];
        ijk = 0;
        while (ijk < numberOfSolution) {
            singular[ijk] = new JgclPointOnCurve3D(this, (Double)snglrParam.elementAt(ijk), false);
            ++ijk;
        }
        return singular;
    }

    public JgclPointOnCurve3D[] inflexion() {
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = this.knotData.validSegments();
        int nvseg = vsegInfo.nSegments();
        int numseg = this.nSegments();
        JgclPureBezierCurve3D[] bzcs = this.toPureBezierCurveArray();
        int minDegree = 3;
        Vector<Double> inflxParam = new Vector<Double>();
        int ijk = 0;
        while (ijk < numseg) {
            block9: {
                double maxParam;
                double minParam;
                int klm = vsegInfo.isValidSegment(ijk);
                if (klm < 0) {
                    minParam = this.knotValueAt(this.degree() + ijk);
                    maxParam = this.knotValueAt(this.degree() + ijk + 1);
                    this.checkEndPoint(minParam, maxParam, minDegree, ijk, nvseg, inflxParam);
                } else {
                    JgclPointOnCurve3D[] inflexionOnBzc;
                    minParam = vsegInfo.knotPoint(klm)[0];
                    maxParam = vsegInfo.knotPoint(klm)[1];
                    this.checkEndPoint(minParam, maxParam, minDegree, klm, nvseg, inflxParam);
                    try {
                        inflexionOnBzc = bzcs[klm].inflexion();
                    }
                    catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                        break block9;
                    }
                    klm = 0;
                    while (klm < inflexionOnBzc.length) {
                        double candidateParam = (maxParam - minParam) * inflexionOnBzc[klm].parameter() + minParam;
                        int mno = 0;
                        while (mno < inflxParam.size()) {
                            if (this.identicalParameter((Double)inflxParam.elementAt(mno), candidateParam)) break;
                            ++mno;
                        }
                        if (mno == inflxParam.size()) {
                            inflxParam.addElement(new Double(candidateParam));
                        }
                        ++klm;
                    }
                }
            }
            ++ijk;
        }
        int numberOfSolution = inflxParam.size();
        JgclPointOnCurve3D[] inflexion = new JgclPointOnCurve3D[numberOfSolution];
        ijk = 0;
        while (ijk < numberOfSolution) {
            inflexion[ijk] = new JgclPointOnCurve3D(this, (Double)inflxParam.elementAt(ijk), false);
            ++ijk;
        }
        return inflexion;
    }

    public JgclBsplineCurve3D toBsplineCurve() {
        if (this.isRational()) {
            return this;
        }
        return new JgclBsplineCurve3D(this.knotData, this.controlPoints, this.makeUniformWeights());
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
        JgclBsplineCurve3D target;
        if (this.isPeriodic()) {
            if (pint.absIncrease() >= this.parameterDomain().section().absIncrease()) {
                target = this;
                try {
                    target = target.shiftIfPeriodic(pint.start());
                }
                catch (JgclOpenCurve jgclOpenCurve) {}
                if (pint.increase() < 0.0) {
                    target = target.reverse();
                }
            } else {
                target = this.truncate(pint);
            }
        } else {
            target = this.truncate(pint);
        }
        return target.toBsplineCurve();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = this.knotData.validSegments();
        JgclAxis2Placement3D placement = new JgclAxis2Placement3D(mate.pnt(), mate.dir().verticalVector(), mate.dir());
        JgclCartesianTransformationOperator3D transform = new JgclCartesianTransformationOperator3D(placement, 1.0);
        int uicp = this.nControlPoints();
        JgclPoint3D[] newCp = new JgclPoint3D[uicp];
        int i = 0;
        while (i < uicp) {
            newCp[i] = transform.toLocal(this.controlPointAt(i));
            ++i;
        }
        double[] weights = this.weights();
        if (this.isRational()) {
            double max_weight = 0.0;
            int i2 = 0;
            while (i2 < uicp) {
                if (Math.abs(weights[i2]) > max_weight) {
                    max_weight = weights[i2];
                }
                ++i2;
            }
            if (max_weight > 0.0) {
                int i3 = 0;
                while (i3 < uicp) {
                    int n = i3++;
                    weights[n] = weights[n] / max_weight;
                }
            }
        }
        JgclBsplineCurve3D bsc = new JgclBsplineCurve3D(this.knotData, newCp, weights);
        Vector<Double> lineParam = new Vector<Double>();
        Vector<Double> bscParam = new Vector<Double>();
        int nSeg = vsegInfo.nSegments();
        int k = 0;
        int degree = bsc.degree();
        JgclPoint3D[] anotherCp = new JgclPoint3D[degree + 3];
        int i4 = 0;
        while (i4 < nSeg) {
            block27: {
                JgclComplex[] roots;
                JgclComplexPolynomial compPoly;
                JgclBsplineCurve3D oldBsc;
                block26: {
                    int l = 0;
                    int m = vsegInfo.segmentNumber(i4);
                    while (l <= degree) {
                        anotherCp[l] = bsc.controlPointAt(m);
                        ++l;
                        ++m;
                    }
                    anotherCp[l++] = JgclPoint3D.origin;
                    anotherCp[l] = new JgclCartesianPoint3D(1.0, 0.0, 0.0);
                    JgclVector3D verticalVector = JgclPlane3D.coplaner(anotherCp);
                    oldBsc = null;
                    if (verticalVector == null) break block26;
                    if (verticalVector.norm() < this.getToleranceForDistance()) break block27;
                    JgclVector3D crossVector = verticalVector.crossProduct(JgclVector3D.xUnitVector).unitized();
                    JgclCartesianTransformationOperator3D transformToPlane = new JgclCartesianTransformationOperator3D(JgclVector3D.xUnitVector, crossVector, verticalVector, JgclPoint3D.origin, 1.0);
                    JgclPoint3D[] cpOnPlane = new JgclPoint3D[uicp];
                    l = 0;
                    while (l < uicp) {
                        cpOnPlane[l] = JgclPoint3D.origin;
                        ++l;
                    }
                    l = 0;
                    m = vsegInfo.segmentNumber(i4);
                    while (l <= degree) {
                        if (m >= uicp) {
                            m = 0;
                        }
                        cpOnPlane[m] = transformToPlane.toLocal(anotherCp[l]);
                        ++l;
                        ++m;
                    }
                    oldBsc = bsc;
                    bsc = new JgclBsplineCurve3D(bsc.knotData(), cpOnPlane, weights);
                }
                JgclRealPolynomial[] realPoly = bsc.polynomial(vsegInfo.segmentNumber(i4), this.isPolynomial());
                if (oldBsc != null) {
                    bsc = oldBsc;
                    compPoly = realPoly[1].toComplexPolynomial();
                } else {
                    JgclRealPolynomial yPoly = realPoly[1].multiply(realPoly[1]);
                    JgclRealPolynomial zPoly = realPoly[2].multiply(realPoly[2]);
                    compPoly = yPoly.add(zPoly).toComplexPolynomial();
                }
                try {
                    roots = compPoly.getRootsByDKA();
                }
                catch (JgclComplexPolynomial.DKANotConverge e) {
                    roots = e.getValues();
                }
                catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
                    throw new JgclFatal();
                }
                catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
                    throw new JgclFatal();
                }
                int nRoots = roots.length;
                int j = 0;
                while (j < nRoots) {
                    double realRoot = roots[j].real();
                    if (bsc.parameterValidity(realRoot) != 3) {
                        double[] knotParams = vsegInfo.knotPoint(i4);
                        if (realRoot < knotParams[0]) {
                            realRoot = knotParams[0];
                        }
                        if (realRoot > knotParams[1]) {
                            realRoot = knotParams[1];
                        }
                        JgclPoint3D workPoint = bsc.coordinates(realRoot);
                        double dTol = bsc.getToleranceForDistance();
                        if (workPoint.y() * workPoint.y() + workPoint.z() * workPoint.z() < this.getToleranceForDistance2()) {
                            int jj = 0;
                            while (jj < k) {
                                double paramA = (Double)lineParam.elementAt(jj);
                                double paramB = (Double)bscParam.elementAt(jj);
                                if (Math.abs(paramA - workPoint.x()) < dTol && bsc.identicalParameter(paramA, paramB)) break;
                                ++jj;
                            }
                            if (jj >= k) {
                                lineParam.addElement(new Double(workPoint.x()));
                                bscParam.addElement(new Double(realRoot));
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i4;
        }
        int num = bscParam.size();
        JgclIntersectionPoint3D[] intersectPoint = new JgclIntersectionPoint3D[num];
        double mateLength = mate.dir().length();
        int i5 = 0;
        while (i5 < k) {
            double work = (Double)lineParam.elementAt(i5) / mateLength;
            JgclPointOnCurve3D pointOnLine = new JgclPointOnCurve3D(mate, work, false);
            work = (Double)bscParam.elementAt(i5);
            JgclPointOnCurve3D pointOnBsc = new JgclPointOnCurve3D(this, work, false);
            JgclPoint3D coordinates = this.coordinates(work);
            intersectPoint[i5] = !doExchange ? new JgclIntersectionPoint3D(coordinates, pointOnBsc, pointOnLine, false) : new JgclIntersectionPoint3D(coordinates, pointOnLine, pointOnBsc, false);
            ++i5;
        }
        return intersectPoint;
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        return JgclIntsBzcBsc3D.intersection(mate, this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        return JgclIntsBscBsc3D.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    public JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate) {
        return mate.intersect(this, true);
    }

    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate) {
        return mate.interfere(this, true);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclPolyline3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclPureBezierCurve3D mate, boolean doExchange) {
        return JgclIntsBzcBsc3D.interference(mate, this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBsplineCurve3D mate, boolean doExchange) {
        return JgclIntsBscBsc3D.interference(this, mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclTrimmedCurve3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    public JgclBsplineCurve3D insertKnot(double param) {
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        Object[] result = JgclBsplineCurveEvaluation.insertKnot(this.knotData, cntlPnts, param);
        JgclBsplineKnot newKnotData = (JgclBsplineKnot)result[0];
        double[][] newControlPoints = (double[][])result[1];
        return new JgclBsplineCurve3D(newKnotData, newControlPoints);
    }

    public JgclBsplineCurve3D[] divide(double param) {
        boolean isPoly = this.isPolynomial();
        JgclBsplineKnot[] newKnotData = new JgclBsplineKnot[2];
        double[][][] newControlPoints = new double[2][][];
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        JgclBsplineCurveEvaluation.divide(this.knotData, cntlPnts, param, newKnotData, newControlPoints);
        if (newKnotData[0] == null) {
            throw new JgclFatal();
        }
        int n_bsc = newKnotData[1] == null ? 1 : 2;
        JgclBsplineCurve3D[] bsc = new JgclBsplineCurve3D[n_bsc];
        int i = 0;
        while (i < n_bsc) {
            try {
                bsc[i] = new JgclBsplineCurve3D(newKnotData[i], newControlPoints[i]);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return bsc;
    }

    public JgclBsplineCurve3D truncate(JgclParameterSection section) {
        JgclBsplineCurve3D t_bsc;
        if (Math.abs(section.increase()) <= this.getToleranceForParameter()) {
            throw new JgclInvalidArgumentValue();
        }
        if (this.isNonPeriodic()) {
            double start_par = this.checkParameter(section.lower());
            double end_par = this.checkParameter(section.upper());
            t_bsc = this.divide(start_par)[1];
            t_bsc = t_bsc.divide(end_par - start_par)[0];
        } else {
            double crv_intvl = this.parameterDomain().section().increase();
            double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();
            double start_par = this.checkParameter(section.start());
            t_bsc = this.divide(start_par)[0];
            if (Math.abs(section.increase()) < crv_intvl - tol_p) {
                if (section.increase() > 0.0) {
                    double end_par = section.increase();
                    t_bsc = t_bsc.divide(end_par)[0];
                } else {
                    double end_par = crv_intvl + section.increase();
                    t_bsc = t_bsc.divide(end_par)[1];
                }
            }
        }
        if (section.increase() < 0.0) {
            t_bsc = t_bsc.reverse();
        }
        return t_bsc;
    }

    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D mate) {
        int dimension = 3;
        int coef_size = this.isPolynomial() ? dimension : dimension + 1;
        JgclRealPolynomial[] offsPoly = new JgclRealPolynomial[dimension];
        JgclRealPolynomial[] tangPoly = new JgclRealPolynomial[coef_size];
        JgclRealPolynomial[] dotePoly = new JgclRealPolynomial[dimension];
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = this.knotData.validSegments();
        JgclPointOnGeometryList projList = new JgclPointOnGeometryList();
        double dTol = this.getToleranceForDistance();
        int ijk = 0;
        while (ijk < vsegInfo.nSegments()) {
            JgclComplex[] root;
            JgclComplexPolynomial dtPoly;
            JgclRealPolynomial[] pointPoly = this.polynomial(vsegInfo.segmentNumber(ijk), this.isPolynomial());
            if (this.isRational()) {
                offsPoly[0] = pointPoly[dimension].multiply(mate.x());
                offsPoly[1] = pointPoly[dimension].multiply(mate.y());
                offsPoly[2] = pointPoly[dimension].multiply(mate.z());
            } else {
                double[][] coef = new double[][]{{mate.x()}, {mate.y()}, {mate.z()}};
                offsPoly[0] = new JgclRealPolynomial(coef[0]);
                offsPoly[1] = new JgclRealPolynomial(coef[1]);
                offsPoly[2] = new JgclRealPolynomial(coef[2]);
            }
            int i = 0;
            while (i < dimension) {
                pointPoly[i] = pointPoly[i].subtract(offsPoly[i]);
                ++i;
            }
            int klm = 0;
            while (klm < coef_size) {
                tangPoly[klm] = pointPoly[klm].derive();
                ++klm;
            }
            if (!this.isRational()) {
                klm = 0;
                while (klm < dimension) {
                    dotePoly[klm] = pointPoly[klm].multiply(tangPoly[klm]);
                    ++klm;
                }
            } else {
                klm = 0;
                while (klm < 3) {
                    JgclRealPolynomial work0 = pointPoly[3].multiply(tangPoly[klm]);
                    JgclRealPolynomial work1 = tangPoly[3].multiply(pointPoly[klm]);
                    JgclRealPolynomial work2 = work0.subtract(work1);
                    double[] work3 = work2.coefficientsBetween(0, work2.degree() - 1);
                    JgclRealPolynomial sub = new JgclRealPolynomial(work3);
                    dotePoly[klm] = pointPoly[klm].multiply(sub);
                    ++klm;
                }
            }
            try {
                dtPoly = dotePoly[0].add(dotePoly[1]).add(dotePoly[2]).toComplexPolynomial();
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            try {
                root = dtPoly.getRootsByDKA();
            }
            catch (JgclComplexPolynomial.DKANotConverge e) {
                root = e.getValues();
            }
            catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
                throw new JgclFatal();
            }
            catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
                throw new JgclFatal();
            }
            double[] intv = vsegInfo.knotPoint(ijk);
            JgclParameterDomain domain = new JgclParameterDomain(false, intv[0], intv[1] - intv[0]);
            int mno = 0;
            while (mno < root.length) {
                JgclPointOnCurve3D proj;
                double par = root[mno].real();
                if (domain.isValid(par) && (proj = this.checkProjection(par = domain.force(par), mate, dTol * dTol)) != null) {
                    projList.addPoint(proj);
                }
                ++mno;
            }
            ++ijk;
        }
        return projList.toJgclPointOnCurve3DArray();
    }

    public JgclBsplineCurve3D shiftIfPeriodic(double newStartParam) throws JgclOpenCurve {
        if (!this.isPeriodic()) {
            throw new JgclOpenCurve();
        }
        newStartParam = this.parameterDomain().wrap(newStartParam);
        int newFirstSegment = this.knotData().getSegmentNumberThatStartIsEqualTo(newStartParam);
        if (newFirstSegment == -1) {
            return this.insertKnot(newStartParam).shiftIfPeriodic(newStartParam);
        }
        JgclBsplineKnot newKnotData = this.knotData().shift(newFirstSegment);
        int nNewControlPoints = newKnotData.nControlPoints();
        JgclPoint3D[] newControlPoints = new JgclPoint3D[nNewControlPoints];
        int i = 0;
        while (i < nNewControlPoints) {
            newControlPoints[i] = this.controlPointAt((i + newFirstSegment) % nNewControlPoints);
            ++i;
        }
        double[] newWeights = null;
        if (this.isRational()) {
            newWeights = new double[nNewControlPoints];
            int i2 = 0;
            while (i2 < nNewControlPoints) {
                newWeights[i2] = this.weightAt((i2 + newFirstSegment) % nNewControlPoints);
                ++i2;
            }
        }
        return new JgclBsplineCurve3D(newKnotData, newControlPoints, newWeights);
    }

    public JgclPolyline3D toPolyline(JgclParameterSection section, JgclToleranceForDistance tolerance) {
        double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        JgclBsplineKnot.ValidSegmentInfo vseg_info = this.knotData.validSegments();
        int nseg = vseg_info.nSegments();
        double lower_limit = vseg_info.knotPoint(0)[0];
        double upper_limit = vseg_info.knotPoint(nseg - 1)[1];
        if (this.isPeriodic()) {
            double par_intvl = upper_limit - lower_limit;
            double my_sp = this.checkParameter(section.start());
            JgclBsplineCurve3D o_bsc = this.divide(my_sp)[0];
            my_sp = section.increase() > 0.0 ? lower_limit : upper_limit;
            JgclParameterSection lpint = new JgclParameterSection(my_sp, section.increase());
            JgclPolyline3D lpol = o_bsc.toPolyline(lpint, tolerance);
            int npnts = lpol.nPoints();
            JgclPoint3D[] pnts = new JgclPoint3D[npnts];
            int i = 0;
            while (i < npnts) {
                JgclPointOnCurve3D lpnt = (JgclPointOnCurve3D)lpol.pointAt(i);
                JgclCartesianPoint3D pnt = new JgclCartesianPoint3D(lpnt.x(), lpnt.y(), lpnt.z());
                double param = lpnt.parameter() + section.start();
                if (param > upper_limit) {
                    param -= upper_limit;
                }
                pnts[i] = new JgclPointOnCurve3D(pnt, this, param, false);
                ++i;
            }
            return new JgclPolyline3D(pnts);
        }
        double my_sp = this.checkParameter(section.lower());
        double my_ep = this.checkParameter(section.upper());
        int my_sseg = vseg_info.segmentIndex(my_sp);
        int my_eseg = vseg_info.segmentIndex(my_ep);
        JgclPureBezierCurve3D[] bzcs = this.toPureBezierCurveArray();
        int no_total_pnts = 0;
        segmentInfo[] seg_infos = new segmentInfo[nseg];
        int i = my_sseg;
        while (i <= my_eseg) {
            block12: {
                JgclPolyline3D lpol;
                double d;
                double[] kp = vseg_info.knotPoint(i);
                seg_infos[i] = new segmentInfo(kp[0], kp[1]);
                double bzc_sp = i == my_sseg ? (my_sp - seg_infos[i].lp()) / seg_infos[i].dp() : 0.0;
                double bzc_ep = i == my_eseg ? (my_ep - seg_infos[i].lp()) / seg_infos[i].dp() : 1.0;
                double bzc_ip = bzc_ep - bzc_sp;
                if (d < tol_p) {
                    my_eseg = i - 1;
                    break;
                }
                JgclParameterSection lpint = new JgclParameterSection(bzc_sp, bzc_ip);
                try {
                    lpol = bzcs[i].toPolyline(lpint, tolerance);
                }
                catch (JgclZeroLength jgclZeroLength) {
                    break block12;
                }
                seg_infos[i].pnts(lpol.points());
                no_total_pnts += seg_infos[i].nPnts();
                if (i > my_sseg) {
                    --no_total_pnts;
                }
            }
            ++i;
        }
        if (no_total_pnts < 2) {
            throw new JgclZeroLength();
        }
        JgclPoint3D[] pnts = new JgclPoint3D[no_total_pnts];
        boolean first = true;
        i = my_sseg;
        int m = 0;
        while (i <= my_eseg) {
            int j = first ? 0 : 1;
            while (j < seg_infos[i].nPnts()) {
                JgclPointOnCurve3D lpnt = (JgclPointOnCurve3D)seg_infos[i].pnts(j);
                JgclCartesianPoint3D pnt = new JgclCartesianPoint3D(lpnt.x(), lpnt.y(), lpnt.z());
                double param = seg_infos[i].lp() + seg_infos[i].dp() * lpnt.parameter();
                pnts[m] = new JgclPointOnCurve3D(pnt, this, param, false);
                first = false;
                ++j;
                ++m;
            }
            ++i;
        }
        if (section.increase() > 0.0) {
            return new JgclPolyline3D(pnts);
        }
        return new JgclPolyline3D(pnts).reverse();
    }

    public JgclPureBezierCurve3D[] toPureBezierCurveArray() {
        boolean isPoly = this.isPolynomial();
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        double[][][] bzc_array = JgclBsplineCurveEvaluation.toBezierCurve(this.knotData, cntlPnts);
        JgclPureBezierCurve3D[] bzcs = new JgclPureBezierCurve3D[bzc_array.length];
        int i = 0;
        while (i < bzc_array.length) {
            try {
                bzcs[i] = new JgclPureBezierCurve3D(bzc_array[i]);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return bzcs;
    }

    JgclBsplineCurve3D reverse() {
        boolean isRat = this.isRational();
        int uicp = this.nControlPoints();
        JgclPoint3D[] rCp = new JgclPoint3D[uicp];
        double[] rWt = null;
        JgclBsplineKnot rKd = this.knotData.reverse();
        if (isRat) {
            rWt = new double[uicp];
        }
        int i = 0;
        int j = uicp - 1;
        while (i < uicp) {
            rCp[i] = this.controlPointAt(j);
            if (isRat) {
                rWt[i] = this.weightAt(j);
            }
            ++i;
            --j;
        }
        return new JgclBsplineCurve3D(rKd, rCp, rWt);
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        JgclPoint3D[] pnts = new JgclPoint3D[this.nControlPoints()];
        int i = 0;
        while (i < this.nControlPoints()) {
            pnts[i] = this.controlPointAt(i).add(moveVec);
            ++i;
        }
        return new JgclBsplineCurve3D(this.knotData, pnts, this.weights);
    }

    JgclParameterDomain getParameterDomain() {
        return this.knotData.getParameterDomain();
    }

    int type() {
        return 21;
    }

    private double checkParameter(double param) {
        this.checkValidity(param);
        return this.parameterDomain().force(this.parameterDomain().wrap(param));
    }

    public JgclBsplineCurve3D elevateOneDegree() {
        JgclBsplineKnot oldKnotData = this.knotData();
        double[][] oldControlPoints = this.toDoubleArray(this.isPolynomial());
        JgclBsplineKnot newKnotData = JgclBsplineCurveEvaluation.getNewKnotDataAtDegreeElevation(oldKnotData);
        double[][] newControlPoints = JgclBsplineCurveEvaluation.getNewControlPointsAtDegreeElevation(oldKnotData, newKnotData, oldControlPoints);
        return new JgclBsplineCurve3D(newKnotData, newControlPoints);
    }

    private JgclBsplineCurve3D elevateDegreeTo(int max_degree) {
        if (this.degree() > max_degree) {
            throw new JgclInvalidArgumentValue();
        }
        JgclBsplineCurve3D old_bsc = this;
        int i = this.degree();
        while (i < max_degree) {
            JgclBsplineCurve3D new_bsc;
            old_bsc = new_bsc = old_bsc.elevateOneDegree();
            ++i;
        }
        return old_bsc;
    }

    public JgclBsplineCurve3D mergeIfContinuous(JgclBsplineCurve3D mate) throws JgclTwoGeomertiesAreNotContinuous {
        boolean isPoly;
        JgclPoint3D tailStart;
        JgclBsplineCurve3D headCurve = this;
        JgclBsplineCurve3D tailCurve = mate;
        JgclParameterSection headSection = headCurve.parameterDomain().section();
        JgclParameterSection tailSection = tailCurve.parameterDomain().section();
        double headEndParameter = headSection.end();
        double tailStartParameter = tailSection.start();
        JgclPoint3D headEnd = headCurve.coordinates(headEndParameter);
        if (!headEnd.identical(tailStart = tailCurve.coordinates(tailStartParameter))) {
            throw new JgclTwoGeomertiesAreNotContinuous();
        }
        boolean headPoly = headCurve.isPolynomial();
        boolean tailPoly = tailCurve.isPolynomial();
        if (headPoly && tailPoly) {
            isPoly = true;
        } else if (headPoly) {
            isPoly = false;
            headCurve = headCurve.toBsplineCurve();
        } else if (tailPoly) {
            isPoly = false;
            tailCurve = tailCurve.toBsplineCurve();
        } else {
            isPoly = false;
        }
        int headDegree = headCurve.degree();
        int tailDegree = tailCurve.degree();
        while (headDegree < tailDegree) {
            headCurve = headCurve.elevateOneDegree();
            ++headDegree;
        }
        while (headDegree > tailDegree) {
            tailCurve = tailCurve.elevateOneDegree();
            ++tailDegree;
        }
        JgclBsplineCurve3D[] dividedCurves = headCurve.divide(headEndParameter);
        headCurve = dividedCurves[0];
        dividedCurves = tailCurve.divide(tailStartParameter);
        tailCurve = dividedCurves[1];
        JgclBsplineKnot headKnotData = headCurve.knotData();
        JgclBsplineKnot tailKnotData = tailCurve.knotData();
        int arrayLength = headKnotData.nKnots() + tailKnotData.nKnots() - 1;
        double[] newKnots = new double[arrayLength];
        int[] newKnotMultiplicities = new int[arrayLength];
        int nNewKnots = 0;
        int j = 0;
        while (j < headKnotData.nKnots()) {
            newKnots[nNewKnots] = headKnotData.knotAt(j);
            newKnotMultiplicities[nNewKnots] = headKnotData.knotMultiplicityAt(j);
            ++nNewKnots;
            ++j;
        }
        newKnotMultiplicities[nNewKnots - 1] = headDegree;
        double offset = headEndParameter - tailStartParameter;
        int j2 = 1;
        while (j2 < tailKnotData.nKnots()) {
            newKnots[nNewKnots] = tailKnotData.knotAt(j2) + offset;
            newKnotMultiplicities[nNewKnots] = tailKnotData.knotMultiplicityAt(j2);
            ++nNewKnots;
            ++j2;
        }
        arrayLength = headKnotData.nControlPoints() + tailKnotData.nControlPoints() - 1;
        JgclPoint3D[] newControlPoints = new JgclPoint3D[arrayLength];
        double[] newWeights = null;
        if (!isPoly) {
            newWeights = new double[arrayLength];
        }
        int nNewControlPoints = 0;
        int j3 = 0;
        while (j3 < headKnotData.nControlPoints()) {
            newControlPoints[nNewControlPoints] = headCurve.controlPointAt(j3);
            if (!isPoly) {
                newWeights[nNewControlPoints] = headCurve.weightAt(j3);
            }
            ++nNewControlPoints;
            ++j3;
        }
        double weightRatio = 0.0;
        if (!isPoly) {
            weightRatio = newWeights[nNewControlPoints - 1] / tailCurve.weightAt(0);
        }
        int j4 = 1;
        while (j4 < tailKnotData.nControlPoints()) {
            newControlPoints[nNewControlPoints] = tailCurve.controlPointAt(j4);
            if (!isPoly) {
                newWeights[nNewControlPoints] = tailCurve.weightAt(j4) * weightRatio;
            }
            ++nNewControlPoints;
            ++j4;
        }
        JgclBsplineCurve3D result = isPoly ? new JgclBsplineCurve3D(headDegree, false, newKnotMultiplicities, newKnots, newControlPoints) : new JgclBsplineCurve3D(headDegree, false, newKnotMultiplicities, newKnots, newControlPoints, newWeights);
        return result;
    }

    private static int getMaxDegree(JgclBsplineCurve3D[] crvs) {
        boolean isClosed = crvs[0].isPeriodic();
        int maxDegree = crvs[0].degree();
        int i = 1;
        while (i < crvs.length) {
            if (isClosed != crvs[i].isPeriodic()) {
                throw new JgclInvalidArgumentValue();
            }
            if (maxDegree < crvs[i].degree()) {
                maxDegree = crvs[i].degree();
            }
            ++i;
        }
        return maxDegree;
    }

    private JgclBsplineCurve3D multipleKnotEndIfOpen() {
        if (this.isPeriodic()) {
            return this;
        }
        return this.truncate(this.parameterDomain().section());
    }

    private JgclBsplineCurve3D singleKnot(JgclParameterSection pint) {
        int n_knots = this.nKnotValues();
        double[] knots = new double[n_knots];
        int[] knotMulti = new int[n_knots];
        double new_lower_limit = pint.start();
        double old_lower_limit = this.parameterDomain().section().start();
        double increase_ratio = pint.increase() / this.parameterDomain().section().increase();
        int i = 0;
        while (i < n_knots) {
            knots[i] = new_lower_limit + (this.knotValueAt(i) - old_lower_limit) * increase_ratio;
            knotMulti[i] = 1;
            ++i;
        }
        JgclBsplineKnot newKnot = new JgclBsplineKnot(this.degree(), this.knotSpec(), this.isPeriodic(), knotMulti, knots, this.nControlPoints(), false);
        return new JgclBsplineCurve3D(newKnot, this.controlPoints, this.weights);
    }

    public static JgclBsplineCurve3D[] identicalKnotSequences(JgclBsplineCurve3D[] crvs, JgclParameterSection pint) {
        if (pint == null) {
            pint = new JgclParameterSection(0.0, 1.0);
        }
        int max_degree = JgclBsplineCurve3D.getMaxDegree(crvs);
        int n_crvs = crvs.length;
        JgclBsplineCurve3D[] new_crvs = new JgclBsplineCurve3D[n_crvs];
        int i = 0;
        while (i < n_crvs) {
            new_crvs[i] = crvs[i].elevateDegreeTo(max_degree).multipleKnotEndIfOpen().singleKnot(pint);
            ++i;
        }
        boolean[] s_xst = new boolean[n_crvs];
        double[] k_val = new double[n_crvs];
        int s_idx = 0;
        int k_idx = max_degree;
        double minimum_knot = 0.0;
        double ptol = crvs[0].getToleranceForParameter();
        while (true) {
            boolean segment_exist = false;
            int ith_crv = 0;
            while (ith_crv < n_crvs) {
                if (s_idx <= new_crvs[ith_crv].nSegments()) {
                    s_xst[ith_crv] = true;
                    k_val[ith_crv] = new_crvs[ith_crv].knotValueAt(k_idx);
                    if (!segment_exist || k_val[ith_crv] < minimum_knot) {
                        segment_exist = true;
                        minimum_knot = k_val[ith_crv];
                    }
                } else {
                    s_xst[ith_crv] = false;
                }
                ++ith_crv;
            }
            if (!segment_exist) break;
            JgclBsplineCurve3D[] new_crvs2 = new JgclBsplineCurve3D[n_crvs];
            ith_crv = 0;
            while (ith_crv < n_crvs) {
                new_crvs2[ith_crv] = !s_xst[ith_crv] || minimum_knot + ptol < k_val[ith_crv] ? new_crvs[ith_crv].insertKnot(minimum_knot) : new_crvs[ith_crv];
                ++ith_crv;
            }
            new_crvs = new_crvs2;
            ++k_idx;
            ++s_idx;
        }
        return new_crvs;
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        int n_pnts = this.nControlPoints();
        JgclPoint3D[] pnts = new JgclPoint3D[n_pnts];
        int i = 0;
        while (i < n_pnts) {
            pnts[i] = this.controlPointAt(i).rotateZ(trns, rCos, rSin);
            ++i;
        }
        JgclBsplineCurve3D result = this.isRational() ? new JgclBsplineCurve3D(this.knotData, pnts, this.weights()) : new JgclBsplineCurve3D(this.knotData, pnts, null);
        return result;
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        JgclVector3D vector;
        JgclPoint3D point;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol2 = condition.getToleranceForDistance2();
        int itry = 0;
        int limit = this.nControlPoints();
        do {
            if (itry >= limit) {
                throw new JgclFatal();
            }
            point = this.controlPointAt(itry);
            vector = point.subtract(line.project1From(point));
            ++itry;
        } while (point.isOn(line) || vector.norm() < dTol2);
        return point;
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D[] tControlPoints = JgclPoint3D.transform(this.controlPoints, reverseTransform, transformationOperator, transformedGeometries);
        return new JgclBsplineCurve3D(this.knotData, tControlPoints, this.weights);
    }

    public JgclBsplineSurface3D tabcylSurface(JgclBsplineCurve3D mate) {
        JgclTabcylSurface3D doObj = new JgclTabcylSurface3D(this, mate);
        return doObj.getSurface();
    }

    public JgclBsplineSurface3D loftSurface(JgclVector3D vector, double length) {
        JgclLoftSurface3D doObj = new JgclLoftSurface3D(this, vector, length);
        return doObj.getSurface();
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        StringBuffer buf = new StringBuffer();
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        this.knotData.output(writer, indent, 0);
        writer.println(String.valueOf(indent_tab) + "\tcontrolPoints");
        int i = 0;
        while (i < this.nControlPoints()) {
            this.controlPointAt(i).output(writer, indent + 2);
            ++i;
        }
        if (this.weights() != null) {
            writer.println(String.valueOf(indent_tab) + "\tweights ");
            int i2 = 0;
            while (true) {
                int j = 0;
                while (j < 10 && i2 < this.weights().length) {
                    writer.print(" " + this.weightAt(i2));
                    ++j;
                    ++i2;
                }
                writer.println();
                if (i2 >= this.weights().length) break;
                writer.print(String.valueOf(indent_tab) + "\t");
            }
        }
        writer.println(String.valueOf(indent_tab) + "\tcurveForm\t" + JgclBsplineCurveForm.toString(this.curveForm));
        writer.println(String.valueOf(indent_tab) + "End");
    }

    private final class 1
    implements JgclRealFunctionWithOneVariable {
        public double evaluate(double parameter) {
            return JgclBsplineCurve3D.this.tangentVector(parameter).length();
        }

        /* synthetic */ 1() {
        }
    }

    private static final class 2
    implements JgclRealFunctionWithOneVariable {
        private final /* synthetic */ JgclRealPolynomial[] val$deriv;

        public double evaluate(double parameter) {
            double[] tang = new double[3];
            int klm = 0;
            while (klm < 3) {
                tang[klm] = this.val$deriv[klm].evaluate(parameter);
                ++klm;
            }
            return Math.sqrt(tang[0] * tang[0] + tang[1] * tang[1] + tang[2] * tang[2]);
        }

        /* synthetic */ 2(JgclRealPolynomial[] val$deriv) {
            this.val$deriv = val$deriv;
        }
    }

    private class segmentInfo {
        private double lp;
        private double up;
        private double dp;
        private JgclPoint3D[] pnts;

        private segmentInfo(double lp, double up) {
            JgclBsplineCurve3D.this = JgclBsplineCurve3D.this;
            this.lp = lp;
            this.up = up;
            this.dp = up - lp;
        }

        private void pnts(JgclPoint3D[] pnts) {
            this.pnts = pnts;
        }

        private double lp() {
            return this.lp;
        }

        private double up() {
            return this.up;
        }

        private double dp() {
            return this.dp;
        }

        private int nPnts() {
            if (this.pnts == null) {
                return 0;
            }
            return this.pnts.length;
        }

        private JgclPoint3D pnts(int n) {
            return this.pnts[n];
        }
    }
}

