/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclApproximation2D;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBoundedLine2D;
import jp.go.ipa.jgcl.JgclBsplineCurveEvaluation;
import jp.go.ipa.jgcl.JgclBsplineCurveForm;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclComplexPolynomial;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFreeformCurveWithControlPoints2D;
import jp.go.ipa.jgcl.JgclHomogeneousPoint2D;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclInterpolation2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntsBscBsc2D;
import jp.go.ipa.jgcl.JgclIntsBzcBsc2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclOfst2D;
import jp.go.ipa.jgcl.JgclOpenCurve;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPointOnGeometryList;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclRealFunctionWithOneVariable;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclTwoGeomertiesAreNotContinuous;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclZeroLength;

public class JgclBsplineCurve2D
extends JgclFreeformCurveWithControlPoints2D {
    private JgclBsplineKnot knotData;
    private int curveForm = 5;

    public JgclBsplineCurve2D(int degree, boolean periodic, int[] knotMultiplicities, double[] knots, JgclPoint2D[] controlPoints) {
        super(controlPoints);
        this.knotData = new JgclBsplineKnot(degree, 1, periodic, knotMultiplicities, knots, this.nControlPoints());
    }

    public JgclBsplineCurve2D(int degree, int[] knotMultiplicities, double[] knots, JgclPoint2D[] controlPoints) {
        super(controlPoints);
        this.knotData = new JgclBsplineKnot(degree, 1, false, knotMultiplicities, knots, this.nControlPoints());
    }

    public JgclBsplineCurve2D(int degree, boolean periodic, int[] knotMultiplicities, double[] knots, JgclPoint2D[] controlPoints, double[] weights) {
        super(controlPoints, weights);
        this.knotData = new JgclBsplineKnot(degree, 1, periodic, knotMultiplicities, knots, this.nControlPoints());
    }

    public JgclBsplineCurve2D(int degree, int[] knotMultiplicities, double[] knots, JgclPoint2D[] controlPoints, double[] weights) {
        super(controlPoints, weights);
        this.knotData = new JgclBsplineKnot(degree, 1, false, knotMultiplicities, knots, this.nControlPoints());
    }

    public JgclBsplineCurve2D(int degree, boolean periodic, int knotSpec, JgclPoint2D[] controlPoints) {
        super(controlPoints);
        this.knotData = new JgclBsplineKnot(degree, knotSpec, periodic, null, null, this.nControlPoints());
    }

    public JgclBsplineCurve2D(int degree, int knotSpec, JgclPoint2D[] controlPoints) {
        super(controlPoints);
        this.knotData = new JgclBsplineKnot(degree, knotSpec, false, null, null, this.nControlPoints());
    }

    public JgclBsplineCurve2D(int degree, boolean periodic, int knotSpec, JgclPoint2D[] controlPoints, double[] weights) {
        super(controlPoints, weights);
        this.knotData = new JgclBsplineKnot(degree, knotSpec, periodic, null, null, this.nControlPoints());
    }

    public JgclBsplineCurve2D(int degree, int knotSpec, JgclPoint2D[] controlPoints, double[] weights) {
        super(controlPoints, weights);
        this.knotData = new JgclBsplineKnot(degree, knotSpec, false, null, null, this.nControlPoints());
    }

    JgclBsplineCurve2D(JgclBsplineKnot knotData, double[][] cpArray) {
        super(cpArray);
        if (knotData.nControlPoints() != this.nControlPoints()) {
            throw new JgclInvalidArgumentValue();
        }
        this.knotData = knotData;
    }

    JgclBsplineCurve2D(JgclBsplineKnot knotData, JgclPoint2D[] controlPoints, double[] weights) {
        super(controlPoints, weights, false);
        this.knotData = knotData;
    }

    public JgclBsplineCurve2D(JgclPoint2D[] points, double[] params) {
        JgclInterpolation2D doObj = new JgclInterpolation2D(points, params);
        this.controlPoints = doObj.controlPoints();
        this.knotData = doObj.knotData();
        this.weights = doObj.weights();
    }

    public JgclBsplineCurve2D(JgclPoint2D[] points, double[] params, JgclVector2D[] endvecs) {
        JgclInterpolation2D doObj = new JgclInterpolation2D(points, params, endvecs);
        this.controlPoints = doObj.controlPoints();
        this.knotData = doObj.knotData();
        this.weights = doObj.weights();
    }

    public JgclBsplineCurve2D(JgclPoint2D[] points, double[] params, JgclVector2D[] endvecs, boolean isClosed) {
        JgclInterpolation2D doObj = new JgclInterpolation2D(points, params, endvecs, isClosed);
        this.controlPoints = doObj.controlPoints();
        this.knotData = doObj.knotData();
        this.weights = doObj.weights();
    }

    public JgclBsplineCurve2D(JgclPoint2D[] points, double[] params, JgclVector2D[] endDir, boolean isClosed, JgclToleranceForDistance tol, JgclToleranceForDistance midTol) {
        JgclApproximation2D doObj = new JgclApproximation2D(points, params, endDir, isClosed);
        JgclBsplineCurve2D bsc = doObj.getApproximationWithTolerance(tol, midTol);
        this.controlPoints = bsc.controlPoints;
        this.knotData = bsc.knotData;
        this.weights = bsc.weights;
    }

    public int degree() {
        return this.knotData.degree();
    }

    public int knotSpec() {
        return this.knotData.knotSpec();
    }

    public int nKnotValues() {
        return this.knotData.nKnotValues();
    }

    public double knotValueAt(int n) {
        return this.knotData.knotValueAt(n);
    }

    int nSegments() {
        return this.knotData.nSegments();
    }

    JgclBsplineKnot.ValidSegmentInfo validSegments() {
        return this.knotData.validSegments();
    }

    JgclBsplineKnot knotData() {
        return this.knotData;
    }

    public boolean isPeriodic() {
        return this.knotData.isPeriodic();
    }

    public JgclPoint2D controlPointAt(int n) {
        if (this.isPeriodic()) {
            int ncp = this.nControlPoints();
            while (n < 0) {
                n += ncp;
            }
            while (n >= ncp) {
                n -= ncp;
            }
        }
        return this.controlPoints[n];
    }

    private void make_coef(double[] coef, int jjj, int seg, double pTol) {
        int degree = coef.length - 3;
        if (degree == 0) {
            coef[1] = jjj == seg ? 1.0 : 0.0;
        } else {
            double aaa;
            double kj;
            double[] coef_1 = new double[degree + 2];
            int ijk = 0;
            while (ijk <= degree) {
                coef[ijk + 1] = 0.0;
                ++ijk;
            }
            coef_1[degree + 1] = 0.0;
            coef_1[0] = 0.0;
            if (jjj != seg - degree) {
                kj = this.knotValueAt(jjj);
                aaa = this.knotValueAt(jjj + degree) - kj;
                if (aaa > pTol) {
                    this.make_coef(coef_1, jjj, seg, pTol);
                    ijk = 0;
                    while (ijk <= degree) {
                        int n = ijk + 1;
                        coef[n] = coef[n] + (coef_1[ijk + 1] - coef_1[ijk] * kj) / aaa;
                        ++ijk;
                    }
                }
            }
            if (jjj != seg && (aaa = (kj = this.knotValueAt(jjj + degree + 1)) - this.knotValueAt(jjj + 1)) > pTol) {
                this.make_coef(coef_1, jjj + 1, seg, pTol);
                ijk = 0;
                while (ijk <= degree) {
                    int n = ijk + 1;
                    coef[n] = coef[n] - (coef_1[ijk + 1] - coef_1[ijk] * kj) / aaa;
                    ++ijk;
                }
            }
        }
    }

    public JgclRealPolynomial[] polynomial(int iSseg, boolean isPoly) {
        int klm;
        int ijk;
        int degree = this.degree();
        int isckt = iSseg;
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        int uicp = this.nControlPoints();
        int dim = cntlPnts[0].length;
        double[][] coef = new double[dim][];
        int i = 0;
        while (i < dim) {
            coef[i] = new double[degree + 1];
            ++i;
        }
        double[] eA = new double[degree + 3];
        double pTol = this.getToleranceForParameter();
        JgclRealPolynomial[] polynomial = new JgclRealPolynomial[dim];
        i = 0;
        while (i < dim) {
            ijk = 0;
            while (ijk <= degree) {
                coef[i][ijk] = 0.0;
                ++ijk;
            }
            ++i;
        }
        ijk = 0;
        int pklm = klm = isckt;
        while (ijk <= degree) {
            this.make_coef(eA, klm, isckt + degree, pTol);
            if (this.isPeriodic() && pklm == uicp) {
                pklm = 0;
            }
            i = 0;
            while (i < dim) {
                int mno = 0;
                while (mno <= degree) {
                    double[] dArray = coef[i];
                    int n = degree - mno;
                    dArray[n] = dArray[n] + eA[mno + 1] * cntlPnts[pklm][i];
                    ++mno;
                }
                ++i;
            }
            ++ijk;
            ++pklm;
            ++klm;
        }
        i = 0;
        while (i < dim) {
            polynomial[i] = new JgclRealPolynomial(coef[i]);
            ++i;
        }
        return polynomial;
    }

    public double length(JgclParameterSection pint) {
        double length = 0.0;
        double dTol = this.getToleranceForDistance() / 2.0;
        double pTol = this.getToleranceForParameter();
        if (!this.isPolynomial() || Math.abs(pint.increase()) <= pTol) {
            1 realFunction = new 1();
            length = JgclMath.getDefiniteIntegral(realFunction, pint, dTol);
        } else {
            JgclBsplineCurve2D tbsc = this.truncate(pint);
            JgclBsplineKnot.ValidSegmentInfo vsegInfo = tbsc.knotData.validSegments();
            int nvseg = vsegInfo.nSegments();
            int ijk = 0;
            while (ijk < nvseg) {
                JgclRealPolynomial[] poly = tbsc.polynomial(ijk, this.isPolynomial());
                JgclRealPolynomial[] deriv = new JgclRealPolynomial[poly.length];
                int klm = 0;
                while (klm < poly.length) {
                    deriv[klm] = poly[klm].derive();
                    ++klm;
                }
                2 realFunction = new 2(deriv);
                JgclParameterSection psec = new JgclParameterSection(vsegInfo.knotPoint(ijk)[0], vsegInfo.knotPoint(ijk)[1]);
                length += JgclMath.getDefiniteIntegral(realFunction, psec, dTol);
                ++ijk;
            }
        }
        return length;
    }

    public JgclPoint2D coordinates(double param) {
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        double[] d0D = JgclBsplineCurveEvaluation.coordinates(this.knotData, cntlPnts, param);
        if (!isPoly) {
            this.convRational0Deriv(d0D);
        }
        return new JgclCartesianPoint2D(d0D[0], d0D[1]);
    }

    public JgclVector2D tangentVector(double param) {
        double[] d1D = new double[3];
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        if (isPoly) {
            JgclBsplineCurveEvaluation.evaluation(this.knotData, cntlPnts, param, null, d1D, null, null);
        } else {
            double[] d0D = new double[3];
            JgclBsplineCurveEvaluation.evaluation(this.knotData, cntlPnts, param, d0D, d1D, null, null);
            this.convRational1Deriv(d0D, d1D);
        }
        return new JgclLiteralVector2D(d1D[0], d1D[1]);
    }

    public JgclCurveCurvature2D curvature(double param) {
        JgclVector2D dDnrm;
        double dDcrv;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double tol_d = condition.getToleranceForDistance();
        int degree = this.degree();
        JgclCurveDerivative2D deriv = this.evaluation(param);
        double tang_leng = deriv.d1D().norm();
        boolean tang0 = tang_leng < tol_d * tol_d;
        if (degree < 2 || tang0) {
            dDcrv = 0.0;
            dDnrm = JgclVector2D.zeroVector;
        } else {
            tang_leng = Math.sqrt(tang_leng);
            dDcrv = tang_leng * tang_leng * tang_leng;
            double ewvec = deriv.d1D().zOfCrossProduct(deriv.d2D());
            dDcrv = Math.abs(ewvec) / dDcrv;
            dDnrm = ewvec < 0.0 ? new JgclLiteralVector2D(deriv.d1D().y(), -deriv.d1D().x()) : new JgclLiteralVector2D(-deriv.d1D().y(), deriv.d1D().x());
            dDnrm = dDnrm.unitized();
        }
        return new JgclCurveCurvature2D(dDcrv, dDnrm);
    }

    public JgclCurveDerivative2D evaluation(double param) {
        double[] ld0D = new double[3];
        double[] ld1D = new double[3];
        double[] ld2D = new double[3];
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        JgclBsplineCurveEvaluation.evaluation(this.knotData, cntlPnts, param, ld0D, ld1D, ld2D, null);
        if (!isPoly) {
            this.convRational2Deriv(ld0D, ld1D, ld2D);
        }
        JgclCartesianPoint2D d0D = new JgclCartesianPoint2D(ld0D[0], ld0D[1]);
        JgclLiteralVector2D d1D = new JgclLiteralVector2D(ld1D[0], ld1D[1]);
        JgclLiteralVector2D d2D = new JgclLiteralVector2D(ld2D[0], ld2D[1]);
        return new JgclCurveDerivative2D(d0D, d1D, d2D);
    }

    public JgclPoint2D blossoming(int segNumber, double[] parameters) {
        double[] adjustedParameters = new double[this.degree()];
        int i = 0;
        while (i < this.degree()) {
            adjustedParameters[i] = this.checkParameter(parameters[i]);
            ++i;
        }
        boolean isPoly = this.isPolynomial();
        double[] d0D = JgclBsplineCurveEvaluation.blossoming(this.knotData, this.toDoubleArray(isPoly), segNumber, adjustedParameters);
        if (!isPoly) {
            this.convRational0Deriv(d0D);
        }
        if (isPoly) {
            return new JgclCartesianPoint2D(d0D[0], d0D[1]);
        }
        return new JgclHomogeneousPoint2D(d0D[0], d0D[1], d0D[2]);
    }

    private void checkEndPoint(double minParam, double maxParam, int minDegree, int seg, int nvseg, Vector paramVec) {
        if (this.degree() < minDegree) {
            if (this.isClosed() && paramVec.size() == 0) {
                paramVec.addElement(new Double(minParam));
            }
            if (seg != nvseg - 1) {
                int mno = 0;
                while (mno < paramVec.size()) {
                    if (this.identicalParameter((Double)paramVec.elementAt(mno), maxParam)) break;
                    ++mno;
                }
                if (mno == paramVec.size()) {
                    paramVec.addElement(new Double(maxParam));
                }
            }
        }
    }

    public JgclPointOnCurve2D[] singular() {
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = this.knotData.validSegments();
        int nvseg = vsegInfo.nSegments();
        int numseg = this.nSegments();
        JgclPureBezierCurve2D[] bzcs = this.toPureBezierCurveArray();
        int minDegree = 2;
        Vector<Double> snglrParam = new Vector<Double>();
        int ijk = 0;
        while (ijk < numseg) {
            block9: {
                double maxParam;
                double minParam;
                int klm = vsegInfo.isValidSegment(ijk);
                if (klm < 0) {
                    minParam = this.knotValueAt(this.degree() + ijk);
                    maxParam = this.knotValueAt(this.degree() + ijk + 1);
                    this.checkEndPoint(minParam, maxParam, minDegree, ijk, nvseg, snglrParam);
                } else {
                    JgclPointOnCurve2D[] singularOnBzc;
                    minParam = vsegInfo.knotPoint(klm)[0];
                    maxParam = vsegInfo.knotPoint(klm)[1];
                    this.checkEndPoint(minParam, maxParam, minDegree, klm, nvseg, snglrParam);
                    try {
                        singularOnBzc = bzcs[klm].singular();
                    }
                    catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                        break block9;
                    }
                    klm = 0;
                    while (klm < singularOnBzc.length) {
                        double candidateParam = (maxParam - minParam) * singularOnBzc[klm].parameter() + minParam;
                        int mno = 0;
                        while (mno < snglrParam.size()) {
                            if (this.identicalParameter((Double)snglrParam.elementAt(mno), candidateParam)) break;
                            ++mno;
                        }
                        if (mno == snglrParam.size()) {
                            snglrParam.addElement(new Double(candidateParam));
                        }
                        ++klm;
                    }
                }
            }
            ++ijk;
        }
        int numberOfSolution = snglrParam.size();
        JgclPointOnCurve2D[] singular = new JgclPointOnCurve2D[numberOfSolution];
        ijk = 0;
        while (ijk < numberOfSolution) {
            singular[ijk] = new JgclPointOnCurve2D(this, (Double)snglrParam.elementAt(ijk), false);
            ++ijk;
        }
        return singular;
    }

    public JgclPointOnCurve2D[] inflexion() {
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = this.knotData.validSegments();
        int nvseg = vsegInfo.nSegments();
        int numseg = this.nSegments();
        JgclPureBezierCurve2D[] bzcs = this.toPureBezierCurveArray();
        int minDegree = 3;
        Vector<Double> inflxParam = new Vector<Double>();
        int ijk = 0;
        while (ijk < numseg) {
            block9: {
                double maxParam;
                double minParam;
                int klm = vsegInfo.isValidSegment(ijk);
                if (klm < 0) {
                    minParam = this.knotValueAt(this.degree() + ijk);
                    maxParam = this.knotValueAt(this.degree() + ijk + 1);
                    this.checkEndPoint(minParam, maxParam, minDegree, ijk, nvseg, inflxParam);
                } else {
                    JgclPointOnCurve2D[] inflexionOnBzc;
                    minParam = vsegInfo.knotPoint(klm)[0];
                    maxParam = vsegInfo.knotPoint(klm)[1];
                    this.checkEndPoint(minParam, maxParam, minDegree, klm, nvseg, inflxParam);
                    try {
                        inflexionOnBzc = bzcs[klm].inflexion();
                    }
                    catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                        break block9;
                    }
                    klm = 0;
                    while (klm < inflexionOnBzc.length) {
                        double candidateParam = (maxParam - minParam) * inflexionOnBzc[klm].parameter() + minParam;
                        int mno = 0;
                        while (mno < inflxParam.size()) {
                            if (this.identicalParameter((Double)inflxParam.elementAt(mno), candidateParam)) break;
                            ++mno;
                        }
                        if (mno == inflxParam.size()) {
                            inflxParam.addElement(new Double(candidateParam));
                        }
                        ++klm;
                    }
                }
            }
            ++ijk;
        }
        int numberOfSolution = inflxParam.size();
        JgclPointOnCurve2D[] inflexion = new JgclPointOnCurve2D[numberOfSolution];
        ijk = 0;
        while (ijk < numberOfSolution) {
            inflexion[ijk] = new JgclPointOnCurve2D(this, (Double)inflxParam.elementAt(ijk), false);
            ++ijk;
        }
        return inflexion;
    }

    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D mate) {
        int dimension = 2;
        int coef_size = this.isPolynomial() ? dimension : dimension + 1;
        JgclRealPolynomial[] offsPoly = new JgclRealPolynomial[dimension];
        JgclRealPolynomial[] tangPoly = new JgclRealPolynomial[coef_size];
        JgclRealPolynomial[] dotePoly = new JgclRealPolynomial[dimension];
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = this.knotData.validSegments();
        JgclPointOnGeometryList projList = new JgclPointOnGeometryList();
        double dTol = this.getToleranceForDistance();
        int ijk = 0;
        while (ijk < vsegInfo.nSegments()) {
            JgclComplex[] root;
            JgclComplexPolynomial dtPoly;
            JgclRealPolynomial[] pointPoly = this.polynomial(vsegInfo.segmentNumber(ijk), this.isPolynomial());
            if (this.isRational()) {
                offsPoly[0] = pointPoly[dimension].multiply(mate.x());
                offsPoly[1] = pointPoly[dimension].multiply(mate.y());
            } else {
                double[][] coef = new double[][]{{mate.x()}, {mate.y()}};
                offsPoly[0] = new JgclRealPolynomial(coef[0]);
                offsPoly[1] = new JgclRealPolynomial(coef[1]);
            }
            int i = 0;
            while (i < dimension) {
                pointPoly[i] = pointPoly[i].subtract(offsPoly[i]);
                ++i;
            }
            int klm = 0;
            while (klm < coef_size) {
                tangPoly[klm] = pointPoly[klm].derive();
                ++klm;
            }
            if (!this.isRational()) {
                klm = 0;
                while (klm < dimension) {
                    dotePoly[klm] = pointPoly[klm].multiply(tangPoly[klm]);
                    ++klm;
                }
            } else {
                klm = 0;
                while (klm < 2) {
                    JgclRealPolynomial work0 = pointPoly[2].multiply(tangPoly[klm]);
                    JgclRealPolynomial work1 = tangPoly[2].multiply(pointPoly[klm]);
                    JgclRealPolynomial work2 = work0.subtract(work1);
                    double[] work3 = work2.coefficientsBetween(0, work2.degree() - 1);
                    JgclRealPolynomial sub = new JgclRealPolynomial(work3);
                    dotePoly[klm] = pointPoly[klm].multiply(sub);
                    ++klm;
                }
            }
            try {
                dtPoly = dotePoly[0].add(dotePoly[1]).toComplexPolynomial();
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            try {
                root = dtPoly.getRootsByDKA();
            }
            catch (JgclComplexPolynomial.DKANotConverge e) {
                root = e.getValues();
            }
            catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
                throw new JgclFatal();
            }
            catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
                throw new JgclFatal();
            }
            double[] intv = vsegInfo.knotPoint(ijk);
            JgclParameterDomain domain = new JgclParameterDomain(false, intv[0], intv[1] - intv[0]);
            int mno = 0;
            while (mno < root.length) {
                JgclPointOnCurve2D proj;
                double par = root[mno].real();
                if (domain.isValid(par) && (proj = this.checkProjection(par = domain.force(par), mate, dTol * dTol)) != null) {
                    projList.addPoint(proj);
                }
                ++mno;
            }
            ++ijk;
        }
        return projList.toJgclPointOnCurve2DArray();
    }

    public JgclBsplineCurve2D toBsplineCurve() {
        if (this.isRational()) {
            return this;
        }
        return new JgclBsplineCurve2D(this.knotData, this.controlPoints, this.makeUniformWeights());
    }

    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
        JgclBsplineCurve2D target;
        if (this.isPeriodic()) {
            if (pint.absIncrease() >= this.parameterDomain().section().absIncrease()) {
                target = this;
                try {
                    target = target.shiftIfPeriodic(pint.start());
                }
                catch (JgclOpenCurve jgclOpenCurve) {}
                if (pint.increase() < 0.0) {
                    target = target.reverse();
                }
            } else {
                target = this.truncate(pint);
            }
        } else {
            target = this.truncate(pint);
        }
        return target.toBsplineCurve();
    }

    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
        return mate.intersect(this, true);
    }

    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = this.knotData.validSegments();
        JgclAxis2Placement2D placement = new JgclAxis2Placement2D(mate.pnt(), mate.dir());
        JgclCartesianTransformationOperator2D transform = new JgclCartesianTransformationOperator2D(placement, 1.0);
        int uicp = this.nControlPoints();
        JgclPoint2D[] newCp = new JgclPoint2D[uicp];
        int i = 0;
        while (i < uicp) {
            newCp[i] = transform.toLocal(this.controlPointAt(i));
            ++i;
        }
        double[] weights = this.weights();
        if (this.isRational()) {
            double max_weight = 0.0;
            int i2 = 0;
            while (i2 < uicp) {
                if (Math.abs(weights[i2]) > max_weight) {
                    max_weight = weights[i2];
                }
                ++i2;
            }
            if (max_weight > 0.0) {
                int i3 = 0;
                while (i3 < uicp) {
                    int n = i3++;
                    weights[n] = weights[n] / max_weight;
                }
            }
        }
        JgclBsplineCurve2D bsc = new JgclBsplineCurve2D(this.knotData, newCp, weights);
        Vector<Double> lineParam = new Vector<Double>();
        Vector<Double> bscParam = new Vector<Double>();
        int nSeg = vsegInfo.nSegments();
        int k = 0;
        int i4 = 0;
        while (i4 < nSeg) {
            JgclComplex[] roots;
            JgclRealPolynomial[] realPoly = bsc.polynomial(vsegInfo.segmentNumber(i4), this.isPolynomial());
            JgclComplexPolynomial compPoly = realPoly[1].toComplexPolynomial();
            try {
                roots = compPoly.getRootsByDKA();
            }
            catch (JgclComplexPolynomial.DKANotConverge e) {
                roots = e.getValues();
            }
            catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
                throw new JgclFatal();
            }
            catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
                throw new JgclFatal();
            }
            int nRoots = roots.length;
            int j = 0;
            while (j < nRoots) {
                double realRoot = roots[j].real();
                if (bsc.parameterValidity(realRoot) != 3) {
                    double[] knotParams = vsegInfo.knotPoint(i4);
                    if (realRoot < knotParams[0]) {
                        realRoot = knotParams[0];
                    }
                    if (realRoot > knotParams[1]) {
                        realRoot = knotParams[1];
                    }
                    JgclPoint2D workPoint = bsc.coordinates(realRoot);
                    double dTol = bsc.getToleranceForDistance();
                    if (Math.abs(workPoint.y()) < dTol) {
                        int jj = 0;
                        while (jj < k) {
                            double paramA = (Double)lineParam.elementAt(jj);
                            double paramB = (Double)bscParam.elementAt(jj);
                            if (Math.abs(paramA - workPoint.x()) < dTol && bsc.identicalParameter(paramA, paramB)) break;
                            ++jj;
                        }
                        if (jj >= k) {
                            lineParam.addElement(new Double(workPoint.x()));
                            bscParam.addElement(new Double(realRoot));
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i4;
        }
        int num = bscParam.size();
        JgclIntersectionPoint2D[] intersectPoint = new JgclIntersectionPoint2D[num];
        double mateLength = mate.dir().length();
        int i5 = 0;
        while (i5 < k) {
            double work = (Double)lineParam.elementAt(i5) / mateLength;
            JgclPointOnCurve2D pointOnLine = new JgclPointOnCurve2D(mate, work, false);
            work = (Double)bscParam.elementAt(i5);
            JgclPointOnCurve2D pointOnBsc = new JgclPointOnCurve2D(this, work, false);
            JgclPoint2D coordinates = this.coordinates(work);
            intersectPoint[i5] = !doExchange ? new JgclIntersectionPoint2D(coordinates, pointOnBsc, pointOnLine, false) : new JgclIntersectionPoint2D(coordinates, pointOnLine, pointOnBsc, false);
            ++i5;
        }
        return intersectPoint;
    }

    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
        return JgclIntsBzcBsc2D.intersection(mate, this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
        return JgclIntsBscBsc2D.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
        return mate.interfere(this, true);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate, boolean doExchange) {
        return JgclIntsBzcBsc2D.interference(mate, this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate, boolean doExchange) {
        return JgclIntsBscBsc2D.interference(this, mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst2D doObj = new JgclOfst2D(this, pint, magni, side, tol);
        return doObj.offset();
    }

    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclBsplineCurve2D insertKnot(double param) {
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        Object[] result = JgclBsplineCurveEvaluation.insertKnot(this.knotData, cntlPnts, param);
        JgclBsplineKnot newKnotData = (JgclBsplineKnot)result[0];
        double[][] newControlPoints = (double[][])result[1];
        return new JgclBsplineCurve2D(newKnotData, newControlPoints);
    }

    public JgclBsplineCurve2D[] divide(double param) {
        boolean isPoly = this.isPolynomial();
        JgclBsplineKnot[] newKnotData = new JgclBsplineKnot[2];
        double[][][] newControlPoints = new double[2][][];
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        JgclBsplineCurveEvaluation.divide(this.knotData, cntlPnts, param, newKnotData, newControlPoints);
        if (newKnotData[0] == null) {
            throw new JgclFatal();
        }
        int n_bsc = newKnotData[1] == null ? 1 : 2;
        JgclBsplineCurve2D[] bsc = new JgclBsplineCurve2D[n_bsc];
        int i = 0;
        while (i < n_bsc) {
            try {
                bsc[i] = new JgclBsplineCurve2D(newKnotData[i], newControlPoints[i]);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return bsc;
    }

    public JgclBsplineCurve2D truncate(JgclParameterSection section) {
        JgclBsplineCurve2D t_bsc;
        if (Math.abs(section.increase()) <= this.getToleranceForParameter()) {
            throw new JgclInvalidArgumentValue();
        }
        if (this.isNonPeriodic()) {
            double start_par = this.checkParameter(section.lower());
            double end_par = this.checkParameter(section.upper());
            t_bsc = this.divide(start_par)[1];
            t_bsc = t_bsc.divide(end_par - start_par)[0];
        } else {
            double crv_intvl = this.parameterDomain().section().increase();
            double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();
            double start_par = this.checkParameter(section.start());
            t_bsc = this.divide(start_par)[0];
            if (Math.abs(section.increase()) < crv_intvl - tol_p) {
                if (section.increase() > 0.0) {
                    double end_par = section.increase();
                    t_bsc = t_bsc.divide(end_par)[0];
                } else {
                    double end_par = crv_intvl + section.increase();
                    t_bsc = t_bsc.divide(end_par)[1];
                }
            }
        }
        if (section.increase() < 0.0) {
            t_bsc = t_bsc.reverse();
        }
        return t_bsc;
    }

    public JgclBsplineCurve2D shiftIfPeriodic(double newStartParam) throws JgclOpenCurve {
        if (!this.isPeriodic()) {
            throw new JgclOpenCurve();
        }
        newStartParam = this.parameterDomain().wrap(newStartParam);
        int newFirstSegment = this.knotData().getSegmentNumberThatStartIsEqualTo(newStartParam);
        if (newFirstSegment == -1) {
            return this.insertKnot(newStartParam).shiftIfPeriodic(newStartParam);
        }
        JgclBsplineKnot newKnotData = this.knotData().shift(newFirstSegment);
        int nNewControlPoints = newKnotData.nControlPoints();
        JgclPoint2D[] newControlPoints = new JgclPoint2D[nNewControlPoints];
        int i = 0;
        while (i < nNewControlPoints) {
            newControlPoints[i] = this.controlPointAt((i + newFirstSegment) % nNewControlPoints);
            ++i;
        }
        double[] newWeights = null;
        if (this.isRational()) {
            newWeights = new double[nNewControlPoints];
            int i2 = 0;
            while (i2 < nNewControlPoints) {
                newWeights[i2] = this.weightAt((i2 + newFirstSegment) % nNewControlPoints);
                ++i2;
            }
        }
        return new JgclBsplineCurve2D(newKnotData, newControlPoints, newWeights);
    }

    public JgclPolyline2D toPolyline(JgclParameterSection section, JgclToleranceForDistance tolerance) {
        double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        JgclBsplineKnot.ValidSegmentInfo vseg_info = this.knotData.validSegments();
        int nseg = vseg_info.nSegments();
        double lower_limit = vseg_info.knotPoint(0)[0];
        double upper_limit = vseg_info.knotPoint(nseg - 1)[1];
        if (this.isPeriodic()) {
            double par_intvl = upper_limit - lower_limit;
            double my_sp = this.checkParameter(section.start());
            JgclBsplineCurve2D o_bsc = this.divide(my_sp)[0];
            my_sp = section.increase() > 0.0 ? lower_limit : upper_limit;
            JgclParameterSection lpint = new JgclParameterSection(my_sp, section.increase());
            JgclPolyline2D lpol = o_bsc.toPolyline(lpint, tolerance);
            int npnts = lpol.nPoints();
            JgclPoint2D[] pnts = new JgclPoint2D[npnts];
            int i = 0;
            while (i < npnts) {
                JgclPointOnCurve2D lpnt = (JgclPointOnCurve2D)lpol.pointAt(i);
                JgclCartesianPoint2D pnt = new JgclCartesianPoint2D(lpnt.x(), lpnt.y());
                double param = lpnt.parameter() + section.start();
                if (param > upper_limit) {
                    param -= upper_limit;
                }
                pnts[i] = new JgclPointOnCurve2D(pnt, this, param, false);
                ++i;
            }
            return new JgclPolyline2D(pnts);
        }
        double my_sp = this.checkParameter(section.lower());
        double my_ep = this.checkParameter(section.upper());
        int my_sseg = vseg_info.segmentIndex(my_sp);
        int my_eseg = vseg_info.segmentIndex(my_ep);
        JgclPureBezierCurve2D[] bzcs = this.toPureBezierCurveArray();
        int no_total_pnts = 0;
        SegmentInfo[] seg_infos = new SegmentInfo[nseg];
        int i = my_sseg;
        while (i <= my_eseg) {
            block12: {
                JgclPolyline2D lpol;
                double d;
                double[] kp = vseg_info.knotPoint(i);
                seg_infos[i] = new SegmentInfo(kp[0], kp[1]);
                double bzc_sp = i == my_sseg ? (my_sp - seg_infos[i].lp()) / seg_infos[i].dp() : 0.0;
                double bzc_ep = i == my_eseg ? (my_ep - seg_infos[i].lp()) / seg_infos[i].dp() : 1.0;
                double bzc_ip = bzc_ep - bzc_sp;
                if (d < tol_p) {
                    my_eseg = i - 1;
                    break;
                }
                JgclParameterSection lpint = new JgclParameterSection(bzc_sp, bzc_ip);
                try {
                    lpol = bzcs[i].toPolyline(lpint, tolerance);
                }
                catch (JgclZeroLength jgclZeroLength) {
                    break block12;
                }
                seg_infos[i].pnts(lpol.points());
                no_total_pnts += seg_infos[i].nPnts();
                if (i > my_sseg) {
                    --no_total_pnts;
                }
            }
            ++i;
        }
        if (no_total_pnts < 2) {
            throw new JgclZeroLength();
        }
        JgclPoint2D[] pnts = new JgclPoint2D[no_total_pnts];
        boolean first = true;
        i = my_sseg;
        int m = 0;
        while (i <= my_eseg) {
            int j = first ? 0 : 1;
            while (j < seg_infos[i].nPnts()) {
                JgclPointOnCurve2D lpnt = (JgclPointOnCurve2D)seg_infos[i].pnts(j);
                JgclCartesianPoint2D pnt = new JgclCartesianPoint2D(lpnt.x(), lpnt.y());
                double param = seg_infos[i].lp() + seg_infos[i].dp() * lpnt.parameter();
                pnts[m] = new JgclPointOnCurve2D(pnt, this, param, false);
                first = false;
                ++j;
                ++m;
            }
            ++i;
        }
        if (section.increase() > 0.0) {
            return new JgclPolyline2D(pnts);
        }
        return new JgclPolyline2D(pnts).reverse();
    }

    public JgclPureBezierCurve2D[] toPureBezierCurveArray() {
        boolean isPoly = this.isPolynomial();
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        double[][][] bzc_array = JgclBsplineCurveEvaluation.toBezierCurve(this.knotData, cntlPnts);
        JgclPureBezierCurve2D[] bzcs = new JgclPureBezierCurve2D[bzc_array.length];
        int i = 0;
        while (i < bzc_array.length) {
            try {
                bzcs[i] = new JgclPureBezierCurve2D(bzc_array[i]);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return bzcs;
    }

    JgclBsplineCurve2D reverse() {
        boolean isRat = this.isRational();
        int uicp = this.nControlPoints();
        JgclPoint2D[] rCp = new JgclPoint2D[uicp];
        double[] rWt = null;
        JgclBsplineKnot rKd = this.knotData.reverse();
        if (isRat) {
            rWt = new double[uicp];
        }
        int i = 0;
        int j = uicp - 1;
        while (i < uicp) {
            rCp[i] = this.controlPointAt(j);
            if (isRat) {
                rWt[i] = this.weightAt(j);
            }
            ++i;
            --j;
        }
        return new JgclBsplineCurve2D(rKd, rCp, rWt);
    }

    JgclParameterDomain getParameterDomain() {
        return this.knotData.getParameterDomain();
    }

    private double checkParameter(double param) {
        this.checkValidity(param);
        return this.parameterDomain().force(this.parameterDomain().wrap(param));
    }

    public JgclBsplineCurve2D elevateOneDegree() {
        JgclBsplineKnot oldKnotData = this.knotData();
        double[][] oldControlPoints = this.toDoubleArray(this.isPolynomial());
        JgclBsplineKnot newKnotData = JgclBsplineCurveEvaluation.getNewKnotDataAtDegreeElevation(oldKnotData);
        double[][] newControlPoints = JgclBsplineCurveEvaluation.getNewControlPointsAtDegreeElevation(oldKnotData, newKnotData, oldControlPoints);
        return new JgclBsplineCurve2D(newKnotData, newControlPoints);
    }

    public JgclBsplineCurve2D mergeIfContinuous(JgclBsplineCurve2D mate) throws JgclTwoGeomertiesAreNotContinuous {
        boolean isPoly;
        JgclPoint2D tailStart;
        JgclBsplineCurve2D headCurve = this;
        JgclBsplineCurve2D tailCurve = mate;
        JgclParameterSection headSection = headCurve.parameterDomain().section();
        JgclParameterSection tailSection = tailCurve.parameterDomain().section();
        double headEndParameter = headSection.end();
        double tailStartParameter = tailSection.start();
        JgclPoint2D headEnd = headCurve.coordinates(headEndParameter);
        if (!headEnd.identical(tailStart = tailCurve.coordinates(tailStartParameter))) {
            throw new JgclTwoGeomertiesAreNotContinuous();
        }
        boolean headPoly = headCurve.isPolynomial();
        boolean tailPoly = tailCurve.isPolynomial();
        if (headPoly && tailPoly) {
            isPoly = true;
        } else if (headPoly) {
            isPoly = false;
            headCurve = headCurve.toBsplineCurve();
        } else if (tailPoly) {
            isPoly = false;
            tailCurve = tailCurve.toBsplineCurve();
        } else {
            isPoly = false;
        }
        int headDegree = headCurve.degree();
        int tailDegree = tailCurve.degree();
        while (headDegree < tailDegree) {
            headCurve = headCurve.elevateOneDegree();
            ++headDegree;
        }
        while (headDegree > tailDegree) {
            tailCurve = tailCurve.elevateOneDegree();
            ++tailDegree;
        }
        JgclBsplineCurve2D[] dividedCurves = headCurve.divide(headEndParameter);
        headCurve = dividedCurves[0];
        dividedCurves = tailCurve.divide(tailStartParameter);
        tailCurve = dividedCurves[1];
        JgclBsplineKnot headKnotData = headCurve.knotData();
        JgclBsplineKnot tailKnotData = tailCurve.knotData();
        int arrayLength = headKnotData.nKnots() + tailKnotData.nKnots() - 1;
        double[] newKnots = new double[arrayLength];
        int[] newKnotMultiplicities = new int[arrayLength];
        int nNewKnots = 0;
        int j = 0;
        while (j < headKnotData.nKnots()) {
            newKnots[nNewKnots] = headKnotData.knotAt(j);
            newKnotMultiplicities[nNewKnots] = headKnotData.knotMultiplicityAt(j);
            ++nNewKnots;
            ++j;
        }
        newKnotMultiplicities[nNewKnots - 1] = headDegree;
        double offset = headEndParameter - tailStartParameter;
        int j2 = 1;
        while (j2 < tailKnotData.nKnots()) {
            newKnots[nNewKnots] = tailKnotData.knotAt(j2) + offset;
            newKnotMultiplicities[nNewKnots] = tailKnotData.knotMultiplicityAt(j2);
            ++nNewKnots;
            ++j2;
        }
        arrayLength = headKnotData.nControlPoints() + tailKnotData.nControlPoints() - 1;
        JgclPoint2D[] newControlPoints = new JgclPoint2D[arrayLength];
        double[] newWeights = null;
        if (!isPoly) {
            newWeights = new double[arrayLength];
        }
        int nNewControlPoints = 0;
        int j3 = 0;
        while (j3 < headKnotData.nControlPoints()) {
            newControlPoints[nNewControlPoints] = headCurve.controlPointAt(j3);
            if (!isPoly) {
                newWeights[nNewControlPoints] = headCurve.weightAt(j3);
            }
            ++nNewControlPoints;
            ++j3;
        }
        double weightRatio = 0.0;
        if (!isPoly) {
            weightRatio = newWeights[nNewControlPoints - 1] / tailCurve.weightAt(0);
        }
        int j4 = 1;
        while (j4 < tailKnotData.nControlPoints()) {
            newControlPoints[nNewControlPoints] = tailCurve.controlPointAt(j4);
            if (!isPoly) {
                newWeights[nNewControlPoints] = tailCurve.weightAt(j4) * weightRatio;
            }
            ++nNewControlPoints;
            ++j4;
        }
        JgclBsplineCurve2D result = isPoly ? new JgclBsplineCurve2D(headDegree, false, newKnotMultiplicities, newKnots, newControlPoints) : new JgclBsplineCurve2D(headDegree, false, newKnotMultiplicities, newKnots, newControlPoints, newWeights);
        return result;
    }

    int type() {
        return 21;
    }

    protected synchronized JgclParametricCurve2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint2D[] tControlPoints = JgclPoint2D.transform(this.controlPoints, reverseTransform, transformationOperator, transformedGeometries);
        return new JgclBsplineCurve2D(this.knotData, tControlPoints, this.weights);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        StringBuffer buf = new StringBuffer();
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        this.knotData.output(writer, indent, 0);
        writer.println(String.valueOf(indent_tab) + "\tcontrolPoints");
        int i = 0;
        while (i < this.nControlPoints()) {
            this.controlPointAt(i).output(writer, indent + 2);
            ++i;
        }
        if (this.weights() != null) {
            writer.println(String.valueOf(indent_tab) + "\tweights ");
            int i2 = 0;
            while (true) {
                int j = 0;
                while (j < 10 && i2 < this.weights().length) {
                    writer.print(" " + this.weightAt(i2));
                    ++j;
                    ++i2;
                }
                writer.println();
                if (i2 >= this.weights().length) break;
                writer.print(String.valueOf(indent_tab) + "\t");
            }
        }
        writer.println(String.valueOf(indent_tab) + "\tcurveForm\t" + JgclBsplineCurveForm.toString(this.curveForm));
        writer.println(String.valueOf(indent_tab) + "End");
    }

    private final class 1
    implements JgclRealFunctionWithOneVariable {
        public double evaluate(double parameter) {
            return JgclBsplineCurve2D.this.tangentVector(parameter).length();
        }

        /* synthetic */ 1() {
        }
    }

    private static final class 2
    implements JgclRealFunctionWithOneVariable {
        private final /* synthetic */ JgclRealPolynomial[] val$deriv;

        public double evaluate(double parameter) {
            double[] tang = new double[2];
            int klm = 0;
            while (klm < 2) {
                tang[klm] = this.val$deriv[klm].evaluate(parameter);
                ++klm;
            }
            return Math.sqrt(tang[0] * tang[0] + tang[1] * tang[1]);
        }

        /* synthetic */ 2(JgclRealPolynomial[] val$deriv) {
            this.val$deriv = val$deriv;
        }
    }

    private class SegmentInfo {
        private double lp;
        private double up;
        private double dp;
        private JgclPoint2D[] pnts;

        private SegmentInfo(double lp, double up) {
            JgclBsplineCurve2D.this = JgclBsplineCurve2D.this;
            this.lp = lp;
            this.up = up;
            this.dp = up - lp;
        }

        private void pnts(JgclPoint2D[] pnts) {
            this.pnts = pnts;
        }

        private double lp() {
            return this.lp;
        }

        private double up() {
            return this.up;
        }

        private double dp() {
            return this.dp;
        }

        private int nPnts() {
            if (this.pnts == null) {
                return 0;
            }
            return this.pnts.length;
        }

        private JgclPoint2D pnts(int n) {
            return this.pnts[n];
        }
    }
}

