/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclMatrix;

class JgclApproximation {
    protected static boolean debug;
    protected boolean isClosed;
    protected int nPoints;
    protected double[] params;
    protected static final int degree = 3;
    private int nseg_numer = 1;
    private int nseg_denom = 2;
    protected static final int MARGIN = 4;

    protected JgclApproximation(int nPoints, double[] params, boolean isClosed) {
        if (nPoints < 2 || isClosed && nPoints < 3) {
            throw new JgclInvalidArgumentValue();
        }
        if (!isClosed && nPoints != params.length || isClosed && nPoints + 1 != params.length) {
            throw new JgclInvalidArgumentValue();
        }
        this.nPoints = nPoints;
        this.params = params;
        this.isClosed = isClosed;
    }

    static int minSegmentNumber(boolean isClosed, int degree) {
        if (isClosed) {
            return degree + 1;
        }
        return 1;
    }

    protected int minSegmentNumber() {
        return JgclApproximation.minSegmentNumber(this.isClosed, 3);
    }

    static int maxSegmentNumber(int nPoints, boolean isClosed, int degree) {
        if (isClosed) {
            return nPoints;
        }
        return nPoints - degree;
    }

    protected int maxSegmentNumber() {
        return JgclApproximation.maxSegmentNumber(this.nPoints, this.isClosed, 3);
    }

    protected int initSegmentNumber() {
        this.nseg_numer = 1;
        this.nseg_denom = 2;
        int nseg = this.nPoints * this.nseg_numer / this.nseg_denom;
        int min_nseg = this.minSegmentNumber();
        if (nseg < min_nseg) {
            nseg = min_nseg;
        }
        if (nseg > this.maxSegmentNumber()) {
            return -1;
        }
        return nseg;
    }

    protected boolean reNewSegmentNumber(int[] nsegs, int nsegI, boolean is_tolerated) {
        if (debug) {
            System.err.println("// nseg = " + nsegs[nsegI] + ", tolerated = " + is_tolerated);
        }
        this.nseg_denom *= 2;
        this.nseg_numer *= 2;
        this.nseg_numer = is_tolerated ? --this.nseg_numer : ++this.nseg_numer;
        nsegs[++nsegI] = this.nPoints * this.nseg_numer / this.nseg_denom;
        int min_nseg = this.minSegmentNumber();
        int max_nseg = this.maxSegmentNumber();
        if (max_nseg < min_nseg) {
            max_nseg = min_nseg;
        }
        if (nsegs[nsegI] < min_nseg) {
            nsegs[nsegI] = min_nseg;
        }
        if (nsegs[nsegI] > max_nseg) {
            nsegs[nsegI] = max_nseg;
        }
        int i = 0;
        while (i < nsegI) {
            if (nsegs[i] == nsegs[nsegI]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean compKnots(double sp, double ep, int nseg, int lower, int upper, double[] curvatures, double[] sorted_curvatures, double[] knots) {
        if (nseg == 1) {
            knots[0] = sp;
            knots[1] = ep;
        } else {
            int k = upper - (nseg - 2);
            if (k < lower) {
                if (debug) {
                    System.err.println("nseg is too large\n");
                }
                return false;
            }
            double threshold = sorted_curvatures[k];
            if (debug) {
                System.err.println("threshold : " + threshold);
            }
            k = 0;
            knots[k++] = sp;
            int i = lower;
            while (i <= upper) {
                if (!(curvatures[i] < threshold) && k < nseg) {
                    knots[k++] = this.params[i];
                }
                ++i;
            }
            knots[k] = ep;
            if (nseg != k) {
                if (debug) {
                    System.err.println("something wrong\n");
                }
                return false;
            }
        }
        return true;
    }

    protected boolean tolerated(double tol, double[] res) {
        int i;
        if (debug) {
            double max_r = res[0];
            int max_i = 0;
            i = 0;
            while (i < this.nPoints) {
                if (res[i] > max_r) {
                    max_r = res[i];
                    max_i = i;
                }
                ++i;
            }
            System.err.println("max res : " + max_r + " [" + max_i + "]");
        }
        i = 0;
        while (i < this.nPoints) {
            if (res[i] > tol) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private double[] getKnotArray(int uik, double[] orig, int nSegments) {
        double[] knots = new double[uik];
        if (this.isClosed) {
            int i = 2;
            int j = nSegments - 1;
            while (i >= 0) {
                knots[i] = knots[i + 1] - (orig[j + 1] - orig[j]);
                --i;
                --j;
            }
            i = 4;
            j = 1;
            while (j < nSegments + 1) {
                knots[i] = orig[j];
                ++i;
                ++j;
            }
            j = 0;
            while (j < 3) {
                knots[i] = knots[i - 1] + (orig[j + 1] - orig[j]);
                ++i;
                ++j;
            }
        } else {
            int i = 0;
            while (i < knots.length) {
                knots[i] = orig[i];
                ++i;
            }
        }
        return knots;
    }

    private int[] getKnotMultiplicities(int length) {
        int[] knotMultiplicities = new int[length];
        int i = 0;
        while (i < knotMultiplicities.length) {
            knotMultiplicities[i] = 1;
            ++i;
        }
        if (!this.isClosed) {
            knotMultiplicities[length - 1] = 4;
            knotMultiplicities[0] = 4;
        }
        return knotMultiplicities;
    }

    protected JgclBsplineKnot getKnotData(int nsegs, double[] knots) {
        int uik;
        int uicp;
        if (this.isClosed) {
            uicp = nsegs;
            uik = 6 + nsegs + 1;
        } else {
            uicp = nsegs + 3;
            uik = nsegs + 1;
        }
        knots = this.getKnotArray(uik, knots, nsegs);
        if (debug) {
            int i = 0;
            while (i < knots.length) {
                System.err.println("knots[" + i + "] = " + knots[i]);
                ++i;
            }
        }
        int[] knotMultiplicities = this.getKnotMultiplicities(knots.length);
        if (debug) {
            int i = 0;
            while (i < knotMultiplicities.length) {
                System.err.println("knotMultiplicities[" + i + "] = " + knotMultiplicities[i]);
                ++i;
            }
        }
        return new JgclBsplineKnot(3, 1, this.isClosed, uik, knotMultiplicities, knots, uicp, false);
    }

    protected JgclMatrix getDesignMatrix(JgclBsplineKnot knotData) {
        int j;
        int uicp = knotData.nControlPoints();
        int nseg = knotData.nSegments();
        int npnts = this.nPoints;
        JgclMatrix designMatrix = new JgclMatrix(npnts, uicp);
        double[] bcoef = new double[4];
        if (debug) {
            System.err.println("<start getDesignMatrix()>");
        }
        int i = 0;
        while (i < npnts) {
            int l;
            int cseg = knotData.evaluateBsplineFunction(this.params[i], bcoef);
            if (this.isClosed) {
                j = 0;
                while (j < cseg) {
                    designMatrix.setElementAt(i, j, 0.0);
                    ++j;
                }
                l = 0;
                while (l <= 3) {
                    int m = j % uicp;
                    designMatrix.setElementAt(i, m, bcoef[l]);
                    ++l;
                    ++j;
                }
                while (j < uicp) {
                    designMatrix.setElementAt(i, j, 0.0);
                    ++j;
                }
            } else {
                j = 0;
                int k = 0;
                while (j < cseg) {
                    designMatrix.setElementAt(i, k, 0.0);
                    ++j;
                    ++k;
                }
                l = 0;
                while (l <= 3) {
                    designMatrix.setElementAt(i, k, bcoef[l]);
                    ++l;
                    ++j;
                    ++k;
                }
                while (j < uicp) {
                    designMatrix.setElementAt(i, k, 0.0);
                    ++j;
                    ++k;
                }
            }
            ++i;
        }
        if (debug) {
            int i2 = 0;
            while (i2 < designMatrix.getRowSize()) {
                System.err.print("<" + designMatrix.getElementAt(i2, 0));
                j = 1;
                while (j < designMatrix.getColumnSize()) {
                    System.err.print(", " + designMatrix.getElementAt(i2, j));
                    ++j;
                }
                System.err.println(">");
                ++i2;
            }
        }
        return designMatrix;
    }
}

