/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.judan;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import jp.co.sra.judan.JudanSuitableParameterSection;
import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBoundedCurve3D;
import jp.go.ipa.jgcl.JgclBoundedSurface3D;
import jp.go.ipa.jgcl.JgclCurveBoundedSurface3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclSetOfTriangles3D;
import jp.go.ipa.jgcl.JgclSurfaceCurve3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclVector3D;
import sra.jun.geometry.basic.Jun3dPoint;
import sra.jun.geometry.curves.Jun3dLine;
import sra.jun.geometry.surfaces.JunPolygon;
import sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import sra.jun.opengl.objects.JunOpenGL3dObject;
import sra.jun.opengl.objects.JunOpenGL3dPolyline;
import sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;
import sra.jun.opengl.objects.JunOpenGL3dVertex;

public class JudanTransform {
    public static JunOpenGL3dCompoundObject asJunOpenGL3dCompoundObject(JgclGeometry[] geometries) {
        int numberOfGeometry = geometries.length;
        JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
        int currentGeometry = 0;
        while (currentGeometry < numberOfGeometry) {
            compoundObject.add_(JudanTransform.asJunOpenGL3dObject(geometries[currentGeometry]));
            ++currentGeometry;
        }
        return compoundObject;
    }

    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclGeometry geometry) {
        try {
            double TOLERANCE = 0.001;
            double SURFACE_TOLERANCE = 0.01;
            boolean is2D = geometry.is2D();
            if (geometry.isPoint()) {
                if (is2D) {
                    return JudanTransform.asJunOpenGL3dObject((JgclPoint2D)geometry);
                }
                return JudanTransform.asJunOpenGL3dObject((JgclPoint3D)geometry);
            }
            if (geometry.isCurve()) {
                if (is2D) {
                    if (geometry instanceof JgclPolyline2D) {
                        return JudanTransform.asJunOpenGL3dObject((JgclPolyline2D)geometry);
                    }
                    if (geometry instanceof JgclBoundedCurve2D) {
                        return JudanTransform.asJunOpenGL3dObject(((JgclBoundedCurve2D)geometry).toPolyline(new JgclToleranceForDistance(TOLERANCE)));
                    }
                    JgclParameterSection psec = JudanSuitableParameterSection.asCurve(geometry);
                    return JudanTransform.asJunOpenGL3dObject(((JgclParametricCurve2D)geometry).toPolyline(psec, new JgclToleranceForDistance(TOLERANCE)));
                }
                if (geometry instanceof JgclPolyline3D) {
                    return JudanTransform.asJunOpenGL3dObject((JgclPolyline3D)geometry);
                }
                if (geometry instanceof JgclSurfaceCurve3D) {
                    JgclSurfaceCurve3D surfaceCurve = (JgclSurfaceCurve3D)geometry;
                    if (surfaceCurve.masterRepresentation() == 0) {
                        return JudanTransform.asJunOpenGL3dObject((JgclGeometry)surfaceCurve.curve3d());
                    }
                    throw new JgclNotSupported();
                }
                if (geometry instanceof JgclBoundedCurve3D) {
                    return JudanTransform.asJunOpenGL3dObject(((JgclBoundedCurve3D)geometry).toPolyline(new JgclToleranceForDistance(TOLERANCE)));
                }
                JgclParameterSection psec = JudanSuitableParameterSection.asCurve(geometry);
                return JudanTransform.asJunOpenGL3dObject(((JgclParametricCurve3D)geometry).toPolyline(psec, new JgclToleranceForDistance(TOLERANCE)));
            }
            if (geometry.isSurface()) {
                JunOpenGL3dObject obj;
                if (geometry instanceof JgclCurveBoundedSurface3D) {
                    obj = JudanTransform.asJunOpenGL3dObject(((JgclCurveBoundedSurface3D)geometry).toSetOfTriangles(SURFACE_TOLERANCE, TOLERANCE));
                } else if (geometry instanceof JgclBoundedSurface3D) {
                    obj = JudanTransform.asJunOpenGL3dObject(((JgclBoundedSurface3D)geometry).toMesh(new JgclToleranceForDistance(SURFACE_TOLERANCE)).toSetOfTriangles());
                } else {
                    JgclParameterSection[] psecs = JudanSuitableParameterSection.asSurface(geometry);
                    obj = JudanTransform.asJunOpenGL3dObject(((JgclParametricSurface3D)geometry).toMesh(psecs[0], psecs[1], new JgclToleranceForDistance(SURFACE_TOLERANCE)).toSetOfTriangles());
                }
                obj.paint_(Color.blue);
                return obj;
            }
            System.out.println(geometry.getClass().getName());
            throw new JgclFatal();
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
    }

    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclSetOfTriangles3D triangles) {
        Enumeration enumeration = triangles.faceElements();
        boolean numberOfFace = false;
        Vector<JunOpenGL3dObject> glVector = new Vector<JunOpenGL3dObject>();
        while (enumeration.hasMoreElements()) {
            JgclSetOfTriangles3D.Face face = (JgclSetOfTriangles3D.Face)enumeration.nextElement();
            JgclSetOfTriangles3D.Vertex[] vertex = face.getVerticesInCCW();
            Vector<Jun3dPoint> vector = new Vector<Jun3dPoint>();
            int i = 0;
            while (i < vertex.length) {
                JgclPoint3D point = vertex[i].getCoordinates();
                vector.addElement(JudanTransform.asJunGeometry(point));
                ++i;
            }
            JunPolygon polygon = JunPolygon.Vertexes_(vector);
            if (polygon == null) continue;
            glVector.addElement(polygon.asJunOpenGL3dObject());
        }
        JunOpenGL3dCompoundObject openGLObj = new JunOpenGL3dCompoundObject();
        openGLObj.addAll_(glVector);
        return openGLObj;
    }

    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclPoint2D point2d) {
        JunOpenGL3dVertex vertex = new JunOpenGL3dVertex(JudanTransform.asJun3dPoint(point2d));
        vertex.size_(5.0f);
        return vertex;
    }

    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclPoint3D point3d) {
        JunOpenGL3dVertex vertex = new JunOpenGL3dVertex(JudanTransform.asJunGeometry(point3d));
        vertex.size_(5.0f);
        return vertex;
    }

    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclLine3D line3d) {
        JunOpenGL3dObject junOpenGL3dObject = JudanTransform.asJunGeometry(line3d).asJunOpenGL3dObject();
        return junOpenGL3dObject;
    }

    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclPolyline3D polyline3d) {
        JgclPoint3D[] point3dArray = polyline3d.points();
        int numberOfPoint = point3dArray.length;
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[numberOfPoint];
        int i = 0;
        while (i < numberOfPoint) {
            jun3dPointArray[i] = JudanTransform.asJunGeometry(point3dArray[i]);
            ++i;
        }
        if (polyline3d.closed()) {
            return new JunOpenGL3dPolylineLoop(jun3dPointArray);
        }
        return new JunOpenGL3dPolyline(jun3dPointArray);
    }

    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclPolyline2D polyline2d) {
        JgclPoint2D[] point2dArray = polyline2d.points();
        int numberOfPoint = point2dArray.length;
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[numberOfPoint];
        int i = 0;
        while (i < numberOfPoint) {
            jun3dPointArray[i] = JudanTransform.asJun3dPoint(point2dArray[i]);
            ++i;
        }
        if (polyline2d.closed()) {
            return new JunOpenGL3dPolylineLoop(jun3dPointArray);
        }
        return new JunOpenGL3dPolyline(jun3dPointArray);
    }

    public static JunOpenGL3dObject asJunOpenGL3dObject(JgclLine2D line2d) {
        JunOpenGL3dObject junOpenGL3dObject = JudanTransform.asJun3dLine(line2d).asJunOpenGL3dObject();
        return junOpenGL3dObject;
    }

    public static Jun3dLine asJun3dLine(JgclLine2D line2d) {
        JgclPoint2D point2d = line2d.pnt();
        JgclVector2D vector2d = line2d.dir();
        JgclPoint2D newPoint2d = point2d.add(vector2d);
        Jun3dPoint jun3dPoint1 = JudanTransform.asJun3dPoint(point2d);
        Jun3dPoint jun3dPoint2 = JudanTransform.asJun3dPoint(newPoint2d);
        return new Jun3dLine(jun3dPoint1, jun3dPoint2);
    }

    public static Jun3dLine asJunGeometry(JgclLine3D line3d) {
        JgclPoint3D point3d = line3d.pnt();
        JgclVector3D vector3d = line3d.dir();
        JgclPoint3D newPoint3d = point3d.add(vector3d);
        Jun3dPoint junPoint1 = JudanTransform.asJunGeometry(point3d);
        Jun3dPoint junPoint2 = JudanTransform.asJunGeometry(newPoint3d);
        return new Jun3dLine(junPoint1, junPoint2);
    }

    public static Jun3dPoint asJunGeometry(JgclPoint3D point3d) {
        return new Jun3dPoint(point3d.x(), point3d.y(), point3d.z());
    }

    public static Jun3dPoint asJun3dPoint(JgclPoint2D point2d) {
        return new Jun3dPoint(point2d.x(), point2d.y(), 0.0);
    }
}

